/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import jdd.bdd.CacheBase;
import jdd.bdd.NodeTable;
import jdd.bdd.SimpleCache;
import jdd.bdd.debug.IdealCache;
import jdd.util.JDDConsole;
import jdd.util.Test;

public final class VerifiedCache
extends CacheBase {
    private SimpleCache cache;
    private IdealCache ideal;
    public int answer;
    public int hash_value;

    public final int getSize() {
        return this.cache.getSize();
    }

    public final void invalidate_cache() {
        this.cache.invalidate_cache();
        this.ideal.invalidate_cache();
    }

    public final void free_or_grow() {
        this.cache.free_or_grow();
        this.ideal.free_or_grow();
    }

    public final void free_or_grow(NodeTable nodeTable) {
        this.cache.free_or_grow(nodeTable);
        this.ideal.free_or_grow(nodeTable);
    }

    public final void invalidate_cache(NodeTable nodeTable) {
        this.cache.invalidate_cache(nodeTable);
        this.ideal.invalidate_cache(nodeTable);
    }

    public final void insert(int n, int n2, int n3) {
        if (this.ideal.lookup(n2)) {
            Test.checkEquality(n3, this.ideal.answer, "Inserted value already exists but is inconsistent (1)");
        }
        this.cache.insert(n, n2, n3);
        this.ideal.insert(n, n2, n3);
    }

    public final void insert(int n, int n2, int n3, int n4) {
        if (this.ideal.lookup(n2, n3)) {
            Test.checkEquality(n4, this.ideal.answer, "Inserted value already exists but is inconsistent (2)");
        }
        this.cache.insert(n, n2, n3, n4);
        this.ideal.insert(n, n2, n3, n4);
    }

    public final void insert(int n, int n2, int n3, int n4, int n5) {
        if (this.ideal.lookup(n2, n3, n4)) {
            Test.checkEquality(n5, this.ideal.answer, "Inserted value already exists but is inconsistent (3)");
        }
        this.cache.insert(n, n2, n3, n4, n5);
        this.ideal.insert(n, n2, n3, n4, n5);
    }

    public final boolean lookup(int n) {
        if (this.cache.lookup(n)) {
            Test.check(this.ideal.lookup(n), "ideal cache not superset of cache (1)");
            Test.checkEquality(this.ideal.answer, this.cache.answer, "ideal cache and cache returning different answers (2)");
            this.answer = this.cache.answer;
            return true;
        }
        this.hash_value = this.cache.hash_value;
        return false;
    }

    public final boolean lookup(int n, int n2) {
        if (this.cache.lookup(n, n2)) {
            Test.check(this.ideal.lookup(n, n2), "ideal cache not superset of cache (2)");
            Test.checkEquality(this.ideal.answer, this.cache.answer, "ideal cache and cache returning different answers (2)");
            this.answer = this.cache.answer;
            return true;
        }
        this.hash_value = this.cache.hash_value;
        return false;
    }

    public final boolean lookup(int n, int n2, int n3) {
        if (this.cache.lookup(n, n2, n3)) {
            Test.check(this.ideal.lookup(n, n2, n3), "ideal cache not superset of cache (3)");
            Test.checkEquality(this.ideal.answer, this.cache.answer, "ideal cache and cache returning different answers (3)");
            this.answer = this.cache.answer;
            return true;
        }
        this.hash_value = this.cache.hash_value;
        return false;
    }

    public final double computeLoadFactor() {
        return this.cache.computeLoadFactor();
    }

    public final double computeHitRate() {
        return this.cache.computeHitRate();
    }

    public final long getAccessCount() {
        return this.cache.getAccessCount();
    }

    public final int getCacheSize() {
        return this.cache.getCacheSize();
    }

    public final int getNumberOfClears() {
        return this.cache.getNumberOfClears();
    }

    public final int getNumberOfPartialClears() {
        return this.cache.getNumberOfPartialClears();
    }

    public final int getNumberOfGrows() {
        return this.cache.getNumberOfGrows();
    }

    public final void check_cache(NodeTable nodeTable) {
        this.cache.check_cache(nodeTable);
    }

    public final void showStats() {
        JDDConsole.out.print("IDEAL:");
        this.ideal.showStats();
        JDDConsole.out.print("NORMAL:");
        this.cache.showStats();
    }

    public static final void main(String[] stringArray) {
    }

    public VerifiedCache(String string, int n, int n2, int n3) {
        super(string);
        this.cache = new SimpleCache(string, n, n2, n3);
        this.ideal = new IdealCache(string, n, n2, n3);
    }
}

