/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.util.Hashtable;
import jdd.bdd.CacheBase;
import jdd.bdd.NodeTable;
import jdd.util.JDDConsole;
import jdd.util.math.Digits;

public final class IdealCache
extends CacheBase {
    public int answer;
    public int hash_value;
    private Hashtable ht;
    private IdealElement query;
    private int num_clears;
    private long num_access;
    private long hit;
    private long miss;

    public final int getSize() {
        return this.ht.size();
    }

    public final void invalidate_cache() {
        this.ht.clear();
        ++this.num_clears;
    }

    public final void free_or_grow() {
        this.invalidate_cache();
    }

    public final void free_or_grow(NodeTable nodeTable) {
        this.invalidate_cache();
    }

    public final void invalidate_cache(NodeTable nodeTable) {
        this.invalidate_cache();
    }

    public final void insert(int n, int n2, int n3) {
        this.insert(n, n2, -1, -1, n3);
    }

    public final void insert(int n, int n2, int n3, int n4) {
        this.insert(n, n2, n3, -1, n4);
    }

    public final boolean lookup(int n) {
        return this.lookup(n, -1, -1);
    }

    public final boolean lookup(int n, int n2) {
        return this.lookup(n, n2, -1);
    }

    public final void insert(int n, int n2, int n3, int n4, int n5) {
        IdealElement idealElement = new IdealElement(n2, n3, n4, n5);
        this.ht.put(idealElement, idealElement);
    }

    public final boolean lookup(int n, int n2, int n3) {
        ++this.num_access;
        this.query.set(n, n2, n3);
        Object v = this.ht.get(this.query);
        if (v == null) {
            ++this.miss;
            return false;
        }
        ++this.hit;
        IdealElement idealElement = (IdealElement)v;
        this.answer = idealElement.value;
        return true;
    }

    public final double computeLoadFactor() {
        return 100.0;
    }

    public final double computeHitRate() {
        if (this.num_access == 0L) {
            return 0.0;
        }
        return (double)((int)(this.hit * 10000L / this.num_access)) / 100.0;
    }

    public final long getAccessCount() {
        return this.num_access;
    }

    public final int getCacheSize() {
        return this.getSize();
    }

    public final int getNumberOfClears() {
        return this.num_clears;
    }

    public final int getNumberOfPartialClears() {
        return 0;
    }

    public final int getNumberOfGrows() {
        return 0;
    }

    public final boolean check_cache(int[] nArray) {
        return true;
    }

    public final void showStats() {
        if (this.num_access != 0L) {
            JDDConsole.out.print(this.getName() + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber(this.ht.size());
            JDDConsole.out.print("accs=");
            Digits.printNumber(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + "/0 ");
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            JDDConsole.out.println();
        }
    }

    public static final void main(String[] stringArray) {
    }

    public IdealCache(String string, int n, int n2, int n3) {
        super(string);
        this.ht = new Hashtable(n);
        this.query = new IdealElement(0, 0, 0, -1);
        this.num_access = 0L;
        this.miss = 0L;
        this.hit = 0L;
        this.num_clears = 0;
        this.hash_value = -1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IdealElement {
        public int key1;
        public int key2;
        public int key3;
        public int value;
        public int hash;

        private final int good_hash(int n, int n2, int n3) {
            return this.pair(n, this.pair(n2, n3));
        }

        private final int pair(int n, int n2) {
            return (n + n2) * (n + n2 + 1) / 2 + n;
        }

        public void set(int n, int n2, int n3) {
            this.key1 = n;
            this.key2 = n2;
            this.key3 = n3;
            this.hash = this.good_hash(this.key1, this.key2, this.key3);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            IdealElement idealElement = (IdealElement)object;
            boolean bl = false;
            if (this.key1 == idealElement.key1 && this.key2 == idealElement.key2 && this.key3 == idealElement.key3) {
                bl = true;
            }
            return bl;
        }

        public IdealElement(int n, int n2, int n3, int n4) {
            this.set(n, n2, n3);
            this.value = n4;
        }
    }
}

