/*
 * Decompiled with CFR 0.152.
 */
package citbach1_1;

import citbach1_1.AndOperator;
import citbach1_1.BooleanMultinaryOperator;
import citbach1_1.EqualityOfParameterAndValue;
import citbach1_1.EqualityOperator;
import citbach1_1.Error;
import citbach1_1.FalseValue;
import citbach1_1.IfOperator;
import citbach1_1.IfthenelseOperator;
import citbach1_1.InequalityOperator;
import citbach1_1.NoParameterNameException;
import citbach1_1.NoValueNameException;
import citbach1_1.Node;
import citbach1_1.NotOperator;
import citbach1_1.OrOperator;
import citbach1_1.OutOfTokenStreamException;
import citbach1_1.PList;
import citbach1_1.Parameter;
import citbach1_1.TokenHandler;
import citbach1_1.TrueValue;
import java.util.List;

public class Parse {
    private TokenHandler t;
    private PList parameterList;

    Parse(TokenHandler t, PList parameterList) {
        this.t = t;
        this.parameterList = parameterList;
    }

    public Node parseExpression() {
        String token;
        block4: {
            token = this.t.peepToken();
            try {
                if (token != null) break block4;
                Error.printError("\u5236\u7d04\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059");
                return null;
            }
            catch (OutOfTokenStreamException e) {
                Error.printError("\u5236\u7d04\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059");
                return null;
            }
        }
        if (token.equals("(")) {
            return this.expressionWithParentheses();
        }
        Error.printError("\u5236\u7d04\u306b'('\u304c\u3042\u308a\u307e\u305b\u3093");
        return null;
    }

    private Node expressionWithParentheses() throws OutOfTokenStreamException {
        String token = this.t.getToken();
        if (!token.equals("(")) {
            Error.printError("\u5236\u7d04\u306b'('\u304c\u3042\u308a\u307e\u305b\u3093");
            return null;
        }
        if (this.t.peepToken() == null) {
            throw new OutOfTokenStreamException();
        }
        Node res = this.t.peepToken().equals("(") ? this.expressionWithParentheses() : this.expressionBody();
        if (!this.t.getToken().equals(")")) {
            Error.printError("\u5236\u7d04\u306b')'\u304c\u3042\u308a\u307e\u305b\u3093");
            return null;
        }
        return res;
    }

    private Node expressionBody() throws OutOfTokenStreamException {
        String token = this.t.peepNextToken();
        if (token == null) {
            throw new OutOfTokenStreamException();
        }
        if (token.equals("(")) {
            return this.boolExpression();
        }
        return this.atomExpression();
    }

    private Node boolExpression() throws OutOfTokenStreamException {
        String token = this.t.peepToken();
        if (this.t.peepToken() == null) {
            throw new OutOfTokenStreamException();
        }
        if (token.equals("not")) {
            return this.notExpression();
        }
        if (token.equals("==")) {
            return this.equalityExpression();
        }
        if (token.equals("<>")) {
            return this.inequalityExpression();
        }
        if (token.equals("or")) {
            return this.orExpression();
        }
        if (token.equals("and")) {
            return this.andExpression();
        }
        if (token.equals("if")) {
            return this.ifExpression();
        }
        if (token.equals("ite")) {
            return this.iteExpression();
        }
        Error.printError(String.valueOf(token) + " is not a valid operator");
        return null;
    }

    private Node notExpression() throws OutOfTokenStreamException {
        NotOperator res = new NotOperator();
        this.t.getToken();
        res.Child = this.parseExpression();
        return res;
    }

    private Node equalityExpression() throws OutOfTokenStreamException {
        EqualityOperator res = new EqualityOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private Node inequalityExpression() throws OutOfTokenStreamException {
        InequalityOperator res = new InequalityOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private Node orExpression() throws OutOfTokenStreamException {
        res = new OrOperator();
        this.t.getToken();
        res.ChildList.add(this.parseExpression());
        res.ChildList.add(this.parseExpression());
        if (this.t.peepToken() != null) ** GOTO lbl14
        throw new OutOfTokenStreamException();
lbl-1000:
        // 1 sources

        {
            res.ChildList.add(this.parseExpression());
            if (this.t.peepToken() != null) continue;
            throw new OutOfTokenStreamException();
lbl14:
            // 2 sources

            ** while (!this.t.peepToken().equals((Object)")"))
        }
lbl15:
        // 1 sources

        return res;
    }

    /*
     * Unable to fully structure code
     */
    private Node andExpression() throws OutOfTokenStreamException {
        res = new AndOperator();
        this.t.getToken();
        res.ChildList.add(this.parseExpression());
        res.ChildList.add(this.parseExpression());
        if (this.t.peepToken() != null) ** GOTO lbl14
        throw new OutOfTokenStreamException();
lbl-1000:
        // 1 sources

        {
            res.ChildList.add(this.parseExpression());
            if (this.t.peepToken() != null) continue;
            throw new OutOfTokenStreamException();
lbl14:
            // 2 sources

            ** while (!this.t.peepToken().equals((Object)")"))
        }
lbl15:
        // 1 sources

        return res;
    }

    private Node ifExpression() throws OutOfTokenStreamException {
        IfOperator res = new IfOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private Node iteExpression() throws OutOfTokenStreamException {
        IfthenelseOperator res = new IfthenelseOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Middle = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private Node atomExpression() throws OutOfTokenStreamException {
        String token = this.t.getToken();
        if (token.equals("==")) {
            return this.equalityAtomExpression();
        }
        if (token.equals("<>")) {
            return this.inequalityAtomExpression();
        }
        Error.printError("\u5236\u7d04\u5f0f\u306b == \u304b <> \u304c\u5fc5\u8981\u3067\u3059");
        return null;
    }

    private Node inequalityAtomExpression() throws OutOfTokenStreamException {
        NotOperator res = new NotOperator();
        res.Child = this.equalityAtomExpression();
        return res;
    }

    private Node equalityAtomExpression() throws OutOfTokenStreamException {
        String token1 = this.t.peepToken();
        String token2 = this.t.peepNextToken();
        if (token1 == null || token2 == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[") && !token2.equals("[")) {
            String val1 = this.t.getToken();
            String val2 = this.t.getToken();
            return this.compareValueAndValue(val1, val2);
        }
        if (!token1.equals("[") && token2.equals("[")) {
            String val1 = this.t.getToken();
            this.t.getToken();
            String para1 = this.t.getToken();
            if (!this.t.getToken().equals("]")) {
                Error.printError("\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059");
            }
            return this.compareParameterAndValue(para1, val1);
        }
        this.t.getToken();
        String para1 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError("\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059");
        }
        if ((token1 = this.t.peepToken()) == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[")) {
            String val1 = this.t.getToken();
            return this.compareParameterAndValue(para1, val1);
        }
        this.t.getToken();
        String para2 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError("\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059");
        }
        return this.compareParameterAndParameter(para1, para2);
    }

    private Node compareValueAndValue(String val1, String val2) {
        if (val1.equals(val2)) {
            return new TrueValue();
        }
        return new FalseValue();
    }

    private Node compareParameterAndValue(String para, String val) {
        Node res;
        int parameterID = 0;
        List<Integer> valueIDs = null;
        try {
            parameterID = this.parameterList.getID(para);
        }
        catch (NoParameterNameException e) {
            Error.printError("\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059");
        }
        Parameter p = (Parameter)this.parameterList.get(parameterID);
        try {
            valueIDs = p.getID(val);
        }
        catch (NoValueNameException e) {
            Error.printError("\u5236\u7d04\u4e2d\u306e\u5024\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059");
        }
        if (valueIDs.size() == 1) {
            res = new EqualityOfParameterAndValue();
            res.p = parameterID;
            res.v = valueIDs.get(0);
            return res;
        }
        res = new OrOperator();
        for (Integer vid : valueIDs) {
            EqualityOfParameterAndValue child = new EqualityOfParameterAndValue();
            child.p = parameterID;
            child.v = vid;
            ((BooleanMultinaryOperator)res).ChildList.add(child);
        }
        return res;
    }

    private Node compareParameterAndParameter(String para1, String para2) {
        int parameterID1 = 0;
        int parameterID2 = 0;
        try {
            parameterID1 = this.parameterList.getID(para1);
            parameterID2 = this.parameterList.getID(para2);
        }
        catch (NoParameterNameException e) {
            Error.printError("\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059");
        }
        Parameter p1 = (Parameter)this.parameterList.get(parameterID1);
        Parameter p2 = (Parameter)this.parameterList.get(parameterID2);
        int count = 0;
        for (String valName1 : p1.value_name) {
            for (String valName2 : p2.value_name) {
                if (!valName1.equals(valName2)) continue;
                ++count;
            }
        }
        if (count == 0) {
            return new FalseValue();
        }
        if (count == 1) {
            for (String valName1 : p1.value_name) {
                for (String valName2 : p2.value_name) {
                    if (!valName1.equals(valName2)) continue;
                    AndOperator res = new AndOperator();
                    EqualityOfParameterAndValue sub1 = new EqualityOfParameterAndValue();
                    EqualityOfParameterAndValue sub2 = new EqualityOfParameterAndValue();
                    try {
                        sub1.p = parameterID1;
                        sub1.v = p1.getID(valName1).get(0).byteValue();
                        sub2.p = parameterID2;
                        sub2.v = p2.getID(valName2).get(0).byteValue();
                    }
                    catch (NoValueNameException e) {
                        Error.printError("\u5185\u90e8\u30a8\u30e9\u30fc");
                    }
                    res.ChildList.add(sub1);
                    res.ChildList.add(sub2);
                    return res;
                }
            }
        }
        OrOperator res = new OrOperator();
        int vid1 = 0;
        while (vid1 < p1.value_name.size()) {
            int vid2 = 0;
            while (vid2 < p2.value_name.size()) {
                if (p1.value_name.get(vid1).equals(p2.value_name.get(vid2))) {
                    AndOperator child = new AndOperator();
                    EqualityOfParameterAndValue sub1 = new EqualityOfParameterAndValue();
                    EqualityOfParameterAndValue sub2 = new EqualityOfParameterAndValue();
                    sub1.p = parameterID1;
                    sub1.v = vid1;
                    sub2.p = parameterID2;
                    sub2.v = vid2;
                    child.ChildList.add(sub1);
                    child.ChildList.add(sub2);
                    res.ChildList.add(child);
                }
                ++vid2;
            }
            ++vid1;
        }
        return res;
    }
}

