/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import v1.ConstraintHandler;
import v1.Error;
import v1.GList;
import v1.Generator;
import v1.OutOfMaxNumOfTestcasesException;
import v1.PairTable;
import v1.ParameterModel;
import v1.ResultOfGenerateOneTest;
import v1.Testcase;

class Generator2
extends Generator {
    final int NumOfIterationForEachTest = 20;

    Generator2(ParameterModel parametermodel, GList groupList, ConstraintHandler constrainthandler, List<Testcase> seed, long randomseed) {
        super(parametermodel, groupList, constrainthandler, seed, randomseed);
    }

    @Override
    List<Testcase> generate() throws OutOfMaxNumOfTestcasesException {
        ArrayList<Testcase> res = new ArrayList<Testcase>();
        PairTable tab = new PairTable(this.parametermodel);
        List<List<Testcase>> tupleSequenceList = this.generateTupleSequenceList();
        int numOfUncoveredTuples = this.checkAllTuples(tab);
        ArrayList[] uncovTab = new ArrayList[this.parametermodel.size];
        this.initializeUncovTab(uncovTab, tab);
        int seedrownum = 0;
        while (numOfUncoveredTuples > 0 || this.hasTuplesToCover(tupleSequenceList)) {
            ResultOfGenerateOneTest newresult = this.generateOneTest(tab, seedrownum, uncovTab, tupleSequenceList);
            res.add(newresult.test);
            if (res.size() > 65532) {
                throw new OutOfMaxNumOfTestcasesException();
            }
            numOfUncoveredTuples -= newresult.numOfCoveredTuples;
            seedrownum = newresult.nextSeedRow;
        }
        return res;
    }

    private void initializeUncovTab(ArrayList<Integer>[] uncovTab, PairTable tab) {
        assert (this.parametermodel.size == uncovTab.length);
        int p1 = 0;
        while (p1 < this.parametermodel.size) {
            uncovTab[p1] = new ArrayList();
            byte v1 = 0;
            while (v1 < this.parametermodel.range[p1]) {
                int sum = 0;
                int p2 = 0;
                while (p2 < this.parametermodel.size) {
                    if (p1 != p2) {
                        byte v2 = 0;
                        while (v2 < this.parametermodel.range[p2]) {
                            if (!tab.get(p1, v1, p2, v2)) {
                                ++sum;
                            }
                            v2 = (byte)(v2 + 1);
                        }
                    }
                    ++p2;
                }
                uncovTab[p1].add(sum);
                v1 = (byte)(v1 + 1);
            }
            ++p1;
        }
    }

    private ResultOfGenerateOneTest generateOneTest(PairTable tab, int seedrownum, ArrayList<Integer>[] uncovTab, List<List<Testcase>> tupleSequenceList) {
        Testcase tmp = new Testcase(this.parametermodel.size);
        tmp.quantify();
        boolean isSeedUsed = false;
        if (this.seed.size() > 0 && seedrownum < this.seed.size()) {
            isSeedUsed = true;
            Testcase seedrow = (Testcase)this.seed.get(seedrownum);
            int i = 0;
            while (i < this.parametermodel.size) {
                tmp.set(i, seedrow.get(i));
                ++i;
            }
        }
        if (!this.constrainthandler.isPossible(tmp)) {
            Error.printError("seed\u306e" + (seedrownum + 1) + "\u884c\u76ee\u304c\u5236\u7d04\u9055\u53cd\u3067\u3059");
            return null;
        }
        this.addGroupedTuples(tmp, tupleSequenceList);
        Testcase temptest = this.generateTempTest(tmp, tab, uncovTab);
        int count = this.computeNewlyCoveredTuples(tab, temptest);
        int i = 1;
        while (i < 20) {
            Testcase newtemptest = this.generateTempTest(tmp, tab, uncovTab);
            int newcount = this.computeNewlyCoveredTuples(tab, newtemptest);
            if (count < newcount) {
                count = newcount;
                temptest = newtemptest;
            }
            ++i;
        }
        this.finallizeUncoverTable(uncovTab, tab, temptest);
        int newtuples = this.finalizePairTable(tab, temptest);
        ResultOfGenerateOneTest res = new ResultOfGenerateOneTest();
        res.test = temptest;
        res.numOfCoveredTuples = newtuples;
        res.nextSeedRow = isSeedUsed ? seedrownum + 1 : seedrownum;
        return res;
    }

    private void addGroupedTuples(Testcase tmp, List<List<Testcase>> tupleSequenceList) {
        block0: for (List<Testcase> TupleSequence : tupleSequenceList) {
            int i = 0;
            while (i < TupleSequence.size()) {
                Testcase tuple = TupleSequence.get(i);
                if (tmp.superimpose(tuple, this.constrainthandler)) {
                    TupleSequence.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private void finallizeUncoverTable(ArrayList<Integer>[] uncovTab, PairTable tab, Testcase temptest) {
        int p1 = 0;
        while (p1 < this.parametermodel.size) {
            int numCovered = 0;
            byte v1 = temptest.get(p1);
            if (v1 >= 0) {
                int p2 = 0;
                while (p2 < this.parametermodel.size) {
                    byte v2;
                    if (p1 != p2 && (v2 = temptest.get(p2)) >= 0 && !tab.get(p1, v1, p2, v2)) {
                        ++numCovered;
                    }
                    ++p2;
                }
                int numUncovered = uncovTab[p1].get(v1);
                uncovTab[p1].set(v1, numUncovered - numCovered);
            }
            ++p1;
        }
    }

    private Testcase generateTempTest(Testcase seedrow, PairTable tab, ArrayList<Integer>[] uncovTab) {
        Testcase tmp = seedrow.makeClone();
        int[] parametersequence = new int[this.parametermodel.size];
        int i = 0;
        while (i < this.parametermodel.size) {
            parametersequence[i] = i;
            ++i;
        }
        i = 1;
        while (i < this.parametermodel.size) {
            int dst = this.rnd.nextInt(i + 1);
            int tmppara = parametersequence[i];
            parametersequence[i] = parametersequence[dst];
            parametersequence[dst] = tmppara;
            ++i;
        }
        i = 0;
        while (i < this.parametermodel.size) {
            int p = parametersequence[i];
            if (tmp.get(p) < 0) {
                int newlyCoveredTuples = -1;
                byte bestValue = -1;
                byte v = 0;
                while (v < this.parametermodel.range[p]) {
                    int newtuples;
                    tmp.set(p, v);
                    if (this.constrainthandler.isPossible(tmp) && (newtuples = this.computeNewlyCoveredTuples(tmp, p, tab)) > newlyCoveredTuples) {
                        bestValue = v;
                        newlyCoveredTuples = newtuples;
                    }
                    v = (byte)(v + 1);
                }
                if (bestValue == -1) {
                    Error.printError("seed\u306b\u5236\u7d04\u9055\u53cd\u306e\u884c\u304c\u3042\u308a\u307e\u3059");
                    return null;
                }
                if (newlyCoveredTuples == 0) {
                    bestValue = -1;
                    int possibleTuples = -1;
                    ArrayList<Byte> candidateValues = new ArrayList<Byte>();
                    byte v2 = 0;
                    while (v2 < this.parametermodel.range[p]) {
                        tmp.set(p, v2);
                        if (this.constrainthandler.isPossible(tmp)) {
                            int newtuples = uncovTab[p].get(v2);
                            if (newtuples > possibleTuples) {
                                bestValue = v2;
                                possibleTuples = newtuples;
                            }
                            if (newtuples == 0 && possibleTuples == 0) {
                                candidateValues.add(v2);
                            }
                        }
                        v2 = (byte)(v2 + 1);
                    }
                    if (possibleTuples == 0) {
                        bestValue = (Byte)candidateValues.get(this.rnd.nextInt(candidateValues.size()));
                    }
                }
                tmp.set(p, bestValue);
            }
            ++i;
        }
        return tmp;
    }

    private int computeNewlyCoveredTuples(Testcase test, int p, PairTable tab) {
        int numOfNewlyCoveredTuples = 0;
        int i = 0;
        while (i < this.numOfParameters) {
            if (p != i && test.get(i) >= 0 && !tab.get(p, test.get(p), i, test.get(i))) {
                ++numOfNewlyCoveredTuples;
            }
            ++i;
        }
        return numOfNewlyCoveredTuples;
    }

    private int finalizePairTable(PairTable tab, Testcase test) {
        int numOfNewlyCoveredTuples = 0;
        int i = 0;
        while (i < this.numOfParameters - 1) {
            int j = i + 1;
            while (j < this.numOfParameters) {
                if (!tab.get(i, test.get(i), j, test.get(j))) {
                    tab.set(i, test.get(i), j, test.get(j));
                    ++numOfNewlyCoveredTuples;
                }
                ++j;
            }
            ++i;
        }
        return numOfNewlyCoveredTuples;
    }

    private int checkAllTuples(PairTable tab) {
        int numOfPairs = 0;
        int i = 0;
        while (i < this.numOfParameters - 1) {
            int j = i + 1;
            while (j < this.numOfParameters) {
                byte v1 = 0;
                while (v1 < this.parametermodel.range[i]) {
                    byte v2 = 0;
                    while (v2 < this.parametermodel.range[j]) {
                        Testcase pair = new Testcase(this.numOfParameters);
                        pair.quantify();
                        pair.set(i, v1);
                        pair.set(j, v2);
                        if (!this.constrainthandler.isPossible(pair)) {
                            tab.set(i, v1, j, v2);
                        } else {
                            ++numOfPairs;
                        }
                        v2 = (byte)(v2 + 1);
                    }
                    v1 = (byte)(v1 + 1);
                }
                ++j;
            }
            ++i;
        }
        return numOfPairs;
    }

    private int computeNewlyCoveredTuples(PairTable tab, Testcase test) {
        int numOfNewlyCoveredTuples = 0;
        int p0 = 0;
        while (p0 < this.numOfParameters - 1) {
            int p1 = p0 + 1;
            while (p1 < this.numOfParameters) {
                if (!tab.get(p0, test.get(p0), p1, test.get(p1))) {
                    ++numOfNewlyCoveredTuples;
                }
                ++p1;
            }
            ++p0;
        }
        return numOfNewlyCoveredTuples;
    }
}

