/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import jdd.bdd.BDD;
import v1.Node;
import v1.PList;
import v1.Parameter;
import v1.Testcase;
import v1.VariableAndBDD;

class ConstraintHandler {
    List<VariableAndBDD> parameters = null;
    BDD bdd = new BDD(1000, 1000);
    int bddConstraint;
    int numOfBDDvariables;

    ConstraintHandler(PList parameterList, List<Node> constraintList) {
        this.parameters = this.setBDDforParameter(parameterList);
        this.bddConstraint = this.setBddConstraint(constraintList);
    }

    void printConstraintBDD() {
        this.bdd.printSet(this.bddConstraint);
    }

    private List<VariableAndBDD> setBDDforParameter(PList parameterList) {
        ArrayList<VariableAndBDD> res = new ArrayList<VariableAndBDD>();
        this.numOfBDDvariables = 0;
        for (Parameter p : parameterList) {
            int num_vars = 1;
            for (int levels = 2; p.value_name.size() >= levels; levels *= 2) {
                ++num_vars;
            }
            this.numOfBDDvariables += num_vars;
            int[] var = new int[num_vars];
            int i = num_vars - 1;
            while (i >= 0) {
                var[i] = this.bdd.createVar();
                --i;
            }
            int f = this.bdd.getZero();
            int i2 = var.length - 1;
            while (i2 >= 0) {
                if ((p.value_name.size() - 1 & 1 << i2) > 0) {
                    int g = this.bdd.getOne();
                    int j = var.length - 1;
                    while (j > i2) {
                        g = (p.value_name.size() - 1 & 1 << j) > 0 ? this.bdd.and(g, var[j]) : this.bdd.and(g, this.bdd.not(var[j]));
                        --j;
                    }
                    f = this.bdd.or(f, this.bdd.and(g, this.bdd.not(var[i2])));
                }
                --i2;
            }
            this.bdd.ref(f);
            int g = this.bdd.getOne();
            int i3 = var.length - 1;
            while (i3 >= 0) {
                g = (p.value_name.size() - 1 & 1 << i3) > 0 ? this.bdd.and(g, var[i3]) : this.bdd.and(g, this.bdd.not(var[i3]));
                --i3;
            }
            this.bdd.ref(g);
            int d = this.bdd.or(f, g);
            this.bdd.ref(d);
            this.bdd.deref(f);
            this.bdd.deref(g);
            res.add(new VariableAndBDD(var, d));
        }
        return res;
    }

    private int setBddConstraint(List<Node> constraintList) {
        int f = this.bdd.getOne();
        for (VariableAndBDD vb : this.parameters) {
            f = this.bdd.and(f, vb.constraint);
        }
        for (Node n : constraintList) {
            int g = n.evaluate(this.bdd, this.parameters);
            f = this.bdd.and(f, g);
            this.bdd.ref(f);
            this.bdd.deref(g);
        }
        f = this.extendBddConstraint(f);
        return f;
    }

    private int extendBddConstraint(int constraint) {
        int f = constraint;
        for (VariableAndBDD p : this.parameters) {
            int cube = p.var[0];
            int i = 1;
            while (i < p.var.length) {
                cube = this.bdd.and(cube, p.var[i]);
                ++i;
            }
            this.bdd.ref(cube);
            int tmp0 = this.bdd.ref(this.bdd.exists(f, cube));
            this.bdd.ref(tmp0);
            int tmp = this.bdd.ref(this.bdd.and(tmp0, cube));
            this.bdd.ref(tmp);
            int newf = this.bdd.ref(this.bdd.or(f, tmp));
            this.bdd.ref(newf);
            this.bdd.deref(cube);
            this.bdd.deref(tmp0);
            this.bdd.deref(tmp);
            this.bdd.deref(f);
            f = newf;
        }
        return f;
    }

    boolean isPossible(Testcase test) {
        int node = this.bddConstraint;
        boolean[] bv = this.binarize(test);
        while (node != 0) {
            if (node == 1) {
                return true;
            }
            if (bv[this.bdd.getVar(node)]) {
                node = this.bdd.getHigh(node);
                continue;
            }
            node = this.bdd.getLow(node);
        }
        return false;
    }

    private boolean[] binarize(Testcase test) {
        boolean[] res = new boolean[this.numOfBDDvariables];
        int pos = 0;
        int i = 0;
        while (i < test.value.length) {
            VariableAndBDD p = this.parameters.get(i);
            byte lv = test.get(i);
            if (lv < 0) {
                int j = 0;
                while (j < p.var.length) {
                    res[pos + j] = true;
                    ++j;
                }
            } else {
                int j0 = 0;
                int j = p.var.length - 1;
                while (j >= 0) {
                    res[pos + j0] = (lv & 1 << j) > 0;
                    ++j0;
                    --j;
                }
            }
            pos += p.var.length;
            ++i;
        }
        return res;
    }
}

