/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import java.util.Random;
import jdd.util.Array;
import jdd.util.math.Prime;

public class Chi2Test {
    private int n;
    private int samples_needed;
    private int samples_have;
    private int[] distibution;
    private boolean has_chi2;
    private double the_chi2;
    private double the_stddev;

    public void reset() {
        this.samples_have = 0;
        Array.set(this.distibution, 0);
        this.has_chi2 = false;
    }

    public boolean more() {
        boolean bl = false;
        if (this.samples_have < this.samples_needed) {
            bl = true;
        }
        return bl;
    }

    public void add(int n) {
        int n2 = n;
        this.distibution[n2] = this.distibution[n2] + 1;
        ++this.samples_have;
        this.has_chi2 = false;
    }

    public double getChi2() {
        if (!this.has_chi2) {
            this.computeChi2();
        }
        return this.the_chi2;
    }

    public double getStandardDeviation() {
        if (!this.has_chi2) {
            this.computeChi2();
        }
        return this.the_stddev;
    }

    private final void computeChi2() {
        this.has_chi2 = true;
        double d = (double)this.samples_have / (double)this.n;
        this.the_chi2 = 0.0;
        int n = 0;
        while (n < this.n) {
            double d2 = (double)this.distibution[n] - d;
            this.the_chi2 += d2 * d2;
            ++n;
        }
        this.the_chi2 /= d;
        this.the_stddev = (this.the_chi2 - (double)this.n) / Math.sqrt(this.n);
    }

    public boolean isChi2Acceptable() {
        double d = this.getChi2();
        boolean bl = false;
        if (Math.abs(d - (double)this.n) < 3.5 * Math.sqrt(this.n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isStandardDeviationAcceptable() {
        double d = this.getStandardDeviation();
        boolean bl = false;
        if (Math.abs(d) < 3.5) {
            bl = true;
        }
        return bl;
    }

    public int[] getDistibution() {
        return this.distibution;
    }

    public static void main(String[] stringArray) {
        int n = Prime.nextPrime(1000);
        Chi2Test chi2Test = new Chi2Test(n);
        while (chi2Test.more()) {
            chi2Test.add((int)(Math.random() * (double)n));
        }
        System.out.println("testing Math.random() * " + n);
        System.out.println("chi2 ==> " + chi2Test.getChi2());
        System.out.println("stddev==> " + chi2Test.getStandardDeviation());
        Random random = new Random();
        chi2Test.reset();
        while (chi2Test.more()) {
            chi2Test.add(random.nextInt(n));
        }
        System.out.println("\nesting java.util.Random.nextInt(" + n + ')');
        System.out.println("chi2 ==> " + chi2Test.getChi2());
        System.out.println("stddev==> " + chi2Test.getStandardDeviation());
    }

    public Chi2Test(int n) {
        this.n = n;
        this.samples_needed = 25 * n + 3;
        this.distibution = new int[n];
        this.reset();
    }
}

