/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import java.io.FileOutputStream;
import java.io.IOException;
import jdd.util.FileUtility;
import jdd.util.JDDConsole;

public class Dot {
    public static final int TYPE_EPS = 0;
    public static final int TYPE_PNG = 1;
    public static final int TYPE_DOT = 2;
    public static final int TYPE_FIG = 3;
    public static final int TYPE_GIF = 4;
    public static final int TYPE_JPG = 5;
    private static final String DOT_COMMAND = "dot";
    private static final String[] DOT_TYPES = new String[]{"ps", "png", "dot", "fig", "gif", "jpg"};
    private static final String GV_COMMAND = "";
    private static Runtime rt = Runtime.getRuntime();
    private static int dot_type = 1;
    private static boolean run_dot = true;
    private static boolean remove_dot_file = true;

    public static void showString(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            Dot.showDot(string);
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save graph to the file " + string + "\nReason: " + iOException.toString());
        }
    }

    public static void showDot(String string) {
        if (FileUtility.invalidFilename(string)) {
            System.err.println("[Dot] The filename '" + string + "' is invalid.");
            System.err.println("[Dot] Maybe it contains characters we don't like?");
            return;
        }
        try {
            if (run_dot) {
                String string2 = "dot -T" + DOT_TYPES[dot_type] + " \"" + string + "\" -o \"" + string + '.' + DOT_TYPES[dot_type] + '\"';
                Process process = rt.exec(string2);
                process.waitFor();
            }
            if (remove_dot_file) {
                FileUtility.delete(string);
            }
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to run DOT on " + string + "\nReason: " + iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            JDDConsole.out.println("DOT interrupted when processing " + string + "\nReason: " + interruptedException.toString());
        }
    }

    public static boolean scaleable() {
        boolean bl = false;
        if (dot_type == 2 || dot_type == 0 || dot_type == 3) {
            bl = true;
        }
        return bl;
    }

    public static void setType(int n) {
        dot_type = n;
    }

    public static void setExecuteDot(boolean bl) {
        run_dot = bl;
    }

    public static void setRemoveDotFile(boolean bl) {
        remove_dot_file = bl;
    }
}

