/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import jdd.bdd.BDD;
import jdd.bdd.BDDIO;
import jdd.bdd.BDDNames;
import jdd.bdd.Permutation;
import jdd.bdd.debug.ProfiledBDD2;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class BDDTrace {
    private static final int DEFAULT_NODES = 10000;
    private static final int MAX_NODES = 3000000;
    public static boolean verbose = false;
    private BDD bdd;
    private InputStream is;
    private StringBuffer sb;
    private String filename;
    private String module;
    private int[] stack;
    private int stack_tos;
    private int nodes;
    private int cache;
    private int vars;
    private HashMap map;
    private Permutation s2sp;
    private Permutation sp2s;
    private TracedVariable last_assignment;
    private Vector operations;
    private Vector variables;
    private int op_count;
    private int line_count;
    private int var_count;
    private long time;

    private final void show_code() {
        Object object;
        JDDConsole.out.println("import org.sf.javabdd.*;\npublic class Test {\npublic static void main(String[] args) {\n");
        JDDConsole.out.println("\n\nBDDFactory B = BDDFactory.init(" + this.nodes + ",100);\nB.setVarNum(" + this.variables.size() + ");\nBDD ");
        int n = 0;
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            object = (TracedVariable)enumeration.nextElement();
            if (!((TracedVariable)object).is_var) continue;
            if (n != 0) {
                JDDConsole.out.print(",");
            }
            JDDConsole.out.print(((TracedVariable)object).name + "=B.ithVar(" + n + ") ");
            ++n;
        }
        JDDConsole.out.println(";");
        enumeration = this.operations.elements();
        while (enumeration.hasMoreElements()) {
            object = (TracedOperation)enumeration.nextElement();
            ((TracedOperation)object).show_code();
        }
        JDDConsole.out.println("}\n}\n");
    }

    private final void setup_bdd(int n) {
        this.vars = n;
        this.nodes = (int)Math.min(3000000.0, (double)this.nodes * (1.0 + Math.log(1 + n)));
        JDDConsole.out.println();
        JDDConsole.out.println("loading " + this.module + " from " + this.filename + " (" + this.nodes + " nodes, " + n + " vars)");
        this.bdd = new ProfiledBDD2(this.nodes, this.cache);
        this.bdd.setNodeNames(new TracedNames());
    }

    private final void alloc_var(String string) {
        TracedVariable tracedVariable = new TracedVariable();
        tracedVariable.last_use = 0;
        tracedVariable.bdd = this.bdd.createVar();
        tracedVariable.name = string;
        tracedVariable.is_var = true;
        this.map.put(string, tracedVariable);
        this.variables.add(tracedVariable);
        ++this.var_count;
    }

    private final void checkVar(TracedBDDOperation tracedBDDOperation) {
        this.checkVar(tracedBDDOperation.ret);
        Enumeration enumeration = tracedBDDOperation.operands.elements();
        while (enumeration.hasMoreElements()) {
            TracedVariable tracedVariable = (TracedVariable)enumeration.nextElement();
            this.checkVar(tracedVariable);
        }
    }

    private final void checkVar(TracedVariable tracedVariable) {
        if (tracedVariable != null && tracedVariable.last_use == this.op_count) {
            this.bdd.deref(tracedVariable.bdd);
            tracedVariable.last_use = -1;
        }
    }

    private final TracedPrintOperation createPrintOperation(boolean bl, TracedVariable tracedVariable) {
        TracedPrintOperation tracedPrintOperation = new TracedPrintOperation();
        tracedPrintOperation.index = this.op_count;
        tracedPrintOperation.graph = bl;
        tracedPrintOperation.v = tracedVariable;
        this.operations.add(tracedPrintOperation);
        return tracedPrintOperation;
    }

    private final TracedSaveOperation createSaveOperation(TracedVariable tracedVariable) {
        TracedSaveOperation tracedSaveOperation = new TracedSaveOperation();
        tracedSaveOperation.index = this.op_count;
        tracedSaveOperation.v = tracedVariable;
        this.operations.add(tracedSaveOperation);
        return tracedSaveOperation;
    }

    private final TracedCheckOperation createCheckOperation(TracedVariable tracedVariable, TracedVariable tracedVariable2) {
        TracedCheckOperation tracedCheckOperation = new TracedCheckOperation();
        tracedCheckOperation.index = this.op_count;
        tracedCheckOperation.t1 = tracedVariable;
        tracedCheckOperation.t2 = tracedVariable2;
        this.operations.add(tracedCheckOperation);
        return tracedCheckOperation;
    }

    private final TracedDebugOperation createDebugOperation(String string) {
        TracedDebugOperation tracedDebugOperation = new TracedDebugOperation();
        tracedDebugOperation.index = this.op_count;
        tracedDebugOperation.text = string;
        this.operations.add(tracedDebugOperation);
        return tracedDebugOperation;
    }

    private final TracedBDDOperation createBDDOperation() {
        TracedBDDOperation tracedBDDOperation = new TracedBDDOperation();
        tracedBDDOperation.index = this.op_count;
        this.operations.add(tracedBDDOperation);
        tracedBDDOperation.operands = new Vector(3);
        return tracedBDDOperation;
    }

    private final void show_results() {
        this.time = System.currentTimeMillis() - this.time;
        JDDConsole.out.println(this.op_count + " operations performed, total execution time: " + this.time + " [ms]");
        if (Options.verbose) {
            if (this.last_assignment != null) {
                int n = this.node_count(this.last_assignment);
                JDDConsole.out.println("Last assginment: " + this.last_assignment.name + ", " + n + " nodes.");
                JDDConsole.out.println("\n");
            }
            this.bdd.showStats();
        }
    }

    private final void check_all_variables() {
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            TracedVariable tracedVariable = (TracedVariable)enumeration.nextElement();
            int cfr_ignored_0 = tracedVariable.last_use;
        }
    }

    private final void execute() throws IOException {
        this.time = System.currentTimeMillis();
        Enumeration enumeration = this.operations.elements();
        while (enumeration.hasMoreElements()) {
            TracedOperation tracedOperation = (TracedOperation)enumeration.nextElement();
            this.op_count = tracedOperation.index;
            if (verbose) {
                tracedOperation.show();
            }
            tracedOperation.execute();
        }
    }

    private final int node_count(TracedVariable tracedVariable) {
        int n = this.bdd.nodeCount(tracedVariable.bdd);
        int n2 = 0;
        if (tracedVariable.bdd < 2) {
            n2 = 1;
        }
        return n += 2 - n2;
    }

    private final void parse() throws IOException {
        this.read_module();
        this.read_input();
        this.skip_output();
        this.read_structure();
    }

    private final void read_module() throws IOException {
        this.need("MODULE");
        this.module = this.need();
    }

    private final void skip_output() throws IOException {
        this.need("OUTPUT");
        String string = this.need();
        while (!string.equals(";")) {
            string = this.need();
        }
    }

    private final void read_structure() throws IOException {
        this.need("STRUCTURE");
        String string;
        while (!(string = this.need()).equals("ENDMODULE")) {
            Object object;
            Object object2;
            Object object3;
            ++this.op_count;
            if (string.equals("trace_verbose_print")) {
                this.need("(");
                object3 = this.getString();
                this.need(")");
                this.need(";");
                this.createDebugOperation((String)object3);
                continue;
            }
            if (string.equals("are_equal")) {
                this.need("(");
                object3 = this.need();
                object2 = this.needVar((String)object3);
                this.need(",");
                object3 = this.need();
                object = this.needVar((String)object3);
                this.need(")");
                this.need(";");
                this.createCheckOperation((TracedVariable)object2, (TracedVariable)object);
                continue;
            }
            if (string.equals("print_bdd") || string.equals("show_bdd")) {
                this.need("(");
                object3 = this.need();
                object2 = this.needVar((String)object3);
                this.need(")");
                this.need(";");
                this.createPrintOperation(string.equals("show_bdd"), (TracedVariable)object2);
                continue;
            }
            if (string.equals("save_bdd")) {
                this.need("(");
                object3 = this.need();
                object2 = this.needVar((String)object3);
                this.need(")");
                this.need(";");
                this.createSaveOperation((TracedVariable)object2);
                continue;
            }
            if (string.equals("check_point_for_force_reordering")) {
                JDDConsole.out.println("NOTE: ignoring variable-reordering request");
                this.skip_eol();
                continue;
            }
            object3 = (TracedVariable)this.map.get(string);
            if (object3 == null) {
                object3 = this.addTemporaryVariable(string);
            }
            this.need("=");
            object2 = this.need();
            this.updateUsage((TracedVariable)object3);
            object = this.createBDDOperation();
            TracedVariable tracedVariable = (TracedVariable)this.map.get(object2);
            if (tracedVariable != null) {
                this.need(";");
                ((TracedBDDOperation)object).operands.add(tracedVariable);
                ((TracedBDDOperation)object).ret = object3;
                ((TracedBDDOperation)object).op = "=";
                this.updateUsage(tracedVariable);
            } else {
                String string2;
                ((TracedBDDOperation)object).op = object2;
                ((TracedBDDOperation)object).ret = object3;
                if (((String)object2).equals("new_int_leaf")) {
                    this.need("(");
                    string2 = this.need();
                    this.need(")");
                    this.need(";");
                    ((TracedBDDOperation)object).operands.add(this.map.get(string2));
                    ((TracedBDDOperation)object).ret = object3;
                    ((TracedBDDOperation)object).op = "=";
                } else {
                    this.need("(");
                    do {
                        string2 = this.need();
                        ((TracedBDDOperation)object).operands.add(this.needVar(string2));
                    } while ((string2 = this.need()).equals(","));
                    this.need(";");
                }
            }
            ((TracedBDDOperation)object).ops = ((TracedBDDOperation)object).operands.size();
            if (((TracedBDDOperation)object).ops > 0) {
                ((TracedBDDOperation)object).op1 = (TracedVariable)((TracedBDDOperation)object).operands.elementAt(0);
            }
            if (((TracedBDDOperation)object).ops > 1) {
                ((TracedBDDOperation)object).op2 = (TracedVariable)((TracedBDDOperation)object).operands.elementAt(1);
            }
            if (((TracedBDDOperation)object).ops <= 2) continue;
            ((TracedBDDOperation)object).op3 = (TracedVariable)((TracedBDDOperation)object).operands.elementAt(2);
        }
        return;
    }

    private final void read_input() throws IOException {
        Object object;
        Object object2;
        boolean bl = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        this.need("INPUT");
        int n = 0;
        while (true) {
            object2 = this.need();
            if (n == 0 && (((String)object2).equals("CURR_NEXT_ASSOCIATE_EVEN_ODD_INPUT_VARS") || ((String)object2).equals("STATE_VAR_ASSOCIATE_CURR_NEXT_INTERLEAVE"))) {
                if (((String)object2).equals("STATE_VAR_ASSOCIATE_CURR_NEXT_INTERLEAVE")) {
                    bl = true;
                }
            } else {
                linkedList.add((String)object2);
                object2 = this.need();
                if (((String)object2).equals(";")) break;
                if (!((String)object2).equals(",")) {
                    throw new IOException("expected ',' when reading inputs, but got: " + (String)object2 + " at line " + this.line_count);
                }
            }
            ++n;
        }
        n = linkedList.size();
        this.setup_bdd(n);
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.alloc_var((String)object);
        }
        int n2 = this.variables.size();
        object = new int[n2 / 2];
        int[] nArray = new int[n2 / 2];
        Enumeration enumeration = this.variables.elements();
        int n3 = 0;
        while (n3 < (n2 & 0xFFFFFFFE)) {
            TracedVariable tracedVariable = (TracedVariable)enumeration.nextElement();
            if (bl) {
                if (n3 % 2 == 0) {
                    object[n3 / 2] = tracedVariable.bdd;
                } else {
                    nArray[n3 / 2] = tracedVariable.bdd;
                }
            } else if (n3 < ((Object)object).length) {
                object[n3] = tracedVariable.bdd;
            } else {
                nArray[n3 - ((Object)object).length] = tracedVariable.bdd;
            }
            ++n3;
        }
        this.s2sp = this.bdd.createPermutation((int[])object, nArray);
        this.sp2s = this.bdd.createPermutation(nArray, (int[])object);
    }

    private final TracedVariable needVar(String string) throws IOException {
        TracedVariable tracedVariable = (TracedVariable)this.map.get(string);
        if (tracedVariable == null) {
            throw new IOException("Unknown variable/operand " + string + " at line " + this.line_count);
        }
        this.updateUsage(tracedVariable);
        return tracedVariable;
    }

    private final void updateUsage(TracedVariable tracedVariable) {
        tracedVariable.last_use = this.op_count;
    }

    private final TracedVariable addTemporaryVariable(String string) {
        TracedVariable tracedVariable = new TracedVariable();
        tracedVariable.last_use = this.op_count;
        tracedVariable.name = string;
        tracedVariable.bdd = this.bdd.ref(0);
        this.variables.add(tracedVariable);
        this.map.put(string, tracedVariable);
        return tracedVariable;
    }

    private final void need(String string) throws IOException {
        String string2 = this.need();
        if (!string2.equals(string)) {
            this.check(false, "Syntax error: expected '" + string + "', but read '" + string2 + "', op=" + this.op_count);
        }
    }

    private final String need() throws IOException {
        String string = this.next();
        if (string == null) {
            this.check(false, "pre-mature end of file");
        }
        return string;
    }

    private final int read() {
        int n = -1;
        if (this.stack_tos > 0) {
            n = this.stack[--this.stack_tos];
        } else {
            try {
                n = this.is.read();
            }
            catch (IOException iOException) {}
        }
        if (n == 10) {
            ++this.line_count;
        }
        return n;
    }

    private final void push(int n) {
        this.stack[this.stack_tos++] = n;
        if (n == 10) {
            --this.line_count;
        }
    }

    private final boolean isSpace(int n) {
        boolean bl = false;
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            bl = true;
        }
        return bl;
    }

    private final boolean isAlnum(int n) {
        boolean bl = false;
        if (n >= 48 && n <= 57 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final String getString() throws IOException {
        var1_1 = new StringBuffer();
        var2_2 = 0;
        while (this.isSpace(var2_2 = this.read())) {
        }
        if (var2_2 == 34) ** GOTO lbl9
        throw new IOException("Not an string at line " + this.line_count);
lbl-1000:
        // 1 sources

        {
            var1_1.append((char)var2_2);
lbl9:
            // 2 sources

            ** while ((var2_2 = this.read()) != 34)
        }
lbl10:
        // 1 sources

        return var1_1.toString();
    }

    private final void skip_eol() {
        int n;
        while ((n = this.read()) != -1 && n != 10) {
        }
    }

    private final String next() {
        int n;
        this.sb.setLength(0);
        do {
            if ((n = this.read()) != -1) continue;
            return null;
        } while (this.isSpace(n));
        if (this.isAlnum(n)) {
            do {
                this.sb.append((char)n);
                n = this.read();
                if (n != -1) continue;
                return this.sb.toString();
            } while (this.isAlnum(n));
            if (!this.isSpace(n)) {
                this.push(n);
            }
        } else {
            if (n == 37 || n == 35) {
                int n2 = this.line_count;
                if (n == 37) {
                    String string = this.next();
                    TracedOperation tracedOperation = (TracedOperation)this.operations.lastElement();
                    if (tracedOperation.size == -1) {
                        tracedOperation.size = Integer.parseInt(string);
                    }
                }
                if (n2 == this.line_count) {
                    this.skip_eol();
                }
                return this.next();
            }
            return "" + (char)n;
        }
        return this.sb.toString();
    }

    void checkEquality(int n, int n2, String string) throws IOException {
        if (n != n2) {
            throw new IOException(string + ", " + n + " != " + n2);
        }
    }

    void check(boolean bl, String string) throws IOException {
        if (!bl) {
            throw new IOException(string);
        }
    }

    void check(boolean bl) throws IOException {
        if (!bl) {
            throw new IOException("Check failed");
        }
    }

    public static void main(String[] stringArray) {
        verbose = true;
        Options.verbose = true;
        Options.profile_cache = true;
        try {
            if (stringArray.length == 2) {
                new BDDTrace(stringArray[0], Integer.parseInt(stringArray[1]));
            } else if (stringArray.length == 1) {
                new BDDTrace(stringArray[0]);
            } else {
                JDDConsole.out.println("Usage:  java jdd.bdd.BDDTrace file.trace [initial node-base]");
            }
        }
        catch (IOException iOException) {
            JDDConsole.out.println("FAILED: " + iOException.getMessage());
            iOException.printStackTrace();
            System.exit(20);
        }
    }

    static /* synthetic */ TracedVariable access$3(BDDTrace bDDTrace) {
        return bDDTrace.last_assignment;
    }

    public BDDTrace(String string) throws IOException {
        this(string, new FileInputStream(string), 10000);
    }

    public BDDTrace(String string, int n) throws IOException {
        this(string, new FileInputStream(string), n);
    }

    public BDDTrace(String string, InputStream inputStream) throws IOException {
        this(string, inputStream, 10000);
    }

    public BDDTrace(String string, InputStream inputStream, int n) throws IOException {
        this.filename = string;
        this.nodes = n;
        this.is = inputStream;
        this.sb = new StringBuffer();
        this.stack = new int[64];
        this.stack_tos = 0;
        this.cache = Math.max(Math.min(n / 10, 5000), 50000);
        this.map = new HashMap(1024);
        this.operations = new Vector();
        this.variables = new Vector();
        this.op_count = 0;
        this.line_count = 1;
        this.var_count = 0;
        TracedVariable tracedVariable = new TracedVariable();
        tracedVariable.last_use = 0;
        tracedVariable.bdd = 0;
        this.map.put("0", tracedVariable);
        tracedVariable = new TracedVariable();
        tracedVariable.last_use = 0;
        tracedVariable.bdd = 1;
        this.map.put("1", tracedVariable);
        this.last_assignment = null;
        this.parse();
        boolean bl = Options.verbose;
        Options.verbose = false;
        this.execute();
        Options.verbose = bl;
        this.show_results();
        this.bdd.cleanup();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedVariable {
        public String name;
        public int index;
        public int last_use;
        public int bdd;
        public boolean is_var;

        public void show() {
            JDDConsole.out.print(this.name);
        }

        public void show(BDD bDD) {
            JDDConsole.out.print("\n\t");
            this.show();
            JDDConsole.out.println();
            bDD.printSet(this.bdd);
        }

        private final /* synthetic */ void this() {
            this.is_var = false;
        }

        TracedVariable() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class TracedOperation {
        public int index;
        public int size;
        public String op;

        public void show() {
        }

        public abstract void execute() throws IOException;

        public void show_code() {
        }

        private final /* synthetic */ void this() {
            this.size = -1;
        }

        TracedOperation() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedNames
    extends BDDNames {
        public String variable(int n) {
            if (n < 0) {
                return "(none)";
            }
            TracedVariable tracedVariable = (TracedVariable)BDDTrace.this.variables.elementAt(n);
            return tracedVariable.name;
        }

        TracedNames() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedBDDOperation
    extends TracedOperation {
        public int ops;
        public TracedVariable ret;
        public TracedVariable op1;
        public TracedVariable op2;
        public TracedVariable op3;
        public Vector operands;

        public void show() {
            JDDConsole.out.print("" + this.index + '\t');
            this.ret.show();
            JDDConsole.out.print(" = ");
            if (this.op.equals("=")) {
                this.op1.show();
                JDDConsole.out.print(";");
            } else {
                JDDConsole.out.print(this.op + '(');
                boolean bl = true;
                Enumeration enumeration = this.operands.elements();
                while (enumeration.hasMoreElements()) {
                    TracedVariable tracedVariable = (TracedVariable)enumeration.nextElement();
                    if (bl) {
                        bl = false;
                    } else {
                        JDDConsole.out.print(", ");
                    }
                    tracedVariable.show();
                }
                JDDConsole.out.print(");");
            }
            if (this.size != -1) {
                JDDConsole.out.print("\t% " + this.size);
            }
            JDDConsole.out.println();
        }

        public void execute() throws IOException {
            int n;
            BDDTrace.this.bdd.deref(this.ret.bdd);
            if (this.op.equals("not")) {
                this.do_not();
            } else if (this.op.equals("=")) {
                this.do_assign();
            } else if (this.op.equals("and")) {
                this.do_and();
            } else if (this.op.equals("or")) {
                this.do_or();
            } else if (this.op.equals("xor")) {
                this.do_xor();
            } else if (this.op.equals("xnor")) {
                this.do_xnor();
            } else if (this.op.equals("nor")) {
                this.do_nor();
            } else if (this.op.equals("nand")) {
                this.do_nand();
            } else if (this.op.equals("ite")) {
                this.do_ite();
            } else if (this.op.equals("vars_curr_to_next")) {
                this.do_s2sp();
            } else if (this.op.equals("vars_next_to_curr")) {
                this.do_sp2s();
            } else if (this.op.equals("support_vars")) {
                this.do_support();
            } else if (this.op.equals("exists")) {
                this.do_exists();
            } else if (this.op.equals("forall")) {
                this.do_forall();
            } else if (this.op.equals("restrict")) {
                this.do_restrict();
            } else if (this.op.equals("rel_prod")) {
                this.do_relprod();
            } else {
                throw new IOException("Unknown operation '" + this.op + "', #" + BDDTrace.this.op_count);
            }
            BDDTrace.this.bdd.ref(this.ret.bdd);
            BDDTrace.this.last_assignment = this.ret;
            BDDTrace.this.checkVar(this);
            if (this.size != -1 && this.size != (n = BDDTrace.this.node_count(this.ret))) {
                JDDConsole.out.println("\n*************************************************************************");
                JDDConsole.out.println("Size comparision failed after " + this.op + " ( wanted " + this.size + ", got " + n + ')');
                this.show();
                JDDConsole.out.println("\n");
                throw new IOException("Size comparision failed");
            }
        }

        private final void do_not() throws IOException {
            BDDTrace.this.checkEquality(this.ops, 1, "do_not");
            this.ret.bdd = BDDTrace.this.bdd.not(this.op1.bdd);
        }

        private final void do_assign() throws IOException {
            BDDTrace.this.checkEquality(this.ops, 1, "do_assign");
            this.ret.bdd = this.op1.bdd;
        }

        private final void do_or() {
            if (this.ops == 2) {
                this.ret.bdd = BDDTrace.this.bdd.or(this.op1.bdd, this.op2.bdd);
            } else {
                Enumeration enumeration = this.operands.elements();
                while (enumeration.hasMoreElements()) {
                    if (((TracedVariable)enumeration.nextElement()).bdd != 1) continue;
                    this.ret.bdd = 1;
                    return;
                }
                int n = 0;
                Enumeration enumeration2 = this.operands.elements();
                while (enumeration2.hasMoreElements()) {
                    TracedVariable tracedVariable = (TracedVariable)enumeration2.nextElement();
                    int n2 = BDDTrace.this.bdd.ref(BDDTrace.this.bdd.or(n, tracedVariable.bdd));
                    BDDTrace.this.bdd.deref(n);
                    n = n2;
                }
                this.ret.bdd = BDDTrace.this.bdd.deref(n);
            }
        }

        private final void do_and() {
            if (this.ops == 2) {
                this.ret.bdd = BDDTrace.this.bdd.and(this.op1.bdd, this.op2.bdd);
            } else {
                Enumeration enumeration = this.operands.elements();
                while (enumeration.hasMoreElements()) {
                    if (((TracedVariable)enumeration.nextElement()).bdd != 0) continue;
                    this.ret.bdd = 0;
                    return;
                }
                int n = 1;
                Enumeration enumeration2 = this.operands.elements();
                while (enumeration2.hasMoreElements()) {
                    TracedVariable tracedVariable = (TracedVariable)enumeration2.nextElement();
                    int n2 = BDDTrace.this.bdd.ref(BDDTrace.this.bdd.and(n, tracedVariable.bdd));
                    BDDTrace.this.bdd.deref(n);
                    n = n2;
                }
                this.ret.bdd = BDDTrace.this.bdd.deref(n);
            }
        }

        private final void do_nand() {
            if (this.ops == 2) {
                this.ret.bdd = BDDTrace.this.bdd.nand(this.op1.bdd, this.op2.bdd);
            } else {
                this.do_and();
                int n = BDDTrace.this.bdd.ref(this.ret.bdd);
                this.ret.bdd = BDDTrace.this.bdd.not(n);
                BDDTrace.this.bdd.deref(n);
            }
        }

        private final void do_nor() {
            if (this.ops == 2) {
                this.ret.bdd = BDDTrace.this.bdd.nor(this.op1.bdd, this.op2.bdd);
            } else {
                this.do_or();
                int n = BDDTrace.this.bdd.ref(this.ret.bdd);
                this.ret.bdd = BDDTrace.this.bdd.not(n);
                BDDTrace.this.bdd.deref(n);
            }
        }

        private final void do_xor() throws IOException {
            boolean bl = false;
            if (this.ops == 2) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.xor(this.op1.bdd, this.op2.bdd);
        }

        private final void do_xnor() throws IOException {
            boolean bl = false;
            if (this.ops == 2) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.biimp(this.op1.bdd, this.op2.bdd);
        }

        private final void do_ite() throws IOException {
            boolean bl = false;
            if (this.ops == 3) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.ite(this.op1.bdd, this.op2.bdd, this.op3.bdd);
        }

        private final void do_s2sp() throws IOException {
            boolean bl = false;
            if (this.ops == 1) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.replace(this.op1.bdd, BDDTrace.this.s2sp);
        }

        private final void do_sp2s() throws IOException {
            boolean bl = false;
            if (this.ops == 1) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.replace(this.op1.bdd, BDDTrace.this.sp2s);
        }

        private final void do_support() throws IOException {
            boolean bl = false;
            if (this.ops == 1) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.support(this.op1.bdd);
        }

        private final void do_exists() throws IOException {
            boolean bl = false;
            if (this.ops == 2) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.exists(this.op2.bdd, this.op1.bdd);
        }

        private final void do_forall() throws IOException {
            boolean bl = false;
            if (this.ops == 2) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.forall(this.op2.bdd, this.op1.bdd);
        }

        private final void do_restrict() throws IOException {
            boolean bl = false;
            if (this.ops == 2) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.restrict(this.op1.bdd, this.op2.bdd);
        }

        private final void do_relprod() throws IOException {
            boolean bl = false;
            if (this.ops == 3) {
                bl = true;
            }
            BDDTrace.this.check(bl);
            this.ret.bdd = BDDTrace.this.bdd.relProd(this.op2.bdd, this.op3.bdd, this.op1.bdd);
        }

        public void show_code() {
            Enumeration enumeration = this.operands.elements();
            TracedVariable tracedVariable = (TracedVariable)enumeration.nextElement();
            if (this.op.equals("=")) {
                JDDConsole.out.println("BDD " + this.ret.name + " = " + tracedVariable.name + ';');
            } else {
                JDDConsole.out.print("BDD " + this.ret.name + " = " + tracedVariable.name + '.' + this.op);
                JDDConsole.out.print("(");
                boolean bl = this.op.equals("ite");
                int n = 0;
                n = 0;
                while (enumeration.hasMoreElements()) {
                    tracedVariable = (TracedVariable)enumeration.nextElement();
                    if (bl && n != 0) {
                        JDDConsole.out.print(", ");
                    }
                    JDDConsole.out.print(tracedVariable.name);
                    if (enumeration.hasMoreElements() && !bl) {
                        JDDConsole.out.print("." + this.op + '(');
                    }
                    ++n;
                }
                if (!bl) {
                    int n2 = 1;
                    while (n2 < n) {
                        JDDConsole.out.print(")");
                        ++n2;
                    }
                }
                JDDConsole.out.println(");");
            }
            if (this.op.equals("ite")) {
                JDDConsole.out.println("System.out.println(\"" + this.ret.name + " ==> \"+" + this.ret.name + ".nodeCount());");
            }
        }

        TracedBDDOperation() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedPrintOperation
    extends TracedOperation {
        public TracedVariable v;
        public boolean graph;

        public void execute() {
            if (this.graph) {
                BDDTrace.this.bdd.printDot(this.v.name, this.v.bdd);
            } else {
                JDDConsole.out.println(this.v.name + ':');
                BDDTrace.this.bdd.printSet(this.v.bdd);
            }
        }

        public void show_code() {
            if (this.graph) {
                JDDConsole.out.println(this.v.name + ".printDot();");
            } else {
                JDDConsole.out.println(this.v.name + ".printSet();");
            }
        }

        TracedPrintOperation() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedSaveOperation
    extends TracedOperation {
        public TracedVariable v;

        public void execute() {
            try {
                BDDIO.saveBuDDy(BDDTrace.this.bdd, this.v.bdd, this.v.name + ".buddy");
                BDDIO.save(BDDTrace.this.bdd, this.v.bdd, this.v.name + ".bdd");
            }
            catch (IOException iOException) {}
        }

        public void show_code() {
            JDDConsole.out.println("BDDIO.saveBuDDy(bdd, " + this.v.bdd + ",\"" + this.v.name + ".buddy\");");
        }

        TracedSaveOperation() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedCheckOperation
    extends TracedOperation {
        public TracedVariable t1;
        public TracedVariable t2;

        public void execute() throws IOException {
            boolean bl;
            boolean bl2 = false;
            if (this.t1.bdd == this.t2.bdd) {
                bl2 = bl = true;
            }
            if (this.size != -1) {
                boolean bl3;
                int n = 0;
                if (this.size == 0) {
                    n = 1;
                }
                if (bl != (bl3 = 1 - n)) {
                    throw new IOException("are_equal(" + this.t1.name + ", " + this.t2.name + ") failed. expected " + bl3 + ", got " + bl);
                }
            }
        }

        TracedCheckOperation() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TracedDebugOperation
    extends TracedOperation {
        public String text;

        public void execute() {
            if (verbose) {
                JDDConsole.out.println(this.text);
            }
        }

        public void show_code() {
            JDDConsole.out.println("//" + this.text);
        }

        TracedDebugOperation() {
        }
    }
}

