/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 30 2011 12:58:15 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x1a,0x00,0x6a,0x55,0x5e,0x2a,0x4a,0xce,0xff,0xff, /* MPFS....jU^.J... */ \
	0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff, /* &O&-....j....r.. */ \
	0x4a,0xe3,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x8a,0xf7,0xff,0xff, /* J........O...... */ \
	0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0x78,0x02,0x00,0x00, /* &...........x... */ \
	0x6d,0x03,0x00,0x00,0x87,0x03,0x00,0x00,0xa8,0x52,0xa3,0x4e,0x00,0x00,0x00,0x00, /* m........R.N.... */ \
	0x01,0x00,0x83,0x02,0x00,0x00,0xf4,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b, /* ................ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x8d,0x02,0x00,0x00,0xb6,0x0c,0x00,0x00, /* .N.............. */ \
	0x40,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x96,0x02, /* @......N........ */ \
	0x00,0x00,0xf6,0x11,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x00,0x00,0x97,0x02,0x00,0x00,0x0e,0x12,0x00,0x00,0xa0,0x00,0x00,0x00, /* ................ */ \
	0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xa2,0x02,0x00,0x00,0xae,0x12, /* .B.N............ */ \
	0x00,0x00,0xa1,0x03,0x00,0x00,0x26,0xf2,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ......&..N...... */ \
	0xad,0x02,0x00,0x00,0x4f,0x16,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e, /* ....O.......'|.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xb7,0x02,0x00,0x00,0x6a,0x1a,0x00,0x00,0x68,0x00, /* ..........j...h. */ \
	0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xb8,0x02,0x00,0x00, /* ..'|.N.......... */ \
	0xd2,0x1a,0x00,0x00,0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ........J..N.... */ \
	0x02,0x00,0xc3,0x02,0x00,0x00,0xa1,0x1d,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7, /* ..........H...J. */ \
	0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xc4,0x02,0x00,0x00,0xe9,0x1d,0x00,0x00, /* .N.............. */ \
	0xf8,0x08,0x00,0x00,0xda,0xef,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xdb,0x02, /* .......N........ */ \
	0x00,0x00,0xe1,0x26,0x00,0x00,0x80,0x00,0x00,0x00,0xda,0xef,0xa4,0x4e,0x00,0x00, /* ...&.........N.. */ \
	0x00,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61,0x27,0x00,0x00,0x03,0x02,0x00,0x00, /* ........a'...... */ \
	0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xf4,0x02,0x00,0x00,0x64,0x29, /* .".N..........d) */ \
	0x00,0x00,0x20,0x00,0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .. ....".N...... */ \
	0xf5,0x02,0x00,0x00,0x84,0x29,0x00,0x00,0x55,0x0b,0x00,0x00,0x81,0x6e,0xab,0x4e, /* .....)..U....n.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x08,0x03,0x00,0x00,0xd9,0x34,0x00,0x00,0x98,0x00, /* ...........4.... */ \
	0x00,0x00,0x81,0x6e,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x03,0x00,0x00, /* ...n.N.......... */ \
	0x71,0x35,0x00,0x00,0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* q5.........N.... */ \
	0x02,0x00,0x1b,0x03,0x00,0x00,0x37,0x39,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b, /* ......79........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x03,0x00,0x00,0x4f,0x39,0x00,0x00, /* .N..........O9.. */ \
	0x14,0x01,0x00,0x00,0xf0,0x6c,0xab,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x32,0x03, /* .....l.N......2. */ \
	0x00,0x00,0x63,0x3a,0x00,0x00,0x18,0x00,0x00,0x00,0xf0,0x6c,0xab,0x4e,0x00,0x00, /* ..c:.......l.N.. */ \
	0x00,0x00,0x00,0x00,0x33,0x03,0x00,0x00,0x7b,0x3a,0x00,0x00,0x08,0x00,0x00,0x00, /* ....3...{:...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x46,0x03,0x00,0x00,0x83,0x3a, /* ...N......F....: */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x47,0x03,0x00,0x00,0x8b,0x3a,0x00,0x00,0x8e,0x01,0x00,0x00,0x11,0x0c,0x9c,0x4e, /* G....:.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x5a,0x03,0x00,0x00,0x19,0x3c,0x00,0x00,0x10,0x00, /* ......Z....<.... */ \
	0x00,0x00,0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x5b,0x03,0x00,0x00, /* .....N......[... */ \
	0x29,0x3c,0x00,0x00,0xa5,0x02,0x00,0x00,0x9a,0x1a,0xab,0x4e,0x00,0x00,0x00,0x00, /* )<.........N.... */ \
	0x02,0x00,0x6c,0x03,0x00,0x00,0xce,0x3e,0x00,0x00,0x30,0x00,0x00,0x00,0x9a,0x1a, /* ..l....>..0..... */ \
	0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x61,0x75,0x74, /* ss.7m3tjz.js.aut */ \
	0x68,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* h.htm..footer.in */ \
	0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64, /* c.header.inc.ind */ \
	0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68, /* ex.htm..status.h */ \
	0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f, /* tm..nodeadapter/ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65, /* config.htm..node */ \
	0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e, /* adapter/config2. */ \
	0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e, /* htm..protect/con */ \
	0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* fig.htm..protect */ \
	0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74, /* /index.htm..prot */ \
	0x65,0x63,0x74,0x2f,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x2e,0x68,0x74, /* ect/missmatch.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f, /* m..protect/reboo */ \
	0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* t.cgi..protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* eboot.htm..prote */ \
	0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08, /* ct/user.htm..... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x56,0x4d,0x6f,0xa3,0x30,0x10,0x3d,0x37, /* ........VMo.0.=7 */ \
	0x52,0xfe,0x03,0x52,0xaf,0x05,0xf1,0x11,0x68,0x4b,0x4f,0xab,0xee,0x79,0x8f,0x7b, /* R..R....hKO..y.{ */ \
	0x37,0x78,0x08,0x56,0x1d,0x8c,0x8c,0x69,0xd2,0xad,0xfa,0xdf,0xd7,0x36,0x06,0x0c, /* 7x.V...i.....6.. */ \
	0x38,0xa9,0x56,0x5a,0x21,0xb5,0x89,0xf1,0xbc,0x37,0x7e,0xf3,0x66,0x9c,0x82,0xe1, /* 8.VZ!....7~.f... */ \
	0x0f,0xef,0x73,0xbf,0xbb,0xab,0x58,0x23,0xfc,0x0a,0x9d,0x08,0xfd,0xc8,0xbd,0xdf, /* ..s...X#........ */ \
	0xc0,0x31,0x6a,0xd0,0x83,0xf7,0x83,0x13,0x44,0x1f,0xbc,0x0e,0x35,0x9d,0xdf,0x01, /* .1j.....D...5... */ \
	0x27,0xd5,0x8b,0xdc,0x5a,0xa0,0xf2,0xed,0xc8,0x59,0xdf,0xe0,0xdc,0xbb,0x4f,0x0b, /* '...Z....Y....O. */ \
	0xf5,0xa8,0xe5,0x13,0xe2,0x47,0xd2,0xe4,0x5e,0xd8,0x5e,0x3c,0xd4,0x0b,0xa6,0xd6, /* .....G..^.^<.... */ \
	0x5a,0x84,0x31,0x69,0x8e,0x72,0x51,0x3e,0xb1,0x7a,0x13,0xca,0xe5,0xaf,0xfd,0x6e  /* Z.1i.rQ>.z.....n */
#define DATACHUNK000001 \
	0xbf,0xbb,0xef,0x6a,0x84,0xd9,0xd9,0x67,0x0d,0xe8,0x04,0xce,0x04,0x8b,0x3a,0xf7, /* ...j...g......:. */ \
	0x1e,0x33,0xb9,0x4b,0xb3,0x30,0x8e,0x81,0xe7,0x5e,0x24,0x83,0x3a,0x46,0x09,0x96, /* .3.K.0...^$.:F.. */ \
	0x5c,0x69,0x3a,0xbf,0xf1,0x05,0x6b,0x73,0x0d,0xe7,0x62,0xfe,0x9a,0x09,0xc4,0x99, /* \i:...ks..b..... */ \
	0x69,0x02,0x07,0xe0,0xa1,0x50,0x8f,0x0b,0xd3,0x8e,0xaf,0x39,0xc0,0x55,0x84,0xc3, /* i....P.....9.U.. */ \
	0xe1,0x9b,0xf0,0x8a,0xf5,0xfc,0x5a,0x74,0x82,0xd4,0x73,0x05,0x40,0x42,0xb4,0xe8, /* ......Zt..s.@B.. */ \
	0x78,0x95,0x39,0x49,0x92,0x4d,0x31,0xaa,0xaa,0x72,0x0a,0x34,0x95,0x21,0x36,0xe2, /* x.9I.M1..r.4.!6. */ \
	0xea,0x6a,0x77,0xe4,0x0f,0x48,0xc8,0xb0,0x15,0x4b,0x42,0x81,0x67,0x47,0x38,0xf6, /* .jw..H...KB.gG8. */ \
	0x08,0x22,0xa8,0xc9,0xca,0xe6,0x4e,0xe2,0xd7,0x9f,0x49,0xbc,0x60,0x3b,0x58,0x64, /* ."....N...I.`;Xd */ \
	0x67,0x20,0xc7,0x5a,0xe4,0x5e,0xc1,0x28,0x56,0x8b,0x25,0xa3,0x8c,0xcf,0x29,0x0f, /* g .Z.^.(V.%...). */ \
	0x25,0xf4,0x0b,0x26,0x04,0x3b,0x49,0xc2,0x74,0x08,0xad,0x4d,0x54,0x94,0xe9,0xef, /* %..&.;I.t..MT... */ \
	0x76,0x02,0x01,0x57,0xaf,0x86,0x4c,0x29,0x43,0x72,0x93,0x5e,0x78,0x99,0xad,0x94, /* v..W..L)Cr.^x... */ \
	0x84,0xe6,0xb4,0x02,0x2e,0xc2,0x47,0x94,0x1c,0x9b,0x79,0xd3,0x00,0x75,0x82,0xa6, /* ......G...y..u.. */ \
	0xb7,0x21,0x28,0x54,0x36,0x42,0x94,0x1a,0x04,0x73,0x24,0x9f,0x0f,0xe9,0x18,0x19, /* .!(T6B...s$..... */ \
	0x2d,0x0c,0x64,0x7b,0x38,0x3a,0x98,0x30,0x4c,0xba,0x96,0x22,0xd9,0x50,0x05,0x65, /* -.d{8:.0L..".P.e */ \
	0xe5,0xdb,0xa6,0x5c,0xb3,0x64,0x46,0x8d,0x73,0x4d,0x04,0x2c,0x24,0x7c,0xba,0x21, /* ...\.dF.sM.,$|.! */ \
	0xa1,0x29,0xf3,0xa4,0xd9,0xec,0x0d,0x23,0xaa,0x3e,0x37,0x86,0x92,0x71,0x24,0x08, /* .).....#.>7..q$. */ \
	0x93,0x87,0x6f,0x64,0xb3,0xad,0xf2,0xce,0x6b,0xf6,0x0e,0x7c,0x5b,0x4e,0xac,0xed, /* ..od....k..|[N.. */ \
	0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3e,0x62,0x1a,0x9b,0x0a,0xad,0xb5,0x5f,0x29, /* 5.,%;4.>b....._) */ \
	0x15,0xd9,0x4a,0x8d,0x38,0x83,0x58,0xa3,0x03,0xca,0x30,0xfc,0x3e,0xd9,0x29,0xd4, /* ..J.8.X...0.>.). */ \
	0xca,0x77,0x04,0x18,0x52,0xdd,0x02,0xc8,0x83,0x00,0xa7,0xc4,0x81,0x52,0x47,0x1a, /* .w..R........RG. */ \
	0xc0,0x98,0x6e,0xe8,0x93,0x39,0xcf,0xa0,0x6b,0x51,0x39,0x72,0x50,0x40,0x5c,0x49, /* ..n..9..kQ9rP@\I */ \
	0x2e,0xea,0x09,0xa5,0x62,0x4c,0x98,0xd7,0x56,0x8f,0x84,0xc1,0x13,0x9c,0x6c,0x67, /* ....bL..V.....lg */ \
	0x67,0x59,0xb6,0x36,0x5f,0x29,0xc9,0x81,0xdb,0x23,0x4b,0xe9,0xe3,0xa5,0x7a,0x30, /* gY.6_)...#K...z0 */ \
	0x7a,0x6b,0xb3,0xe9,0xbc,0xa2,0xc5,0x38,0x34,0x6b,0x72,0x3b,0x96,0x55,0x07,0x3c, /* zk.....84kr;.U.< */ \
	0xb2,0x98,0x89,0x2a,0x90,0xe8,0xbb,0x85,0x13,0x1f,0x6f,0x97,0x69,0xc6,0xb7,0x13, /* ..........o.i... */ \
	0x5a,0x8f,0xdf,0x25,0x97,0xd3,0x8c,0x8b,0x04,0x5a,0x9d,0xc2,0x44,0x91,0x0e,0xa7, /* Z..%.....Z..D... */ \
	0x93,0x7f,0x23,0xbb,0x21,0x89,0x2c,0x4f,0x23,0x11,0xfc,0x75,0x0a,0xd3,0xfc,0x0b, /* ..#.!.,O#..u.... */ \
	0xe0,0x82,0x4e,0x2d,0x85,0x82,0x5d,0xac,0x7a,0xe5,0x5a,0x33,0xd5,0x62,0xde,0xf4, /* ..N-..].z.Z3.b.. */ \
	0xc9,0xd5,0x33,0xae,0x13,0x24,0x96,0x55,0x86,0x9a,0xcc,0x25,0xb1,0xec,0x7f,0x8f, /* ..3..$.U...%.... */ \
	0xf1,0x74,0xa8,0xa0,0x64,0x18,0xb6,0x57,0xe4,0xab,0x1c,0xeb,0x44,0xba,0xe0,0x17, /* .t..d..W....D... */ \
	0x9c,0x1f,0xc6,0x2f,0x0f,0x5e,0x45,0x2e,0x80,0x7d,0x2d,0xbe,0xf9,0x62,0x9d,0x05, /* .../.^E..}-..b.. */ \
	0x78,0x49,0x3a,0xc7,0xe4,0xac,0xe0,0xf9,0x65,0xa5,0x97,0x35,0x12,0xd5,0x48,0xda, /* xI:.....e..5..H. */ \
	0xd8,0x60,0x58,0x8c,0xe7,0x8e,0x87,0x22,0x99,0x99,0x38,0x67,0xdc,0x36,0xf8,0x12, /* .`X...."..8g.6.. */ \
	0x62,0x53,0xfa,0x65,0x32,0x18,0xdf,0xe2,0x79,0x0e,0xe7,0xdb,0x69,0xea,0xa6,0xcc, /* bS.e2...y...i... */ \
	0xba,0xa3,0x2c,0x87,0xa2,0xae,0xb6,0x34,0x9f,0x0c,0x96,0xae,0xd2,0x08,0x57,0xa3, /* ..,....4......W. */ \
	0xde,0x6a,0x44,0xab,0xfe,0xe6,0x52,0xb2,0x2a,0x37,0xce,0xea,0xf5,0xc4,0x49,0x67, /* .jD...R..7....Ig */ \
	0x80,0x8a,0x00,0xc5,0x1d,0x88,0xff,0xeb,0x9e,0x2b,0x46,0x99,0xc8,0x30,0x79,0x5f, /* .........+F..0y_ */ \
	0x36,0x80,0xd2,0x4f,0x71,0xa9,0xff,0xe3,0x95,0xb2,0x0d,0xa1,0xa8,0x00,0xba,0x2d, /* 6..Oq..........- */ \
	0x9b,0x1f,0x1d,0x5c,0x73,0x21,0x1e,0xd6,0xc6,0x3e,0xcf,0xc2,0x1b,0x17,0x45,0xcb, /* ...\s!...>....E. */ \
	0x3a,0x32,0x8c,0x44,0x54,0xc8,0x3a,0xf6,0x02,0x36,0x09,0x90,0xa6,0xed,0xc5,0x96, /* :2.DT.:..6...... */ \
	0x7c,0x1c,0x49,0x23,0x4d,0xec,0x4a,0x5e,0xc7,0x06,0xdd,0xc9,0x1e,0x3c,0xf3,0xcf, /* |.I#M.J^.....<.. */ \
	0xb0,0xcd,0x46,0x84,0x23,0xc7,0xce,0xeb,0x97,0xf4,0x14,0xae,0x76,0x20,0x0e,0x8b, /* ..F.#.......v .. */ \
	0xab,0x36,0xb6,0xe5,0x0c,0x38,0x74,0x3d,0x15,0xfb,0xdd,0xe7,0x7e,0x35,0x61,0xff, /* .6...8t=....~5a. */ \
	0xad,0xde,0xcb,0x5f,0x58,0xee,0x01,0xee,0xbe,0x91,0xed,0x4e,0x02,0x98,0x64,0xbe, /* ..._X......N..d. */ \
	0x0b,0xd8,0x9b,0xce,0x7a,0x6c,0x92,0xe9,0x8e,0x28,0xf4,0x44,0x5d,0x05,0x56,0xfa, /* ....zl...(.D].V. */ \
	0x37,0x80,0x8c,0xbc,0x53,0xa1,0x15,0x22,0xd4,0x19,0x5c,0x64,0x8e,0xe0,0x0a,0x16, /* 7...S.."..\d.... */ \
	0xc1,0x7d,0xe3,0x26,0x2e,0x4b,0x57,0x6c,0x85,0x4d,0xec,0x5f,0x49,0x0a,0x28,0xc4, /* .}.&.KWl.M._I.(. */ \
	0x17,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57, /* ...............W */ \
	0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38, /* ]o.6.}V...;?,2.8 */ \
	0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02, /* N....;.I.fH. q.. */ \
	0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff, /* ..h.....JRv."?h. */ \
	0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7, /* r...,.iQ.}Y.X... */ \
	0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43, /* ...O......F....C */ \
	0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa, /* OF.'.OF.#z.2.... */ \
	0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05, /* h".y..}...2..... */ \
	0x79,0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94, /* y.KFZi.2........ */ \
	0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42, /* ].....k.u"..\g.B */ \
	0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f, /* .N8.K.iC..di%..O */ \
	0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd, /* ...(...s..Y.RZZ. */ \
	0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46, /* eI.;...u.,e....F */ \
	0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55, /* ..sj...]o.o)...U */ \
	0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d, /* .^.....F..::Z..= */ \
	0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f, /* ..:.....Z....o.o */ \
	0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f  /* I.a.%.......%... */
#define DATACHUNK000002 \
	0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1, /* ..{...+:5F...I4. */ \
	0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02, /* .TN....2#ez..e.. */ \
	0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09, /* Im.g...p.."..X.. */ \
	0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10, /* ...L.h...s...... */ \
	0x28,0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc, /* (.4...3.....+... */ \
	0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d, /* z...../)..K..... */ \
	0xac,0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95, /* ..p.58 ..3.a..A. */ \
	0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37, /* ..)./...r..xF..7 */ \
	0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2, /* 7.$.L. .:..;..J. */ \
	0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3, /* .t...ka...vB.... */ \
	0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d, /* ..V....I.....|.- */ \
	0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90, /* .x..}..K|.9.+x.. */ \
	0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9, /* .....kv......W~. */ \
	0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda, /* ;.....<o..9..... */ \
	0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2, /* .}0fOt_..`....D. */ \
	0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6, /* ........|....G.. */ \
	0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66, /* ...Jp..$~..1v!.f */ \
	0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7, /* .....!\....&,... */ \
	0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92, /* .....8...?.g.... */ \
	0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59, /* e.2..1[......I.Y */ \
	0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56, /* ....P...../..)<V */ \
	0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67, /* #..?..<0.m..q..g */ \
	0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42, /* D.......Q.t..S.B */ \
	0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53, /* VO..C....$.....S */ \
	0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56, /* ..R...........6V */ \
	0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8, /* ...s2..u..mvP.v. */ \
	0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6, /* ..}.}...F...F... */ \
	0x9d,0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6, /* .!Q.b.6..w..M... */ \
	0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa, /* ...!.}...Qa.)^.. */ \
	0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa, /* .....~...R...^". */ \
	0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea, /* .,..9.r. .M!.... */ \
	0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28, /* 5...me}T+..N.W.( */ \
	0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2, /* . ..IL..6.%qyQ.. */ \
	0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87, /* .2.$...(......<. */ \
	0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e, /* :....../.FSI.P[. */ \
	0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99, /* .Y....)zNh....1. */ \
	0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2, /* p.I6&..v.f.LN... */ \
	0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0, /* ..$.|...~5...... */ \
	0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6, /* 9~..^+..%M...fR. */ \
	0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c, /* ....Qj..5%_..... */ \
	0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d, /* .....#..X......} */ \
	0x98,0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62, /* .'..r4...:.we..b */ \
	0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f, /* q.u..8vv.J....F. */ \
	0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85, /* ...G...~...#..^. */ \
	0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b, /* ..6}.e!...M65... */ \
	0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f, /* .>t..-i.....b}.? */ \
	0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8, /* .>T%..&...O.k... */ \
	0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13, /* ..1............. */ \
	0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c, /* g...\.h)........ */ \
	0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e, /* Kv..T..C..oZ.... */ \
	0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62, /* ..v......y..Y%.b */ \
	0x75,0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb, /* u...0H.c........ */ \
	0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b, /* K..U.8.4.......K */ \
	0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1, /* I+.x........y4.. */ \
	0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5, /* .Ne1...y....!Z.. */ \
	0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd, /* }.....f.....[.U. */ \
	0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6, /* .b.......0...... */ \
	0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf, /* ......H)..B..... */ \
	0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72, /* 4....rT.BW~..jar */ \
	0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a, /* .d...&.f7..o..X: */ \
	0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e, /* ...r.$....(..RV> */ \
	0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb, /* v.L,....".0..... */ \
	0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83, /* ........;X...x.. */ \
	0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0  /* }bC.E...M....G.. */
#define DATACHUNK000003 \
	0x38,0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33, /* 8."g...@......M3 */ \
	0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a, /* F..jS">.=0..Q"NZ */ \
	0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d, /* .....J.~D....j.. */ \
	0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f, /* 0.."....#.Ja.9.. */ \
	0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4, /* N.D..F.p.I#. ... */ \
	0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee, /* pf.......Jg_.'.. */ \
	0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45, /* w...t...=.).&3WE */ \
	0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56, /* >,1.{...`#}.N.uV */ \
	0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4, /* v...|......4H... */ \
	0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b, /* ].!'......M..s.. */ \
	0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8, /* ...g....O..../.. */ \
	0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65, /* .-....~inc:heade */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* r.inc~..<div id= */ \
	0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* "content">....<h */ \
	0x31,0x3e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* 1>Authentication */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4d,0x61,0x6e,0x79, /* </h1>....<p>Many */ \
	0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x6e,0x65, /*  applications ne */ \
	0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x61, /* ed to restrict a */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x75,0x74,0x68,0x6f,0x72,0x69, /* ccess to authori */ \
	0x7a,0x65,0x64,0x20,0x75,0x73,0x65,0x72,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x20, /* zed users.  The  */ \
	0x48,0x54,0x54,0x50,0x20,0x0d,0x0a,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x75, /* HTTP ..server su */ \
	0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x48,0x54,0x54, /* pports Basic HTT */ \
	0x50,0x20,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* P Authentication */ \
	0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x74,0x68,0x69,0x73, /*  to provide this */ \
	0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x69,0x74,0x79,0x2e,0x3c, /*  functionality.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x77,0x6f,0x20,0x66,0x75, /* /p>....<p>Two fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x69,0x6e,0x76,0x6f, /* nctions are invo */ \
	0x6c,0x76,0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x61,0x75,0x74,0x68,0x65,0x6e, /* lved with authen */ \
	0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62,0x6f,0x74,0x68,0x20,0x6f, /* tication, both o */ \
	0x66,0x20,0x77,0x68,0x69,0x63,0x68,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x61,0x0d, /* f which store a. */ \
	0x0a,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x69,0x6e, /* .return value in */ \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x69, /*  <code>curHTTP.i */ \
	0x73,0x41,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x3c,0x2f,0x63,0x6f,0x64, /* sAuthorized</cod */ \
	0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x4d,0x53,0x42,0x20,0x6f,0x66,0x20, /* e>.  The MSB of  */ \
	0x74,0x68,0x69,0x73,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x69,0x6e,0x64,0x69, /* this value..indi */ \
	0x63,0x61,0x74,0x65,0x73,0x20,0x77,0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6f,0x72, /* cates whether or */ \
	0x20,0x6e,0x6f,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x69,0x73,0x20,0x61, /*  not access is a */ \
	0x6c,0x6c,0x6f,0x77,0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x69,0x72, /* llowed.  The fir */ \
	0x73,0x74,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x0d,0x0a,0x3c, /* st callback, ..< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x4e,0x65,0x65,0x64,0x73,0x41,0x75, /* code>HTTPNeedsAu */ \
	0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20,0x64,0x65,0x74,0x65,0x72, /* th</code>, deter */ \
	0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71, /* mines if the req */ \
	0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x20,0x72,0x65,0x71,0x75, /* uested page requ */ \
	0x69,0x72,0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x63,0x72,0x65,0x64, /* ires..valid cred */ \
	0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65, /* entials to proce */ \
	0x65,0x64,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61, /* ed.  Return a va */ \
	0x6c,0x75,0x65,0x20,0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38, /* lue of <code>0x8 */ \
	0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x67,0x72,0x65,0x61, /* 0</code> or grea */ \
	0x74,0x65,0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x20,0x61, /* ter ..to allow a */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e,0x64,0x69,0x74,0x69,0x6f, /* ccess unconditio */ \
	0x6e,0x61,0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x3c, /* nally.  Return < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* code>0x79</code> */ \
	0x20,0x6f,0x72,0x20,0x6c,0x6f,0x77,0x65,0x72,0x20,0x74,0x6f,0x20,0x72,0x65,0x71, /*  or lower to req */ \
	0x75,0x69,0x72,0x65,0x20,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x61, /* uire ..authoriza */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x54,0x68,0x65, /* tion.</p>....The */ \
	0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /*  second, <code>H */ \
	0x54,0x54,0x50,0x56,0x65,0x72,0x69,0x66,0x79,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63, /* TTPVerifyAuth</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20, /* ode> determines  */ \
	0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x20, /* if the supplied  */ \
	0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x0d,0x0a,0x61,0x72, /* credentials ..ar */ \
	0x65,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x61,0x62,0x6c,0x65,0x20,0x66,0x6f,0x72, /* e acceptable for */ \
	0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70, /*  the requested p */ \
	0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69, /* age.  Your appli */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75,0x6c,0x64,0x20,0x72,0x65  /* cation should re */
#define DATACHUNK000004 \
	0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x0d,0x0a,0x67, /* turn a value ..g */ \
	0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x3c,0x63,0x6f,0x64, /* reater than <cod */ \
	0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f, /* e>0x80</code> to */ \
	0x20,0x70,0x65,0x72,0x6d,0x69,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x2c,0x20, /*  permit access,  */ \
	0x6f,0x72,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6c,0x65,0x73,0x73,0x20, /* or a value less  */ \
	0x74,0x68,0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37, /* than ..<code>0x7 */ \
	0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x72,0x65,0x6a,0x65, /* 9</code> to reje */ \
	0x63,0x74,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* ct the password  */ \
	0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /* supplied.</p>... */ \
	0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /* .<p>As an exampl */ \
	0x65,0x2c,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x69,0x73,0x20,0x72, /* e, access this r */ \
	0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x3a,0x3c, /* estricted page:< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* /p>....<div clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d, /* s="examplebox">. */ \
	0x0a,0x3c,0x62,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* .<b>User Name:</ */ \
	0x62,0x3e,0x20,0x61,0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20, /* b> admin &nbsp;  */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c,0x62, /* &nbsp; &nbsp; <b */ \
	0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x6d, /* >Password:</b> m */ \
	0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a, /* icrochip<br />.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63, /* <a href="/protec */ \
	0x74,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x52,0x65,0x73,0x74,0x72,0x69, /* t">Access Restri */ \
	0x63,0x74,0x65,0x64,0x20,0x50,0x61,0x67,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* cted Page</a>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* /div>....</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* ...<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ">..<!--..docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72, /* d('hello').inner */ \
	0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73, /* HTML = "~helloms */ \
	0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* g~";..-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* ipt>..~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x12,0x05, /* r.inc~....3..... */ \
	0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x64, /* ......0.......<d */ \
	0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65,0x72, /* iv class="spacer */ \
	0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ">&nbsp;</div>.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72,0x22, /* <div id="footer" */ \
	0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70,0x79, /* >Copyright &copy */ \
	0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20,0x59, /* ; 2011 Satoshi Y */ \
	0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36, /* asuda 7m3tjz/ad6 */ \
	0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* gz</div>....</di */ \
	0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f, /* v></div></div></ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* div></div>....</ */ \
	0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21, /* body>..</html><! */ \
	0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55,0x42, /* DOCTYPE html PUB */ \
	0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54,0x44, /* LIC "-//W3C//DTD */ \
	0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69,0x63, /*  XHTML 1.0 Stric */ \
	0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70,0x3a, /* t//EN"..  "http: */ \
	0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f, /* //www.w3.org/TR/ */ \
	0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c, /* xhtml1/DTD/xhtml */ \
	0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a, /* 1-strict.dtd">.. */ \
	0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74, /* <html xmlns="htt */ \
	0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31, /* p://www.w3.org/1 */ \
	0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c, /* 999/xhtml" xml:l */ \
	0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65, /* ang="en" lang="e */ \
	0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69, /* n">..<head>..<ti */ \
	0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72, /* tle>D-STAR dSqur */ \
	0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d, /* e Client Program */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73, /* href="/7m3tjz.cs */ \
	0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65, /* s" rel="styleshe */ \
	0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63, /* et" type="text/c */ \
	0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* ss" />..<script  */ \
	0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22, /* src="/7m3tjz.js" */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61  /*  type="text/java */
#define DATACHUNK000005 \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* script"></script */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62, /* >..</head>....<b */ \
	0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73, /* ody>..<div id="s */ \
	0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20, /* hadow-one"><div  */ \
	0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e, /* id="shadow-two"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d, /* <div id="shadow- */ \
	0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* three"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c, /* shadow-four">..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a, /* div id="page">.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65, /* ..<div id="title */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69, /* "><div class="ri */ \
	0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75, /* ght">D-STAR dSqu */ \
	0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* re Client</div>< */ \
	0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e, /* span id="hello"> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64, /* &nbsp;</span></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* iv>....<div id=" */ \
	0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d, /* menu">..<a href= */ \
	0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65, /* "/index.htm">Ove */ \
	0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72, /* rview</a>..<a hr */ \
	0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e, /* ef="/protect/con */ \
	0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b, /* fig.htm">Network */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f, /* a>..<a href="/no */ \
	0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67, /* deadapter/config */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74, /* .htm">Node Adapt */ \
	0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* er Configuration */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66, /* nodeadapter/conf */ \
	0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20, /* ig2.htm">Beacon  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* >..<a href="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x55, /* tect/user.htm">U */ \
	0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72, /* ser ID & Passwor */ \
	0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* d setting</a>..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73,0x2e, /* a href="/status. */ \
	0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74,0x61, /* htm">Current Sta */ \
	0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e, /* tus</a>..</div>~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41, /* t">....<h1>D-STA */ \
	0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c, /* R dSqure Client< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73, /* /h1>....<table s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65, /* tyle="padding-le */ \
	0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ft: 10px;">..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53, /* ><td><b>dSqure S */ \
	0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d, /* erver Domain Nam */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* e :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64, /* server_name~</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72, /* <b>Out bound Por */ \
	0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* t :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* out_port~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c, /* In bound Port :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70, /* p;</td><td>~in_p */ \
	0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ort~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65, /* <tr><td><b>Confe */ \
	0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20, /* rence Room Name  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f, /* bsp;</td><td>~Ro */ \
	0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72  /* omName~</td></tr */
#define DATACHUNK000006 \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f, /* >..<tr><td><b>No */ \
	0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62, /* de Callsign :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61, /* </td><td>~NodeNa */ \
	0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* me~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x63,0x63,0x65,0x73,0x73, /* tr><td><b>Access */ \
	0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61, /*  Control File Na */ \
	0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* me :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ~AccCtrl~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69, /* NTP Server Domai */ \
	0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* n Name :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* <td>~NtpName~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c, /* ><b>Time Zone :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65, /* p;</td><td>~Time */ \
	0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72, /* Zone~ &nbsp;hour */ \
	0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65, /* s&nbsp;~TimeZone */ \
	0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69, /* Minutes~&nbsp;mi */ \
	0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* nutes</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74,0x74, /* .<tr><td><b>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20,0x50, /* er Buffer Wait P */ \
	0x61,0x63,0x6b,0x65,0x74,0x73,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* ackets:</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x3c, /* td>~JitterSize~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* /td></tr>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* le>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* ";..//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* ipt>....~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00, /* ter.inc~......3. */ \
	0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b,0x00, /* ......J.......K. */ \
	0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d,0x00, /* ..L...L.......M. */ \
	0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f,0x00, /* ......N...A..._. */ \
	0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61,0x00, /* ......`.......a. */ \
	0x00,0x00,0xf8,0x02,0x00,0x00,0x6d,0x00,0x00,0x00,0x64,0x03,0x00,0x00,0x6e,0x00, /* ......m...d...n. */ \
	0x00,0x00,0xe7,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x09,0x04,0x00,0x00,0x02,0x00, /* ................ */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d, /* tent">....<h1>D- */ \
	0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x74,0x61,0x74, /* STAR dSqure Stat */ \
	0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c, /* us</h1>....<tabl */ \
	0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67, /* e style="padding */ \
	0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a, /* -left: 10px;">.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65,0x20, /* <tr><td><b>Date  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75, /* bsp;</td><td>~Cu */ \
	0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* rDate~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d, /* ..<tr><td><b>Tim */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* e :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* CurTime~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x50, /* r>..<tr><td><b>P */ \
	0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* TT :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74  /* ~CurPTT~</td></t */
#define DATACHUNK000007 \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43, /* r>..<tr><td><b>C */ \
	0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* OS :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* ~CurCOS~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e, /* r>..<tr><td><b>N */ \
	0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* ode User :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x55,0x73,0x65,0x72,0x7e,0x3c, /* d><td>~CurUser~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53,0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* td><b>SSN :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c, /* td><td>~CurSSN~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* /td></tr>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le>....</div>..< */ \
	0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74, /* /body>..<meta ht */ \
	0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73, /* tp-equiv="refres */ \
	0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e, /* h" content="10"> */ \
	0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* ..<body>..<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /* .document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27, /* mentById('hello' */ \
	0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e, /* ).innerHTML = "~ */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d, /* hellomsg~";..//- */ \
	0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e, /* ->..</script>..~ */ \
	0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:footer.inc~. */ \
	0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x9b,0x00,0x00,0x00,0x63,0x00,0x00, /* .....3.......c.. */ \
	0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x1e,0x01,0x00,0x00,0x66,0x00,0x00, /* .....d.......f.. */ \
	0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x69,0x00,0x00, /* .^...g.......i.. */ \
	0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x01,0x00,0x00, /* .....h.......... */ \
	0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65, /* .<h1>Node Adapte */ \
	0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* r Configuration< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65, /* /h1>....<form me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69, /* thod="post" acti */ \
	0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72, /* on="/nodeadapter */ \
	0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* /config.htm" nam */ \
	0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66, /* e="nodecfg">..<f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ieldset>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54, /* label>TX Delay T */ \
	0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ime:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c, /*  name="dely" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e, /* ue="~delay_time~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="4" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d, /* ="ad1" />&nbsp;m */ \
	0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* Sec.</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20, /* ><label>TX Time  */ \
	0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* out:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c, /*  name="tout" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20, /* ue="~time_out~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="4" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e, /* ad1"/>&nbsp;Sec. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76, /* bel>RX Keep Aliv */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="keep" value */ \
	0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20, /* ="~keep_alive~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="4" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63  /* ad1"/>&nbsp;mSec */
#define DATACHUNK000008 \
	0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66, /* abel>Jitter Buff */ \
	0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* er size:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22, /* ext" name="jitt" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72, /*  value="~jittter */ \
	0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22, /* _size~" size="3" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63, /* bsp;0: not effec */ \
	0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* t</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c, /* abel>RX Auto Pol */ \
	0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* arity:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70, /* ckbox" name="rxp */ \
	0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f, /* l" value="" ~RX_ */ \
	0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c, /* AutoPolarity~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ass="ad1"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52, /* >..<div><label>R */ \
	0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* X Polarity:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="rxpo" value="" */ \
	0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20, /*  ~RX_Polarity~   */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* class="ad1"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c, /* >TX Polarity:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61, /* " name="txpo" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72, /* lue="" ~TX_Polar */ \
	0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ity~ class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b, /* <label>COS Check */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22, /* kbox" name="cos" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43, /*  value="" ~COS_C */ \
	0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* heck~ class="ad1 */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65, /* ><label>S/N Sque */ \
	0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* lch Value:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* l>..<td><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f, /* "sn" value="~SN_ */ \
	0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* Squelch~" size=" */ \
	0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 5" class="ad1"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66, /* &nbsp;0: not eff */ \
	0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* ect</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b, /* <label>CRC Check */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22, /* kbox" name="crc" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43, /*  value="" ~CRC_C */ \
	0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* heck~ class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d, /* <label>Last Fram */ \
	0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* e Send:</label>. */ \
	0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* .<td><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="last" value="" */ \
	0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61, /*  ~LastFrame~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ss="ad1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48, /* >..<div><label>H */ \
	0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e  /* eader Generation */
#define DATACHUNK000009 \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67, /* kbox" name="hdrg */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64, /* " value="" ~Head */ \
	0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* erGen~ class="ad */ \
	0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* 1" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20, /* v><label>Header  */ \
	0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* Gen. Type:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* l>..<td><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="hdrt" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79, /* ="" ~HeaderGenTy */ \
	0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* pe~  class="ad1" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a, /* />&nbsp;Checked: */ \
	0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /*  Space</div>..<d */ \
	0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* iv>&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d, /* sp;&nbsp;&nbsp;. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61, /* p;.Unchecked: La */ \
	0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69, /* st RF Header</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78, /* Half/Full Duplex */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22, /* kbox" name="h_f" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46, /*  value="" ~HalfF */ \
	0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ull~  class="ad1 */ \
	0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64, /* "/>&nbsp;Checked */ \
	0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76, /* :&nbsp;Half</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* >..<div>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* bsp;.&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65, /* ;&nbsp;.Unchecke */ \
	0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f, /* d: Full Duplex</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* div>......<div>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20, /* it" class="ap1"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69, /* value="Save Basi */ \
	0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* c Info." /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* >..</fieldset>.. */ \
	0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* </form>..</div>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00, /* ~....3.......Q.. */ \
	0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00, /* .k...R.......S.. */ \
	0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00, /* .o...T.......U.. */ \
	0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00, /* .x...^.......V.. */ \
	0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00, /* .a...W.......X.. */ \
	0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00, /* .a...Y.......Z.. */ \
	0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00, /* .R...[.......\.. */ \
	0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0xe8,0x08,0x00,0x00,0x02,0x00,0x00, /* .....].......... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65,0x61, /* ent">....<h1>Bea */ \
	0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f, /* con Configuratio */ \
	0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* n</h1>....<form  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63, /* method="post" ac */ \
	0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74, /* tion="/nodeadapt */ \
	0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x20, /* er/config2.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d,0x0a, /* name="beacon">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76  /* <fieldset>..<div */
#define DATACHUNK00000a \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x4d, /* ><label>Beacon M */ \
	0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* essage:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22,0x20, /* xt" name="beac"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d,0x7e, /* value="~BeaconM~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73, /* " size="20" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* s="sm"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65,0x72, /* <div><label>Iner */ \
	0x76,0x61,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* val:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61,0x6c, /*  name="intv" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76,0x7e, /* ue="~BeaconIntv~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="3" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65, /* ="ad1"/>&nbsp;Se */ \
	0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* c.</div>....<div */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75, /* ><input type="su */ \
	0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31, /* bmit" class="ap1 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x65, /* " value="Save Be */ \
	0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* acon Info." /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74, /* div>..</fieldset */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* >..</form>..</di */ \
	0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* v>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe6,0x00,0x00,0x00, /* inc~....3....... */ \
	0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00,0x00,0x00,0xf3,0x01,0x00,0x00, /* q...S...r....... */ \
	0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ....~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Network Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* ation</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* orm method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65, /* " action="/prote */ \
	0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e, /* ct/config.htm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c, /* ame="config">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65, /* <label>MAC Addre */ \
	0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ss:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="mac" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20, /* ="~config_mac~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d, /* label>Server Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="host" value */ \
	0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x22, /* ="~server_name~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e,0x64, /* <label>Out Bound */ \
	0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /*  Port:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20,0x76, /* t" name="oprt" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* alue="~out_port~ */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69, /* " class="ad1" si */ \
	0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ze="5"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42, /* <div><label>In B */ \
	0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ound Port:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72, /* "text" name="ipr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f, /* t" value="~in_po */ \
	0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* rt~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /*  size="5"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52, /* >..<div><label>R */ \
	0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* oom Name:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d  /* text" name="RmNm */
#define DATACHUNK00000b \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61, /* " value="~RoomNa */ \
	0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* me~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20, /* div><label>Node  */ \
	0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* Callsign:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d, /* text" name="NdNm */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61, /* " value="~NodeNa */ \
	0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* me~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65, /* div><label>Jitte */ \
	0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x3a,0x3c,0x2f, /* r Buffer Wait:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4a, /* "jitt" value="~J */ \
	0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* itterSize~" size */ \
	0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="2" class="ad1" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72, /* label>NTP Server */ \
	0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e, /*  Name:</label>&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61, /* bsp;..<select na */ \
	0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69, /* me="ntp">..<opti */ \
	0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e,0x6e, /* on value="pool.n */ \
	0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70, /* tp.org">pool.ntp */ \
	0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61, /* .org..<option va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c, /* lue="europe.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70,0x65, /* .ntp.org">europe */ \
	0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c, /* .pool.ntp.org..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x73, /* option value="as */ \
	0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22, /* ia.pool.ntp.org" */ \
	0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* >asia.pool.ntp.o */ \
	0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75, /* rg..<option valu */ \
	0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* e="oceania.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61, /* ntp.org">oceania */ \
	0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c, /* .pool.ntp.org..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e,0x6f, /* option value="no */ \
	0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c, /* rth-america.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68,0x2d, /* .ntp.org">north- */ \
	0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70, /* america.pool.ntp */ \
	0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61, /* .org..<option va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69, /* lue="south-ameri */ \
	0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22, /* ca.pool.ntp.org" */ \
	0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70, /* >south-america.p */ \
	0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70, /* ool.ntp.org..<op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72,0x69, /* tion value="afri */ \
	0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22, /* ca.pool.ntp.org" */ \
	0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70, /* >africa.pool.ntp */ \
	0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d, /* .org..</select>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a,0x3c, /* abel>Time Zone:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="zone" value="~ */ \
	0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* TimeZone~" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x2f, /* ="ad1" size="3"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73, /* >&nbsp;hours&nbs */ \
	0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* p;..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e,0x65, /* "text" name="zne */ \
	0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a, /* M" value="~TimeZ */ \
	0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c,0x61, /* oneMinutes~" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32, /* ss="ad1" size="2 */ \
	0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73, /* "/>&nbsp;minutes */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c  /* </div>....<div>< */
#define DATACHUNK00000c \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e, /* label>Access Con */ \
	0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c, /* trol File Name:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x61,0x63,0x74,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="actl" value="~ */ \
	0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* AccCtrl~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* v>..<div>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* nbsp;</div>..<di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* v>..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* "checkbox" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70, /* ="sm" name="dhcp */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c, /* " value="1" oncl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78, /* ick="configIPBox */ \
	0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68, /* es()" ~config_dh */ \
	0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e, /* cpchecked~ /> En */ \
	0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* able DHCP</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20, /* .<div><label>IP  */ \
	0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Address:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69, /* e="text" name="i */ \
	0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69, /* p" value="~confi */ \
	0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* g_ip~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74, /* .<div><label>Gat */ \
	0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* eway:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20, /* text" name="gw"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67, /* value="~config_g */ \
	0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* w~" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74, /* iv><label>Subnet */ \
	0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /*  Mask:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62, /* "text" name="sub */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* " value="~config */ \
	0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* _subnet~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61, /* Primary DNS:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="dns1" value=" */ \
	0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f, /* ~config_dns1~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44, /* abel>Secondary D */ \
	0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* NS:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="dns2" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e, /* e="~config_dns2~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75, /* ><input type="su */ \
	0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22, /* bmit" class="sm" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e, /*  value="Save Con */ \
	0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* fig" /></div>..< */ \
	0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f, /* /fieldset>..</fo */ \
	0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* rm>..</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d, /* script language= */ \
	0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* "javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f, /* !--..function co */ \
	0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d, /* nfigIPBoxes() {. */ \
	0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66, /* ..e = document.f */ \
	0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73, /* orms.config;...s */ \
	0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b, /* t = e.dhcp.check */ \
	0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62, /* ed;...e.ip.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77, /* led = st;...e.gw */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64  /* ..e.sub.disabled */
#define DATACHUNK00000d \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e, /*  = st;...e.dns1. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.dns2.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /*  = st;..}..docum */ \
	0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* ent.forms.config */ \
	0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* .mac.disabled =  */ \
	0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49, /* true;....configI */ \
	0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* PBoxes();..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00, /* .....%...>...J.. */ \
	0x00,0xa2,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x16,0x02,0x00,0x00,0x4c,0x00,0x00, /* .....K.......L.. */ \
	0x00,0x85,0x02,0x00,0x00,0x4d,0x00,0x00,0x00,0xe5,0x02,0x00,0x00,0x4e,0x00,0x00, /* .....M.......N.. */ \
	0x00,0x4a,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0xdb,0x05,0x00,0x00,0x61,0x00,0x00, /* .J...n.......a.. */ \
	0x00,0x36,0x06,0x00,0x00,0x6d,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5f,0x00,0x00, /* .6...m......._.. */ \
	0x00,0x52,0x07,0x00,0x00,0x27,0x00,0x00,0x00,0xc6,0x07,0x00,0x00,0x28,0x00,0x00, /* .R...'.......(.. */ \
	0x00,0x23,0x08,0x00,0x00,0x29,0x00,0x00,0x00,0x85,0x08,0x00,0x00,0x2a,0x00,0x00, /* .#...).......... */ \
	0x00,0xec,0x08,0x00,0x00,0x2b,0x00,0x00,0x00,0x4f,0x09,0x00,0x00,0x2c,0x00,0x00, /* .....+...O...,.. */ \
	0x00,0x25,0x0b,0x00,0x00,0x01,0x00,0x00,0x00,0x45,0x0b,0x00,0x00,0x02,0x00,0x00, /* .%.......E...... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67, /* ent">....<h1>Log */ \
	0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68, /* in Successful</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76, /* 1>....<p>You hav */ \
	0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c, /* e successfully l */ \
	0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20, /* ogged in to the  */ \
	0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69, /* web server.  Thi */ \
	0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* s authentication */ \
	0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69, /*  ..is valid unti */ \
	0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72, /* l you close your */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /*  browser.</p>... */ \
	0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20, /* .<p>Credentials  */ \
	0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20, /* are verified in  */ \
	0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20, /* your own custom  */ \
	0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* callback functio */ \
	0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65, /* n called ..<code */ \
	0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74, /* >HTTPAuthenticat */ \
	0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65, /* e</code>.  In he */ \
	0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65, /* re, you can dete */ \
	0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70, /* rmine if the sup */ \
	0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65, /* plied..user name */ \
	0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72, /*  and password ar */ \
	0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65, /* e valid for acce */ \
	0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73, /* ss to the reques */ \
	0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63, /* ted page.  You c */ \
	0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c, /* an ..add multipl */ \
	0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74, /* e users and rest */ \
	0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75, /* rict different u */ \
	0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e, /* sers to differen */ \
	0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t pages.</p>.... */ \
	0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69, /* <p class="exerci */ \
	0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a, /* se"><b>Exercise: */ \
	0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20, /* </b> Change the  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65, /* ssword in..<code */ \
	0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74, /* >HTTPAuthenticat */ \
	0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20, /* e</code> to one  */ \
	0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67, /* of your choosing */ \
	0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b, /* .  (The callback */ \
	0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e  /*  is ..located in */
#define DATACHUNK00000e \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54, /*  <code>CustomHTT */ \
	0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c, /* PApp.c</code>.)< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* /p>....<div clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d, /* s="examplebox">. */ \
	0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68, /* .When you finish */ \
	0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70, /* , refresh this p */ \
	0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72, /* age to test your */ \
	0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61, /*  new user name a */ \
	0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f, /* nd password ..co */ \
	0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* mbination...</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* v>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* pt>....~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94, /* er.inc~....3.... */ \
	0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* ...............~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4d,0x69,0x73,0x73,0x20, /* t">....<h1>Miss  */ \
	0x4d,0x61,0x74,0x63,0x68,0x20,0x74,0x68,0x65,0x20,0x50,0x61,0x73,0x73,0x77,0x6f, /* Match the Passwo */ \
	0x72,0x64,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x50,0x6c, /* rd</h1>....<p>Pl */ \
	0x65,0x61,0x73,0x65,0x20,0x72,0x65,0x2d,0x65,0x6e,0x74,0x72,0x79,0x20,0x74,0x68, /* ease re-entry th */ \
	0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x6e,0x64,0x20,0x74, /* e password and t */ \
	0x68,0x65,0x20,0x63,0x6f,0x6d,0x66,0x69,0x72,0x6d,0x20,0x70,0x61,0x73,0x73,0x77, /* he comfirm passw */ \
	0x6f,0x72,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* ord.</p>....<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* -..document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c, /* lementById('hell */ \
	0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20, /* o').innerHTML =  */ \
	0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f, /* "~hellomsg~";../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* ...~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe2,0x00,0x00,0x00,0x01, /* nc~....3........ */ \
	0x00,0x00,0x00,0x04,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f, /* ...........~rebo */ \
	0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ot~....-...~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e, /* ...<h1>Reboot In */ \
	0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31, /*  Progress...</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74, /* >....<p>Your set */ \
	0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65, /* tings were succe */ \
	0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61, /* ssfully saved, a */ \
	0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20, /* nd the board is  */ \
	0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a, /* now rebooting .. */ \
	0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73, /* to configure its */ \
	0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77, /* elf with the new */ \
	0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /*  settings.</p>.. */ \
	0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ..<h6></h6>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73, /*  language="javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66, /* cript">..<!--..f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75, /* unction rebootDu */ \
	0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d, /* mmy(x){}..setTim */ \
	0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d, /* eout("newAJAXCom */ \
	0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* mand('/protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f, /* eboot.cgi',reboo */ \
	0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c, /* tDummy,false);", */ \
	0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f  /* 500);..//-->..</ */
#define DATACHUNK00000f \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0x7e,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .~.......~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64, /* .<h1>User ID and */ \
	0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e, /*  Password Settin */ \
	0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* g</h1>....<form  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63, /* method="post" ac */ \
	0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75, /* tion="/protect/u */ \
	0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75, /* ser.htm" name="u */ \
	0x73,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74, /* ser">..<fieldset */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55, /* >..<div><label>U */ \
	0x73,0x65,0x72,0x20,0x49,0x44,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* ser ID:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20, /* xt" name="user"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e, /* value="~user_id~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ><label>Password */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* t type="password */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c, /* " name="pwd" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22, /* ue="~user_pass~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a, /* <label>Password: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22, /*  type="password" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c, /*  name="pwdC" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e, /* ue="~user_passC~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75, /* ><input type="su */ \
	0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* bmit" class="ad1 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x49,0x44, /* " value="Save ID */ \
	0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x2f,0x3e,0x3c, /*  & Password" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f, /* ript">..<!--..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d, /* lomsg~";..//-->. */ \
	0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69, /* .</script>....~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b,0x01, /* ..3.......j...;. */ \
	0x00,0x00,0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x73,0x02, /* ..k.......l...s. */ \
	0x00,0x00,0x01,0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x02,0x00,0x00,0x00            /* ..............   */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
