/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 24 2011 01:55:57 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x15,0x00,0x6a,0x55,0x5e,0x2a,0x4a,0xce,0xff,0xff, /* MPFS....jU^.J... */ \
	0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff,0xde,0x6c,0x6a,0x83,0xff,0xff,0xea,0x72, /* &O&-.....lj....r */ \
	0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6, /* .......O..&..... */ \
	0xff,0xff,0x00,0x02,0x00,0x00,0xbe,0x02,0x00,0x00,0x87,0x03,0x00,0x00,0xa8,0x52, /* ...............R */ \
	0xa3,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x0b,0x02,0x00,0x00,0x45,0x06,0x00,0x00, /* .N..........E... */ \
	0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x15,0x02, /* .......N........ */ \
	0x00,0x00,0x07,0x0c,0x00,0x00,0x40,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ......@......N.. */ \
	0x00,0x00,0x02,0x00,0x1e,0x02,0x00,0x00,0x47,0x11,0x00,0x00,0x18,0x00,0x00,0x00, /* ........G....... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x02,0x00,0x00,0x5f,0x11, /* ...N.........._. */ \
	0x00,0x00,0xa0,0x00,0x00,0x00,0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .......B.N...... */ \
	0x2a,0x02,0x00,0x00,0xff,0x11,0x00,0x00,0x28,0x03,0x00,0x00,0x5d,0xae,0xa4,0x4e, /* ........(...]..N */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x35,0x02,0x00,0x00,0x27,0x15,0x00,0x00,0x91,0x03, /* ......5...'..... */ \
	0x00,0x00,0x5d,0xa2,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x3f,0x02,0x00,0x00, /* ..]..N......?... */ \
	0xb8,0x18,0x00,0x00,0x58,0x00,0x00,0x00,0x5d,0xa2,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ....X...]..N.... */ \
	0x00,0x00,0x40,0x02,0x00,0x00,0x10,0x19,0x00,0x00,0x5a,0x0d,0x00,0x00,0x03,0x7f, /* ..@.......Z..... */ \
	0x9f,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x4b,0x02,0x00,0x00,0x6a,0x26,0x00,0x00, /* .N......K...j&.. */ \
	0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x56,0x02, /* ....J..N......V. */ \
	0x00,0x00,0x39,0x29,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00, /* ..9)..H...J..N.. */ \
	0x00,0x00,0x00,0x00,0x57,0x02,0x00,0x00,0x81,0x29,0x00,0x00,0xf8,0x08,0x00,0x00, /* ....W....)...... */ \
	0xda,0xef,0xa4,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x6e,0x02,0x00,0x00,0x79,0x32, /* ...N......n...y2 */ \
	0x00,0x00,0x80,0x00,0x00,0x00,0xda,0xef,0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x6f,0x02,0x00,0x00,0xf9,0x32,0x00,0x00,0x69,0x0a,0x00,0x00,0xb9,0xeb,0xa4,0x4e, /* o....2..i......N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x82,0x02,0x00,0x00,0x62,0x3d,0x00,0x00,0x88,0x00, /* ..........b=.... */ \
	0x00,0x00,0xb9,0xeb,0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x02,0x00,0x00, /* .....N.......... */ \
	0xea,0x3d,0x00,0x00,0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* .=.........N.... */ \
	0x02,0x00,0x95,0x02,0x00,0x00,0xb0,0x41,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b, /* .......A........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x02,0x00,0x00,0xc8,0x41,0x00,0x00, /* .N...........A.. */ \
	0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa9,0x02, /* .......N........ */ \
	0x00,0x00,0xd0,0x41,0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...A.........N.. */ \
	0x00,0x00,0x00,0x00,0xaa,0x02,0x00,0x00,0xd8,0x41,0x00,0x00,0x8e,0x01,0x00,0x00, /* .........A...... */ \
	0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xbd,0x02,0x00,0x00,0x66,0x43, /* ...N..........fC */ \
	0x00,0x00,0x10,0x00,0x00,0x00,0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a, /* 7m3tjz.css.7m3tj */ \
	0x7a,0x2e,0x6a,0x73,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66, /* z.js.auth.htm..f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72, /* ooter.inc.header */ \
	0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00, /* .inc.index.htm.. */ \
	0x4d,0x50,0x46,0x53,0x49,0x6d,0x67,0x32,0x2e,0x63,0x00,0x73,0x74,0x61,0x74,0x75, /* MPFSImg2.c.statu */ \
	0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74, /* s.htm..nodeadapt */ \
	0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70, /* er/config.htm..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74, /* rotect/config.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78, /* m..protect/index */ \
	0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65, /* .htm..protect/re */ \
	0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* boot.cgi..protec */ \
	0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b, /* t/reboot.htm.... */ \
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x56,0x4d,0x6f,0xa3,0x30,0x10,0x3d, /* .........VMo.0.= */ \
	0x37,0x52,0xfe,0x03,0x52,0xaf,0x05,0xf1,0x11,0x68,0x4b,0x4f,0xab,0xee,0x79,0x8f, /* 7R..R....hKO..y. */ \
	0x7b,0x37,0x78,0x08,0x56,0x1d,0x8c,0x8c,0x69,0xd2,0xad,0xfa,0xdf,0xd7,0x36,0x06, /* {7x.V...i.....6. */ \
	0x0c,0x38,0xa9,0x56,0x5a,0x21,0xb5,0x89,0xf1,0xbc,0x37,0x7e,0xf3,0x66,0x9c,0x82, /* .8.VZ!....7~.f.. */ \
	0xe1,0x0f,0xef,0x73,0xbf,0xbb,0xab,0x58,0x23,0xfc,0x0a,0x9d,0x08,0xfd,0xc8,0xbd, /* ...s...X#....... */ \
	0xdf,0xc0,0x31,0x6a,0xd0,0x83,0xf7,0x83,0x13,0x44,0x1f,0xbc,0x0e,0x35,0x9d,0xdf, /* ..1j.....D...5.. */ \
	0x01,0x27,0xd5,0x8b,0xdc,0x5a,0xa0,0xf2,0xed,0xc8,0x59,0xdf,0xe0,0xdc,0xbb,0x4f, /* .'...Z....Y....O */ \
	0x0b,0xf5,0xa8,0xe5,0x13,0xe2,0x47,0xd2,0xe4,0x5e,0xd8,0x5e,0x3c,0xd4,0x0b,0xa6, /* ......G..^.^<... */ \
	0xd6,0x5a,0x84,0x31,0x69,0x8e,0x72,0x51,0x3e,0xb1,0x7a,0x13,0xca,0xe5,0xaf,0xfd, /* .Z.1i.rQ>.z..... */ \
	0x6e,0xbf,0xbb,0xef,0x6a,0x84,0xd9,0xd9,0x67,0x0d,0xe8,0x04,0xce,0x04,0x8b,0x3a, /* n...j...g......: */ \
	0xf7,0x1e,0x33,0xb9,0x4b,0xb3,0x30,0x8e,0x81,0xe7,0x5e,0x24,0x83,0x3a,0x46,0x09, /* ..3.K.0...^$.:F. */ \
	0x96,0x5c,0x69,0x3a,0xbf,0xf1,0x05,0x6b,0x73,0x0d,0xe7,0x62,0xfe,0x9a,0x09,0xc4, /* .\i:...ks..b.... */ \
	0x99,0x69,0x02,0x07,0xe0,0xa1,0x50,0x8f,0x0b,0xd3,0x8e,0xaf,0x39,0xc0,0x55,0x84, /* .i....P.....9.U. */ \
	0xc3,0xe1,0x9b,0xf0,0x8a,0xf5,0xfc,0x5a,0x74,0x82,0xd4,0x73,0x05,0x40,0x42,0xb4, /* .......Zt..s.@B. */ \
	0xe8,0x78,0x95,0x39,0x49,0x92,0x4d,0x31,0xaa,0xaa,0x72,0x0a,0x34,0x95,0x21,0x36, /* .x.9I.M1..r.4.!6 */ \
	0xe2,0xea,0x6a,0x77,0xe4,0x0f,0x48,0xc8,0xb0,0x15,0x4b,0x42,0x81,0x67,0x47,0x38, /* ..jw..H...KB.gG8 */ \
	0xf6,0x08,0x22,0xa8,0xc9,0xca,0xe6,0x4e,0xe2,0xd7,0x9f,0x49,0xbc,0x60,0x3b,0x58, /* .."....N...I.`;X */ \
	0x64,0x67,0x20,0xc7,0x5a,0xe4,0x5e,0xc1,0x28,0x56,0x8b,0x25,0xa3,0x8c,0xcf,0x29, /* dg .Z.^.(V.%...) */ \
	0x0f,0x25,0xf4,0x0b,0x26,0x04,0x3b,0x49,0xc2,0x74,0x08,0xad,0x4d,0x54,0x94,0xe9, /* .%..&.;I.t..MT.. */ \
	0xef,0x76,0x02,0x01,0x57,0xaf,0x86,0x4c,0x29,0x43,0x72,0x93,0x5e,0x78,0x99,0xad  /* .v..W..L)Cr.^x.. */
#define DATACHUNK000001 \
	0x94,0x84,0xe6,0xb4,0x02,0x2e,0xc2,0x47,0x94,0x1c,0x9b,0x79,0xd3,0x00,0x75,0x82, /* .......G...y..u. */ \
	0xa6,0xb7,0x21,0x28,0x54,0x36,0x42,0x94,0x1a,0x04,0x73,0x24,0x9f,0x0f,0xe9,0x18, /* ..!(T6B...s$.... */ \
	0x19,0x2d,0x0c,0x64,0x7b,0x38,0x3a,0x98,0x30,0x4c,0xba,0x96,0x22,0xd9,0x50,0x05, /* .-.d{8:.0L..".P. */ \
	0x65,0xe5,0xdb,0xa6,0x5c,0xb3,0x64,0x46,0x8d,0x73,0x4d,0x04,0x2c,0x24,0x7c,0xba, /* e...\.dF.sM.,$|. */ \
	0x21,0xa1,0x29,0xf3,0xa4,0xd9,0xec,0x0d,0x23,0xaa,0x3e,0x37,0x86,0x92,0x71,0x24, /* !.).....#.>7..q$ */ \
	0x08,0x93,0x87,0x6f,0x64,0xb3,0xad,0xf2,0xce,0x6b,0xf6,0x0e,0x7c,0x5b,0x4e,0xac, /* ...od....k..|[N. */ \
	0xed,0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3e,0x62,0x1a,0x9b,0x0a,0xad,0xb5,0x5f, /* .5.,%;4.>b....._ */ \
	0x29,0x15,0xd9,0x4a,0x8d,0x38,0x83,0x58,0xa3,0x03,0xca,0x30,0xfc,0x3e,0xd9,0x29, /* )..J.8.X...0.>.) */ \
	0xd4,0xca,0x77,0x04,0x18,0x52,0xdd,0x02,0xc8,0x83,0x00,0xa7,0xc4,0x81,0x52,0x47, /* ..w..R........RG */ \
	0x1a,0xc0,0x98,0x6e,0xe8,0x93,0x39,0xcf,0xa0,0x6b,0x51,0x39,0x72,0x50,0x40,0x5c, /* ...n..9..kQ9rP@\ */ \
	0x49,0x2e,0xea,0x09,0xa5,0x62,0x4c,0x98,0xd7,0x56,0x8f,0x84,0xc1,0x13,0x9c,0x6c, /* I....bL..V.....l */ \
	0x67,0x67,0x59,0xb6,0x36,0x5f,0x29,0xc9,0x81,0xdb,0x23,0x4b,0xe9,0xe3,0xa5,0x7a, /* ggY.6_)...#K...z */ \
	0x30,0x7a,0x6b,0xb3,0xe9,0xbc,0xa2,0xc5,0x38,0x34,0x6b,0x72,0x3b,0x96,0x55,0x07, /* 0zk.....84kr;.U. */ \
	0x3c,0xb2,0x98,0x89,0x2a,0x90,0xe8,0xbb,0x85,0x13,0x1f,0x6f,0x97,0x69,0xc6,0xb7, /* <..........o.i.. */ \
	0x13,0x5a,0x8f,0xdf,0x25,0x97,0xd3,0x8c,0x8b,0x04,0x5a,0x9d,0xc2,0x44,0x91,0x0e, /* .Z..%.....Z..D.. */ \
	0xa7,0x93,0x7f,0x23,0xbb,0x21,0x89,0x2c,0x4f,0x23,0x11,0xfc,0x75,0x0a,0xd3,0xfc, /* ...#.!.,O#..u... */ \
	0x0b,0xe0,0x82,0x4e,0x2d,0x85,0x82,0x5d,0xac,0x7a,0xe5,0x5a,0x33,0xd5,0x62,0xde, /* ...N-..].z.Z3.b. */ \
	0xf4,0xc9,0xd5,0x33,0xae,0x13,0x24,0x96,0x55,0x86,0x9a,0xcc,0x25,0xb1,0xec,0x7f, /* ...3..$.U...%... */ \
	0x8f,0xf1,0x74,0xa8,0xa0,0x64,0x18,0xb6,0x57,0xe4,0xab,0x1c,0xeb,0x44,0xba,0xe0, /* ..t..d..W....D.. */ \
	0x17,0x9c,0x1f,0xc6,0x2f,0x0f,0x5e,0x45,0x2e,0x80,0x7d,0x2d,0xbe,0xf9,0x62,0x9d, /* ..../.^E..}-..b. */ \
	0x05,0x78,0x49,0x3a,0xc7,0xe4,0xac,0xe0,0xf9,0x65,0xa5,0x97,0x35,0x12,0xd5,0x48, /* .xI:.....e..5..H */ \
	0xda,0xd8,0x60,0x58,0x8c,0xe7,0x8e,0x87,0x22,0x99,0x99,0x38,0x67,0xdc,0x36,0xf8, /* ..`X...."..8g.6. */ \
	0x12,0x62,0x53,0xfa,0x65,0x32,0x18,0xdf,0xe2,0x79,0x0e,0xe7,0xdb,0x69,0xea,0xa6, /* .bS.e2...y...i.. */ \
	0xcc,0xba,0xa3,0x2c,0x87,0xa2,0xae,0xb6,0x34,0x9f,0x0c,0x96,0xae,0xd2,0x08,0x57, /* ...,....4......W */ \
	0xa3,0xde,0x6a,0x44,0xab,0xfe,0xe6,0x52,0xb2,0x2a,0x37,0xce,0xea,0xf5,0xc4,0x49, /* ..jD...R..7....I */ \
	0x67,0x80,0x8a,0x00,0xc5,0x1d,0x88,0xff,0xeb,0x9e,0x2b,0x46,0x99,0xc8,0x30,0x79, /* g.........+F..0y */ \
	0x5f,0x36,0x80,0xd2,0x4f,0x71,0xa9,0xff,0xe3,0x95,0xb2,0x0d,0xa1,0xa8,0x00,0xba, /* _6..Oq.......... */ \
	0x2d,0x9b,0x1f,0x1d,0x5c,0x73,0x21,0x1e,0xd6,0xc6,0x3e,0xcf,0xc2,0x1b,0x17,0x45, /* -...\s!...>....E */ \
	0xcb,0x3a,0x32,0x8c,0x44,0x54,0xc8,0x3a,0xf6,0x02,0x36,0x09,0x90,0xa6,0xed,0xc5, /* .:2.DT.:..6..... */ \
	0x96,0x7c,0x1c,0x49,0x23,0x4d,0xec,0x4a,0x5e,0xc7,0x06,0xdd,0xc9,0x1e,0x3c,0xf3, /* .|.I#M.J^.....<. */ \
	0xcf,0xb0,0xcd,0x46,0x84,0x23,0xc7,0xce,0xeb,0x97,0xf4,0x14,0xae,0x76,0x20,0x0e, /* ...F.#.......v . */ \
	0x8b,0xab,0x36,0xb6,0xe5,0x0c,0x38,0x74,0x3d,0x15,0xfb,0xdd,0xe7,0x7e,0x35,0x61, /* ..6...8t=....~5a */ \
	0xff,0xad,0xde,0xcb,0x5f,0x58,0xee,0x01,0xee,0xbe,0x91,0xed,0x4e,0x02,0x98,0x64, /* ...._X......N..d */ \
	0xbe,0x0b,0xd8,0x9b,0xce,0x7a,0x6c,0x92,0xe9,0x8e,0x28,0xf4,0x44,0x5d,0x05,0x56, /* .....zl...(.D].V */ \
	0xfa,0x37,0x80,0x8c,0xbc,0x53,0xa1,0x15,0x22,0xd4,0x19,0x5c,0x64,0x8e,0xe0,0x0a, /* .7...S.."..\d... */ \
	0x16,0xc1,0x7d,0xe3,0x26,0x2e,0x4b,0x57,0x6c,0x85,0x4d,0xec,0x5f,0x49,0x0a,0x28, /* ..}.&.KWl.M._I.( */ \
	0xc4,0x17,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5, /* ................ */ \
	0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0, /* W]o.6.}V...;?,2. */ \
	0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87, /* 8N....;.I.fH. q. */ \
	0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68, /* ...h.....JRv."?h */ \
	0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc, /* .r...,.iQ.}Y.X.. */ \
	0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd, /* ....O......F.... */ \
	0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9, /* COF.'.OF.#z.2... */ \
	0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16, /* .h".y..}...2.... */ \
	0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad, /* .y.KFZi.2....... */ \
	0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5, /* .].....k.u"..\g. */ \
	0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12, /* B.N8.K.iC..di%.. */ \
	0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a, /* O...(...s..Y.RZZ */ \
	0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97, /* .eI.;...u.,e.... */ \
	0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3, /* F..sj...]o.o)... */ \
	0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd, /* U.^.....F..::Z.. */ \
	0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7, /* =..:.....Z....o. */ \
	0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89, /* oI.a.%.......%.. */ \
	0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34, /* ...{...+:5F...I4 */ \
	0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce, /* ..TN....2#ez..e. */ \
	0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2, /* .Im.g...p.."..X. */ \
	0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18, /* ....L.h...s..... */ \
	0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6, /* .(.4...3.....+.. */ \
	0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1, /* .z...../)..K.... */ \
	0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41, /* ...p.58 ..3.a..A */ \
	0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4, /* ...)./...r..xF.. */ \
	0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a, /* 77.$.L. .:..;..J */ \
	0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85, /* ..t...ka...vB... */ \
	0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10  /* ...V....I.....|. */
#define DATACHUNK000002 \
	0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4, /* -.x..}..K|.9.+x. */ \
	0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e, /* ......kv......W~ */ \
	0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3, /* .;.....<o..9.... */ \
	0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44, /* ..}0fOt_..`....D */ \
	0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d, /* .........|....G. */ \
	0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0, /* ....Jp..$~..1v!. */ \
	0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09, /* f.....!\....&,.. */ \
	0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba, /* ......8...?.g... */ \
	0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef, /* .e.2..1[......I. */ \
	0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c, /* Y....P...../..)< */ \
	0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2, /* V#..?..<0.m..q.. */ \
	0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1, /* gD.......Q.t..S. */ \
	0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86, /* BVO..C....$..... */ \
	0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36, /* S..R...........6 */ \
	0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76, /* V...s2..u..mvP.v */ \
	0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10, /* ...}.}...F...F.. */ \
	0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6, /* ..!Q.b.6..w..M.. */ \
	0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3, /* ....!.}...Qa.)^. */ \
	0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22, /* ......~...R...^" */ \
	0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08, /* ..,..9.r. .M!... */ \
	0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba, /* .5...me}T+..N.W. */ \
	0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16, /* (. ..IL..6.%qyQ. */ \
	0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c, /* ..2.$...(......< */ \
	0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b, /* .:....../.FSI.P[ */ \
	0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31, /* ..Y....)zNh....1 */ \
	0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f, /* .p.I6&..v.f.LN.. */ \
	0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8, /* ...$.|...~5..... */ \
	0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52, /* .9~..^+..%M...fR */ \
	0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0, /* .....Qj..5%_.... */ \
	0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3, /* ......#..X...... */ \
	0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00, /* }.'..r4...:.we.. */ \
	0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46, /* bq.u..8vv.J....F */ \
	0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e, /* ....G...~...#..^ */ \
	0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb, /* ...6}.e!...M65.. */ \
	0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91, /* ..>t..-i.....b}. */ \
	0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c, /* ?.>T%..&...O.k.. */ \
	0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4, /* ...1............ */ \
	0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1, /* .g...\.h)....... */ \
	0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf, /* .Kv..T..C..oZ... */ \
	0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb, /* ...v......y..Y%. */ \
	0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee, /* bu...0H.c....... */ \
	0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07, /* .K..U.8.4....... */ \
	0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11, /* KI+.x........y4. */ \
	0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e, /* ..Ne1...y....!Z. */ \
	0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55, /* .}.....f.....[.U */ \
	0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5, /* ..b.......0..... */ \
	0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a, /* .......H)..B.... */ \
	0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61, /* .4....rT.BW~..ja */ \
	0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58, /* r.d...&.f7..o..X */ \
	0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56, /* :...r.$....(..RV */ \
	0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a, /* >v.L,....".0.... */ \
	0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4, /* .........;X...x. */ \
	0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd, /* .}bC.E...M....G. */ \
	0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d, /* .8."g...@......M */ \
	0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e, /* 3F..jS">.=0..Q"N */ \
	0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb, /* Z.....J.~D....j. */ \
	0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17, /* .0.."....#.Ja.9. */ \
	0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84, /* .N.D..F.p.I#. .. */ \
	0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2, /* .pf.......Jg_.'. */ \
	0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57, /* .w...t...=.).&3W */ \
	0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75, /* E>,1.{...`#}.N.u */ \
	0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f, /* Vv...|......4H.. */ \
	0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6, /* .].!'......M..s. */ \
	0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde  /* ....g....O..../. */
#define DATACHUNK000003 \
	0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* ..-....~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f, /* h1>Authenticatio */ \
	0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4d,0x61,0x6e, /* n</h1>....<p>Man */ \
	0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x6e, /* y applications n */ \
	0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20, /* eed to restrict  */ \
	0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x75,0x74,0x68,0x6f,0x72, /* access to author */ \
	0x69,0x7a,0x65,0x64,0x20,0x75,0x73,0x65,0x72,0x73,0x2e,0x20,0x20,0x54,0x68,0x65, /* ized users.  The */ \
	0x20,0x48,0x54,0x54,0x50,0x20,0x0d,0x0a,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73, /*  HTTP ..server s */ \
	0x75,0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x48,0x54, /* upports Basic HT */ \
	0x54,0x50,0x20,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f, /* TP Authenticatio */ \
	0x6e,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x74,0x68,0x69, /* n to provide thi */ \
	0x73,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x69,0x74,0x79,0x2e, /* s functionality. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x77,0x6f,0x20,0x66, /* </p>....<p>Two f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x69,0x6e,0x76, /* unctions are inv */ \
	0x6f,0x6c,0x76,0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x61,0x75,0x74,0x68,0x65, /* olved with authe */ \
	0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62,0x6f,0x74,0x68,0x20, /* ntication, both  */ \
	0x6f,0x66,0x20,0x77,0x68,0x69,0x63,0x68,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x61, /* of which store a */ \
	0x0d,0x0a,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x69, /* ..return value i */ \
	0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e, /* n <code>curHTTP. */ \
	0x69,0x73,0x41,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x3c,0x2f,0x63,0x6f, /* isAuthorized</co */ \
	0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x4d,0x53,0x42,0x20,0x6f,0x66, /* de>.  The MSB of */ \
	0x20,0x74,0x68,0x69,0x73,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x69,0x6e,0x64, /*  this value..ind */ \
	0x69,0x63,0x61,0x74,0x65,0x73,0x20,0x77,0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6f, /* icates whether o */ \
	0x72,0x20,0x6e,0x6f,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x69,0x73,0x20, /* r not access is  */ \
	0x61,0x6c,0x6c,0x6f,0x77,0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x69, /* allowed.  The fi */ \
	0x72,0x73,0x74,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x0d,0x0a, /* rst callback, .. */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x4e,0x65,0x65,0x64,0x73,0x41, /* <code>HTTPNeedsA */ \
	0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20,0x64,0x65,0x74,0x65, /* uth</code>, dete */ \
	0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x72,0x65, /* rmines if the re */ \
	0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x20,0x72,0x65,0x71, /* quested page req */ \
	0x75,0x69,0x72,0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x63,0x72,0x65, /* uires..valid cre */ \
	0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63, /* dentials to proc */ \
	0x65,0x65,0x64,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76, /* eed.  Return a v */ \
	0x61,0x6c,0x75,0x65,0x20,0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78, /* alue of <code>0x */ \
	0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x67,0x72,0x65, /* 80</code> or gre */ \
	0x61,0x74,0x65,0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x20, /* ater ..to allow  */ \
	0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e,0x64,0x69,0x74,0x69, /* access unconditi */ \
	0x6f,0x6e,0x61,0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20, /* onally.  Return  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* <code>0x79</code */ \
	0x3e,0x20,0x6f,0x72,0x20,0x6c,0x6f,0x77,0x65,0x72,0x20,0x74,0x6f,0x20,0x72,0x65, /* > or lower to re */ \
	0x71,0x75,0x69,0x72,0x65,0x20,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a, /* quire ..authoriz */ \
	0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x54,0x68, /* ation.</p>....Th */ \
	0x65,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* e second, <code> */ \
	0x48,0x54,0x54,0x50,0x56,0x65,0x72,0x69,0x66,0x79,0x41,0x75,0x74,0x68,0x3c,0x2f, /* HTTPVerifyAuth</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73, /* code> determines */ \
	0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64, /*  if the supplied */ \
	0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x0d,0x0a,0x61, /*  credentials ..a */ \
	0x72,0x65,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x61,0x62,0x6c,0x65,0x20,0x66,0x6f, /* re acceptable fo */ \
	0x72,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20, /* r the requested  */ \
	0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c, /* page.  Your appl */ \
	0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75,0x6c,0x64,0x20,0x72, /* ication should r */ \
	0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x0d,0x0a, /* eturn a value .. */ \
	0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x3c,0x63,0x6f, /* greater than <co */ \
	0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74, /* de>0x80</code> t */ \
	0x6f,0x20,0x70,0x65,0x72,0x6d,0x69,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x2c, /* o permit access, */ \
	0x20,0x6f,0x72,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6c,0x65,0x73,0x73, /*  or a value less */ \
	0x20,0x74,0x68,0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78, /*  than ..<code>0x */ \
	0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x72,0x65,0x6a, /* 79</code> to rej */ \
	0x65,0x63,0x74,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ect the password */ \
	0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /*  supplied.</p>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70, /* ..<p>As an examp */ \
	0x6c,0x65,0x2c,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x69,0x73,0x20  /* le, access this  */
#define DATACHUNK000004 \
	0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x3a, /* restricted page: */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61, /* </p>....<div cla */ \
	0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e, /* ss="examplebox"> */ \
	0x0d,0x0a,0x3c,0x62,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c, /* ..<b>User Name:< */ \
	0x2f,0x62,0x3e,0x20,0x61,0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b, /* /b> admin &nbsp; */ \
	0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c, /*  &nbsp; &nbsp; < */ \
	0x62,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x62,0x3e,0x20, /* b>Password:</b>  */ \
	0x6d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d, /* microchip<br />. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65, /* .<a href="/prote */ \
	0x63,0x74,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x52,0x65,0x73,0x74,0x72, /* ct">Access Restr */ \
	0x69,0x63,0x74,0x65,0x64,0x20,0x50,0x61,0x67,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* icted Page</a>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* </div>....</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* ....<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* sg~";..-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x12, /* er.inc~....3.... */ \
	0x05,0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x3c, /* .......0.......< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65, /* div class="space */ \
	0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* r">&nbsp;</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72, /* .<div id="footer */ \
	0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70, /* ">Copyright &cop */ \
	0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20, /* y; 2011 Satoshi  */ \
	0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64, /* Yasuda 7m3tjz/ad */ \
	0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64, /* 6gz</div>....</d */ \
	0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* iv></div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* /div></div>....< */ \
	0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x3c, /* /body>..</html>< */ \
	0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55, /* !DOCTYPE html PU */ \
	0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54, /* BLIC "-//W3C//DT */ \
	0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69, /* D XHTML 1.0 Stri */ \
	0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70, /* ct//EN"..  "http */ \
	0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52, /* ://www.w3.org/TR */ \
	0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d, /* /xhtml1/DTD/xhtm */ \
	0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d, /* l1-strict.dtd">. */ \
	0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74, /* .<html xmlns="ht */ \
	0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f, /* tp://www.w3.org/ */ \
	0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a, /* 1999/xhtml" xml: */ \
	0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22, /* lang="en" lang=" */ \
	0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74, /* en">..<head>..<t */ \
	0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75, /* itle>D-STAR dSqu */ \
	0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61, /* re Client Progra */ \
	0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b, /* m</title>..<link */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /*  href="/7m3tjz.c */ \
	0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68, /* ss" rel="stylesh */ \
	0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f, /* eet" type="text/ */ \
	0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* css" />..<script */ \
	0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73, /*  src="/7m3tjz.js */ \
	0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* " type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ascript"></scrip */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* t>..</head>....< */ \
	0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* body>..<div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76, /* shadow-one"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22, /*  id="shadow-two" */ \
	0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77, /* ><div id="shadow */ \
	0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* -three"><div id= */ \
	0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a, /* "shadow-four">.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d, /* <div id="page">. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c, /* ...<div id="titl */ \
	0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72  /* e"><div class="r */
#define DATACHUNK000005 \
	0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* ight">D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ure Client</div> */ \
	0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22, /* <span id="hello" */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f, /* >&nbsp;</span></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* div>....<div id= */ \
	0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* "menu">..<a href */ \
	0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76, /* ="/index.htm">Ov */ \
	0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* erview</a>..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f, /* ref="/protect/co */ \
	0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72, /* nfig.htm">Networ */ \
	0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* k Configuration< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e, /* /a>..<a href="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70, /* g.htm">Node Adap */ \
	0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f, /* ter Configuratio */ \
	0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* n</a>..<a href=" */ \
	0x2f,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72, /* /status.htm">Cur */ \
	0x72,0x65,0x6e,0x74,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d, /* rent Status</a>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .</div>~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65, /* h1>D-STAR dSqure */ \
	0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /*  Client</h1>.... */ \
	0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61, /* <table style="pa */ \
	0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78, /* dding-left: 10px */ \
	0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* ;">..<tr><td><b> */ \
	0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f, /* dSqure Server Do */ \
	0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* main Name :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* td><td>~server_n */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62, /* <tr><td><b>Out b */ \
	0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* ound Port :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74, /* td><td>~out_port */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64, /* ><td><b>In bound */ \
	0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Port :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64, /* td>~in_port~</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f, /* <b>Conference Ro */ \
	0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* om Name :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c, /* ><td>~RoomName~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73, /* td><b>Node Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ign :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* >~NodeName~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c, /* b>Access Control */ \
	0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /*  File Name :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c, /* /td><td>~AccCtrl */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76, /* ><td><b>NTP Serv */ \
	0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a, /* er Domain Name : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70, /* sp;</td><td>~Ntp */ \
	0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* Name~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65, /* .<tr><td><b>Time */ \
	0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Zone :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c  /* <td>&nbsp;</td>< */
#define DATACHUNK000006 \
	0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x3c,0x2f,0x74, /* td>~TimeZone~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65, /* d></tr>..</table */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >....</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* t/javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* <!--..document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68, /* etElementById('h */ \
	0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c, /* ello').innerHTML */ \
	0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b, /*  = "~hellomsg~"; */ \
	0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ..//-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* t>....~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* r.inc~......3... */ \
	0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b,0x00,0x00,0x00, /* ....J.......K... */ \
	0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d,0x00,0x00,0x00, /* L...L.......M... */ \
	0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f,0x00,0x00,0x00, /* ....N...A..._... */ \
	0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61,0x00,0x00,0x00, /* ....`.......a... */ \
	0x5d,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x7f,0x03,0x00,0x00,0x02,0x00,0x00,0x00, /* ]............... */ \
	0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xed,0x5c,0xeb,0x6e,0xdb,0xc8, /* ...........\.n.. */ \
	0x15,0xfe,0xdd,0x00,0x79,0x87,0xa9,0x16,0x08,0x9a,0x45,0xa0,0x0b,0xa9,0x8b,0xed, /* ....y.....E..... */ \
	0xd8,0x06,0x1c,0xd9,0x8e,0xdd,0x24,0xb6,0x21,0x29,0xbb,0x5e,0xb4,0x85,0x40,0x91, /* ......$.!).^..@. */ \
	0x23,0x8b,0x35,0x45,0xaa,0x24,0xe5,0xda,0x29,0xea,0xc7,0xe8,0xb3,0xf5,0x71,0x3a, /* #.5E.$..).....q: */ \
	0x73,0x86,0x9c,0x9b,0x86,0x34,0x75,0x01,0x36,0x6d,0x57,0x08,0x18,0x59,0x24,0xe7, /* s....4u.6mW..Y$. */ \
	0x9b,0x73,0xce,0xf7,0xcd,0x9c,0x39,0xbc,0x34,0x7e,0xdc,0xee,0xf3,0xfa,0x15,0xfa, /* .s....9.4~...... */ \
	0x11,0x7d,0xb9,0x39,0x1f,0x5e,0xce,0xef,0xac,0xba,0x0b,0x7f,0x9e,0xe2,0xa9,0x1f, /* .}.9.^.......... */ \
	0xe2,0x04,0x39,0x21,0xec,0xb1,0x90,0x3f,0x77,0xee,0x30,0x4a,0x23,0x34,0xc1,0x28, /* ..9!...?w.0J#4.( */ \
	0x49,0xa3,0x18,0x7b,0xc8,0x0f,0xd1,0x22,0x8e,0xee,0x62,0x67,0x8e,0xe6,0x78,0x1e, /* I..{..."..bg..x. */ \
	0xc5,0x4f,0x75,0x7a,0x2a,0x9c,0x7e,0x75,0x3d,0x42,0xe7,0xd7,0x03,0x74,0x71,0x72, /* .Ouz..~u=B...tqr */ \
	0x75,0x8a,0xbe,0x5c,0x9f,0x5e,0x9e,0x5f,0xf6,0x4f,0x46,0x97,0xd7,0x57,0xb0,0x77, /* u..\.^._.OF..W.w */ \
	0x34,0xf3,0x13,0x34,0xf5,0x03,0x8c,0xc8,0xff,0xce,0x32,0x8d,0xe6,0x4e,0xea,0xbb, /* 4..4......2..N.. */ \
	0x4e,0x10,0x3c,0xa1,0x3b,0x1c,0xe2,0xd8,0x49,0x49,0xeb,0x93,0x27,0x94,0xce,0x70, /* N.<.;...II..'..p */ \
	0x86,0xfe,0x35,0xf5,0x03,0x3f,0x7d,0x82,0xb3,0x4f,0x3e,0x7f,0x56,0x9a,0x1c,0xa2, /* ..5..?}..O>.V... */ \
	0x9f,0x2f,0xc9,0x4f,0x1f,0xce,0xd0,0xf5,0x4f,0x67,0x83,0x9f,0x07,0x97,0xa3,0xd1, /* ./.O....Og...... */ \
	0xd9,0x15,0xfa,0xf0,0x0b,0x1a,0x5d,0x9c,0x65,0xa7,0x7f,0x3c,0xbb,0x3a,0x1b,0x9c, /* ......].e..<.:.. */ \
	0x8c,0xae,0x07,0xd0,0xc0,0x47,0x8e,0xf1,0xaf,0x7f,0xa3,0x56,0x13,0x59,0xf4,0x5f, /* .....G.....V.Y._ */ \
	0xab,0x45,0xbe,0x1e,0x74,0xec,0x83,0x66,0x0f,0xd1,0xa3,0xb6,0xfb,0x34,0x5e,0xbf, /* .E..t..f.....4^. */ \
	0x7a,0xfd,0xea,0x07,0x0f,0x9c,0x88,0xc6,0x63,0x70,0xee,0x97,0x8f,0xd6,0xb8,0x0f, /* z.......cp...... */ \
	0xbf,0xfb,0xa1,0x1b,0x2c,0x3d,0x8c,0x6a,0xa3,0xfe,0xcd,0xe5,0x4d,0x3f,0x0a,0xa7, /* ....,=.j....M?.. */ \
	0xfe,0x5d,0x7d,0x56,0xa3,0x7b,0xa6,0xe8,0xf7,0xec,0x2c,0xef,0x0f,0xf4,0xa4,0xf1, /* .]}V.{....,..... */ \
	0xd7,0xe1,0xd9,0xf8,0xec,0xec,0x66,0x70,0xfd,0xe5,0x2d,0x7a,0xf3,0xc6,0xb0,0x73, /* ......fp..-z...s */ \
	0x78,0x73,0x39,0x3e,0xff,0x7c,0x32,0xbc,0x78,0x6b,0x68,0x1a,0x0d,0x53,0xc7,0xbd, /* xs9>.|2.xkh..S.. */ \
	0x6f,0xc0,0x77,0x0e,0x90,0x37,0x31,0x1c,0x9d,0xf4,0x3f,0x41,0x1b,0xe0,0x24,0x38, /* o.w..71...?A..$8 */ \
	0xff,0xf5,0xab,0xc6,0x9a,0x9c,0xb1,0xd0,0x25,0x30,0xe3,0xd4,0x49,0x9d,0xca,0x7e, /* ........%0..I..~ */ \
	0x6b,0x08,0xe7,0x9c,0x9e,0x90,0x6e,0x5c,0x7c,0xbd,0xfa,0xd4,0x84,0x0f,0xfa,0xf3, /* k.....n\|....... */ \
	0xeb,0x57,0xbf,0x6b,0x3e,0xb6,0xbd,0x77,0xcd,0xc7,0x4e,0x93,0x6c,0xda,0x5d,0xfa, /* .W.k>..w..N.l.]. */ \
	0xcd,0x26,0x9b,0xa6,0x45,0x37,0x2d,0xfe,0x8d,0xee,0xc5,0x0e,0xd9,0xd8,0x74,0x33, /* .&..E7-.......t3 */ \
	0x9d,0xe6,0x1b,0x7b,0x2f,0xdf,0x9b,0x6f,0x50,0x83,0xf5,0xb5,0x4e,0x3f,0x07,0xf5, /* ...{/..oP...N?.. */ \
	0xfa,0x1e,0xf9,0x0f,0xfd,0xd8,0xc8,0xb1,0xda,0xfa,0xf1,0xcd,0xc7,0xbd,0x0e,0xfd, /* ................ */ \
	0xa6,0x36,0xe4,0xd2,0x8d,0x43,0x0f,0xde,0xc7,0xb4,0x63,0x78,0xf5,0xb4,0x0c,0xeb, /* .6...C....cx.... */ \
	0xb4,0xce,0x3f,0x57,0x75,0x05,0x4b,0xf4,0xbc,0x6d,0xaf,0x9e,0xee,0xee,0xaf,0xa2, /* ..?Wu.K..m...... */ \
	0xee,0xad,0x20,0x88,0x9e,0x50,0xac,0x7a,0xbd,0x5f,0x97,0x3f,0x02,0xab,0xac,0x97, /* .. ..P.z._.?.... */ \
	0xf2,0xa6,0x4b,0x7b,0xd2,0xa5,0x9e,0xeb,0xd2,0x83,0xbb,0xd4,0xe1,0x5d,0xda,0x93, /* ..K{.........].. */ \
	0x6e,0x8f,0x6c,0x2c,0xf8,0x6d,0x8f,0x61,0x5d,0x31,0x0c,0x37,0x63,0xac,0xc0,0xea, /* n.l,.m.a]1.7c... */ \
	0x51,0xb7,0x74,0x3d,0xa5,0xdd,0x1e,0xe6,0x0d,0xe1,0x1c,0x06,0x42,0xd5,0xa5,0x16, /* Q.t=........B... */ \
	0x76,0xa9,0x87,0xbb,0x34,0x9a,0xdd,0x76,0xfe,0x67,0xcf,0x62,0x80,0x14,0x2b,0x9d, /* v...4..v.g.b..+. */ \
	0xd7,0xeb,0xcf,0x84,0xcd,0x07,0x33,0xec,0x78,0x38,0x96,0xec,0xd2,0x9a,0x04,0x98, /* ......3.x8...... */ \
	0x26,0x40,0x03,0x19,0x5c,0xde,0x24,0x3d,0xae,0x47,0xad,0xb1,0x9a,0xbc,0x27,0x74, /* &@..\.$=.G....'t */ \
	0x87,0x4d,0x0f,0xb6,0x2c,0xd6,0x00,0xc5,0x22,0x30,0xcf,0xf5,0xfa,0xa1,0xe7,0x3f, /* .M..,..."0.....? */ \
	0x20,0xdf,0x3b,0xaa,0xb9,0x12,0x16,0x77,0x4b,0x8f,0xf7,0x52,0xfc,0x09,0x6d,0xd8, /*  .;....wK..R..m. */ \
	0x2a,0xbe,0xde,0x13,0x6a,0xab,0xdd,0x62,0xc7,0x51,0xac,0x28,0x4c,0x71,0x98,0xd6, /* ....j..b.Q.(Lq.. */ \
	0x8e,0xa9,0x1f,0x0f,0x67,0xad,0x63,0x89,0x87,0x98,0xc7,0x81,0x63,0x41,0xcf,0xdb, /* ....g.c.....cA.. */ \
	0xc2,0x4b,0xf4,0x5b,0xaf,0xa9,0x74,0x87,0x39,0x8d,0x53,0x2a,0xef,0x31,0xc5,0xba, /* .K.[..t.9.S..1.. */ \
	0x8a,0xc8,0x48,0x70,0xe2,0x39,0x8b,0x14,0xc7,0x88,0x0c,0x33,0x92,0x5d,0x6a,0x90, /* ..Hp.9.....3.]j. */ \
	0x7b,0xbc,0x21,0x86,0xc0,0xdd,0x27,0xec,0x07,0x6b,0xac,0xa9,0x6e,0x12,0x18,0x4c, /* {.!...'..k..n..L */ \
	0xb1,0x08,0x21,0x96,0x64,0x50,0xf5,0xa3,0xf0,0xb0,0x41,0xcc,0x92,0x39,0x6f,0x72  /* ..!.dP....A..9or */
#define DATACHUNK000007 \
	0x4b,0x37,0x6f,0x9c,0xa1,0x7a,0x3c,0x4a,0x1e,0xb7,0xab,0xcd,0xa9,0xc2,0x7d,0x62, /* K7o..z<J......}b */ \
	0x7b,0x19,0xe7,0xeb,0x87,0xd3,0x28,0xa6,0xd3,0x4e,0x3a,0x8b,0xbc,0x23,0x81,0x05, /* {.....(..N:..#.. */ \
	0x11,0x01,0x07,0xb1,0xc6,0x6d,0x25,0x54,0x0c,0xa1,0xc5,0x99,0x63,0x32,0x93,0x73, /* .....m%T....c2.s */ \
	0x83,0xd8,0x4a,0xb1,0x6a,0x8b,0x28,0x49,0x6b,0xc8,0x71,0xa9,0x69,0x47,0xb5,0x86, /* ..J.j.(Ik.q.iG.. */ \
	0xe4,0x43,0x43,0xbc,0xba,0x15,0x42,0x35,0x35,0x6a,0x8e,0x62,0x85,0x24,0x5e,0x0e, /* .CC...B55j.b.$^. */ \
	0x0b,0x57,0x83,0x6a,0x4c,0xe7,0xbc,0xac,0x47,0x59,0x73,0x92,0x71,0x98,0x77,0x82, /* .W.jL...GYs.q.w. */ \
	0x3b,0x52,0xa2,0x7b,0xd6,0x63,0xe0,0x3c,0xd1,0x6f,0x3a,0xaf,0xa1,0xd0,0x99,0xe3, /* ;R.{.c.<.o:..... */ \
	0xa3,0x5a,0x18,0x49,0x58,0xc2,0x1a,0x9b,0x87,0xaa,0x57,0x40,0x77,0x29,0x9a,0xfb, /* .Z.IX.....W@w).. */ \
	0xfc,0x34,0x2e,0xc1,0x1e,0xd3,0x97,0x87,0xdd,0xe9,0x1d,0xa5,0xfc,0xe1,0xd4,0xc7, /* .4.............. */ \
	0x81,0x97,0x48,0x58,0x3c,0xd2,0xc6,0x76,0x55,0x19,0xdb,0x9c,0x87,0x0c,0x01,0xcc, /* ..HX<..vU....... */ \
	0xb4,0x24,0x54,0x8a,0x85,0xd3,0x63,0x26,0xe5,0xe3,0xc3,0xc0,0x99,0xe0,0x40,0x60, /* .$T...c&......@` */ \
	0xc1,0xe9,0x1d,0xda,0x64,0x67,0x8f,0x4b,0xa6,0xad,0x76,0x1a,0x82,0xb6,0x9f,0xef, /* ....dg.K..v..... */ \
	0xed,0x08,0x82,0x08,0x6f,0x66,0xbd,0xa3,0x58,0xc7,0xa3,0x5b,0x92,0x28,0x05,0xce, /* ....of..X..[.(.. */ \
	0x13,0x1a,0xf9,0x73,0x7c,0x70,0x28,0xf1,0x70,0x5a,0xdc,0xcb,0x02,0x5b,0xf9,0xa8, /* ...s|p(.pZ...[.. */ \
	0xc6,0x48,0xc3,0x1d,0x63,0xb1,0x39,0xa5,0x01,0xd6,0x50,0xdb,0xfc,0x70,0xb1,0x4c, /* .H..c.9...P..p.L */ \
	0x91,0x36,0xf6,0x42,0xa7,0x19,0xf1,0xd5,0x98,0x4b,0xec,0xe3,0xa4,0x29,0xe3,0x0b, /* .6.B.....K...).. */ \
	0x8c,0xbd,0x4f,0x0b,0xc2,0x89,0x14,0x3f,0xa6,0x8c,0x1f,0x92,0x0f,0x05,0x97,0x54, /* ..O....?.......T */ \
	0xcf,0x31,0xa7,0xf1,0x76,0x21,0x5e,0xac,0x5d,0x37,0xb7,0x46,0xef,0x18,0x1b,0xa3, /* .1..v!^.]7.F.... */ \
	0x8e,0x6a,0x1e,0x0e,0x9e,0x6a,0xe8,0xc1,0x09,0x96,0x04,0xf4,0xd9,0xc8,0x43,0x35, /* .j...j........C5 */ \
	0x36,0x9d,0xe9,0x3b,0x45,0xbc,0x62,0xc8,0xc0,0x6a,0x27,0x6c,0x4e,0x1f,0x27,0xe3, /* 6..;E.b..j'lN.'. */ \
	0x21,0x89,0xd5,0x38,0x25,0xb1,0x7a,0xae,0xa1,0xc4,0xff,0xa6,0xf1,0x50,0xf4,0xcd, /* !..8%.z......P.. */ \
	0xd6,0xbc,0x64,0xab,0x9d,0xb0,0xf3,0x8d,0xe4,0x0e,0x2e,0x7c,0x32,0x32,0x02,0x0f, /* ..d........|22.. */ \
	0x8f,0x6a,0xed,0x1a,0x72,0x03,0x27,0x49,0x8e,0x6a,0x8e,0xd7,0xd2,0xc6,0x28,0x68, /* .j..r.'I.j....(h */ \
	0x17,0x58,0x02,0x64,0xb0,0xba,0x3c,0x18,0x16,0x47,0xa0,0x87,0xd8,0x93,0xdc,0x42, /* .X.d..<..G.....B */ \
	0xc8,0x81,0x84,0x2c,0x2d,0x2c,0x78,0x58,0x43,0x8d,0xe3,0x37,0xe1,0x24,0x59,0xbc, /* ...,-,xXC..7.$Y. */ \
	0x9f,0x0f,0xb1,0x5b,0x5f,0xe1,0xa1,0x41,0x46,0x1b,0x29,0x0d,0x78,0x48,0xa5,0x25, /* ...[_..AF.).xH.% */ \
	0x29,0x4c,0xf3,0xa1,0xe0,0xb7,0xa6,0x34,0x93,0x96,0x2c,0x31,0x50,0x8b,0x71,0x40, /* )L.....4..,1P.q@ */ \
	0xd2,0x17,0xe1,0x3b,0x51,0x18,0xd5,0x16,0x8a,0x96,0xe9,0xff,0x97,0xbe,0x58,0xbb, /* ...;Q.........X. */ \
	0xaa,0x6f,0x36,0xd3,0x57,0x4a,0x7c,0x67,0xd2,0x97,0x49,0x41,0x20,0x2d,0x0d,0xb5, /* .o6.WJ|g..IA -.. */ \
	0x4c,0x55,0x02,0x15,0xec,0x22,0x91,0x1a,0x13,0x34,0xa6,0x2e,0xac,0xcf,0xcb,0x5b, /* LU..."...4.....[ */ \
	0xaa,0x4a,0x9b,0x97,0x15,0x75,0xc9,0xf3,0x72,0x05,0x41,0x15,0x68,0xc9,0xa4,0x17, /* .J...u..r.A.h... */ \
	0x18,0xe7,0x99,0xb8,0x40,0x5b,0x94,0xff,0x1a,0xd6,0x96,0xb3,0x56,0xae,0x17,0xa6, /* ....@[......V... */ \
	0x2f,0x75,0xf6,0x3a,0x1e,0x08,0x2c,0x69,0xd6,0x9a,0xf0,0xd3,0x3b,0xb9,0x5d,0x52, /* /u.:..,i....;.]R */ \
	0xa6,0xe8,0x2a,0xf8,0xca,0xac,0x25,0x94,0x43,0xb1,0x6e,0xd1,0x27,0x8c,0x17,0xe8, /* ......%.C.n.'... */ \
	0x24,0xf0,0x1f,0xc8,0xec,0xd5,0x90,0xe6,0xca,0x5d,0xa8,0x4a,0x28,0x87,0x62,0xa9, /* $........].J(.b. */ \
	0xea,0x4a,0x9f,0x24,0x1e,0xee,0x40,0x55,0xe2,0x5c,0x8a,0xa5,0xaa,0xeb,0xa8,0x26, /* .J.$..@U.\.....& */ \
	0xd9,0x65,0xf2,0xdc,0x9a,0xaa,0x12,0xad,0x50,0xac,0x7b,0xe2,0x41,0xa1,0xae,0x7b, /* .e......P.{.A..{ */ \
	0xac,0xe7,0x36,0x4d,0xae,0xaa,0xa2,0xd8,0x54,0xd7,0x17,0x5e,0x8c,0x1d,0x1a,0xab, /* ..6M....T..^.... */ \
	0xef,0x5e,0x5f,0x65,0x13,0x96,0x26,0x32,0x49,0x5f,0xf3,0x5c,0x60,0x12,0x37,0xb6, /* .^_e..&2I_.\`.7. */ \
	0x9b,0xb0,0x34,0xfa,0x52,0xac,0x07,0x4d,0x60,0xd2,0xfa,0xcb,0xe1,0x4d,0xb6,0x55, /* ..4.R..M`....M.U */ \
	0x0a,0x8a,0x15,0x96,0xc5,0x69,0xd1,0xe5,0x1b,0xf5,0x90,0x3c,0x7c,0x14,0xeb,0x8f, /* .....i.....<|... */ \
	0x7e,0x4a,0x57,0x5e,0x1f,0x96,0xd3,0x29,0xf9,0x2f,0x91,0xed,0x12,0xa1,0x5d,0x51, /* ~JW^...)./....]Q */ \
	0xe6,0xfa,0xea,0xa3,0x58,0xdf,0x40,0xc1,0x42,0x65,0x9a,0xbe,0x0a,0x94,0xb9,0xbe, /* ....X.@.Be...... */ \
	0xfa,0x40,0x5f,0xa0,0x60,0xa1,0x32,0x7d,0x4d,0x54,0xb8,0xfe,0x30,0x78,0xb8,0x4c, /* .@_.`.2}MT..0x.L */ \
	0x7d,0xb0,0x26,0x02,0x05,0xff,0x95,0x78,0x92,0xa9,0xac,0x30,0x67,0x63,0xca,0x34, /* }.&....x...0gc.4 */ \
	0x20,0x68,0x81,0xec,0xf0,0x85,0xa1,0x22,0xb2,0x2c,0x67,0x7b,0xa6,0x48,0x24,0x68, /*  h.....".,g{.H$h */ \
	0x63,0x2a,0x30,0xc9,0x87,0x95,0x34,0x9a,0xeb,0xd0,0x7e,0x41,0x87,0x14,0x2b,0xd7, /* c.0...4...~A..+. */ \
	0x70,0xcd,0x66,0x3a,0x93,0xb0,0x2a,0x69,0xb4,0x92,0x0e,0x6d,0x16,0xaf,0x5c,0xc3, /* p.f:...i...m..\. */ \
	0x99,0xce,0x9a,0x92,0x96,0x1d,0xde,0x4b,0xbe,0x9a,0x15,0x2c,0xe9,0x1a,0x98,0x2e, /* .......K...,.... */ \
	0x56,0xce,0x66,0x2d,0x1f,0x90,0x55,0x6c,0x8a,0x30,0x61,0xbc,0x9b,0xfe,0x7a,0x5a, /* V.f-..Ul.0a...zZ */ \
	0xee,0x40,0xa4,0xc5,0x84,0xd9,0x52,0x24,0x00,0x66,0xb2,0xac,0x94,0x67,0xa0,0x52, /* .@....R$.f...g.R */ \
	0x80,0x2c,0x95,0x43,0xcc,0xae,0xc1,0x2d,0x3a,0x59,0xa6,0x11,0xba,0x89,0x02,0x27, /* .,.C...-:Y.....' */ \
	0xf6,0xe5,0xf9,0x6b,0x17,0x0a,0x16,0x2a,0x05,0x1f,0x1e,0xaa,0xd9,0xa8,0x96,0xb3, /* ...k............ */ \
	0x55,0x50,0x30,0xe3,0x9c,0xa8,0xb3,0xc1,0x9f,0x13,0xde,0x27,0x08,0x33,0xab,0xe9, /* UP0........'.3.. */ \
	0xe5,0x4a,0x76,0x67,0xd8,0xbd,0x9f,0x44,0x8f,0xa6,0x75,0x4a,0xb9,0xaa,0xc1,0x5f, /* .Jvg...D..uJ..._ */ \
	0x6c,0xa0,0x68,0xe6,0xb6,0xae,0xaa,0x9a,0xad,0x53,0x98,0x9a,0xe3,0xc7,0x45,0x40, /* l.h......S....E@ */ \
	0xd5,0x2c,0x69,0xb9,0x68,0xbe,0x95,0x1a,0xca,0x92,0xa4,0x2c,0xae,0x20,0x63,0x53, /* .,i.h......,. cS */ \
	0x5c,0x3b,0x8c,0xf3,0x30,0x1f,0xd7,0xd0,0xf3,0xe0,0x76,0x4c,0xe3,0x76,0xa3,0xd7, /* \;..0.....vL.v.. */ \
	0xf4,0x4a,0xc2,0x9d,0xcb,0xbd,0xd2,0x24,0x0a,0x35,0x3d,0x46,0x89,0xe7,0x7c,0xc2, /* .J.....$.5=F..|. */ \
	0xd4,0xf3,0xa8,0x22,0xf1,0x16,0xa4,0x9c,0x85,0x2a,0x81,0x3c,0x0a,0x84,0x7c,0xc8, /* ...".......<..|. */ \
	0x97,0x61,0x5a,0x8d,0x68,0xdd,0x94,0x53,0x59,0xa2,0xc9,0x62,0x80,0x1a,0x91,0x48, /* .aZ.h..SY..b...H */ \
	0x43,0x6f,0x29,0xf1,0x35,0xbb,0x4c,0x9e,0xdb,0x48,0x0c,0x60,0x17,0xf5,0xa0,0x44, /* Co).5.L..H.`...D */ \
	0x7c,0x49,0x5f,0xd5,0x13,0xcd,0x0a,0x62,0xa0,0x58,0x3c,0x09,0xcd,0x88,0x2f,0xd9, /* |I_....b.X<.../. */ \
	0x65,0x16,0xca,0x86,0x62,0xa0,0x58,0x20,0x2a,0x89,0xf8,0x1a,0x0f,0xd7,0x4a,0x3e  /* e...b.X ......J> */
#define DATACHUNK000008 \
	0xcb,0xc4,0x00,0x3c,0xe4,0x89,0x28,0x23,0xbe,0x34,0x1e,0x56,0x1a,0xe7,0x64,0xe2, /* ...<..(#.4.V..d. */ \
	0x97,0xb1,0x9f,0x62,0xdd,0x70,0xd2,0x33,0xd6,0x1b,0x6b,0x44,0x3b,0x60,0x3f,0x5b, /* ...b.p.3..kD;`?[ */ \
	0xc3,0xaa,0xac,0xd7,0xb9,0xb1,0xe1,0x82,0x4b,0x2b,0x50,0xb0,0x78,0xc9,0xf3,0xc9, /* ........K+P.x... */ \
	0x88,0xb0,0x7e,0xad,0x71,0xa3,0x3a,0xfb,0x91,0x34,0x6e,0x70,0xd6,0xa3,0xe2,0x0b, /* ..~.q.:..4np.... */ \
	0x63,0xad,0xbc,0x98,0xae,0x0e,0x0a,0x6c,0xd8,0x6b,0xab,0x56,0x57,0x97,0x0a,0x2b, /* c......l.k.VW..+ */ \
	0xa6,0x1f,0xa6,0xde,0xb1,0x90,0x44,0x61,0x82,0x55,0x6d,0x4e,0x29,0x94,0x4a,0x96, /* ......Da.UmN).J. */ \
	0x60,0xe5,0xf3,0x0c,0x48,0xa2,0x38,0x99,0x6b,0x4b,0x32,0x5a,0x5f,0x2a,0x19,0x56, /* `...H.8.kK2Z_..V */ \
	0xfa,0xb8,0x10,0x92,0x30,0x4d,0x6c,0x3d,0x95,0x07,0x9d,0x6c,0xfe,0x58,0x4b,0x2a, /* ....0Ml=...l.XK. */ \
	0x6c,0x62,0x7b,0x1e,0xdd,0x8e,0x25,0x49,0x68,0x03,0xca,0xfa,0x8b,0x30,0xb5,0x3c, /* lb{...%Ih....0.< */ \
	0x98,0x53,0x0a,0x06,0x14,0xb1,0x28,0x43,0x54,0x12,0x7a,0xc1,0x74,0x07,0x75,0x3e, /* .S....(CT.z.t.u> */ \
	0x3e,0x50,0x6a,0xb5,0x3e,0xac,0x4d,0xd8,0x70,0x3a,0x5c,0x75,0x6a,0x83,0xe7,0xec, /* >Pj.>.M.p:\uj... */ \
	0xbc,0xe7,0xed,0x22,0xaa,0x14,0x08,0x04,0x26,0xec,0xe3,0xfe,0xf5,0x10,0xf5,0x29, /* ..."....&......) */ \
	0x3d,0x40,0x10,0x12,0xd6,0xcb,0x79,0xd4,0x1a,0x3a,0xa0,0x58,0x59,0x6e,0x25,0x78, /* =@....y..:.XYn%x */ \
	0x2f,0xb8,0xb1,0xab,0xdc,0x8a,0xf3,0x50,0xcb,0xaf,0x6a,0x1a,0xd6,0x0b,0x2b,0x26, /* /......P..j...+& */ \
	0x7e,0x9d,0xa8,0xa7,0x2e,0x2a,0xcc,0x8b,0xa5,0x6c,0x9a,0x71,0xa3,0xe4,0x85,0xc5, /* ~........l.q.... */ \
	0x92,0x26,0x01,0x2d,0x86,0x2c,0xb7,0x2a,0x32,0x33,0x2b,0x2c,0xb2,0x59,0x86,0xc4, /* .&.-.,..23+,.Y.. */ \
	0x6c,0x0c,0x31,0x7b,0xd6,0xed,0xda,0x15,0xf1,0xc1,0x2e,0x8d,0xf4,0xdf,0x47,0x81, /* l.1{..........G. */ \
	0xdb,0xce,0xbb,0xda,0xe6,0xb3,0x26,0xfc,0xd6,0xe3,0x59,0xa9,0x74,0xf5,0x82,0x7b, /* ......&...Y.t..{ */ \
	0x93,0x1d,0xd7,0xcd,0x0b,0xdc,0xc3,0xc6,0x15,0x1a,0xfe,0x6d,0x89,0x03,0x77,0x86, /* ...........m..w. */ \
	0x7e,0xd2,0x13,0x47,0x6d,0x74,0xdb,0x78,0xa1,0x01,0x09,0x16,0x19,0x05,0xe5,0x85, /* ~..Gmt.x........ */ \
	0x85,0x5e,0x08,0xde,0x78,0x12,0x31,0x8c,0xbd,0xca,0x84,0xa2,0x8c,0xbd,0x9b,0x17, /* .^..x.1......... */ \
	0xf6,0xf2,0x55,0xb7,0xbc,0x12,0x07,0x2c,0xa9,0xd0,0x97,0x84,0x72,0x31,0xa2,0x6a, /* ..U....,....r1.j */ \
	0x39,0x0f,0x82,0x06,0x31,0xec,0x70,0x09,0xac,0xc6,0x10,0x16,0x9c,0x59,0x99,0x6f, /* 9...1.p......Y.o */ \
	0x78,0x35,0x86,0x98,0xe9,0xe3,0xfc,0x5e,0xde,0x64,0xe5,0x52,0x41,0x47,0xb5,0xdf, /* x5.....^.d.RAG.. */ \
	0x16,0x58,0xee,0x8c,0x97,0x08,0x3a,0xb4,0x44,0xa0,0x27,0xdf,0xd5,0xcb,0x79,0xe5, /* .X....:.D.'...y. */ \
	0xa5,0x02,0xe0,0x46,0xa2,0x96,0x08,0xa4,0x04,0x2b,0x2b,0x23,0xec,0xa6,0x54,0x40, /* ...F.....++#..T@ */ \
	0xb1,0xde,0x37,0xd5,0x12,0xc1,0x77,0x31,0x7f,0x41,0x2a,0xdd,0xde,0x76,0xfe,0x1a, /* ..7...w1.A...v.. */ \
	0xf4,0x7f,0x9b,0xbf,0x0c,0x58,0x3d,0xfe,0xad,0xea,0xfc,0x15,0xbb,0x1b,0xcc,0x5f, /* .....X=........_ */ \
	0x22,0x86,0xeb,0xcc,0x5f,0x83,0xfe,0x6e,0xe7,0x2f,0x63,0xce,0xa6,0x54,0xd2,0xbf, /* "..._..n./c..T.. */ \
	0x87,0x9c,0x4d,0xb3,0x8b,0xcb,0x18,0xee,0xb6,0x13,0x37,0x02,0x69,0x97,0x6a,0xa5, /* ..M.......7.i.j. */ \
	0x8a,0x3e,0xce,0x38,0xff,0xd9,0x49,0x52,0x74,0x1e,0xd3,0x8b,0x98,0x43,0x1c,0x6a, /* .>.8..IRt....C.j */ \
	0x76,0x6d,0x53,0x19,0x53,0x14,0x01,0x76,0xc9,0x93,0x17,0x61,0xfe,0x7f,0x69,0x81, /* vmS.S..v...a..i. */ \
	0x60,0xa5,0x10,0xac,0x14,0x08,0xd4,0x42,0xf0,0xda,0xd7,0x7c,0x75,0x59,0xe8,0x58, /* `......B...|uY.X */ \
	0xa9,0x5c,0x20,0xf8,0xbc,0x82,0x55,0x18,0xfd,0x35,0xea,0x61,0x7c,0x3c,0x4c,0x81, /* .\ ...U..5.a|<L. */ \
	0x15,0xbc,0x26,0xe6,0xe8,0xdc,0x78,0x69,0xad,0x53,0x55,0x1b,0xc0,0x8d,0x6c,0x2d, /* ..&...xi.SU...l- */ \
	0xb4,0x8b,0xa2,0x58,0xbb,0xe4,0xee,0x44,0xb5,0x28,0x76,0x01,0x77,0x26,0x6a,0xe3, /* ...X...D.(v.w&j. */ \
	0x46,0xbb,0x27,0x69,0x44,0x9c,0x99,0xfb,0xcb,0x74,0xcb,0x59,0xf1,0x9c,0x92,0xdf, /* F.'iD....t.Y.... */ \
	0xaa,0xec,0x47,0xe1,0x6f,0x73,0x0a,0xc7,0xda,0xcb,0xed,0x62,0x7e,0xe5,0xb7,0xa6, /* ..G.os.....b~... */ \
	0xad,0xaa,0x44,0x9a,0x53,0x66,0x5e,0x7c,0x07,0xec,0x97,0x38,0x5f,0x41,0x41,0xa5, /* ..D.Sf^|...8_AA. */ \
	0xb7,0xaa,0x2a,0xb1,0xa6,0x58,0x99,0xb2,0x18,0x31,0x3e,0xca,0xe3,0xe1,0xba,0x0a, /* .....X...1>..... */ \
	0x2a,0x57,0x09,0x5c,0x40,0xd2,0x16,0x45,0xda,0x78,0xb8,0xb3,0x85,0x11,0x8c,0x87, /* .W.\@..E.x...... */ \
	0xda,0xa2,0xa8,0x9c,0x87,0xe5,0x4e,0x33,0xa9,0xc4,0x92,0x6a,0x29,0x92,0xb2,0x88, /* ......N3...j)... */ \
	0x07,0xeb,0x52,0x3e,0xdf,0x31,0x51,0x70,0xab,0x35,0xd1,0x88,0xd0,0xf0,0xd7,0x5f, /* ..R>.1Qp.5....._ */ \
	0x13,0x6d,0x59,0x58,0x33,0x60,0x29,0x45,0x36,0x15,0x4b,0x15,0xcf,0x96,0x53,0x0c, /* .mYX3`)E6.K...S. */ \
	0xc5,0x22,0xc2,0x52,0xa6,0x15,0xe9,0x82,0x7a,0x75,0xf1,0x98,0x83,0xab,0x54,0xa3, /* .".R....zu....T. */ \
	0x29,0x16,0x17,0x16,0x0d,0xdc,0x33,0xda,0x41,0x9d,0xcd,0xbc,0x3a,0xd2,0xea,0x6c, /* ).....3.A...:..l */ \
	0xb0,0x2a,0xd2,0x2e,0xd0,0x8a,0x8b,0xac,0x85,0x89,0x26,0xfb,0x93,0x27,0x42,0x52, /* ..........&..'BR */ \
	0x81,0xa0,0xc9,0xbb,0xc3,0xe6,0xe5,0x64,0xf1,0x1e,0x92,0x50,0xec,0x1d,0xa0,0xe1, /* .......d...P.... */ \
	0xc2,0x71,0xf5,0xbc,0x77,0x5b,0x41,0xe7,0xc6,0x41,0xde,0xab,0x88,0xf9,0x4d,0xa8, /* .q..w[A..A....M. */ \
	0x69,0x59,0x33,0xae,0xfc,0xfa,0x72,0xd9,0x5e,0xd0,0x32,0x31,0x8c,0x5d,0x73,0x66, /* iY3...r.^.21.]sf */ \
	0x5b,0x69,0x9c,0xdf,0xb8,0x5d,0xd3,0x5e,0x8a,0x25,0xe3,0xd0,0xad,0x76,0x03,0xc4, /* [i...].^.%...v.. */ \
	0x96,0xd6,0xa8,0x3e,0x54,0xad,0xda,0xce,0x87,0x10,0xbe,0x92,0xb5,0xb9,0xc0,0xa9, /* ...>T........... */ \
	0x9b,0xd6,0xe6,0xdb,0x98,0x04,0xa4,0xe9,0x48,0xf3,0x97,0x62,0x56,0xfd,0x6b,0x58, /* ........H..bV.kX */ \
	0x65,0x8c,0x32,0x90,0xbc,0x70,0x79,0xc1,0x96,0x68,0x5d,0x31,0x46,0x51,0xc2,0xc3, /* e.2..py..h]1FQ.. */ \
	0x12,0x62,0x70,0xae,0xe7,0x51,0xa5,0x83,0xc7,0x1a,0x8a,0x80,0x1c,0x80,0x0d,0x1c, /* .bp..Q.......... */ \
	0x9c,0xf9,0xe5,0xeb,0xaf,0xca,0x49,0xa2,0xb8,0xa3,0xab,0xfb,0x8e,0xaf,0xf5,0xa4, /* ......I......... */ \
	0xeb,0x47,0x17,0x4e,0x30,0x95,0xd6,0x7a,0x2c,0xbd,0x16,0x25,0x41,0x97,0xfb,0xab, /* .G.N0..z,..%A... */ \
	0x9d,0xef,0x10,0x57,0xd0,0x45,0x8d,0xac,0x24,0x3f,0x3c,0x5f,0x06,0x01,0x3a,0x5d, /* ...W.E..$?<_..:] */ \
	0x2e,0x02,0xfc,0xf8,0xbf,0x92,0x1f,0xa2,0x82,0xfc,0xb0,0xe8,0xc2,0x98,0xb5,0x66, /* ...............f */ \
	0xe2,0xc8,0xee,0xc5,0xeb,0xe6,0xbf,0xbd,0x5c,0x8c,0x98,0x8d,0xa7,0x6b,0x16,0x23, /* ........\....k.# */ \
	0x0c,0xdc,0x30,0x85,0x5e,0xbe,0x80,0x94,0xe5,0x8d,0x84,0x2f,0x34,0xa4,0xf2,0x05, /* ..0.^....../4... */ \
	0xa4,0xdd,0x14,0x23,0xe4,0xc1,0x4b,0x9f,0xd9,0xca,0x07,0xaf,0xca,0xb3,0x9b,0x71, /* ...#..K........q */ \
	0x50,0x9e,0x48,0x33,0x5b,0xd1,0xa0,0x6c,0xf2,0x57,0x55,0x7d,0xcb,0x57,0x89,0x17, /* P.H3[..l.WU}.W.. */ \
	0xef,0xa9,0xff,0x72,0x8d,0x2b,0x4f,0xdd,0x55,0x4d,0x79,0x2b,0xdf,0xcd,0x9a,0xa7  /* ...r.+O.UMy+.... */
#define DATACHUNK000009 \
	0xc2,0x15,0xef,0x66,0xb5,0x79,0xf4,0x2d,0xce,0x4d,0x7e,0x35,0xf1,0xa5,0x3b,0xc5, /* ...f.y.-.M~5..;. */ \
	0xa8,0x12,0x92,0xe5,0x64,0xee,0xa7,0x55,0xee,0x14,0x63,0x7e,0x55,0x97,0x0d,0x15, /* ....d..U..c~U... */ \
	0xd2,0xba,0x8e,0xcd,0xef,0x14,0x5b,0xb4,0x78,0x3a,0x37,0xd4,0x8b,0xce,0xbc,0xb6, /* ......[.x:7..... */ \
	0x2b,0x6e,0x87,0x14,0x8c,0x64,0xee,0x13,0x45,0x54,0xf1,0x9c,0x1e,0x7f,0xda,0xcb, /* +n...d..ET...... */ \
	0xca,0x8a,0xe3,0x50,0x74,0x7e,0xc0,0xe8,0x83,0x93,0xf8,0x2e,0xba,0x0c,0xa7,0x51, /* ...Pt~.........Q */ \
	0x5d,0x5f,0x04,0x6e,0x58,0x11,0xb0,0xb8,0xbe,0xf3,0x07,0x92,0x80,0xf3,0x52,0x75, /* ]_.nX.........Ru */ \
	0xa0,0x31,0xf5,0xf5,0xa2,0x58,0xfe,0xb0,0x52,0x3e,0xec,0xb6,0x5f,0x6e,0x5c,0x7d, /* .1...X..R>.._n\} */ \
	0x76,0x4d,0x7e,0x12,0x2e,0xf0,0x12,0xf6,0x10,0x52,0x83,0x3e,0xa3,0xb6,0xf2,0x24, /* vM~......R.>...$ */ \
	0x5c,0x55,0x6b,0x8a,0x1f,0x9f,0xcc,0xf0,0x81,0x87,0xb9,0x55,0xf0,0xa8,0xe4,0x54, /* \Uk........U...T */ \
	0x7e,0x8a,0x4b,0x3c,0x24,0x23,0x96,0x5e,0x86,0x26,0xd9,0xe3,0x93,0xcd,0x17,0x36, /* ~.K<$#.^.&.....6 */ \
	0x70,0xb7,0x42,0x8a,0xe3,0x3a,0x7b,0x54,0x52,0x7b,0xd2,0x94,0x3d,0x8a,0x3b,0x31, /* p.B..:{TR{..=.;1 */ \
	0x9c,0xd9,0x5a,0xfd,0x0d,0x06,0x0f,0x7d,0x87,0xa5,0x61,0xf1,0xc7,0x59,0xef,0xcd, /* ..Z....}..a..Y.. */ \
	0x58,0xfb,0x86,0x36,0x6c,0x03,0xd6,0x54,0x6f,0x9c,0x6c,0xda,0x45,0x58,0x91,0x11, /* X..6l..To.l.EX.. */ \
	0x8b,0xb5,0xab,0x35,0xde,0x59,0xc5,0x82,0xf9,0x4b,0x3f,0xae,0x5b,0x84,0xf5,0x68, /* ...5.Y...K?.[..h */ \
	0xb6,0x0b,0x1b,0xda,0xe8,0x19,0xec,0x6a,0xe9,0x86,0x34,0xd5,0xe7,0x86,0x15,0x2c, /* .......j..4...., */ \
	0xc7,0x88,0xe5,0xd9,0x86,0x36,0xf6,0x8b,0xb0,0x34,0x83,0x9d,0x35,0xb1,0xf6,0x0c, /* .....6...4..5... */ \
	0x6d,0x18,0xf8,0x02,0xf9,0xa1,0xe2,0x34,0xb2,0x71,0x8b,0xb0,0x06,0x46,0x2c,0x77, /* m......4.q...F,w */ \
	0x62,0x68,0xc3,0x5b,0xc5,0xf2,0x5a,0x06,0xe7,0xe2,0x22,0x2c,0x33,0xe7,0x61,0x24, /* bh.[..Z...",3.a$ */ \
	0xd5,0x1e,0xd8,0x6e,0x4e,0x35,0x2c,0x54,0xe5,0x43,0xb1,0x96,0x39,0x48,0xf6,0x61, /* ...nN5,T.C..9H.a */ \
	0x6f,0x11,0xd8,0xe4,0x91,0xfc,0x3e,0x0a,0xfc,0xf0,0xde,0x99,0x04,0x18,0x25,0x4f, /* o.....>.......%O */ \
	0xf3,0x49,0x14,0x24,0xeb,0x3c,0x9a,0xdf,0x68,0xa0,0xf3,0x28,0x46,0xfd,0xd6,0xde, /* .I.$.<..h..(F... */ \
	0x3b,0xfa,0x0a,0x86,0x04,0x23,0x27,0x26,0x0d,0x2d,0x02,0x3f,0x45,0x7e,0x98,0x46, /* ;....#'&.-.?E~.F */ \
	0x28,0xc1,0x0b,0x78,0x81,0x02,0xf9,0x3d,0x76,0x9e,0x12,0x92,0x1a,0xba,0xce,0x92, /* (..x...=v....... */ \
	0x1c,0x46,0xf6,0x27,0x0b,0x8c,0xbd,0x04,0x2d,0x17,0xc8,0x8d,0xe6,0x0b,0x3f,0x80, /* .F.'....-.....?. */ \
	0xda,0x25,0x72,0x50,0x10,0xa5,0xc4,0x2e,0xde,0x76,0x44,0xda,0x8d,0xb3,0x43,0x70, /* .%rP.....vD...Cp */ \
	0x9c,0x00,0x0e,0xc2,0x61,0xea,0x13,0x20,0xcf,0x49,0x1d,0xd6,0x32,0x9a,0x2f,0xc9, /* ....a.. .I..2./. */ \
	0xd2,0x60,0x82,0xf3,0x57,0x16,0x20,0x32,0xf9,0x39,0x28,0xf1,0xc3,0x3b,0x62,0xd8, /* .`..W. 2.9(..;b. */ \
	0x83,0x13,0xfb,0x60,0x21,0xe9,0x10,0xb4,0x8b,0xc3,0x64,0x49,0x4e,0x4f,0x67,0x4e, /* ...`!.....dINOgN */ \
	0x0a,0xcd,0x51,0x17,0x10,0x10,0x2f,0xc2,0x09,0x5c,0x70,0x8c,0x71,0x14,0xd3,0xaa, /* ..Q.../..\p.q... */ \
	0x12,0xdd,0x07,0x18,0xee,0x6c,0x19,0xde,0x27,0xf4,0x35,0x16,0xe7,0x64,0x5a,0x9d, /* .....l..'.5..dZ. */ \
	0xa1,0xbf,0xcf,0x70,0xc8,0xfb,0xc4,0xda,0x8c,0x16,0xa9,0x3f,0xf7,0xbf,0x81,0x15, /* ...p.......?.... */ \
	0x09,0xb8,0x21,0x5d,0xc6,0xb4,0x27,0x51,0x58,0x57,0xdf,0xa6,0x30,0x1e,0xb7,0xf6, /* ..!]..'QXW..0... */ \
	0xfa,0xb7,0xb7,0x6f,0x09,0x39,0x06,0xd7,0x5f,0xd0,0x87,0x5f,0x46,0xec,0xe5,0x13, /* ...o.9.._.._F... */ \
	0xe3,0x61,0xea,0xc4,0xe9,0x9f,0xfe,0x82,0x8e,0xd0,0x3f,0xb4,0x77,0x1d,0xfc,0xf3, /* .a........?.w... */ \
	0xfd,0xca,0xc1,0xec,0x5e,0x2f,0xd3,0xd1,0xad,0xa2,0xa3,0x2d,0xd3,0xd1,0x16,0x3d, /* ....^/.....-...= */ \
	0xfa,0x07,0x1c,0x24,0x78,0x8d,0xfe,0xbc,0xd3,0xef,0x39,0xd3,0x7f,0xc8,0x5a,0x0d, /* ...$x.....9...Z. */ \
	0x3d,0x7f,0xba,0x16,0x33,0x4b,0x19,0x7b,0x16,0x12,0x6f,0x4e,0xa1,0x6f,0x5b,0xbf, /* =...3K.{..oN.o[. */ \
	0x77,0xa3,0x91,0x77,0x0f,0x91,0xd8,0x95,0xbf,0xeb,0x42,0x3d,0x6e,0x8b,0x97,0x6e, /* w..w......B=n..n */ \
	0xfc,0x07,0xce,0x71,0x46,0x71,0x7e,0x45,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ...qFq~E..~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* ..<h1>D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* ure Status</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* ...<table style= */ \
	0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31, /* "padding-left: 1 */ \
	0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* 0px;">..<tr><td> */ \
	0x3c,0x62,0x3e,0x44,0x61,0x74,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* <b>Date :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f, /* ><td>~CurDate~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* d><b>Time :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e, /* td><td>~CurTime~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>PTT :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e, /* /td><td>~CurPTT~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>COS :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e, /* /td><td>~CurCOS~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72, /* <td><b>Node User */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26  /*  :</b></td><td>& */
#define DATACHUNK00000a \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43, /* nbsp;</td><td>~C */ \
	0x75,0x72,0x55,0x73,0x65,0x72,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* urUser~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53, /* >..<tr><td><b>SS */ \
	0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* N :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* CurSSN~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >..</table>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a, /* /div>..</body>.. */ \
	0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76, /* <meta http-equiv */ \
	0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65, /* ="refresh" conte */ \
	0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* nt="10">..<body> */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* er.inc~......3.. */ \
	0x00,0x9b,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00, /* .....c.......d.. */ \
	0x00,0x1e,0x01,0x00,0x00,0x66,0x00,0x00,0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00, /* .....f...^...g.. */ \
	0x00,0xa4,0x01,0x00,0x00,0x69,0x00,0x00,0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00, /* .....i.......h.. */ \
	0x00,0x9d,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64, /* ent">....<h1>Nod */ \
	0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* e Adapter Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* st" action="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e, /* eadapter/config. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63, /* htm" name="nodec */ \
	0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* fg">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58, /* ..<div><label>TX */ \
	0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /*  Delay Time:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* e="text" name="d */ \
	0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c, /* ely" value="~del */ \
	0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ay_time~" size=" */ \
	0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f, /* 4" class="ad1" / */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69, /* >&nbsp;mSec.</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61, /* TX Time out:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74, /* e="text" name="t */ \
	0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d, /* out" value="~tim */ \
	0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* e_out~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* bsp;Sec.</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b, /* <div><label>RX K */ \
	0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* eep Alive:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65, /* "text" name="kee */ \
	0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f, /* p" value="~keep_ */ \
	0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* alive~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* bsp;mSec.</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74, /* .<div><label>Jit */ \
	0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a, /* ter Buffer size: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="jitt" value=" */ \
	0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20  /* ~jittter_size~"  */
#define DATACHUNK00000b \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="3" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e, /* ad1"/>&nbsp;0: n */ \
	0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ot effect</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20, /* .<div><label>RX  */ \
	0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f, /* Auto Polarity:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="rxpl" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61, /* ="" ~RX_AutoPola */ \
	0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* rity~ class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69, /* <label>RX Polari */ \
	0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ty:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20, /* ox" name="rxpo"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c, /* value="" ~RX_Pol */ \
	0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* arity~  class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* d1"/></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61, /* v><label>TX Pola */ \
	0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* rity:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* txpo" value="" ~ */ \
	0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61, /* TX_Polarity~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ss="ad1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43, /* >..<div><label>C */ \
	0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* OS Check:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="cos" value=" */ \
	0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c, /* " ~COS_Check~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ass="ad1" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75, /* S/N Squelch Valu */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* e:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c, /* t" name="sn" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e, /* ue="~SN_Squelch~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="5" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a, /* ="ad1"/>&nbsp;0: */ \
	0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76, /*  not effect</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43, /* >..<div><label>C */ \
	0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* RC Check:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="crc" value=" */ \
	0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c, /* " ~CRC_Check~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ass="ad1"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c, /* >..<div><label>L */ \
	0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c, /* ast Frame Send:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20, /* ox" name="last"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72, /* value="" ~LastFr */ \
	0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ame~ class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65, /* <label>Header Ge */ \
	0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* neration:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="hdrg" value= */ \
	0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63, /* "" ~HeaderGen~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* lass="ad1" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c  /* iv>..<div><label */
#define DATACHUNK00000c \
	0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70, /* >Header Gen. Typ */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* e:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72, /* ckbox" name="hdr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61, /* t" value="" ~Hea */ \
	0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61, /* derGenType~  cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ss="ad1"/>&nbsp; */ \
	0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f, /* Checked: Space</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70, /* div>..<div>&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* ;&nbsp;.&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65, /* bsp;&nbsp;.Unche */ \
	0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65, /* cked: Last RF He */ \
	0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* ader</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c, /* ><label>Half/Ful */ \
	0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* l Duplex:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="h_f" value=" */ \
	0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c, /* " ~HalfFull~  cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /* ass="ad1"/>&nbsp */ \
	0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48, /* ;Checked:&nbsp;H */ \
	0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* alf</div>..<div> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62, /* &nbsp;&nbsp;.&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a, /* sp;&nbsp;&nbsp;. */ \
	0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20, /* Unchecked: Full  */ \
	0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* Duplex</div>.... */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ..<div><input ty */ \
	0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73, /* pe="submit" clas */ \
	0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53, /* s="ap1" value="S */ \
	0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22, /* ave Basic Info." */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /*  /></div>..</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* .</div>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00, /* .....Q...k...R.. */ \
	0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00, /* .....S...o...T.. */ \
	0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00, /* .....U...x...^.. */ \
	0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00, /* .....V...a...W.. */ \
	0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00, /* .....X...a...Y.. */ \
	0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00, /* .....Z...R...[.. */ \
	0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00, /* .....\.......].. */ \
	0x00,0xe8,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e, /* .<h1>Network Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* figuration</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d, /* ...<form method= */ \
	0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f, /* "post" action="/ */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* protect/config.h */ \
	0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67, /* tm" name="config */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* ">..<fieldset>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20, /* <div><label>MAC  */ \
	0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Address:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20, /* ext" name="mac"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d, /* value="~config_m */ \
	0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ac~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65  /* div><label>Serve */
#define DATACHUNK00000d \
	0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* r Name:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20, /* xt" name="host"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* value="~server_n */ \
	0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ame~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20, /* <div><label>Out  */ \
	0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Bound Port:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70, /* ="text" name="op */ \
	0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f, /* rt" value="~out_ */ \
	0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* port~" class="ad */ \
	0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* 1" size="5"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c, /* >In Bound Port:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="iprt" value="~ */ \
	0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* in_port~" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e, /* "ad1" size="5"/> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* bel>Room Name:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52, /* "RmNm" value="~R */ \
	0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* oomName~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f, /* Node Callsign:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e, /* "NdNm" value="~N */ \
	0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* odeName~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* NTP Server Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* </label>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a, /* p;&nbsp;&nbsp;.. */ \
	0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74, /* <select name="nt */ \
	0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* p">..<option val */ \
	0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ue="pool.ntp.org */ \
	0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* ">pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65, /* <option value="e */ \
	0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* urope.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* rg">europe.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f, /*  value="asia.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e, /* l.ntp.org">asia. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65, /* ption value="oce */ \
	0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* ania.pool.ntp.or */ \
	0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* g">oceania.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d, /*  value="north-am */ \
	0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* erica.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* rg">north-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73, /* <option value="s */ \
	0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* outh-america.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68, /* l.ntp.org">south */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* alue="africa.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63, /* l.ntp.org">afric */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a  /* a.pool.ntp.org.. */
#define DATACHUNK00000e \
	0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* </select>..</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ime Zone:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65, /* text" name="zone */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f, /* " value="~TimeZo */ \
	0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ne~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /*  size="3"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69, /* ccess Control Fi */ \
	0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* le Name:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x74,0x6c,0x22, /* ext" name="actl" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c, /*  value="~AccCtrl */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* v>&nbsp;&nbsp;</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* div>..<div>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e, /* ox" class="sm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="dhcp" value */ \
	0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f, /* ="1" onclick="co */ \
	0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e, /* nfigIPBoxes()" ~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b, /* config_dhcpcheck */ \
	0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48, /* ed~ /> Enable DH */ \
	0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* CP</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73, /* label>IP Address */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75, /* " name="ip" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20, /* e="~config_ip~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f, /* label>Gateway:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ame="gw" value=" */ \
	0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* ~config_gw~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c, /* el>Subnet Mask:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="sub" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74, /* ="~config_subnet */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79, /* v><label>Primary */ \
	0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  DNS:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31, /* text" name="dns1 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* " value="~config */ \
	0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* _dns1~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65, /* ..<div><label>Se */ \
	0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61, /* condary DNS:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* e="text" name="d */ \
	0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e, /* ns2" value="~con */ \
	0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* fig_dns2~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* iv>..<div><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63, /*  type="submit" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* lass="sm" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e, /* "Save Config" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73, /* </div>..</fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f, /* et>..</form>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* div>....<script  */ \
	0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63, /* language="javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75  /* ript">..<!--..fu */
#define DATACHUNK00000f \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42, /* nction configIPB */ \
	0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64, /* oxes() {...e = d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f, /* ocument.forms.co */ \
	0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64, /* nfig;...st = e.d */ \
	0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65, /* hcp.checked;...e */ \
	0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* .ip.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* t;...e.gw.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62, /* ed = st;...e.sub */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.dns1.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32, /* d = st;...e.dns2 */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* .}..document.for */ \
	0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69, /* ms.config.mac.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a, /* sabled = true;.. */ \
	0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28, /* ..configIPBoxes( */ \
	0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /* );..document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c, /* ElementById('hel */ \
	0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d, /* lo').innerHTML = */ \
	0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a, /*  "~hellomsg~";.. */ \
	0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* //-->..</script> */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00, /* c~....3.......%. */ \
	0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2,0x01,0x00,0x00,0x4b,0x00, /* ..>...J.......K. */ \
	0x00,0x00,0x16,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x85,0x02,0x00,0x00,0x4d,0x00, /* ......L.......M. */ \
	0x00,0x00,0xe5,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x60,0x05,0x00,0x00,0x61,0x00, /* ......N...`...a. */ \
	0x00,0x00,0xdf,0x05,0x00,0x00,0x5f,0x00,0x00,0x00,0x66,0x06,0x00,0x00,0x27,0x00, /* ......_...f...'. */ \
	0x00,0x00,0xda,0x06,0x00,0x00,0x28,0x00,0x00,0x00,0x37,0x07,0x00,0x00,0x29,0x00, /* ......(...7...). */ \
	0x00,0x00,0x99,0x07,0x00,0x00,0x2a,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x2b,0x00, /* ..............+. */ \
	0x00,0x00,0x63,0x08,0x00,0x00,0x2c,0x00,0x00,0x00,0x39,0x0a,0x00,0x00,0x01,0x00, /* ..c...,...9..... */ \
	0x00,0x00,0x59,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..Y.......~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63, /* ..<h1>Login Succ */ \
	0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* essful</h1>....< */ \
	0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65, /* p>You have succe */ \
	0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69, /* ssfully logged i */ \
	0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72, /* n to the web ser */ \
	0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65, /* ver.  This authe */ \
	0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76, /* ntication ..is v */ \
	0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63, /* alid until you c */ \
	0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65, /* lose your browse */ \
	0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65, /* r.</p>....<p>Cre */ \
	0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72, /* dentials are ver */ \
	0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77, /* ified in your ow */ \
	0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63, /* n custom callbac */ \
	0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65, /* k function calle */ \
	0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75, /* d ..<code>HTTPAu */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* thenticate</code */ \
	0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75, /* >.  In here, you */ \
	0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69, /*  can determine i */ \
	0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a, /* f the supplied.. */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64, /* ssword are valid */ \
	0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74, /*  for access to t */ \
	0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67, /* he requested pag */ \
	0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64, /* e.  You can ..ad */ \
	0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73, /* d multiple users */ \
	0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69, /*  and restrict di */ \
	0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f, /* fferent users to */ \
	0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73, /*  different pages */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73, /* .</p>....<p clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e, /* s="exercise"><b> */ \
	0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68  /* Exercise:</b> Ch */
#define DATACHUNK000010 \
	0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61, /* ange the user na */ \
	0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* me and password  */ \
	0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75, /* in..<code>HTTPAu */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* thenticate</code */ \
	0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72, /* > to one of your */ \
	0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65, /*  choosing.  (The */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c, /*  callback is ..l */ \
	0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* ocated in <code> */ \
	0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c, /* CustomHTTPApp.c< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* /code>.)</p>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d, /* <div class="exam */ \
	0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79, /* plebox">..When y */ \
	0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65, /* ou finish, refre */ \
	0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20, /* sh this page to  */ \
	0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73, /* test your new us */ \
	0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73, /* er name and pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69, /* word ..combinati */ \
	0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* on...</div>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d, /* document.getElem */ \
	0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29, /* entById('hello') */ \
	0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68, /* .innerHTML = "~h */ \
	0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* ellomsg~";..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a, /* >..</script>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00, /* ....3........... */ \
	0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e, /* ........~reboot~ */ \
	0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ....-...~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72, /* <h1>Reboot In Pr */ \
	0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* ogress...</h1>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e, /* ..<p>Your settin */ \
	0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66, /* gs were successf */ \
	0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20, /* ully saved, and  */ \
	0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77, /* the board is now */ \
	0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20, /*  rebooting ..to  */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66, /* configure itself */ \
	0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65, /*  with the new se */ \
	0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ttings.</p>....< */ \
	0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* h6></h6>....</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61, /* v>....<script la */ \
	0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* nguage="javascri */ \
	0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* pt">..<!--..func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79, /* tion rebootDummy */ \
	0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75, /* (x){}..setTimeou */ \
	0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e, /* t("newAJAXComman */ \
	0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f, /* d('/protect/rebo */ \
	0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75, /* ot.cgi',rebootDu */ \
	0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30, /* mmy,false);",500 */ \
	0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* );..//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* ipt>..~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x7e,0x01, /* r.inc~....3...~. */ \
	0x00,0x00,0x02,0x00,0x00,0x00                                                    /* ......           */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
