/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 23 2011 08:33:38 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x19,0x00,0x6a,0x55,0x5e,0x2a,0x4a,0xce,0xff,0xff, /* MPFS....jU^.J... */ \
	0xea,0x81,0xff,0xff,0x2a,0xba,0xff,0xff,0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff, /* ........&O&-.... */ \
	0x98,0xdb,0x0a,0x85,0xff,0xff,0xea,0x72,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f, /* .......r.......O */ \
	0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0x60,0x02,0x00,0x00,0x36,0x03, /* ..&.......`...6. */ \
	0x00,0x00,0x85,0x03,0x00,0x00,0x68,0x06,0x9e,0x4e,0x00,0x00,0x00,0x00,0x01,0x00, /* ......h..N...... */ \
	0x6b,0x02,0x00,0x00,0xbb,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x92,0x1b,0x15,0x4e, /* k..............N */ \
	0x00,0x00,0x00,0x00,0x01,0x00,0x75,0x02,0x00,0x00,0x7d,0x0c,0x00,0x00,0x40,0x05, /* ......u...}...@. */ \
	0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x7e,0x02,0x00,0x00, /* .....N......~... */ \
	0xbd,0x11,0x00,0x00,0x18,0x00,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* ...........N.... */ \
	0x00,0x00,0x7f,0x02,0x00,0x00,0xd5,0x11,0x00,0x00,0x98,0x08,0x00,0x00,0x92,0x1b, /* ................ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x8b,0x02,0x00,0x00,0x6d,0x1a,0x00,0x00, /* .N..........m... */ \
	0x20,0x00,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8c,0x02, /*  ......N........ */ \
	0x00,0x00,0x8d,0x1a,0x00,0x00,0xf8,0x03,0x00,0x00,0xe4,0xa2,0x9b,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x02,0x00,0x98,0x02,0x00,0x00,0x85,0x1e,0x00,0x00,0x20,0x00,0x00,0x00, /* ............ ... */ \
	0xe4,0xa2,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x02,0x00,0x00,0xa5,0x1e, /* ...N............ */ \
	0x00,0x00,0xa0,0x00,0x00,0x00,0xc4,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .......B.N...... */ \
	0xa4,0x02,0x00,0x00,0x45,0x1f,0x00,0x00,0xfe,0x02,0x00,0x00,0x6c,0x22,0x9c,0x4e, /* ....E.......l".N */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xaf,0x02,0x00,0x00,0x43,0x22,0x00,0x00,0xa7,0x02, /* ..........C".... */ \
	0x00,0x00,0xca,0xea,0x9a,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xb9,0x02,0x00,0x00, /* .....N.......... */ \
	0xea,0x24,0x00,0x00,0x40,0x00,0x00,0x00,0xca,0xea,0x9a,0x4e,0x00,0x00,0x00,0x00, /* .$..@......N.... */ \
	0x00,0x00,0xba,0x02,0x00,0x00,0x2a,0x25,0x00,0x00,0xb6,0x01,0x00,0x00,0x92,0x1b, /* .......%........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xc3,0x02,0x00,0x00,0xe0,0x26,0x00,0x00, /* .N...........&.. */ \
	0xa0,0x03,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xce,0x02, /* .......N........ */ \
	0x00,0x00,0x80,0x2a,0x00,0x00,0x20,0x00,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00, /* ...... ......N.. */ \
	0x00,0x00,0x00,0x00,0xcf,0x02,0x00,0x00,0xa0,0x2a,0x00,0x00,0x85,0x08,0x00,0x00, /* ................ */ \
	0xc2,0xa4,0x9e,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xe6,0x02,0x00,0x00,0x25,0x33, /* ...N..........%3 */ \
	0x00,0x00,0x80,0x00,0x00,0x00,0xc2,0xa4,0x9e,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0xe7,0x02,0x00,0x00,0xa5,0x33,0x00,0x00,0x42,0x07,0x00,0x00,0xac,0x95,0x9b,0x4e, /* .....3..B......N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xfa,0x02,0x00,0x00,0xe7,0x3a,0x00,0x00,0x78,0x00, /* ...........:..x. */ \
	0x00,0x00,0xac,0x95,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00, /* .....N.......... */ \
	0x5f,0x3b,0x00,0x00,0xc6,0x03,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* _;.........N.... */ \
	0x02,0x00,0x0d,0x03,0x00,0x00,0x25,0x3f,0x00,0x00,0x18,0x00,0x00,0x00,0x92,0x1b, /* ......%?........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x03,0x00,0x00,0x3d,0x3f,0x00,0x00, /* .N..........=?.. */ \
	0x08,0x00,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x21,0x03, /* .......N......!. */ \
	0x00,0x00,0x45,0x3f,0x00,0x00,0x08,0x00,0x00,0x00,0x92,0x1b,0x15,0x4e,0x00,0x00, /* ..E?.........N.. */ \
	0x00,0x00,0x00,0x00,0x22,0x03,0x00,0x00,0x4d,0x3f,0x00,0x00,0x8e,0x01,0x00,0x00, /* ...."...M?...... */ \
	0x12,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x35,0x03,0x00,0x00,0xdb,0x40, /* ...N......5....@ */ \
	0x00,0x00,0x10,0x00,0x00,0x00,0x12,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a, /* 7m3tjz.css.7m3tj */ \
	0x7a,0x2e,0x6a,0x73,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00,0x00,0x63, /* z.js.auth.htm..c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x79,0x6e,0x76, /* ookies.htm..dynv */ \
	0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* ars.htm..footer. */ \
	0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69, /* inc.header.inc.i */ \
	0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x6e,0x6d,0x70,0x2e,0x62, /* ndex.htm..snmp.b */ \
	0x69,0x62,0x00,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e, /* ib.upload.htm..n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63, /* g.htm..protect/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* onfig.htm..prote */ \
	0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72, /* ct/index.htm..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69, /* otect/reboot.cgi */ \
	0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74, /* ..protect/reboot */ \
	0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* .htm............ */ \
	0xad,0x56,0xc1,0x6e,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x01,0xa9,0xd7,0x80,0x20, /* .V.n.0.=7R.....  */ \
	0x09,0xb4,0xa5,0xa7,0xd5,0xde,0xf7,0xb8,0x77,0x83,0x87,0x60,0xd5,0xc1,0xc8,0x98, /* ........w..`.... */ \
	0x26,0xdd,0xaa,0xff,0xbe,0xb6,0x31,0xd8,0x80,0x93,0x6a,0xa5,0x2d,0x52,0xdb,0x18, /* &.....1...j.-R.. */ \
	0xcf,0x7b,0xe3,0x37,0x6f,0xc6,0x29,0x18,0xfe,0x08,0x3e,0xb7,0x9b,0x87,0x8a,0x35, /* .{.7o.)...>....5 */ \
	0x22,0xac,0xd0,0x99,0xd0,0x8f,0x3c,0xf8,0x0d,0x1c,0xa3,0x06,0xed,0x82,0x1f,0x9c, /* ".....<......... */ \
	0x20,0xba,0x0b,0x3a,0xd4,0x74,0x61,0x07,0x9c,0x54,0xaf,0x72,0x6b,0x81,0xca,0xb7, /*  ..:.ta..T.rk... */ \
	0x13,0x67,0x7d,0x83,0xf3,0xe0,0x31,0x2d,0xd4,0xa3,0x96,0xcf,0x88,0x9f,0x48,0x93, /* .g}...1-......H. */ \
	0x07,0x71,0x7b,0x0d,0x50,0x2f,0x98,0x5a,0x6b,0x11,0xc6,0xa4,0x39,0xc9,0x45,0xf9, /* .q{.P/.Zk...9.E. */ \
	0xec,0xd5,0x9b,0x58,0x2e,0x7f,0x6d,0x37,0xdb,0xcd,0x63,0x57,0x23,0xcc,0x2e,0x21, /* ...X..m7..cW#..! */ \
	0x6b,0x40,0x27,0x70,0x21,0x58,0xd4,0x79,0xf0,0x94,0xc9,0x5d,0x9a,0x85,0x71,0x0c, /* k@'p!X.y...]..q. */ \
	0x3c,0x0f,0x12,0x19,0xd4,0x31,0x4a,0xb0,0xe4,0x4a,0x53,0xfb,0x26,0x14,0xac,0xcd, /* <....1J..JS.&... */ \
	0x35,0x9c,0x8f,0xf9,0xcb,0x12,0x88,0x0b,0xd3,0x04,0x1e,0xc0,0x63,0xa1,0x1e,0x1f  /* 5...........c... */
#define DATACHUNK000001 \
	0xa6,0x1b,0x5f,0x73,0x80,0x9b,0x08,0xc7,0xe3,0x37,0xe1,0x15,0xeb,0xf9,0xad,0xe8, /* .._s.....7...... */ \
	0x03,0x52,0xcf,0x0d,0x00,0x09,0xd1,0xa2,0xd3,0x4d,0xe6,0xc3,0xe1,0xb0,0x2a,0x46, /* .R.......M.....F */ \
	0x55,0x55,0x5e,0x81,0xa6,0x32,0xec,0x8d,0xb8,0xba,0xda,0x1d,0xf9,0x03,0x12,0x32, /* UU^..2.........2 */ \
	0x6e,0xc5,0x9c,0x50,0x60,0xeb,0x08,0xcf,0x1e,0x41,0x04,0x35,0x59,0xb9,0xdc,0xb1, /* n..P`....A.5Y... */ \
	0xfc,0x19,0xe8,0x27,0xb6,0xa3,0x43,0x76,0x01,0x72,0xaa,0x45,0x1e,0x14,0x8c,0x62, /* ...'..Cv.r.E...b */ \
	0xb5,0x58,0x32,0xca,0xb8,0x4d,0x79,0x28,0x61,0x58,0x30,0x21,0xd8,0x59,0x12,0xa6, /* .X2..My(aX0!.Y.. */ \
	0x43,0x68,0x6d,0xa2,0x92,0x4c,0x7f,0x76,0x13,0x88,0xb8,0x7a,0x35,0x64,0x4a,0x19, /* Chm..L.v...z5dJ. */ \
	0x92,0x9b,0xf4,0xc2,0xab,0xb5,0xd2,0x21,0x36,0xa7,0x15,0x70,0x15,0x21,0xa2,0xe4, /* .......!6..p.!.. */ \
	0xd4,0xd8,0x4d,0x03,0xd4,0x19,0x9a,0xde,0x85,0xa0,0x50,0xb9,0x08,0x49,0x6a,0x10, /* ..M.......P..Ij. */ \
	0xcc,0x91,0x42,0x3e,0xa4,0x63,0x64,0x74,0x30,0x90,0xeb,0xe1,0xe4,0x68,0xc2,0x30, /* ..B>.cdt0....h.0 */ \
	0xe9,0x5a,0x8a,0x64,0x43,0x15,0x94,0x95,0x6f,0xab,0x72,0x59,0xc9,0x8c,0x1a,0x97, /* .Z.dC...o.rY.... */ \
	0x9a,0x08,0x98,0x49,0xf8,0x7c,0x47,0x42,0x53,0xe6,0x49,0x33,0xeb,0x0d,0x23,0xaa, /* ...I.|GBS.I3..#. */ \
	0x3e,0x37,0x86,0x92,0x71,0x24,0x08,0x93,0x87,0x6f,0x64,0xb3,0x2d,0xf2,0xce,0x6b, /* >7..q$...od.-..k */ \
	0xf6,0x0e,0x7c,0x5d,0x4e,0xac,0xed,0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3d,0x62, /* ..|]N..5.,%;4.=b */ \
	0xba,0x37,0x15,0x5a,0x6a,0xbf,0x50,0x2a,0x71,0x95,0x1a,0x71,0x06,0xb1,0x46,0x07, /* .7.Zj.P.q..q..F. */ \
	0x94,0x71,0xfc,0x7d,0xb2,0x53,0xa8,0x93,0xef,0x08,0x30,0xa4,0xba,0x06,0x90,0x07, /* .q.}.S....0..... */ \
	0x01,0x4e,0x89,0x07,0xa5,0x4e,0x34,0x80,0x31,0xdd,0xd0,0x27,0x36,0xcf,0xa8,0x6b, /* .N...N4.1..'6..k */ \
	0x51,0x39,0x72,0x50,0x40,0x5c,0x49,0x2e,0xea,0x09,0xa5,0x62,0x4c,0x98,0xd7,0x4e, /* Q9rP@\I....bL..N */ \
	0x8f,0xc4,0xd1,0x33,0x9c,0x5d,0x67,0x67,0x59,0xb6,0x34,0x5f,0x29,0xc9,0x81,0xbb, /* ...3.]ggY.4_)... */ \
	0x23,0x4b,0xe9,0x13,0xa4,0x7a,0x30,0x06,0x4b,0xb3,0xe9,0xbc,0x92,0xd9,0x38,0x34, /* #K...z0.K.....84 */ \
	0x6b,0x72,0x3b,0x96,0x55,0x07,0x3c,0xb2,0x98,0x89,0x2a,0x90,0xe8,0xbb,0x99,0x13, /* kr;.U.<......... */ \
	0x9f,0xee,0x97,0xc9,0xe2,0xbb,0x09,0x2d,0xc7,0xef,0x9c,0xcb,0x6b,0xc6,0x59,0x02, /* .......-....k.Y. */ \
	0xad,0x4e,0x61,0xa2,0x48,0x87,0xd3,0xc9,0xdf,0x89,0xdb,0x90,0x44,0x96,0xa7,0x91, /* .Na.H.......D... */ \
	0x08,0xe1,0x32,0x85,0x69,0xfe,0x45,0x70,0x45,0xe7,0x96,0x42,0xc1,0xae,0x4e,0xbd, /* ..2.i.EpE..B..N. */ \
	0x72,0xad,0x99,0x6a,0xb1,0x60,0xfa,0xcf,0xd7,0x33,0xbe,0x13,0x1c,0x1c,0xab,0x0c, /* r..j.`...3...... */ \
	0x35,0xb1,0x25,0x71,0xec,0xff,0x88,0xf1,0x74,0xa8,0xa8,0x64,0x18,0xd6,0x57,0xe4, /* 5.%q....t..d..W. */ \
	0x4f,0x39,0xd6,0x89,0x74,0xc1,0x2f,0xb8,0xec,0xc6,0x0f,0xbb,0xa0,0x22,0x57,0xc0, /* O9..t./......"W. */ \
	0xa1,0x16,0xdf,0x7c,0x70,0xce,0x02,0xbc,0x24,0x9d,0x67,0x72,0x56,0xf0,0xf2,0xba, /* ...|p...$.grV... */ \
	0xd0,0xcb,0x19,0x89,0x6a,0x24,0xad,0x6c,0x30,0x2c,0xee,0x6d,0xc7,0x43,0x71,0xb0, /* ....j$.l0,.m.Cq. */ \
	0x4c,0x9c,0x33,0xee,0x1a,0x7c,0x0e,0xb1,0x2a,0xfd,0x3c,0x19,0x8c,0xef,0xf1,0xbc, /* L.3..|....<..... */ \
	0xc4,0xf6,0x76,0x9a,0xba,0x29,0x73,0xee,0x28,0xc7,0xa1,0xa8,0xab,0x1d,0xcd,0x27, /* ..v..)s.(......' */ \
	0x83,0xa5,0x8b,0x34,0xe2,0xc5,0xa8,0x77,0x1a,0xd1,0xa9,0xbf,0xb9,0x94,0x9c,0xca, /* ...4...w........ */ \
	0x8d,0xb3,0x7a,0x39,0x71,0x52,0x0b,0x50,0x11,0xa0,0xb8,0x03,0xf1,0x7f,0xdd,0x73, /* ..z9qR.P.......s */ \
	0xc3,0x28,0x13,0x19,0x26,0xef,0xf3,0x06,0x50,0xfa,0x29,0x2e,0xf5,0x77,0xbc,0x52, /* .(..&...P.)..w.R */ \
	0xd6,0x21,0x14,0x15,0x40,0xd7,0x65,0x0b,0x93,0xa3,0x6f,0x2e,0xec,0x87,0xb5,0xb1, /* .!..@.e...o..... */ \
	0xcf,0xb3,0xf8,0xce,0x45,0xd1,0xb2,0x8e,0x0c,0x23,0x11,0x15,0xb2,0x8e,0xbd,0x80, /* ....E....#...... */ \
	0x55,0x02,0xa4,0x69,0x7b,0xb1,0x26,0x1f,0x47,0xd2,0x48,0xb3,0xf7,0x25,0xaf,0x63, /* U..i{.&.G.H..%.c */ \
	0xa3,0xee,0xec,0x0e,0x1e,0xfb,0x35,0x6c,0xb5,0x11,0xe1,0xc4,0xb3,0xf3,0xf6,0x25, /* ......5l.......% */ \
	0x3d,0x85,0xab,0x1d,0x88,0xc3,0xec,0xaa,0xdd,0xbb,0x72,0x46,0x1c,0xba,0x9e,0x8a, /* =.........rF.... */ \
	0xed,0xe6,0x73,0xbb,0x98,0xb0,0xff,0x56,0xef,0xf9,0x37,0x2c,0xff,0x00,0xf7,0xdf, /* ..s....V..7,.... */ \
	0xc8,0x6e,0x27,0x01,0x4c,0x32,0x3f,0x44,0xec,0x4d,0x67,0x3d,0x36,0xc9,0x74,0x47, /* .n'.L2?D.Mg=6.tG */ \
	0x14,0x7a,0xa2,0x2e,0x02,0x2b,0xfd,0x1d,0x40,0x46,0x3e,0xa8,0xd0,0x0a,0x11,0xea, /* .z...+..@F>..... */ \
	0x0d,0x2e,0x32,0x4f,0x70,0x05,0xb3,0xe0,0xbe,0xf1,0x13,0x97,0xa5,0x2f,0xb6,0xc2, /* ..2Op......../.. */ \
	0x26,0xf6,0x2f,0x34,0xd6,0x95,0x07,0x17,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00, /* &./4............ */ \
	0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc, /* ......W]o.6.}V.. */ \
	0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1, /* .;?,2.8N....;.I. */ \
	0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a, /* fH. q....h.....J */ \
	0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac, /* Rv."?h.r...,.iQ. */ \
	0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae, /* }Y.X......O..... */ \
	0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23, /* .F....COF.'.OF.# */ \
	0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6, /* z.2....h".y..}.. */ \
	0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f, /* .2.....y.KFZi.2. */ \
	0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75, /* .......].....k.u */ \
	0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85, /* "..\g.B.N8.K.iC. */ \
	0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9, /* .di%..O...(...s. */ \
	0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4, /* .Y.RZZ.eI.;...u. */ \
	0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f, /* ,e....F..sj...]o */ \
	0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3, /* .o)...U.^.....F. */ \
	0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a, /* .::Z..=..:.....Z */ \
	0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed, /* ....o.oI.a.%.... */ \
	0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35, /* ...%.....{...+:5 */ \
	0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23, /* F...I4..TN....2# */ \
	0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3, /* ez..e..Im.g...p. */ \
	0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b  /* ."..X.....L.h... */
#define DATACHUNK000002 \
	0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7, /* s......(.4...3.. */ \
	0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5, /* ...+...z...../). */ \
	0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2, /* .K.......p.58 .. */ \
	0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72, /* 3.a..A...)./...r */ \
	0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a, /* ..xF..77.$.L. .: */ \
	0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa, /* ..;..J..t...ka.. */ \
	0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a, /* .vB......V....I. */ \
	0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c, /* ....|.-.x..}..K| */ \
	0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83, /* .9.+x.......kv.. */ \
	0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2, /* ....W~.;.....<o. */ \
	0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6, /* .9......}0fOt_.. */ \
	0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c, /* `....D.........| */ \
	0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e, /* ....G.....Jp..$~ */ \
	0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca, /* ..1v!.f.....!\.. */ \
	0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82, /* ..&,........8... */ \
	0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff, /* ?.g....e.2..1[.. */ \
	0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f, /* ....I.Y....P.... */ \
	0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08, /* ./..)<V#..?..<0. */ \
	0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51, /* m..q..gD.......Q */ \
	0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f, /* .t..S.BVO..C.... */ \
	0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16, /* $.....S..R...... */ \
	0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f, /* .....6V...s2..u. */ \
	0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46, /* .mvP.v...}.}...F */ \
	0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87, /* ...F....!Q.b.6.. */ \
	0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e, /* w..M......!.}... */ \
	0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb, /* Qa.)^.......~... */ \
	0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20, /* R...^"..,..9.r.  */ \
	0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b, /* .M!....5...me}T+ */ \
	0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36, /* ..N.W.(. ..IL..6 */ \
	0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6, /* .%qyQ...2.$...(. */ \
	0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90, /* .....<.:....../. */ \
	0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e, /* FSI.P[..Y....)zN */ \
	0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae, /* h....1.p.I6&..v. */ \
	0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e, /* f.LN.....$.|...~ */ \
	0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25, /* 5......9~..^+..% */ \
	0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35, /* M...fR.....Qj..5 */ \
	0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58, /* %_..........#..X */ \
	0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6, /* ......}.'..r4... */ \
	0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb, /* :.we..bq.u..8vv. */ \
	0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2, /* J....F....G...~. */ \
	0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12, /* ..#..^...6}.e!.. */ \
	0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98, /* .M65....>t..-i.. */ \
	0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96, /* ...b}.?.>T%..&.. */ \
	0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98, /* .O.k.....1...... */ \
	0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a, /* .......g...\.h). */ \
	0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f, /* .......Kv..T..C. */ \
	0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1, /* .oZ......v...... */ \
	0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92, /* y..Y%.bu...0H.c. */ \
	0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0, /* .......K..U.8.4. */ \
	0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18, /* ......KI+.x..... */ \
	0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe, /* ...y4...Ne1...y. */ \
	0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1, /* ...!Z..}.....f.. */ \
	0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2, /* ...[.U..b....... */ \
	0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd, /* 0............H). */ \
	0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42, /* .B.....4....rT.B */ \
	0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37, /* W~..jar.d...&.f7 */ \
	0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde, /* ..o..X:...r.$... */ \
	0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22, /* .(..RV>v.L,...." */ \
	0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b, /* .0.............; */ \
	0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d, /* X...x..}bC.E...M */ \
	0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1, /* ....G..8."g...@. */ \
	0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d, /* .....M3F..jS">.= */ \
	0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44, /* 0..Q"NZ.....J.~D */ \
	0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23  /* ....j..0.."....# */
#define DATACHUNK000003 \
	0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d, /* .Ja.9..N.D..F.p. */ \
	0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d, /* I#. ...pf....... */ \
	0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d, /* Jg_.'..w...t...= */ \
	0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60, /* .).&3WE>,1.{...` */ \
	0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb, /* #}.N.uVv...|.... */ \
	0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f, /* ..4H...].!'..... */ \
	0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f, /* .M..s.....g....O */ \
	0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x7e,0x69,0x6e, /* ..../...-....~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* >....<h1>Authent */ \
	0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* ication</h1>.... */ \
	0x3c,0x70,0x3e,0x4d,0x61,0x6e,0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74, /* <p>Many applicat */ \
	0x69,0x6f,0x6e,0x73,0x20,0x6e,0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73, /* ions need to res */ \
	0x74,0x72,0x69,0x63,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20, /* trict access to  */ \
	0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x20,0x75,0x73,0x65,0x72,0x73, /* authorized users */ \
	0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x0d,0x0a,0x73,0x65, /* .  The HTTP ..se */ \
	0x72,0x76,0x65,0x72,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x42,0x61, /* rver supports Ba */ \
	0x73,0x69,0x63,0x20,0x48,0x54,0x54,0x50,0x20,0x41,0x75,0x74,0x68,0x65,0x6e,0x74, /* sic HTTP Authent */ \
	0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69, /* ication to provi */ \
	0x64,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* de this function */ \
	0x61,0x6c,0x69,0x74,0x79,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* ality.</p>....<p */ \
	0x3e,0x54,0x77,0x6f,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x20,0x61, /* >Two functions a */ \
	0x72,0x65,0x20,0x69,0x6e,0x76,0x6f,0x6c,0x76,0x65,0x64,0x20,0x77,0x69,0x74,0x68, /* re involved with */ \
	0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c, /*  authentication, */ \
	0x20,0x62,0x6f,0x74,0x68,0x20,0x6f,0x66,0x20,0x77,0x68,0x69,0x63,0x68,0x20,0x73, /*  both of which s */ \
	0x74,0x6f,0x72,0x65,0x20,0x61,0x0d,0x0a,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76, /* tore a..return v */ \
	0x61,0x6c,0x75,0x65,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75, /* alue in <code>cu */ \
	0x72,0x48,0x54,0x54,0x50,0x2e,0x69,0x73,0x41,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a, /* rHTTP.isAuthoriz */ \
	0x65,0x64,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20, /* ed</code>.  The  */ \
	0x4d,0x53,0x42,0x20,0x6f,0x66,0x20,0x74,0x68,0x69,0x73,0x20,0x76,0x61,0x6c,0x75, /* MSB of this valu */ \
	0x65,0x0d,0x0a,0x69,0x6e,0x64,0x69,0x63,0x61,0x74,0x65,0x73,0x20,0x77,0x68,0x65, /* e..indicates whe */ \
	0x74,0x68,0x65,0x72,0x20,0x6f,0x72,0x20,0x6e,0x6f,0x74,0x20,0x61,0x63,0x63,0x65, /* ther or not acce */ \
	0x73,0x73,0x20,0x69,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x65,0x64,0x2e,0x20,0x20, /* ss is allowed.   */ \
	0x54,0x68,0x65,0x20,0x66,0x69,0x72,0x73,0x74,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61, /* The first callba */ \
	0x63,0x6b,0x2c,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* ck, ..<code>HTTP */ \
	0x4e,0x65,0x65,0x64,0x73,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* NeedsAuth</code> */ \
	0x2c,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20, /* , determines if  */ \
	0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61, /* the requested pa */ \
	0x67,0x65,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c, /* ge requires..val */ \
	0x69,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x74, /* id credentials t */ \
	0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x65,0x64,0x2e,0x20,0x20,0x52,0x65,0x74,0x75, /* o proceed.  Retu */ \
	0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6f,0x66,0x20,0x3c,0x63, /* rn a value of <c */ \
	0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* ode>0x80</code>  */ \
	0x6f,0x72,0x20,0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20, /* or greater ..to  */ \
	0x61,0x6c,0x6c,0x6f,0x77,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x75,0x6e,0x63, /* allow access unc */ \
	0x6f,0x6e,0x64,0x69,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52, /* onditionally.  R */ \
	0x65,0x74,0x75,0x72,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39, /* eturn <code>0x79 */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x6c,0x6f,0x77,0x65,0x72, /* </code> or lower */ \
	0x20,0x74,0x6f,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x20,0x0d,0x0a,0x61,0x75, /*  to require ..au */ \
	0x74,0x68,0x6f,0x72,0x69,0x7a,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e, /* thorization.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x54,0x68,0x65,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20, /* ....The second,  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x56,0x65,0x72,0x69,0x66,0x79, /* <code>HTTPVerify */ \
	0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x64,0x65,0x74,0x65, /* Auth</code> dete */ \
	0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75, /* rmines if the su */ \
	0x70,0x70,0x6c,0x69,0x65,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61, /* pplied credentia */ \
	0x6c,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x61, /* ls ..are accepta */ \
	0x62,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75, /* ble for the requ */ \
	0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75, /* ested page.  You */ \
	0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x68, /* r application sh */ \
	0x6f,0x75,0x6c,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61, /* ould return a va */ \
	0x6c,0x75,0x65,0x20,0x0d,0x0a,0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x74,0x68, /* lue ..greater th */ \
	0x61,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63, /* an <code>0x80</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x70,0x65,0x72,0x6d,0x69,0x74,0x20,0x61  /* ode> to permit a */
#define DATACHUNK000004 \
	0x63,0x63,0x65,0x73,0x73,0x2c,0x20,0x6f,0x72,0x20,0x61,0x20,0x76,0x61,0x6c,0x75, /* ccess, or a valu */ \
	0x65,0x20,0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63, /* e less than ..<c */ \
	0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* ode>0x79</code>  */ \
	0x74,0x6f,0x20,0x72,0x65,0x6a,0x65,0x63,0x74,0x20,0x74,0x68,0x65,0x20,0x70,0x61, /* to reject the pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x2e, /* ssword supplied. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e, /* </p>....<p>As an */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x61,0x63,0x63,0x65,0x73,0x73, /*  example, access */ \
	0x20,0x74,0x68,0x69,0x73,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64, /*  this restricted */ \
	0x20,0x70,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /*  page:</p>....<d */ \
	0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c, /* iv class="exampl */ \
	0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x55,0x73,0x65,0x72,0x20, /* ebox">..<b>User  */ \
	0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x61,0x64,0x6d,0x69,0x6e,0x20, /* Name:</b> admin  */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e, /* &nbsp; &nbsp; &n */ \
	0x62,0x73,0x70,0x3b,0x20,0x3c,0x62,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* bsp; <b>Password */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x3c, /* :</b> microchip< */ \
	0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* br />..<a href=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73, /* /protect">Access */ \
	0x20,0x52,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x50,0x61,0x67,0x65, /*  Restricted Page */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* </a>..</div>.... */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* </div>....<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /* .document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27, /* mentById('hello' */ \
	0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e, /* ).innerHTML = "~ */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e, /* hellomsg~";..--> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e, /* ..</script>..~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0x12,0x05,0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,0x00, /* .3...........0.. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /* >Cookies</h1>... */ \
	0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20, /* .<p>Cookies are  */ \
	0x73,0x6d,0x61,0x6c,0x6c,0x20,0x74,0x65,0x78,0x74,0x20,0x73,0x74,0x72,0x69,0x6e, /* small text strin */ \
	0x67,0x73,0x20,0x74,0x68,0x61,0x74,0x20,0x61,0x72,0x65,0x20,0x73,0x74,0x6f,0x72, /* gs that are stor */ \
	0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x72,0x6f,0x77,0x73,0x65, /* ed in the browse */ \
	0x72,0x2e,0x20,0x20,0x54,0x68,0x65,0x73,0x65,0x20,0x73,0x74,0x72,0x69,0x6e,0x67, /* r.  These string */ \
	0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x73,0x65,0x74,0x20,0x62,0x79,0x20,0x74, /* s ..are set by t */ \
	0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2c,0x20,0x61,0x6e,0x64,0x20,0x72, /* he server, and r */ \
	0x65,0x74,0x75,0x72,0x6e,0x65,0x64,0x20,0x61,0x73,0x20,0x70,0x61,0x72,0x61,0x6d, /* eturned as param */ \
	0x65,0x74,0x65,0x72,0x73,0x20,0x66,0x6f,0x72,0x20,0x61,0x6c,0x6c,0x20,0x66,0x75, /* eters for all fu */ \
	0x74,0x75,0x72,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x73,0x20,0x75,0x6e, /* ture requests un */ \
	0x74,0x69,0x6c,0x20,0x0d,0x0a,0x74,0x68,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f, /* til ..the sessio */ \
	0x6e,0x20,0x65,0x6e,0x64,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20,0x63,0x61, /* n ends.  They ca */ \
	0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x74,0x6f,0x20,0x73,0x74,0x6f, /* n be used to sto */ \
	0x72,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x73,0x74,0x61,0x74,0x65, /* re session state */ \
	0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x61,0x6e, /*  information, an */ \
	0x64,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e, /* d are ..valid un */ \
	0x74,0x69,0x6c,0x20,0x74,0x68,0x65,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x20, /* til the browser  */ \
	0x69,0x73,0x20,0x63,0x6c,0x6f,0x73,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* is closed.</p>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ..<div class="ex */ \
	0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62, /* amplebox">..<tab */ \
	0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72, /* le align="center */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e, /* ">..<tr><td><b>N */ \
	0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* ame:</b></td><td */ \
	0x3e,0x7e,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* >~cookiename~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72,0x69,0x74,0x65,0x3a,0x3c,0x2f,0x62, /* ><b>Favorite:</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x6e,0x6f,0x74,0x20,0x69,0x6d, /* ></td><td>not im */ \
	0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x65,0x64,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* plemented</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c, /* tr>..</table>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x72, /* /div>....<p>Ther */ \
	0x65,0x20,0x61,0x72,0x65,0x20,0x6e,0x75,0x6d,0x65,0x72,0x6f,0x75,0x73,0x20,0x75  /* e are numerous u */
#define DATACHUNK000005 \
	0x73,0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e, /* ses for cookies. */ \
	0x20,0x20,0x49,0x6e,0x20,0x74,0x68,0x69,0x73,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /*   In this exampl */ \
	0x65,0x2c,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x27,0x73,0x20,0x6e,0x61, /* e, the user's na */ \
	0x6d,0x65,0x20,0x69,0x73,0x20,0x0d,0x0a,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x61, /* me is ..stored a */ \
	0x73,0x20,0x61,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x2e,0x20,0x20,0x41,0x6c,0x6c, /* s a cookie.  All */ \
	0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x70,0x61,0x67,0x65,0x20,0x6c,0x6f,0x61, /*  future page loa */ \
	0x64,0x73,0x20,0x77,0x69,0x6c,0x6c,0x20,0x73,0x68,0x6f,0x77,0x20,0x74,0x68,0x69, /* ds will show thi */ \
	0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x74,0x6f, /* s name in the to */ \
	0x70,0x20,0x6c,0x65,0x66,0x74,0x20,0x0d,0x0a,0x63,0x6f,0x72,0x6e,0x65,0x72,0x2c, /* p left ..corner, */ \
	0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x20,0x61,0x73,0x20,0x69,0x6e,0x20,0x74, /*  as well as in t */ \
	0x68,0x65,0x20,0x62,0x6f,0x78,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70, /* he box above.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x61,0x63,0x74,0x69,0x6f, /* >....<form actio */ \
	0x6e,0x3d,0x22,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x22,0x20, /* n="cookies.htm"  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67,0x65,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* method="get">..< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70, /* div class="examp */ \
	0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20, /* lebox">..<table  */ \
	0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d, /* align="center">. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x69,0x72,0x73, /* .<tr><td><b>Firs */ \
	0x74,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* t Name:</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x61,0x6d, /* "text" name="nam */ \
	0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x6d,0x61,0x78, /* e" size="20" max */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x31,0x36,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* length="16" /></ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72,0x69,0x74,0x65,0x3a,0x3c,0x2f, /* d><b>Favorite:</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x73,0x65, /* b></td><td>..<se */ \
	0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x61,0x76,0x22,0x3e, /* lect name="fav"> */ \
	0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ..<option value= */ \
	0x22,0x50,0x49,0x43,0x31,0x38,0x22,0x3e,0x50,0x49,0x43,0x31,0x38,0x3c,0x2f,0x6f, /* "PIC18">PIC18</o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20, /* ption>..<option  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x32,0x34,0x22,0x3e,0x50,0x49, /* value="PIC24">PI */ \
	0x43,0x32,0x34,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f, /* C24</option>..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x64,0x73,0x50, /* ption value="dsP */ \
	0x49,0x43,0x22,0x3e,0x64,0x73,0x50,0x49,0x43,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f, /* IC">dsPIC</optio */ \
	0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75, /* n>..<option valu */ \
	0x65,0x3d,0x22,0x50,0x49,0x43,0x33,0x32,0x22,0x3e,0x50,0x49,0x43,0x33,0x32,0x3c, /* e="PIC32">PIC32< */ \
	0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* /option>..</sele */ \
	0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* ct>..</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* .<tr><td></td><t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* d><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65, /* ubmit" value="Se */ \
	0x74,0x20,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x74, /* t Cookies" /></t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65, /* d></tr>..</table */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* >..</div>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* m>....<p>Cookies */ \
	0x20,0x61,0x72,0x65,0x20,0x73,0x65,0x74,0x20,0x62,0x79,0x20,0x73,0x74,0x6f,0x72, /*  are set by stor */ \
	0x69,0x6e,0x67,0x20,0x6e,0x75,0x6c,0x6c,0x2d,0x74,0x65,0x72,0x6d,0x69,0x6e,0x61, /* ing null-termina */ \
	0x74,0x65,0x64,0x20,0x6e,0x61,0x6d,0x65,0x2f,0x76,0x61,0x6c,0x75,0x65,0x20,0x70, /* ted name/value p */ \
	0x61,0x69,0x72,0x73,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75, /* airs in <code>cu */ \
	0x72,0x48,0x54,0x54,0x50,0x2e,0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* rHTTP.data</code */ \
	0x3e,0x20,0x0d,0x0a,0x61,0x6e,0x64,0x20,0x69,0x6e,0x64,0x69,0x63,0x61,0x74,0x69, /* > ..and indicati */ \
	0x6e,0x67,0x20,0x68,0x6f,0x77,0x20,0x6d,0x61,0x6e,0x79,0x20,0x63,0x6f,0x6f,0x6b, /* ng how many cook */ \
	0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x74,0x6f,0x20,0x62,0x65,0x20,0x73,0x65, /* ies are to be se */ \
	0x74,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54, /* t in <code>curHT */ \
	0x54,0x50,0x2e,0x68,0x61,0x73,0x41,0x72,0x67,0x73,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* TP.hasArgs</code */ \
	0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20,0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62, /* >.  They ..can b */ \
	0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20,0x65,0x69,0x74,0x68,0x65,0x72,0x20, /* e set in either  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45,0x78,0x65,0x63,0x75,0x74, /* <code>HTTPExecut */ \
	0x65,0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x3c, /* eGet</code> or < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45,0x78,0x65,0x63,0x75,0x74,0x65, /* code>HTTPExecute */ \
	0x50,0x6f,0x73,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x3c,0x2f,0x70,0x3e, /* Post</code>.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61, /* ....<p>Cookies a */ \
	0x72,0x65,0x20,0x72,0x65,0x74,0x72,0x69,0x65,0x76,0x65,0x64,0x20,0x69,0x6e,0x20, /* re retrieved in  */ \
	0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20,0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20  /* the same manner  */
#define DATACHUNK000006 \
	0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x66,0x6f,0x72,0x6d,0x20,0x61,0x72,0x67,0x75, /* as GET form argu */ \
	0x6d,0x65,0x6e,0x74,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20,0x61,0x72,0x65, /* ments.  They are */ \
	0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x0d,0x0a,0x69,0x6e,0x20,0x3c,0x63,0x6f, /*  stored ..in <co */ \
	0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x64,0x61,0x74,0x61,0x3c, /* de>curHTTP.data< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e,0x64,0x20,0x63,0x61,0x6e,0x20,0x62, /* /code> and can b */ \
	0x65,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x75,0x73,0x69,0x6e,0x67,0x20, /* e located using  */ \
	0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x47,0x65, /* the <code>HTTPGe */ \
	0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x0d,0x0a,0x66,0x75, /* tArg</code> ..fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x2e,0x20,0x20,0x53,0x69,0x6e,0x63,0x65,0x20, /* nctions.  Since  */ \
	0x74,0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20, /* they are stored  */ \
	0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20,0x61,0x72,0x72,0x61, /* in the same arra */ \
	0x79,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e, /* y as GET argumen */ \
	0x74,0x73,0x2c,0x20,0x74,0x68,0x65,0x20,0x74,0x6f,0x74,0x61,0x6c,0x20,0x0d,0x0a, /* ts, the total .. */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x6f,0x66,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65, /* length of cookie */ \
	0x73,0x20,0x61,0x6e,0x64,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x20,0x61, /* s and variable a */ \
	0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x20,0x63,0x61,0x6e,0x6e,0x6f,0x74,0x20, /* rguments cannot  */ \
	0x65,0x78,0x63,0x65,0x65,0x64,0x20,0x74,0x68,0x65,0x20,0x38,0x30,0x20,0x62,0x79, /* exceed the 80 by */ \
	0x74,0x65,0x20,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x6c,0x69,0x6d,0x69,0x74,0x2e, /* te buffer limit. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73, /* </p>....<p class */ \
	0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45, /* ="exercise"><b>E */ \
	0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x53,0x65,0x74, /* xercise:</b> Set */ \
	0x20,0x61,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65, /*  a second cookie */ \
	0x20,0x6e,0x61,0x6d,0x65,0x64,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x61,0x76, /*  named <code>fav */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65, /* </code> with the */ \
	0x20,0x0d,0x0a,0x76,0x61,0x6c,0x75,0x65,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20, /*  ..value of the  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x61,0x76,0x6f,0x72,0x69,0x74,0x65,0x3c,0x2f, /* <code>favorite</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x69,0x65,0x6c,0x64,0x20,0x61,0x6e,0x64,0x20, /* code> field and  */ \
	0x68,0x61,0x76,0x65,0x20,0x69,0x74,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x65, /* have it displaye */ \
	0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x67,0x72,0x61,0x79,0x20,0x62,0x6f, /* d in the gray bo */ \
	0x78,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* x above.</p>.... */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* </div>....<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /* .document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27, /* mentById('hello' */ \
	0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e, /* ).innerHTML = "~ */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e, /* hellomsg~";..--> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e, /* ..</script>..~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0xac,0x01,0x00,0x00,0x03,0x00,0x00,0x00,0x6a,0x08,0x00, /* .3...........j.. */ \
	0x00,0x01,0x00,0x00,0x00,0x88,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .............~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63, /* >....<h1>Dynamic */ \
	0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /*  Variables</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x73,0x68,0x6f,0x72,0x74,0x20, /* ...<p>For short  */ \
	0x6f,0x75,0x74,0x70,0x75,0x74,0x73,0x20,0x28,0x6c,0x65,0x73,0x73,0x20,0x74,0x68, /* outputs (less th */ \
	0x61,0x6e,0x20,0x31,0x36,0x20,0x62,0x79,0x74,0x65,0x73,0x29,0x20,0x79,0x6f,0x75, /* an 16 bytes) you */ \
	0x20,0x6e,0x65,0x65,0x64,0x20,0x6f,0x6e,0x6c,0x79,0x20,0x74,0x6f,0x20,0x63,0x61, /*  need only to ca */ \
	0x6c,0x6c,0x20,0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72,0x6f,0x70,0x72,0x69,0x61, /* ll the appropria */ \
	0x74,0x65,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x54,0x43,0x50,0x50,0x75, /* te ..<code>TCPPu */ \
	0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* t</code> functio */ \
	0x6e,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x2e,0x20,0x20,0x46, /* n and return.  F */ \
	0x6f,0x72,0x20,0x6c,0x6f,0x6e,0x67,0x65,0x72,0x20,0x6f,0x75,0x74,0x70,0x75,0x74, /* or longer output */ \
	0x73,0x20,0x74,0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61, /* s the output sta */ \
	0x74,0x65,0x20,0x6d,0x75,0x73,0x74,0x20,0x62,0x65,0x20,0x0d,0x0a,0x6d,0x61,0x6e, /* te must be ..man */ \
	0x61,0x67,0x65,0x64,0x20,0x74,0x68,0x72,0x6f,0x75,0x67,0x68,0x20,0x73,0x75,0x63, /* aged through suc */ \
	0x63,0x65,0x73,0x73,0x69,0x76,0x65,0x20,0x63,0x61,0x6c,0x6c,0x73,0x2c,0x20,0x77, /* cessive calls, w */ \
	0x68,0x69,0x63,0x68,0x20,0x70,0x72,0x65,0x76,0x65,0x6e,0x74,0x73,0x20,0x74,0x68, /* hich prevents th */ \
	0x65,0x20,0x6c,0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x62,0x75,0x66,0x66,0x65,0x72, /* e limited buffer */ \
	0x20,0x73,0x70,0x61,0x63,0x65,0x20,0x66,0x72,0x6f,0x6d,0x20,0x62,0x65,0x69,0x6e, /*  space from bein */ \
	0x67,0x20,0x0d,0x0a,0x6f,0x76,0x65,0x72,0x72,0x75,0x6e,0x2e,0x3c,0x2f,0x70,0x3e, /* g ..overrun.</p> */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70, /* ..<p>As an examp */ \
	0x6c,0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x20,0x69,0x73,0x20,0x74,0x68,0x65,0x20  /* le, here is the  */
#define DATACHUNK000007 \
	0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x4c,0x43,0x44,0x20,0x64,0x69,0x73,0x70, /* current LCD disp */ \
	0x6c,0x61,0x79,0x20,0x28,0x77,0x68,0x69,0x63,0x68,0x20,0x75,0x73,0x65,0x73,0x20, /* lay (which uses  */ \
	0x33,0x32,0x20,0x62,0x79,0x74,0x65,0x73,0x29,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* 32 bytes):</p>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ..<div class="ex */ \
	0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20,0x63,0x6f,0x64,0x65,0x22,0x3e,0x7e, /* amplebox code">~ */ \
	0x6c,0x63,0x64,0x74,0x65,0x78,0x74,0x7e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* lcdtext~</div>.. */ \
	0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72, /* ..<p class="exer */ \
	0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73, /* cise"><b>Exercis */ \
	0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4c,0x6f,0x6f,0x6b,0x20,0x61,0x74,0x20,0x63, /* e:</b> Look at c */ \
	0x6f,0x64,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67, /* ode for this pag */ \
	0x65,0x20,0x61,0x6e,0x64,0x20,0x66,0x69,0x6e,0x64,0x20,0x68,0x6f,0x77,0x20,0x0d, /* e and find how . */ \
	0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* .<code>header.in */ \
	0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e,0x64,0x20,0x3c,0x63,0x6f, /* c</code> and <co */ \
	0x64,0x65,0x3e,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63, /* de>footer.inc</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x61,0x72,0x65,0x20,0x75,0x73,0x65,0x64,0x2e,0x20,0x20, /* ode> are used.   */ \
	0x54,0x68,0x65,0x73,0x65,0x20,0x66,0x69,0x6c,0x65,0x73,0x20,0x70,0x72,0x6f,0x76, /* These files prov */ \
	0x69,0x64,0x65,0x20,0x0d,0x0a,0x61,0x20,0x74,0x65,0x6d,0x70,0x6c,0x61,0x74,0x65, /* ide ..a template */ \
	0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x67,0x65,0x73,0x20,0x74, /*  for the pages t */ \
	0x6f,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x74,0x68,0x65,0x20,0x73,0x61, /* o include the sa */ \
	0x6d,0x65,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x6c,0x61,0x79,0x6f,0x75,0x74,0x2c, /* me menu, layout, */ \
	0x20,0x61,0x6e,0x64,0x20,0x64,0x65,0x73,0x69,0x67,0x6e,0x20,0x65,0x6c,0x65,0x6d, /*  and design elem */ \
	0x65,0x6e,0x74,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x3c,0x73, /* ents.</p>..<p><s */ \
	0x6d,0x61,0x6c,0x6c,0x3e,0x28,0x41,0x74,0x20,0x74,0x68,0x69,0x73,0x20,0x74,0x69, /* mall>(At this ti */ \
	0x6d,0x65,0x2c,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69, /* me, dynamic vari */ \
	0x61,0x62,0x6c,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x6e,0x2d,0x72,0x65, /* ables are non-re */ \
	0x63,0x75,0x72,0x73,0x69,0x76,0x65,0x2c,0x20,0x73,0x6f,0x20,0x76,0x61,0x72,0x69, /* cursive, so vari */ \
	0x61,0x62,0x6c,0x65,0x73,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e, /* ables located in */ \
	0x73,0x69,0x64,0x65,0x0d,0x0a,0x66,0x69,0x6c,0x65,0x73,0x3c,0x62,0x72,0x20,0x2f, /* side..files<br / */ \
	0x3e,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68, /* > included in th */ \
	0x69,0x73,0x20,0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f, /* is manner are no */ \
	0x74,0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x2e,0x29,0x3c,0x2f,0x73,0x6d,0x61,0x6c, /* t parsed.)</smal */ \
	0x6c,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* l></p>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ~";..-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xc2,0x01,0x00, /* .inc~....3...... */ \
	0x00,0x0d,0x00,0x00,0x00,0xca,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xe8,0x03,0x00, /* ................ */ \
	0x00,0x02,0x00,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* .....<div class= */ \
	0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* "spacer">&nbsp;< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* /div>..<div id=" */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68, /* footer">Copyrigh */ \
	0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61, /* t &copy; 2011 Sa */ \
	0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33, /* toshi Yasuda 7m3 */ \
	0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* tjz/ad6gz</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* ...</div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f, /* >....</body>..</ */ \
	0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68, /* html><!DOCTYPE h */ \
	0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57, /* tml PUBLIC "-//W */ \
	0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e, /* 3C//DTD XHTML 1. */ \
	0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20, /* 0 Strict//EN"..  */ \
	0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e, /*  "http://www.w3. */ \
	0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54, /* org/TR/xhtml1/DT */ \
	0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e, /* D/xhtml1-strict. */ \
	0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c, /* dtd">..<html xml */ \
	0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77, /* ns="http://www.w */ \
	0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c, /* 3.org/1999/xhtml */ \
	0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20, /* " xml:lang="en"  */ \
	0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61  /* lang="en">..<hea */
#define DATACHUNK000008 \
	0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41, /* d>..<title>D-STA */ \
	0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20, /* R dSqure Client  */ \
	0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d, /* Program</title>. */ \
	0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d, /* .<link href="/7m */ \
	0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73, /* 3tjz.css" rel="s */ \
	0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d, /* tylesheet" type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* "text/css" />..< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33, /* script src="/7m3 */ \
	0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* tjz.js" type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c, /* xt/javascript">< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64, /* /script>..</head */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* >....<body>..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65, /* v id="shadow-one */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* "><div id="shado */ \
	0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* w-two"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64, /* shadow-three"><d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f, /* iv id="shadow-fo */ \
	0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70, /* ur">..<div id="p */ \
	0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* age">....<div id */ \
	0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* ="title"><div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54, /* ass="right">D-ST */ \
	0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74, /* AR dSqure Client */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22, /* </div><span id=" */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73, /* hello">&nbsp;</s */ \
	0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* pan></div>....<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c, /* iv id="menu">..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68, /* a href="/index.h */ \
	0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e, /* tm">Overview</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* ..<a href="/prot */ \
	0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e, /* ect/config.htm"> */ \
	0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Network Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72, /* ation</a>..<a hr */ \
	0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72, /* ef="/nodeadapter */ \
	0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64, /* /config.htm">Nod */ \
	0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* e Adapter Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* uration</a>..</d */ \
	0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* iv>~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44, /* ntent">....<h1>D */ \
	0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69, /* -STAR dSqure Cli */ \
	0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x68,0x31,0x3e, /* ent Program</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65, /* ....<table style */ \
	0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20, /* ="padding-left:  */ \
	0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* 10px;">..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65, /* ><b>dSqure Serve */ \
	0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c, /* r Domain Name :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76, /* p;</td><td>~serv */ \
	0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* er_name~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4f, /* r>..<tr><td><b>O */ \
	0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c, /* ut bound Port :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f, /* p;</td><td>~out_ */ \
	0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* port~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49,0x6e,0x20,0x62, /* .<tr><td><b>In b */ \
	0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* ound Port :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* td><td>~in_port~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63, /* <td><b>Conferenc */ \
	0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62, /* e Room Name :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61, /* </td><td>~RoomNa */ \
	0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c  /* me~</td></tr>..< */
#define DATACHUNK000009 \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43, /* tr><td><b>Node C */ \
	0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* allsign :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c, /* ><td>~NodeName~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* /td></tr>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* le>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* ";..//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* ipt>....~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00, /* ter.inc~......3. */ \
	0x00,0x00,0xb8,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x08,0x01,0x00,0x00,0x4b,0x00, /* ......J.......K. */ \
	0x00,0x00,0x54,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0xa6,0x01,0x00,0x00,0x4d,0x00, /* ..T...L.......M. */ \
	0x00,0x00,0xf2,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x73,0x02,0x00,0x00,0x01,0x00, /* ......N...s..... */ \
	0x00,0x00,0x95,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x2b,0x10,0x06,0x10,0x01,0x10, /* ..........+..... */ \
	0x02,0x18,0x5b,0x00,0x01,0x10,0x01,0x10,0x01,0x0a,0x17,0x00,0x03,0x03,0x50,0x49, /* ..[...........PI */ \
	0x43,0x02,0xca,0x01,0xff,0x27,0x00,0x09,0x08,0x2b,0x06,0x01,0x04,0x01,0x81,0x85, /* C....'...+...... */ \
	0x47,0x03,0x88,0x01,0xfa,0x2e,0x00,0x07,0x04,0x0a,0x39,0x00,0x03,0x05,0x61,0x64, /* G.........9...ad */ \
	0x6d,0x69,0x6e,0x05,0x0a,0x48,0x00,0x03,0x09,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68, /* min..H...Microch */ \
	0x69,0x70,0x06,0x0a,0x54,0x00,0x03,0x06,0x6f,0x66,0x66,0x69,0x63,0x65,0x07,0x03, /* ip..T...office.. */ \
	0x6d,0x00,0x00,0x01,0x07,0x04,0x18,0x92,0x01,0x01,0x10,0x81,0x10,0x85,0x10,0x47, /* m..............G */ \
	0x10,0x01,0x10,0x01,0x18,0x95,0x00,0x01,0x0a,0x7e,0x00,0x03,0x0b,0x53,0x4e,0x4d, /* .........~...SNM */ \
	0x50,0x76,0x33,0x41,0x67,0x65,0x6e,0x74,0x02,0x0a,0x89,0x00,0x03,0x05,0x76,0x35, /* Pv3Agent......v5 */ \
	0x2e,0x33,0x31,0x03,0x03,0x9d,0x00,0x03,0x06,0x4f,0x63,0x74,0x20,0x31,0x30,0x02, /* .31......Oct 10. */ \
	0x18,0xcd,0x00,0x01,0x10,0x01,0x10,0x01,0xac,0x01,0x01,0xa9,0x00,0x00,0x01,0x01, /* ................ */ \
	0x01,0x01,0x00,0x02,0xac,0x01,0x02,0xb5,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x03, /* ................ */ \
	0xac,0x01,0x03,0xc1,0x00,0x05,0x01,0x01,0x01,0x01,0x00,0x04,0xa5,0x01,0x04,0xd1, /* ................ */ \
	0x00,0x04,0x01,0x01,0x01,0x01,0x00,0x03,0x18,0xf4,0x00,0x01,0xa8,0x01,0x05,0xd8, /* ................ */ \
	0x00,0x00,0x02,0xa8,0x01,0x06,0xdf,0x00,0x00,0x03,0x88,0x01,0x07,0xe6,0x00,0x00, /* ................ */ \
	0x04,0x88,0x01,0x08,0xed,0x00,0x01,0x06,0xa1,0x01,0x0a,0xfc,0x00,0x04,0x04,0x18, /* ................ */ \
	0x44,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x0b,0x08,0x01,0x00,0x01,0x01,0x01, /* D............... */ \
	0x0b,0x00,0x02,0xac,0x01,0x0c,0x14,0x01,0x04,0x01,0x01,0x01,0x0b,0x00,0x03,0xac, /* ................ */ \
	0x01,0x0d,0x20,0x01,0x00,0x01,0x01,0x01,0x0b,0x00,0x04,0xac,0x01,0x0e,0x2c,0x01, /* .. ...........,. */ \
	0x04,0x01,0x01,0x01,0x0b,0x00,0x05,0xac,0x01,0x0f,0x38,0x01,0x00,0x01,0x01,0x01, /* ..........8..... */ \
	0x0b,0x00,0x06,0xa5,0x01,0x10,0x4c,0x01,0x04,0x01,0x01,0x01,0x0b,0x00,0x05,0x18, /* ......L......... */ \
	0x88,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x11,0x58,0x01,0x00,0x01,0x01,0x01, /* ..........X..... */ \
	0x11,0x00,0x02,0xac,0x01,0x12,0x64,0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x03,0xac, /* ......d......... */ \
	0x01,0x13,0x70,0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x04,0xac,0x01,0x14,0x7c,0x01, /* ..p...........|. */ \
	0x04,0x01,0x01,0x01,0x11,0x00,0x05,0xa5,0x01,0x15,0x8a,0x01,0x00,0x01,0x01,0x01, /* ................ */ \
	0x11,0x00,0x07,0x10,0x01,0x81,0x02,0x01,0xf4,0x9c,0x01,0x00,0x06,0x10,0x03,0x10, /* ................ */ \
	0x0a,0x10,0x02,0x10,0x01,0x10,0x01,0x88,0x01,0xf9,0xa3,0x01,0x04,0x02,0x88,0x01, /* ................ */ \
	0xf8,0xaa,0x01,0x02,0x03,0x88,0x01,0xf7,0xb1,0x01,0x02,0x04,0x80,0x01,0xf6,0x01, /* ................ */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46,0x69,0x6c,0x65, /* nt">....<h1>File */ \
	0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /*  Uploads</h1>... */ \
	0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x73,0x65,0x72, /* .<p>The HTTP ser */ \
	0x76,0x65,0x72,0x20,0x63,0x61,0x6e,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x20,0x66, /* ver can accept f */ \
	0x69,0x6c,0x65,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64,0x73,0x20,0x76,0x69,0x61,0x20, /* ile uploads via  */ \
	0x50,0x4f,0x53,0x54,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x63,0x61,0x6e,0x20, /* POST.  This can  */ \
	0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x0d,0x0a,0x6d,0x61, /* be used for ..ma */ \
	0x6e,0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20, /* ny applications  */ \
	0x73,0x75,0x63,0x68,0x20,0x61,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x69,0x6e,0x67, /* such as allowing */ \
	0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64, /*  users to upload */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73, /*  configuration s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x66,0x69,0x6c,0x65,0x73,0x2e,0x0d,0x0a, /* ettings files... */ \
	0x45,0x61,0x63,0x68,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* Each application */ \
	0x20,0x6d,0x75,0x73,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x20, /*  must implement  */ \
	0x69,0x74,0x73,0x20,0x6f,0x77,0x6e,0x20,0x66,0x69,0x6c,0x65,0x20,0x70,0x72,0x6f, /* its own file pro */ \
	0x63,0x65,0x73,0x73,0x6f,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x65,0x78  /* cessor.  This ex */
#define DATACHUNK00000a \
	0x61,0x6d,0x70,0x6c,0x65,0x20,0x0d,0x0a,0x63,0x61,0x6c,0x63,0x75,0x6c,0x61,0x74, /* ample ..calculat */ \
	0x65,0x73,0x20,0x74,0x68,0x65,0x20,0x4d,0x44,0x35,0x20,0x68,0x61,0x73,0x68,0x20, /* es the MD5 hash  */ \
	0x6f,0x66,0x20,0x61,0x6e,0x79,0x20,0x66,0x69,0x6c,0x65,0x2e,0x3c,0x2f,0x70,0x3e, /* of any file.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* ....<form action */ \
	0x3d,0x22,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6d,0x65, /* ="upload.htm" me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x65,0x6e,0x63,0x74, /* thod="post" enct */ \
	0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74,0x2f,0x66, /* ype="multipart/f */ \
	0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* orm-data">..<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62, /*  class="exampleb */ \
	0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x7e,0x75,0x70,0x6c,0x6f,0x61,0x64,0x65,0x64,0x6d, /* ox">..~uploadedm */ \
	0x64,0x35,0x7e,0x0d,0x0a,0x3c,0x70,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d, /* d5~..<p style="m */ \
	0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a,0x20,0x32,0x70, /* argin-bottom: 2p */ \
	0x78,0x22,0x3e,0x3c,0x62,0x3e,0x46,0x69,0x6c,0x65,0x3a,0x20,0x3c,0x2f,0x62,0x3e, /* x"><b>File: </b> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* &nbsp;..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="file" name= */ \
	0x22,0x6d,0x64,0x35,0x66,0x69,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* "md5file" size=" */ \
	0x33,0x30,0x22,0x20,0x2f,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c, /* 30" /> &nbsp;..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x47,0x65,0x74,0x20,0x4d, /* it" value="Get M */ \
	0x44,0x35,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f, /* D5" />..</p>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d, /* div>..</form>... */ \
	0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61,0x6e,0x20,0x61, /* .<p>This is an a */ \
	0x64,0x76,0x61,0x6e,0x63,0x65,0x64,0x20,0x66,0x65,0x61,0x74,0x75,0x72,0x65,0x2e, /* dvanced feature. */ \
	0x20,0x20,0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72, /*   For more infor */ \
	0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x70,0x6c,0x65,0x61,0x73,0x65,0x20,0x72, /* mation, please r */ \
	0x65,0x66,0x65,0x72,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x69,0x6d, /* efer to the ..im */ \
	0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x20, /* plementation in  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50, /* <code>CustomHTTP */ \
	0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x6f,0x72, /* App.c</code> for */ \
	0x20,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x73,0x20,0x61,0x6e,0x64,0x20,0x65,0x78, /*  comments and ex */ \
	0x70,0x6c,0x61,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* plaination.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63, /* ...</div>....<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f, /* ript type="text/ */ \
	0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21, /* javascript">..<! */ \
	0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /* --..document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c, /* ElementById('hel */ \
	0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d, /* lo').innerHTML = */ \
	0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a, /*  "~hellomsg~";.. */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb6,0x01,0x00,0x00,0x1d,0x00,0x00,0x00, /* ....3........... */ \
	0x72,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x90,0x03,0x00,0x00,0x02,0x00,0x00,0x00, /* r............... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65, /* nt">....<h1>Node */ \
	0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /*  Adapter Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ration</h1>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65, /* t" action="/node */ \
	0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* adapter/config.h */ \
	0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66, /* tm" name="nodecf */ \
	0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* g">..<fieldset>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20, /* .<div><label>TX  */ \
	0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Delay Time:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65, /* ="text" name="de */ \
	0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61, /* ly" value="~dela */ \
	0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34, /* y_time~" size="4 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e, /* " class="ad1" /> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76, /* &nbsp;mSec.</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* X Time out:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f  /* ="text" name="to */
#define DATACHUNK00000b \
	0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65, /* ut" value="~time */ \
	0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20, /* _out~" size="4"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* class="ad1"/>&nb */ \
	0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* sp;Sec.</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65, /* div><label>RX Ke */ \
	0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ep Alive:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70, /* text" name="keep */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61, /* " value="~keep_a */ \
	0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20, /* live~" size="4"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* class="ad1"/>&nb */ \
	0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* sp;mSec.</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74, /* <div><label>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c, /* er Buffer size:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="jitt" value="~ */ \
	0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73, /* jittter_size~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="3" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f, /* d1"/>&nbsp;0: no */ \
	0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* t effect</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41, /* <div><label>RX A */ \
	0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c, /* uto Polarity:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="rxpl" value= */ \
	0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72, /* "" ~RX_AutoPolar */ \
	0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ity~ class="ad1" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74, /* label>RX Polarit */ \
	0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* y:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76, /* x" name="rxpo" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61, /* alue="" ~RX_Pola */ \
	0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* rity~  class="ad */ \
	0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* 1"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72, /* ><label>TX Polar */ \
	0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ity:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* d><input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74, /* heckbox" name="t */ \
	0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54, /* xpo" value="" ~T */ \
	0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73, /* X_Polarity~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* s="ad1" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f, /* ..<div><label>CO */ \
	0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* S Check:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* e="cos" value="" */ \
	0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61, /*  ~COS_Check~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ss="ad1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53, /* >..<div><label>S */ \
	0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65, /* /N Squelch Value */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75, /* " name="sn" valu */ \
	0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22, /* e="~SN_Squelch~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="5" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20, /* "ad1"/>&nbsp;0:  */ \
	0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* not effect</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52, /* ..<div><label>CR */ \
	0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* C Check:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22  /* e="crc" value="" */
#define DATACHUNK00000c \
	0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61, /*  ~CRC_Check~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ss="ad1"/></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61, /* ..<div><label>La */ \
	0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f, /* st Frame Send:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76, /* x" name="last" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61, /* alue="" ~LastFra */ \
	0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20, /* me~ class="ad1"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e, /* label>Header Gen */ \
	0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* eration:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="hdrg" value=" */ \
	0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c, /* " ~HeaderGen~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ass="ad1" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65, /* Header Gen. Type */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74, /* kbox" name="hdrt */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64, /* " value="" ~Head */ \
	0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73, /* erGenType~  clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43, /* s="ad1"/>&nbsp;C */ \
	0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64, /* hecked: Space</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* iv>..<div>&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* &nbsp;.&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63, /* sp;&nbsp;.Unchec */ \
	0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61, /* ked: Last RF Hea */ \
	0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* der</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c, /* <label>Half/Full */ \
	0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /*  Duplex:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* e="h_f" value="" */ \
	0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61, /*  ~HalfFull~  cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ss="ad1"/>&nbsp; */ \
	0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61, /* Checked:&nbsp;Ha */ \
	0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* lf</div>......<d */ \
	0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* iv><input type=" */ \
	0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* submit" class="a */ \
	0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20, /* p1" value="Save  */ \
	0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c, /* Basic Info." />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* iv>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00, /* .Q...k...R...... */ \
	0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00, /* .S...o...T...... */ \
	0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00, /* .U...x...^...... */ \
	0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00, /* .V...a...W...... */ \
	0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00, /* .X...a...Y...... */ \
	0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00, /* .Z...R...[...... */ \
	0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0x75,0x08,0x00, /* .\.......]...u.. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* >Network Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ration</h1>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73  /* form method="pos */
#define DATACHUNK00000d \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* t" action="/prot */ \
	0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20, /* ect/config.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a, /* name="config">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* <fieldset>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72, /* ><label>MAC Addr */ \
	0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ess:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="mac" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22, /* e="~config_mac~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61, /* <label>Server Na */ \
	0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* me:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="host" valu */ \
	0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e, /* e="~server_name~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e, /* ><label>Out Boun */ \
	0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* d Port:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20, /* xt" name="oprt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74, /* value="~out_port */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e, /* v><label>In Boun */ \
	0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* d Port:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20, /* xt" name="iprt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* value="~in_port~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d, /* ><label>Room Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="RmNm" value */ \
	0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e, /* ="~RoomName~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67, /* bel>Node Callsig */ \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* n:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="NdNm" value */ \
	0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e, /* ="~NodeName~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62, /* </div>..<div>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* sp;</div>..<div> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20, /* sm" name="dhcp"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63, /* value="1" onclic */ \
	0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73, /* k="configIPBoxes */ \
	0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70, /* ()" ~config_dhcp */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DHCP</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64, /* div><label>IP Ad */ \
	0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* dress:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22, /* "text" name="ip" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ip~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77, /* div><label>Gatew */ \
	0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64, /* ay:</label>..<td */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* ><input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61, /* xt" name="gw" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e, /* lue="~config_gw~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d, /* ><label>Subnet M */ \
	0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ask:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74  /* d><input type="t */
#define DATACHUNK00000e \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20, /* ext" name="sub"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73, /* value="~config_s */ \
	0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ubnet~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72, /* ..<div><label>Pr */ \
	0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* imary DNS:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* l>..<td><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63, /* "dns1" value="~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* onfig_dns1~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53, /* el>Secondary DNS */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dns2" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20, /* "~config_dns2~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76, /* it" class="sm" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69, /* alue="Save Confi */ \
	0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* g" /></div>..</f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d, /* ieldset>..</form */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63, /* >..</div>....<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a, /* ript language="j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66, /* -..function conf */ \
	0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09, /* igIPBoxes() {... */ \
	0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* e = document.for */ \
	0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20, /* ms.config;...st  */ \
	0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64, /* = e.dhcp.checked */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.ip.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64, /* d = st;...e.gw.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* e.sub.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69, /*  st;...e.dns1.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .dns2.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  st;..}..documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d, /* t.forms.config.m */ \
	0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72, /* ac.disabled = tr */ \
	0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42, /* ue;....configIPB */ \
	0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* oxes();..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde, /* er.inc~....3.... */ \
	0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2, /* ...%...>...J.... */ \
	0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x5d, /* ...K.......L...] */ \
	0x02,0x00,0x00,0x4d,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x3f, /* ...M.......N...? */ \
	0x03,0x00,0x00,0x27,0x00,0x00,0x00,0xb3,0x03,0x00,0x00,0x28,0x00,0x00,0x00,0x10, /* ...'.......(.... */ \
	0x04,0x00,0x00,0x29,0x00,0x00,0x00,0x72,0x04,0x00,0x00,0x2a,0x00,0x00,0x00,0xd9, /* ...)...r........ */ \
	0x04,0x00,0x00,0x2b,0x00,0x00,0x00,0x3c,0x05,0x00,0x00,0x2c,0x00,0x00,0x00,0x12, /* ...+...<...,.... */ \
	0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x32,0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* .......2.......~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e, /* t">....<h1>Login */ \
	0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e, /*  Successful</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20, /* ....<p>You have  */ \
	0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67, /* successfully log */ \
	0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65, /* ged in to the we */ \
	0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20, /* b server.  This  */ \
	0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d, /* authentication . */ \
	0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20  /* .is valid until  */
#define DATACHUNK00000f \
	0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62, /* you close your b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* rowser.</p>....< */ \
	0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72, /* p>Credentials ar */ \
	0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f, /* e verified in yo */ \
	0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61, /* ur own custom ca */ \
	0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* llback function  */ \
	0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* called ..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65, /* /code>.  In here */ \
	0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d, /* , you can determ */ \
	0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c, /* ine if the suppl */ \
	0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61, /* ied..user name a */ \
	0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20, /* nd password are  */ \
	0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73, /* valid for access */ \
	0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65, /*  to the requeste */ \
	0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e, /* d page.  You can */ \
	0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20, /*  ..add multiple  */ \
	0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69, /* users and restri */ \
	0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65, /* ct different use */ \
	0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20, /* rs to different  */ \
	0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* pages.</p>....<p */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /*  class="exercise */ \
	0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f, /* "><b>Exercise:</ */ \
	0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73, /* b> Change the us */ \
	0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73, /* er name and pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* word in..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66, /* /code> to one of */ \
	0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20, /*  your choosing.  */ \
	0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69, /*  (The callback i */ \
	0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c, /* s ..located in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41, /* code>CustomHTTPA */ \
	0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70, /* pp.c</code>.)</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* >....<div class= */ \
	0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57, /* "examplebox">..W */ \
	0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20, /* hen you finish,  */ \
	0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67, /* refresh this pag */ \
	0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e, /* e to test your n */ \
	0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64, /* ew user name and */ \
	0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62, /*  password ..comb */ \
	0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ination...</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* ....</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* !--..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* >....~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00, /* .inc~....3...... */ \
	0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65, /* .............~re */ \
	0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e, /* boot~....-...~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20, /* >....<h1>Reboot  */ \
	0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f, /* In Progress...</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73, /* h1>....<p>Your s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63, /* ettings were suc */ \
	0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c, /* cessfully saved, */ \
	0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69, /*  and the board i */ \
	0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20, /* s now rebooting  */ \
	0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69, /* ..to configure i */ \
	0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e  /* tself with the n */
#define DATACHUNK000010 \
	0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e, /* ew settings.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d, /* ....<h6></h6>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76, /* pt language="jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74, /* .function reboot */ \
	0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54, /* Dummy(x){}..setT */ \
	0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43, /* imeout("newAJAXC */ \
	0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* ommand('/protect */ \
	0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62, /* /reboot.cgi',reb */ \
	0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b, /* ootDummy,false); */ \
	0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* ",500);..//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0x7e,0x01,0x00,0x00,0x02,0x00,0x00,0x00                           /* ...~.......      */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
