/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 23 2011 06:25:50 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x13,0x00,0x6a,0x55,0x5e,0x2a,0x4a,0xce,0xff,0xff, /* MPFS....jU^.J... */ \
	0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff,0xde,0x6c,0xea,0x72,0xff,0xff,0xea,0x92, /* &O&-.....l.r.... */ \
	0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xd0,0x01, /* ...O..&......... */ \
	0x00,0x00,0x82,0x02,0x00,0x00,0x87,0x03,0x00,0x00,0xa8,0x52,0xa3,0x4e,0x00,0x00, /* ...........R.N.. */ \
	0x00,0x00,0x01,0x00,0xdb,0x01,0x00,0x00,0x09,0x06,0x00,0x00,0xc2,0x05,0x00,0x00, /* ................ */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0xe5,0x01,0x00,0x00,0xcb,0x0b, /* ...N............ */ \
	0x00,0x00,0x40,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00, /* ..@......N...... */ \
	0xee,0x01,0x00,0x00,0x0b,0x11,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e, /* ...............N */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xef,0x01,0x00,0x00,0x23,0x11,0x00,0x00,0xa0,0x00, /* ..........#..... */ \
	0x00,0x00,0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xfa,0x01,0x00,0x00, /* ...B.N.......... */ \
	0xc3,0x11,0x00,0x00,0xfe,0x02,0x00,0x00,0xc3,0xd9,0xa3,0x4e,0x00,0x00,0x00,0x00, /* ...........N.... */ \
	0x00,0x00,0x05,0x02,0x00,0x00,0xc1,0x14,0x00,0x00,0x49,0x03,0x00,0x00,0x82,0x8e, /* ..........I..... */ \
	0xa3,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x0f,0x02,0x00,0x00,0x0a,0x18,0x00,0x00, /* .N.............. */ \
	0x50,0x00,0x00,0x00,0x82,0x8e,0xa3,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x02, /* P......N........ */ \
	0x00,0x00,0x5a,0x18,0x00,0x00,0x5a,0x0d,0x00,0x00,0x03,0x7f,0x9f,0x4e,0x00,0x00, /* ..Z...Z......N.. */ \
	0x00,0x00,0x01,0x00,0x1b,0x02,0x00,0x00,0xb4,0x25,0x00,0x00,0xff,0x08,0x00,0x00, /* .........%...... */ \
	0xa6,0xdf,0x9f,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x32,0x02,0x00,0x00,0xb3,0x2e, /* ...N......2..... */ \
	0x00,0x00,0x80,0x00,0x00,0x00,0xa6,0xdf,0x9f,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x33,0x02,0x00,0x00,0x33,0x2f,0x00,0x00,0x12,0x08,0x00,0x00,0xf5,0x8d,0xa3,0x4e, /* 3...3/.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x46,0x02,0x00,0x00,0x45,0x37,0x00,0x00,0x88,0x00, /* ......F...E7.... */ \
	0x00,0x00,0xf5,0x8d,0xa3,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x47,0x02,0x00,0x00, /* .....N......G... */ \
	0xcd,0x37,0x00,0x00,0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* .7.........N.... */ \
	0x02,0x00,0x59,0x02,0x00,0x00,0x93,0x3b,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b, /* ..Y....;........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x5a,0x02,0x00,0x00,0xab,0x3b,0x00,0x00, /* .N......Z....;.. */ \
	0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x6d,0x02, /* .......N......m. */ \
	0x00,0x00,0xb3,0x3b,0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...;.........N.. */ \
	0x00,0x00,0x00,0x00,0x6e,0x02,0x00,0x00,0xbb,0x3b,0x00,0x00,0x8e,0x01,0x00,0x00, /* ....n....;...... */ \
	0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x81,0x02,0x00,0x00,0x49,0x3d, /* ...N..........I= */ \
	0x00,0x00,0x10,0x00,0x00,0x00,0x11,0x0c,0x9c,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a, /* 7m3tjz.css.7m3tj */ \
	0x7a,0x2e,0x6a,0x73,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66, /* z.js.auth.htm..f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72, /* ooter.inc.header */ \
	0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00, /* .inc.index.htm.. */ \
	0x4d,0x50,0x46,0x53,0x49,0x6d,0x67,0x32,0x2e,0x63,0x00,0x6e,0x6f,0x64,0x65,0x61, /* MPFSImg2.c.nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74, /* dapter/config.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* m..protect/confi */ \
	0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69, /* g.htm..protect/i */ \
	0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* ndex.htm..protec */ \
	0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72, /* t/reboot.cgi..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d, /* otect/reboot.htm */ \
	0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x56,0x4d,0x6f, /* .............VMo */ \
	0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x03,0x52,0xaf,0x05,0xf1,0x11,0x68,0x4b,0x4f, /* .0.=7R..R....hKO */ \
	0xab,0xee,0x79,0x8f,0x7b,0x37,0x78,0x08,0x56,0x1d,0x8c,0x8c,0x69,0xd2,0xad,0xfa, /* ..y.{7x.V...i... */ \
	0xdf,0xd7,0x36,0x06,0x0c,0x38,0xa9,0x56,0x5a,0x21,0xb5,0x89,0xf1,0xbc,0x37,0x7e, /* ..6..8.VZ!....7~ */ \
	0xf3,0x66,0x9c,0x82,0xe1,0x0f,0xef,0x73,0xbf,0xbb,0xab,0x58,0x23,0xfc,0x0a,0x9d, /* .f.....s...X#... */ \
	0x08,0xfd,0xc8,0xbd,0xdf,0xc0,0x31,0x6a,0xd0,0x83,0xf7,0x83,0x13,0x44,0x1f,0xbc, /* ......1j.....D.. */ \
	0x0e,0x35,0x9d,0xdf,0x01,0x27,0xd5,0x8b,0xdc,0x5a,0xa0,0xf2,0xed,0xc8,0x59,0xdf, /* .5...'...Z....Y. */ \
	0xe0,0xdc,0xbb,0x4f,0x0b,0xf5,0xa8,0xe5,0x13,0xe2,0x47,0xd2,0xe4,0x5e,0xd8,0x5e, /* ...O......G..^.^ */ \
	0x3c,0xd4,0x0b,0xa6,0xd6,0x5a,0x84,0x31,0x69,0x8e,0x72,0x51,0x3e,0xb1,0x7a,0x13, /* <....Z.1i.rQ>.z. */ \
	0xca,0xe5,0xaf,0xfd,0x6e,0xbf,0xbb,0xef,0x6a,0x84,0xd9,0xd9,0x67,0x0d,0xe8,0x04, /* ....n...j...g... */ \
	0xce,0x04,0x8b,0x3a,0xf7,0x1e,0x33,0xb9,0x4b,0xb3,0x30,0x8e,0x81,0xe7,0x5e,0x24, /* ...:..3.K.0...^$ */ \
	0x83,0x3a,0x46,0x09,0x96,0x5c,0x69,0x3a,0xbf,0xf1,0x05,0x6b,0x73,0x0d,0xe7,0x62, /* .:F..\i:...ks..b */ \
	0xfe,0x9a,0x09,0xc4,0x99,0x69,0x02,0x07,0xe0,0xa1,0x50,0x8f,0x0b,0xd3,0x8e,0xaf, /* .....i....P..... */ \
	0x39,0xc0,0x55,0x84,0xc3,0xe1,0x9b,0xf0,0x8a,0xf5,0xfc,0x5a,0x74,0x82,0xd4,0x73, /* 9.U........Zt..s */ \
	0x05,0x40,0x42,0xb4,0xe8,0x78,0x95,0x39,0x49,0x92,0x4d,0x31,0xaa,0xaa,0x72,0x0a, /* .@B..x.9I.M1..r. */ \
	0x34,0x95,0x21,0x36,0xe2,0xea,0x6a,0x77,0xe4,0x0f,0x48,0xc8,0xb0,0x15,0x4b,0x42, /* 4.!6..jw..H...KB */ \
	0x81,0x67,0x47,0x38,0xf6,0x08,0x22,0xa8,0xc9,0xca,0xe6,0x4e,0xe2,0xd7,0x9f,0x49, /* .gG8.."....N...I */ \
	0xbc,0x60,0x3b,0x58,0x64,0x67,0x20,0xc7,0x5a,0xe4,0x5e,0xc1,0x28,0x56,0x8b,0x25, /* .`;Xdg .Z.^.(V.% */ \
	0xa3,0x8c,0xcf,0x29,0x0f,0x25,0xf4,0x0b,0x26,0x04,0x3b,0x49,0xc2,0x74,0x08,0xad, /* ...).%..&.;I.t.. */ \
	0x4d,0x54,0x94,0xe9,0xef,0x76,0x02,0x01,0x57,0xaf,0x86,0x4c,0x29,0x43,0x72,0x93, /* MT...v..W..L)Cr. */ \
	0x5e,0x78,0x99,0xad,0x94,0x84,0xe6,0xb4,0x02,0x2e,0xc2,0x47,0x94,0x1c,0x9b,0x79, /* ^x.........G...y */ \
	0xd3,0x00,0x75,0x82,0xa6,0xb7,0x21,0x28,0x54,0x36,0x42,0x94,0x1a,0x04,0x73,0x24, /* ..u...!(T6B...s$ */ \
	0x9f,0x0f,0xe9,0x18,0x19,0x2d,0x0c,0x64,0x7b,0x38,0x3a,0x98,0x30,0x4c,0xba,0x96, /* .....-.d{8:.0L.. */ \
	0x22,0xd9,0x50,0x05,0x65,0xe5,0xdb,0xa6,0x5c,0xb3,0x64,0x46,0x8d,0x73,0x4d,0x04  /* ".P.e...\.dF.sM. */
#define DATACHUNK000001 \
	0x2c,0x24,0x7c,0xba,0x21,0xa1,0x29,0xf3,0xa4,0xd9,0xec,0x0d,0x23,0xaa,0x3e,0x37, /* ,$|.!.).....#.>7 */ \
	0x86,0x92,0x71,0x24,0x08,0x93,0x87,0x6f,0x64,0xb3,0xad,0xf2,0xce,0x6b,0xf6,0x0e, /* ..q$...od....k.. */ \
	0x7c,0x5b,0x4e,0xac,0xed,0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3e,0x62,0x1a,0x9b, /* |[N..5.,%;4.>b.. */ \
	0x0a,0xad,0xb5,0x5f,0x29,0x15,0xd9,0x4a,0x8d,0x38,0x83,0x58,0xa3,0x03,0xca,0x30, /* ..._)..J.8.X...0 */ \
	0xfc,0x3e,0xd9,0x29,0xd4,0xca,0x77,0x04,0x18,0x52,0xdd,0x02,0xc8,0x83,0x00,0xa7, /* .>.)..w..R...... */ \
	0xc4,0x81,0x52,0x47,0x1a,0xc0,0x98,0x6e,0xe8,0x93,0x39,0xcf,0xa0,0x6b,0x51,0x39, /* ..RG...n..9..kQ9 */ \
	0x72,0x50,0x40,0x5c,0x49,0x2e,0xea,0x09,0xa5,0x62,0x4c,0x98,0xd7,0x56,0x8f,0x84, /* rP@\I....bL..V.. */ \
	0xc1,0x13,0x9c,0x6c,0x67,0x67,0x59,0xb6,0x36,0x5f,0x29,0xc9,0x81,0xdb,0x23,0x4b, /* ...lggY.6_)...#K */ \
	0xe9,0xe3,0xa5,0x7a,0x30,0x7a,0x6b,0xb3,0xe9,0xbc,0xa2,0xc5,0x38,0x34,0x6b,0x72, /* ...z0zk.....84kr */ \
	0x3b,0x96,0x55,0x07,0x3c,0xb2,0x98,0x89,0x2a,0x90,0xe8,0xbb,0x85,0x13,0x1f,0x6f, /* ;.U.<..........o */ \
	0x97,0x69,0xc6,0xb7,0x13,0x5a,0x8f,0xdf,0x25,0x97,0xd3,0x8c,0x8b,0x04,0x5a,0x9d, /* .i...Z..%.....Z. */ \
	0xc2,0x44,0x91,0x0e,0xa7,0x93,0x7f,0x23,0xbb,0x21,0x89,0x2c,0x4f,0x23,0x11,0xfc, /* .D.....#.!.,O#.. */ \
	0x75,0x0a,0xd3,0xfc,0x0b,0xe0,0x82,0x4e,0x2d,0x85,0x82,0x5d,0xac,0x7a,0xe5,0x5a, /* u......N-..].z.Z */ \
	0x33,0xd5,0x62,0xde,0xf4,0xc9,0xd5,0x33,0xae,0x13,0x24,0x96,0x55,0x86,0x9a,0xcc, /* 3.b....3..$.U... */ \
	0x25,0xb1,0xec,0x7f,0x8f,0xf1,0x74,0xa8,0xa0,0x64,0x18,0xb6,0x57,0xe4,0xab,0x1c, /* %.....t..d..W... */ \
	0xeb,0x44,0xba,0xe0,0x17,0x9c,0x1f,0xc6,0x2f,0x0f,0x5e,0x45,0x2e,0x80,0x7d,0x2d, /* .D....../.^E..}- */ \
	0xbe,0xf9,0x62,0x9d,0x05,0x78,0x49,0x3a,0xc7,0xe4,0xac,0xe0,0xf9,0x65,0xa5,0x97, /* ..b..xI:.....e.. */ \
	0x35,0x12,0xd5,0x48,0xda,0xd8,0x60,0x58,0x8c,0xe7,0x8e,0x87,0x22,0x99,0x99,0x38, /* 5..H..`X...."..8 */ \
	0x67,0xdc,0x36,0xf8,0x12,0x62,0x53,0xfa,0x65,0x32,0x18,0xdf,0xe2,0x79,0x0e,0xe7, /* g.6..bS.e2...y.. */ \
	0xdb,0x69,0xea,0xa6,0xcc,0xba,0xa3,0x2c,0x87,0xa2,0xae,0xb6,0x34,0x9f,0x0c,0x96, /* .i.....,....4... */ \
	0xae,0xd2,0x08,0x57,0xa3,0xde,0x6a,0x44,0xab,0xfe,0xe6,0x52,0xb2,0x2a,0x37,0xce, /* ...W..jD...R..7. */ \
	0xea,0xf5,0xc4,0x49,0x67,0x80,0x8a,0x00,0xc5,0x1d,0x88,0xff,0xeb,0x9e,0x2b,0x46, /* ...Ig.........+F */ \
	0x99,0xc8,0x30,0x79,0x5f,0x36,0x80,0xd2,0x4f,0x71,0xa9,0xff,0xe3,0x95,0xb2,0x0d, /* ..0y_6..Oq...... */ \
	0xa1,0xa8,0x00,0xba,0x2d,0x9b,0x1f,0x1d,0x5c,0x73,0x21,0x1e,0xd6,0xc6,0x3e,0xcf, /* ....-...\s!...>. */ \
	0xc2,0x1b,0x17,0x45,0xcb,0x3a,0x32,0x8c,0x44,0x54,0xc8,0x3a,0xf6,0x02,0x36,0x09, /* ...E.:2.DT.:..6. */ \
	0x90,0xa6,0xed,0xc5,0x96,0x7c,0x1c,0x49,0x23,0x4d,0xec,0x4a,0x5e,0xc7,0x06,0xdd, /* .....|.I#M.J^... */ \
	0xc9,0x1e,0x3c,0xf3,0xcf,0xb0,0xcd,0x46,0x84,0x23,0xc7,0xce,0xeb,0x97,0xf4,0x14, /* ..<....F.#...... */ \
	0xae,0x76,0x20,0x0e,0x8b,0xab,0x36,0xb6,0xe5,0x0c,0x38,0x74,0x3d,0x15,0xfb,0xdd, /* .v ...6...8t=... */ \
	0xe7,0x7e,0x35,0x61,0xff,0xad,0xde,0xcb,0x5f,0x58,0xee,0x01,0xee,0xbe,0x91,0xed, /* .~5a...._X...... */ \
	0x4e,0x02,0x98,0x64,0xbe,0x0b,0xd8,0x9b,0xce,0x7a,0x6c,0x92,0xe9,0x8e,0x28,0xf4, /* N..d.....zl...(. */ \
	0x44,0x5d,0x05,0x56,0xfa,0x37,0x80,0x8c,0xbc,0x53,0xa1,0x15,0x22,0xd4,0x19,0x5c, /* D].V.7...S.."..\ */ \
	0x64,0x8e,0xe0,0x0a,0x16,0xc1,0x7d,0xe3,0x26,0x2e,0x4b,0x57,0x6c,0x85,0x4d,0xec, /* d.....}.&.KWl.M. */ \
	0x5f,0x49,0x0a,0x28,0xc4,0x17,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00, /* _I.(............ */ \
	0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b, /* ....W]o.6.}V...; */ \
	0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48, /* ?,2.8N....;.I.fH */ \
	0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76, /* . q....h.....JRv */ \
	0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59, /* ."?h.r...,.iQ.}Y */ \
	0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46, /* .X......O......F */ \
	0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad, /* ....COF.'.OF.#z. */ \
	0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32, /* 2....h".y..}...2 */ \
	0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f,0xee,0xef, /* .....y.KFZi.2... */ \
	0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb, /* .....].....k.u". */ \
	0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85,0xca,0x64, /* .\g.B.N8.K.iC..d */ \
	0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59, /* i%..O...(...s..Y */ \
	0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65, /* .RZZ.eI.;...u.,e */ \
	0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f, /* ....F..sj...]o.o */ \
	0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a, /* )...U.^.....F..: */ \
	0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e, /* :Z..=..:.....Z.. */ \
	0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda, /* ..o.oI.a.%...... */ \
	0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac, /* .%.....{...+:5F. */ \
	0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a, /* ..I4..TN....2#ez */ \
	0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22, /* ..e..Im.g...p.." */ \
	0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16, /* ..X.....L.h...s. */ \
	0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00, /* .....(.4...3.... */ \
	0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b, /* .+...z...../)..K */ \
	0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6, /* .......p.58 ..3. */ \
	0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c, /* a..A...)./...r.. */ \
	0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca, /* xF..77.$.L. .:.. */ \
	0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76, /* ;..J..t...ka...v */ \
	0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06, /* B......V....I... */ \
	0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39, /* ..|.-.x..}..K|.9 */ \
	0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f, /* .+x.......kv.... */ \
	0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39, /* ..W~.;.....<o..9 */ \
	0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9  /* ......}0fOt_..`. */
#define DATACHUNK000002 \
	0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b, /* ...D.........|.. */ \
	0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf, /* ..G.....Jp..$~.. */ \
	0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea, /* 1v!.f.....!\.... */ \
	0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd, /* &,........8...?. */ \
	0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7, /* g....e.2..1[.... */ \
	0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f,0x94,0x2f, /* ..I.Y....P...../ */ \
	0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb, /* ..)<V#..?..<0.m. */ \
	0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74, /* .q..gD.......Q.t */ \
	0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b, /* ..S.BVO..C....$. */ \
	0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4, /* ....S..R........ */ \
	0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d, /* ...6V...s2..u..m */ \
	0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84, /* vP.v...}.}...F.. */ \
	0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87,0x77,0xd2, /* .F....!Q.b.6..w. */ \
	0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61, /* .M......!.}...Qa */ \
	0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb, /* .)^.......~...R. */ \
	0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d, /* ..^"..,..9.r. .M */ \
	0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1, /* !....5...me}T+.. */ \
	0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36,0xff,0x25, /* N.W.(. ..IL..6.% */ \
	0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99, /* qyQ...2.$...(... */ \
	0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53, /* ...<.:....../.FS */ \
	0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b, /* I.P[..Y....)zNh. */ \
	0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1, /* ...1.p.I6&..v.f. */ \
	0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a, /* LN.....$.|...~5. */ \
	0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a, /* .....9~..^+..%M. */ \
	0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35,0x25,0x5f, /* ..fR.....Qj..5%_ */ \
	0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6, /* ..........#..X.. */ \
	0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5, /* ....}.'..r4...:. */ \
	0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea, /* we..bq.u..8vv.J. */ \
	0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc, /* ...F....G...~... */ \
	0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d, /* #..^...6}.e!...M */ \
	0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88, /* 65....>t..-i.... */ \
	0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f, /* .b}.?.>T%..&...O */ \
	0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2, /* .k.....1........ */ \
	0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1, /* .....g...\.h)... */ \
	0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f, /* .....Kv..T..C..o */ \
	0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c, /* Z......v......y. */ \
	0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92,0x9d,0xae, /* .Y%.bu...0H.c... */ \
	0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8, /* .....K..U.8.4... */ \
	0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e, /* ....KI+.x....... */ \
	0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf, /* .y4...Ne1...y... */ \
	0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e, /* .!Z..}.....f.... */ \
	0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6, /* .[.U..b.......0. */ \
	0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42, /* ...........H)..B */ \
	0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e, /* .....4....rT.BW~ */ \
	0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb, /* ..jar.d...&.f7.. */ \
	0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28, /* o..X:...r.$....( */ \
	0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30, /* ..RV>v.L,....".0 */ \
	0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2, /* .............;X. */ \
	0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9, /* ..x..}bC.E...M.. */ \
	0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1,0xde,0xbb, /* ..G..8."g...@... */ \
	0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc, /* ...M3F..jS">.=0. */ \
	0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08, /* .Q"NZ.....J.~D.. */ \
	0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a, /* ..j..0.."....#.J */ \
	0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23, /* a.9..N.D..F.p.I# */ \
	0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67, /* . ...pf.......Jg */ \
	0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29, /* _.'..w...t...=.) */ \
	0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d, /* .&3WE>,1.{...`#} */ \
	0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9, /* .N.uVv...|...... */ \
	0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d, /* 4H...].!'......M */ \
	0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0, /* ..s.....g....O.. */ \
	0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ../...-....~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63  /* ...<h1>Authentic */
#define DATACHUNK000003 \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* ation</h1>....<p */ \
	0x3e,0x4d,0x61,0x6e,0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f, /* >Many applicatio */ \
	0x6e,0x73,0x20,0x6e,0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x74,0x72, /* ns need to restr */ \
	0x69,0x63,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x75, /* ict access to au */ \
	0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x20,0x75,0x73,0x65,0x72,0x73,0x2e,0x20, /* thorized users.  */ \
	0x20,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x0d,0x0a,0x73,0x65,0x72,0x76, /*  The HTTP ..serv */ \
	0x65,0x72,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x42,0x61,0x73,0x69, /* er supports Basi */ \
	0x63,0x20,0x48,0x54,0x54,0x50,0x20,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63, /* c HTTP Authentic */ \
	0x61,0x74,0x69,0x6f,0x6e,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65, /* ation to provide */ \
	0x20,0x74,0x68,0x69,0x73,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c, /*  this functional */ \
	0x69,0x74,0x79,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54, /* ity.</p>....<p>T */ \
	0x77,0x6f,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65, /* wo functions are */ \
	0x20,0x69,0x6e,0x76,0x6f,0x6c,0x76,0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x61, /*  involved with a */ \
	0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62, /* uthentication, b */ \
	0x6f,0x74,0x68,0x20,0x6f,0x66,0x20,0x77,0x68,0x69,0x63,0x68,0x20,0x73,0x74,0x6f, /* oth of which sto */ \
	0x72,0x65,0x20,0x61,0x0d,0x0a,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x61,0x6c, /* re a..return val */ \
	0x75,0x65,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48, /* ue in <code>curH */ \
	0x54,0x54,0x50,0x2e,0x69,0x73,0x41,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64, /* TTP.isAuthorized */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x4d,0x53, /* </code>.  The MS */ \
	0x42,0x20,0x6f,0x66,0x20,0x74,0x68,0x69,0x73,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d, /* B of this value. */ \
	0x0a,0x69,0x6e,0x64,0x69,0x63,0x61,0x74,0x65,0x73,0x20,0x77,0x68,0x65,0x74,0x68, /* .indicates wheth */ \
	0x65,0x72,0x20,0x6f,0x72,0x20,0x6e,0x6f,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73, /* er or not access */ \
	0x20,0x69,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x65,0x64,0x2e,0x20,0x20,0x54,0x68, /*  is allowed.  Th */ \
	0x65,0x20,0x66,0x69,0x72,0x73,0x74,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b, /* e first callback */ \
	0x2c,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x4e,0x65, /* , ..<code>HTTPNe */ \
	0x65,0x64,0x73,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20, /* edsAuth</code>,  */ \
	0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68, /* determines if th */ \
	0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65, /* e requested page */ \
	0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64, /*  requires..valid */ \
	0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x74,0x6f,0x20, /*  credentials to  */ \
	0x70,0x72,0x6f,0x63,0x65,0x65,0x64,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e, /* proceed.  Return */ \
	0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64, /*  a value of <cod */ \
	0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72, /* e>0x80</code> or */ \
	0x20,0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c, /*  greater ..to al */ \
	0x6c,0x6f,0x77,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e, /* low access uncon */ \
	0x64,0x69,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52,0x65,0x74, /* ditionally.  Ret */ \
	0x75,0x72,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f, /* urn <code>0x79</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x6c,0x6f,0x77,0x65,0x72,0x20,0x74, /* code> or lower t */ \
	0x6f,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x20,0x0d,0x0a,0x61,0x75,0x74,0x68, /* o require ..auth */ \
	0x6f,0x72,0x69,0x7a,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* orization.</p>.. */ \
	0x0d,0x0a,0x54,0x68,0x65,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63, /* ..The second, <c */ \
	0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x56,0x65,0x72,0x69,0x66,0x79,0x41,0x75, /* ode>HTTPVerifyAu */ \
	0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d, /* th</code> determ */ \
	0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70, /* ines if the supp */ \
	0x6c,0x69,0x65,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73, /* lied credentials */ \
	0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x61,0x62,0x6c, /*  ..are acceptabl */ \
	0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73, /* e for the reques */ \
	0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x72,0x20, /* ted page.  Your  */ \
	0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75, /* application shou */ \
	0x6c,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75, /* ld return a valu */ \
	0x65,0x20,0x0d,0x0a,0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20,0x74,0x68,0x61,0x6e, /* e ..greater than */ \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64, /*  <code>0x80</cod */ \
	0x65,0x3e,0x20,0x74,0x6f,0x20,0x70,0x65,0x72,0x6d,0x69,0x74,0x20,0x61,0x63,0x63, /* e> to permit acc */ \
	0x65,0x73,0x73,0x2c,0x20,0x6f,0x72,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20, /* ess, or a value  */ \
	0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64, /* less than ..<cod */ \
	0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f, /* e>0x79</code> to */ \
	0x20,0x72,0x65,0x6a,0x65,0x63,0x74,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x73,0x73, /*  reject the pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f, /* word supplied.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65, /* p>....<p>As an e */ \
	0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74, /* xample, access t */ \
	0x68,0x69,0x73,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x70, /* his restricted p */ \
	0x61,0x67,0x65,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* age:</p>....<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62, /*  class="exampleb */ \
	0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61  /* ox">..<b>User Na */
#define DATACHUNK000004 \
	0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x61,0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e, /* me:</b> admin &n */ \
	0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73, /* bsp; &nbsp; &nbs */ \
	0x70,0x3b,0x20,0x3c,0x62,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c, /* p; <b>Password:< */ \
	0x2f,0x62,0x3e,0x20,0x6d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x3c,0x62,0x72, /* /b> microchip<br */ \
	0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70, /*  />..<a href="/p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x52, /* rotect">Access R */ \
	0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x50,0x61,0x67,0x65,0x3c,0x2f, /* estricted Page</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* a>..</div>....</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* div>....<script  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73, /* type="text/javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64, /* cript">..<!--..d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e, /* ntById('hello'). */ \
	0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65, /* innerHTML = "~he */ \
	0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a, /* llomsg~";..-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0x12,0x05,0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,0x00,0x00,0x02, /* ...........0.... */ \
	0x00,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ...<div class="s */ \
	0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* pacer">&nbsp;</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f, /* iv>..<div id="fo */ \
	0x6f,0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20, /* oter">Copyright  */ \
	0x26,0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f, /* &copy; 2011 Sato */ \
	0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a, /* shi Yasuda 7m3tj */ \
	0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* z/ad6gz</div>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64, /* .</div></div></d */ \
	0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* iv></div></div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74, /* ...</body>..</ht */ \
	0x6d,0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d, /* ml><!DOCTYPE htm */ \
	0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43, /* l PUBLIC "-//W3C */ \
	0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20, /* //DTD XHTML 1.0  */ \
	0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22, /* Strict//EN"..  " */ \
	0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72, /* http://www.w3.or */ \
	0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f, /* g/TR/xhtml1/DTD/ */ \
	0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74, /* xhtml1-strict.dt */ \
	0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73, /* d">..<html xmlns */ \
	0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e, /* ="http://www.w3. */ \
	0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20, /* org/1999/xhtml"  */ \
	0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61, /* xml:lang="en" la */ \
	0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e, /* ng="en">..<head> */ \
	0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20, /* ..<title>D-STAR  */ \
	0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72, /* dSqure Client Pr */ \
	0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c, /* ogram</title>..< */ \
	0x6c,0x69,0x6e,0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74, /* link href="/7m3t */ \
	0x6a,0x7a,0x2e,0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79, /* jz.css" rel="sty */ \
	0x6c,0x65,0x73,0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* lesheet" type="t */ \
	0x65,0x78,0x74,0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63, /* ext/css" />..<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a, /* ript src="/7m3tj */ \
	0x7a,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* z.js" type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73, /* /javascript"></s */ \
	0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d, /* cript>..</head>. */ \
	0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ...<body>..<div  */ \
	0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e, /* id="shadow-one"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d, /* <div id="shadow- */ \
	0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68, /* two"><div id="sh */ \
	0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76, /* adow-three"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72, /*  id="shadow-four */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67, /* ">..<div id="pag */ \
	0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* e">....<div id=" */ \
	0x74,0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* title"><div clas */ \
	0x73,0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52, /* s="right">D-STAR */ \
	0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f, /*  dSqure Client</ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65, /* div><span id="he */ \
	0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61  /* llo">&nbsp;</spa */
#define DATACHUNK000005 \
	0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* n></div>....<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /*  id="menu">..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d, /* href="/index.htm */ \
	0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* ">Overview</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63, /* <a href="/protec */ \
	0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65, /* t/config.htm">Ne */ \
	0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74, /* twork Configurat */ \
	0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ion</a>..<a href */ \
	0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63, /* ="/nodeadapter/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20, /* onfig.htm">Node  */ \
	0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Adapter Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ation</a>..</div */ \
	0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* >~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53, /* ent">....<h1>D-S */ \
	0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e, /* TAR dSqure Clien */ \
	0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65, /* t</h1>....<table */ \
	0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d, /*  style="padding- */ \
	0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c, /* left: 10px;">..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65, /* tr><td><b>dSqure */ \
	0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e, /*  Server Domain N */ \
	0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ame :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f, /* >~server_name~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50, /* d><b>Out bound P */ \
	0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ort :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* >~out_port~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20, /* b>In bound Port  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e, /* bsp;</td><td>~in */ \
	0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* _port~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e, /* ..<tr><td><b>Con */ \
	0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d, /* ference Room Nam */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* e :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* RoomName~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c, /* Node Callsign :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65, /* p;</td><td>~Node */ \
	0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* Name~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x63,0x63,0x65, /* .<tr><td><b>Acce */ \
	0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20, /* ss Control File  */ \
	0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* Name :</b></td>< */ \
	0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* td>&nbsp;</td><t */ \
	0x64,0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* d>~AccCtrl~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d, /* b>NTP Server Dom */ \
	0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* ain Name :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c, /* d><td>~NtpName~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* /td></tr>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* le>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* ";..//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f  /* ipt>....~inc:foo */
#define DATACHUNK000006 \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00, /* ter.inc~......3. */ \
	0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b,0x00, /* ......J.......K. */ \
	0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d,0x00, /* ..L...L.......M. */ \
	0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f,0x00, /* ......N...A..._. */ \
	0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00,0x15,0x03,0x00,0x00,0x01,0x00, /* ......`......... */ \
	0x00,0x00,0x37,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00, /* ..7............. */ \
	0x00,0x00,0x00,0x00,0xed,0x5c,0xeb,0x6e,0xdb,0xc8,0x15,0xfe,0xdd,0x00,0x79,0x87, /* .....\.n......y. */ \
	0xa9,0x16,0x08,0x9a,0x45,0xa0,0x0b,0xa9,0x8b,0xed,0xd8,0x06,0x1c,0xd9,0x8e,0xdd, /* ....E........... */ \
	0x24,0xb6,0x21,0x29,0xbb,0x5e,0xb4,0x85,0x40,0x91,0x23,0x8b,0x35,0x45,0xaa,0x24, /* $.!).^..@.#.5E.$ */ \
	0xe5,0xda,0x29,0xea,0xc7,0xe8,0xb3,0xf5,0x71,0x3a,0x73,0x86,0x9c,0x9b,0x86,0x34, /* ..).....q:s....4 */ \
	0x75,0x01,0x36,0x6d,0x57,0x08,0x18,0x59,0x24,0xe7,0x9b,0x73,0xce,0xf7,0xcd,0x9c, /* u.6mW..Y$..s.... */ \
	0x39,0xbc,0x34,0x7e,0xdc,0xee,0xf3,0xfa,0x15,0xfa,0x11,0x7d,0xb9,0x39,0x1f,0x5e, /* 9.4~.......}.9.^ */ \
	0xce,0xef,0xac,0xba,0x0b,0x7f,0x9e,0xe2,0xa9,0x1f,0xe2,0x04,0x39,0x21,0xec,0xb1, /* ............9!.. */ \
	0x90,0x3f,0x77,0xee,0x30,0x4a,0x23,0x34,0xc1,0x28,0x49,0xa3,0x18,0x7b,0xc8,0x0f, /* .?w.0J#4.(I..{.. */ \
	0xd1,0x22,0x8e,0xee,0x62,0x67,0x8e,0xe6,0x78,0x1e,0xc5,0x4f,0x75,0x7a,0x2a,0x9c, /* ."..bg..x..Ouz.. */ \
	0x7e,0x75,0x3d,0x42,0xe7,0xd7,0x03,0x74,0x71,0x72,0x75,0x8a,0xbe,0x5c,0x9f,0x5e, /* ~u=B...tqru..\.^ */ \
	0x9e,0x5f,0xf6,0x4f,0x46,0x97,0xd7,0x57,0xb0,0x77,0x34,0xf3,0x13,0x34,0xf5,0x03, /* ._.OF..W.w4..4.. */ \
	0x8c,0xc8,0xff,0xce,0x32,0x8d,0xe6,0x4e,0xea,0xbb,0x4e,0x10,0x3c,0xa1,0x3b,0x1c, /* ....2..N..N.<.;. */ \
	0xe2,0xd8,0x49,0x49,0xeb,0x93,0x27,0x94,0xce,0x70,0x86,0xfe,0x35,0xf5,0x03,0x3f, /* ..II..'..p..5..? */ \
	0x7d,0x82,0xb3,0x4f,0x3e,0x7f,0x56,0x9a,0x1c,0xa2,0x9f,0x2f,0xc9,0x4f,0x1f,0xce, /* }..O>.V..../.O.. */ \
	0xd0,0xf5,0x4f,0x67,0x83,0x9f,0x07,0x97,0xa3,0xd1,0xd9,0x15,0xfa,0xf0,0x0b,0x1a, /* ..Og............ */ \
	0x5d,0x9c,0x65,0xa7,0x7f,0x3c,0xbb,0x3a,0x1b,0x9c,0x8c,0xae,0x07,0xd0,0xc0,0x47, /* ].e..<.:.......G */ \
	0x8e,0xf1,0xaf,0x7f,0xa3,0x56,0x13,0x59,0xf4,0x5f,0xab,0x45,0xbe,0x1e,0x74,0xec, /* .....V.Y._.E..t. */ \
	0x83,0x66,0x0f,0xd1,0xa3,0xb6,0xfb,0x34,0x5e,0xbf,0x7a,0xfd,0xea,0x07,0x0f,0x9c, /* .f.....4^.z..... */ \
	0x88,0xc6,0x63,0x70,0xee,0x97,0x8f,0xd6,0xb8,0x0f,0xbf,0xfb,0xa1,0x1b,0x2c,0x3d, /* ..cp..........,= */ \
	0x8c,0x6a,0xa3,0xfe,0xcd,0xe5,0x4d,0x3f,0x0a,0xa7,0xfe,0x5d,0x7d,0x56,0xa3,0x7b, /* .j....M?...]}V.{ */ \
	0xa6,0xe8,0xf7,0xec,0x2c,0xef,0x0f,0xf4,0xa4,0xf1,0xd7,0xe1,0xd9,0xf8,0xec,0xec, /* ....,........... */ \
	0x66,0x70,0xfd,0xe5,0x2d,0x7a,0xf3,0xc6,0xb0,0x73,0x78,0x73,0x39,0x3e,0xff,0x7c, /* fp..-z...sxs9>.| */ \
	0x32,0xbc,0x78,0x6b,0x68,0x1a,0x0d,0x53,0xc7,0xbd,0x6f,0xc0,0x77,0x0e,0x90,0x37, /* 2.xkh..S..o.w..7 */ \
	0x31,0x1c,0x9d,0xf4,0x3f,0x41,0x1b,0xe0,0x24,0x38,0xff,0xf5,0xab,0xc6,0x9a,0x9c, /* 1...?A..$8...... */ \
	0xb1,0xd0,0x25,0x30,0xe3,0xd4,0x49,0x9d,0xca,0x7e,0x6b,0x08,0xe7,0x9c,0x9e,0x90, /* ..%0..I..~k..... */ \
	0x6e,0x5c,0x7c,0xbd,0xfa,0xd4,0x84,0x0f,0xfa,0xf3,0xeb,0x57,0xbf,0x6b,0x3e,0xb6, /* n\|........W.k>. */ \
	0xbd,0x77,0xcd,0xc7,0x4e,0x93,0x6c,0xda,0x5d,0xfa,0xcd,0x26,0x9b,0xa6,0x45,0x37, /* .w..N.l.]..&..E7 */ \
	0x2d,0xfe,0x8d,0xee,0xc5,0x0e,0xd9,0xd8,0x74,0x33,0x9d,0xe6,0x1b,0x7b,0x2f,0xdf, /* -.......t3...{/. */ \
	0x9b,0x6f,0x50,0x83,0xf5,0xb5,0x4e,0x3f,0x07,0xf5,0xfa,0x1e,0xf9,0x0f,0xfd,0xd8, /* .oP...N?........ */ \
	0xc8,0xb1,0xda,0xfa,0xf1,0xcd,0xc7,0xbd,0x0e,0xfd,0xa6,0x36,0xe4,0xd2,0x8d,0x43, /* ...........6...C */ \
	0x0f,0xde,0xc7,0xb4,0x63,0x78,0xf5,0xb4,0x0c,0xeb,0xb4,0xce,0x3f,0x57,0x75,0x05, /* ....cx......?Wu. */ \
	0x4b,0xf4,0xbc,0x6d,0xaf,0x9e,0xee,0xee,0xaf,0xa2,0xee,0xad,0x20,0x88,0x9e,0x50, /* K..m........ ..P */ \
	0xac,0x7a,0xbd,0x5f,0x97,0x3f,0x02,0xab,0xac,0x97,0xf2,0xa6,0x4b,0x7b,0xd2,0xa5, /* .z._.?......K{.. */ \
	0x9e,0xeb,0xd2,0x83,0xbb,0xd4,0xe1,0x5d,0xda,0x93,0x6e,0x8f,0x6c,0x2c,0xf8,0x6d, /* .......]..n.l,.m */ \
	0x8f,0x61,0x5d,0x31,0x0c,0x37,0x63,0xac,0xc0,0xea,0x51,0xb7,0x74,0x3d,0xa5,0xdd, /* .a]1.7c...Q.t=.. */ \
	0x1e,0xe6,0x0d,0xe1,0x1c,0x06,0x42,0xd5,0xa5,0x16,0x76,0xa9,0x87,0xbb,0x34,0x9a, /* ......B...v...4. */ \
	0xdd,0x76,0xfe,0x67,0xcf,0x62,0x80,0x14,0x2b,0x9d,0xd7,0xeb,0xcf,0x84,0xcd,0x07, /* .v.g.b..+....... */ \
	0x33,0xec,0x78,0x38,0x96,0xec,0xd2,0x9a,0x04,0x98,0x26,0x40,0x03,0x19,0x5c,0xde, /* 3.x8......&@..\. */ \
	0x24,0x3d,0xae,0x47,0xad,0xb1,0x9a,0xbc,0x27,0x74,0x87,0x4d,0x0f,0xb6,0x2c,0xd6, /* $=.G....'t.M..,. */ \
	0x00,0xc5,0x22,0x30,0xcf,0xf5,0xfa,0xa1,0xe7,0x3f,0x20,0xdf,0x3b,0xaa,0xb9,0x12, /* .."0.....? .;... */ \
	0x16,0x77,0x4b,0x8f,0xf7,0x52,0xfc,0x09,0x6d,0xd8,0x2a,0xbe,0xde,0x13,0x6a,0xab, /* .wK..R..m.....j. */ \
	0xdd,0x62,0xc7,0x51,0xac,0x28,0x4c,0x71,0x98,0xd6,0x8e,0xa9,0x1f,0x0f,0x67,0xad, /* .b.Q.(Lq......g. */ \
	0x63,0x89,0x87,0x98,0xc7,0x81,0x63,0x41,0xcf,0xdb,0xc2,0x4b,0xf4,0x5b,0xaf,0xa9, /* c.....cA...K.[.. */ \
	0x74,0x87,0x39,0x8d,0x53,0x2a,0xef,0x31,0xc5,0xba,0x8a,0xc8,0x48,0x70,0xe2,0x39, /* t.9.S..1....Hp.9 */ \
	0x8b,0x14,0xc7,0x88,0x0c,0x33,0x92,0x5d,0x6a,0x90,0x7b,0xbc,0x21,0x86,0xc0,0xdd, /* .....3.]j.{.!... */ \
	0x27,0xec,0x07,0x6b,0xac,0xa9,0x6e,0x12,0x18,0x4c,0xb1,0x08,0x21,0x96,0x64,0x50, /* '..k..n..L..!.dP */ \
	0xf5,0xa3,0xf0,0xb0,0x41,0xcc,0x92,0x39,0x6f,0x72,0x4b,0x37,0x6f,0x9c,0xa1,0x7a, /* ....A..9orK7o..z */ \
	0x3c,0x4a,0x1e,0xb7,0xab,0xcd,0xa9,0xc2,0x7d,0x62,0x7b,0x19,0xe7,0xeb,0x87,0xd3, /* <J......}b{..... */ \
	0x28,0xa6,0xd3,0x4e,0x3a,0x8b,0xbc,0x23,0x81,0x05,0x11,0x01,0x07,0xb1,0xc6,0x6d, /* (..N:..#.......m */ \
	0x25,0x54,0x0c,0xa1,0xc5,0x99,0x63,0x32,0x93,0x73,0x83,0xd8,0x4a,0xb1,0x6a,0x8b, /* %T....c2.s..J.j. */ \
	0x28,0x49,0x6b,0xc8,0x71,0xa9,0x69,0x47,0xb5,0x86,0xe4,0x43,0x43,0xbc,0xba,0x15, /* (Ik.q.iG...CC... */ \
	0x42,0x35,0x35,0x6a,0x8e,0x62,0x85,0x24,0x5e,0x0e,0x0b,0x57,0x83,0x6a,0x4c,0xe7, /* B55j.b.$^..W.jL. */ \
	0xbc,0xac,0x47,0x59,0x73,0x92,0x71,0x98,0x77,0x82,0x3b,0x52,0xa2,0x7b,0xd6,0x63, /* ..GYs.q.w.;R.{.c */ \
	0xe0,0x3c,0xd1,0x6f,0x3a,0xaf,0xa1,0xd0,0x99,0xe3,0xa3,0x5a,0x18,0x49,0x58,0xc2, /* .<.o:......Z.IX. */ \
	0x1a,0x9b,0x87,0xaa,0x57,0x40,0x77,0x29,0x9a,0xfb,0xfc,0x34,0x2e,0xc1,0x1e,0xd3, /* ....W@w)...4.... */ \
	0x97,0x87,0xdd,0xe9,0x1d,0xa5,0xfc,0xe1,0xd4,0xc7,0x81,0x97,0x48,0x58,0x3c,0xd2, /* ............HX<. */ \
	0xc6,0x76,0x55,0x19,0xdb,0x9c,0x87,0x0c,0x01,0xcc,0xb4,0x24,0x54,0x8a,0x85,0xd3, /* .vU........$T... */ \
	0x63,0x26,0xe5,0xe3,0xc3,0xc0,0x99,0xe0,0x40,0x60,0xc1,0xe9,0x1d,0xda,0x64,0x67  /* c&......@`....dg */
#define DATACHUNK000007 \
	0x8f,0x4b,0xa6,0xad,0x76,0x1a,0x82,0xb6,0x9f,0xef,0xed,0x08,0x82,0x08,0x6f,0x66, /* .K..v.........of */ \
	0xbd,0xa3,0x58,0xc7,0xa3,0x5b,0x92,0x28,0x05,0xce,0x13,0x1a,0xf9,0x73,0x7c,0x70, /* ..X..[.(.....s|p */ \
	0x28,0xf1,0x70,0x5a,0xdc,0xcb,0x02,0x5b,0xf9,0xa8,0xc6,0x48,0xc3,0x1d,0x63,0xb1, /* (.pZ...[...H..c. */ \
	0x39,0xa5,0x01,0xd6,0x50,0xdb,0xfc,0x70,0xb1,0x4c,0x91,0x36,0xf6,0x42,0xa7,0x19, /* 9...P..p.L.6.B.. */ \
	0xf1,0xd5,0x98,0x4b,0xec,0xe3,0xa4,0x29,0xe3,0x0b,0x8c,0xbd,0x4f,0x0b,0xc2,0x89, /* ...K...)....O... */ \
	0x14,0x3f,0xa6,0x8c,0x1f,0x92,0x0f,0x05,0x97,0x54,0xcf,0x31,0xa7,0xf1,0x76,0x21, /* .?.......T.1..v! */ \
	0x5e,0xac,0x5d,0x37,0xb7,0x46,0xef,0x18,0x1b,0xa3,0x8e,0x6a,0x1e,0x0e,0x9e,0x6a, /* ^.]7.F.....j...j */ \
	0xe8,0xc1,0x09,0x96,0x04,0xf4,0xd9,0xc8,0x43,0x35,0x36,0x9d,0xe9,0x3b,0x45,0xbc, /* ........C56..;E. */ \
	0x62,0xc8,0xc0,0x6a,0x27,0x6c,0x4e,0x1f,0x27,0xe3,0x21,0x89,0xd5,0x38,0x25,0xb1, /* b..j'lN.'.!..8%. */ \
	0x7a,0xae,0xa1,0xc4,0xff,0xa6,0xf1,0x50,0xf4,0xcd,0xd6,0xbc,0x64,0xab,0x9d,0xb0, /* z......P....d... */ \
	0xf3,0x8d,0xe4,0x0e,0x2e,0x7c,0x32,0x32,0x02,0x0f,0x8f,0x6a,0xed,0x1a,0x72,0x03, /* .....|22...j..r. */ \
	0x27,0x49,0x8e,0x6a,0x8e,0xd7,0xd2,0xc6,0x28,0x68,0x17,0x58,0x02,0x64,0xb0,0xba, /* 'I.j....(h.X.d.. */ \
	0x3c,0x18,0x16,0x47,0xa0,0x87,0xd8,0x93,0xdc,0x42,0xc8,0x81,0x84,0x2c,0x2d,0x2c, /* <..G.....B...,-, */ \
	0x78,0x58,0x43,0x8d,0xe3,0x37,0xe1,0x24,0x59,0xbc,0x9f,0x0f,0xb1,0x5b,0x5f,0xe1, /* xXC..7.$Y....[_. */ \
	0xa1,0x41,0x46,0x1b,0x29,0x0d,0x78,0x48,0xa5,0x25,0x29,0x4c,0xf3,0xa1,0xe0,0xb7, /* .AF.).xH.%)L.... */ \
	0xa6,0x34,0x93,0x96,0x2c,0x31,0x50,0x8b,0x71,0x40,0xd2,0x17,0xe1,0x3b,0x51,0x18, /* .4..,1P.q@...;Q. */ \
	0xd5,0x16,0x8a,0x96,0xe9,0xff,0x97,0xbe,0x58,0xbb,0xaa,0x6f,0x36,0xd3,0x57,0x4a, /* ........X..o6.WJ */ \
	0x7c,0x67,0xd2,0x97,0x49,0x41,0x20,0x2d,0x0d,0xb5,0x4c,0x55,0x02,0x15,0xec,0x22, /* |g..IA -..LU..." */ \
	0x91,0x1a,0x13,0x34,0xa6,0x2e,0xac,0xcf,0xcb,0x5b,0xaa,0x4a,0x9b,0x97,0x15,0x75, /* ...4.....[.J...u */ \
	0xc9,0xf3,0x72,0x05,0x41,0x15,0x68,0xc9,0xa4,0x17,0x18,0xe7,0x99,0xb8,0x40,0x5b, /* ..r.A.h.......@[ */ \
	0x94,0xff,0x1a,0xd6,0x96,0xb3,0x56,0xae,0x17,0xa6,0x2f,0x75,0xf6,0x3a,0x1e,0x08, /* ......V.../u.:.. */ \
	0x2c,0x69,0xd6,0x9a,0xf0,0xd3,0x3b,0xb9,0x5d,0x52,0xa6,0xe8,0x2a,0xf8,0xca,0xac, /* ,i....;.]R...... */ \
	0x25,0x94,0x43,0xb1,0x6e,0xd1,0x27,0x8c,0x17,0xe8,0x24,0xf0,0x1f,0xc8,0xec,0xd5, /* %.C.n.'...$..... */ \
	0x90,0xe6,0xca,0x5d,0xa8,0x4a,0x28,0x87,0x62,0xa9,0xea,0x4a,0x9f,0x24,0x1e,0xee, /* ...].J(.b..J.$.. */ \
	0x40,0x55,0xe2,0x5c,0x8a,0xa5,0xaa,0xeb,0xa8,0x26,0xd9,0x65,0xf2,0xdc,0x9a,0xaa, /* @U.\.....&.e.... */ \
	0x12,0xad,0x50,0xac,0x7b,0xe2,0x41,0xa1,0xae,0x7b,0xac,0xe7,0x36,0x4d,0xae,0xaa, /* ..P.{.A..{..6M.. */ \
	0xa2,0xd8,0x54,0xd7,0x17,0x5e,0x8c,0x1d,0x1a,0xab,0xef,0x5e,0x5f,0x65,0x13,0x96, /* ..T..^.....^_e.. */ \
	0x26,0x32,0x49,0x5f,0xf3,0x5c,0x60,0x12,0x37,0xb6,0x9b,0xb0,0x34,0xfa,0x52,0xac, /* &2I_.\`.7...4.R. */ \
	0x07,0x4d,0x60,0xd2,0xfa,0xcb,0xe1,0x4d,0xb6,0x55,0x0a,0x8a,0x15,0x96,0xc5,0x69, /* .M`....M.U.....i */ \
	0xd1,0xe5,0x1b,0xf5,0x90,0x3c,0x7c,0x14,0xeb,0x8f,0x7e,0x4a,0x57,0x5e,0x1f,0x96, /* .....<|...~JW^.. */ \
	0xd3,0x29,0xf9,0x2f,0x91,0xed,0x12,0xa1,0x5d,0x51,0xe6,0xfa,0xea,0xa3,0x58,0xdf, /* .)./....]Q....X. */ \
	0x40,0xc1,0x42,0x65,0x9a,0xbe,0x0a,0x94,0xb9,0xbe,0xfa,0x40,0x5f,0xa0,0x60,0xa1, /* @.Be.......@_.`. */ \
	0x32,0x7d,0x4d,0x54,0xb8,0xfe,0x30,0x78,0xb8,0x4c,0x7d,0xb0,0x26,0x02,0x05,0xff, /* 2}MT..0x.L}.&... */ \
	0x95,0x78,0x92,0xa9,0xac,0x30,0x67,0x63,0xca,0x34,0x20,0x68,0x81,0xec,0xf0,0x85, /* .x...0gc.4 h.... */ \
	0xa1,0x22,0xb2,0x2c,0x67,0x7b,0xa6,0x48,0x24,0x68,0x63,0x2a,0x30,0xc9,0x87,0x95, /* .".,g{.H$hc.0... */ \
	0x34,0x9a,0xeb,0xd0,0x7e,0x41,0x87,0x14,0x2b,0xd7,0x70,0xcd,0x66,0x3a,0x93,0xb0, /* 4...~A..+.p.f:.. */ \
	0x2a,0x69,0xb4,0x92,0x0e,0x6d,0x16,0xaf,0x5c,0xc3,0x99,0xce,0x9a,0x92,0x96,0x1d, /* .i...m..\....... */ \
	0xde,0x4b,0xbe,0x9a,0x15,0x2c,0xe9,0x1a,0x98,0x2e,0x56,0xce,0x66,0x2d,0x1f,0x90, /* .K...,....V.f-.. */ \
	0x55,0x6c,0x8a,0x30,0x61,0xbc,0x9b,0xfe,0x7a,0x5a,0xee,0x40,0xa4,0xc5,0x84,0xd9, /* Ul.0a...zZ.@.... */ \
	0x52,0x24,0x00,0x66,0xb2,0xac,0x94,0x67,0xa0,0x52,0x80,0x2c,0x95,0x43,0xcc,0xae, /* R$.f...g.R.,.C.. */ \
	0xc1,0x2d,0x3a,0x59,0xa6,0x11,0xba,0x89,0x02,0x27,0xf6,0xe5,0xf9,0x6b,0x17,0x0a, /* .-:Y.....'...k.. */ \
	0x16,0x2a,0x05,0x1f,0x1e,0xaa,0xd9,0xa8,0x96,0xb3,0x55,0x50,0x30,0xe3,0x9c,0xa8, /* ..........UP0... */ \
	0xb3,0xc1,0x9f,0x13,0xde,0x27,0x08,0x33,0xab,0xe9,0xe5,0x4a,0x76,0x67,0xd8,0xbd, /* .....'.3...Jvg.. */ \
	0x9f,0x44,0x8f,0xa6,0x75,0x4a,0xb9,0xaa,0xc1,0x5f,0x6c,0xa0,0x68,0xe6,0xb6,0xae, /* .D..uJ..._l.h... */ \
	0xaa,0x9a,0xad,0x53,0x98,0x9a,0xe3,0xc7,0x45,0x40,0xd5,0x2c,0x69,0xb9,0x68,0xbe, /* ...S....E@.,i.h. */ \
	0x95,0x1a,0xca,0x92,0xa4,0x2c,0xae,0x20,0x63,0x53,0x5c,0x3b,0x8c,0xf3,0x30,0x1f, /* .....,. cS\;..0. */ \
	0xd7,0xd0,0xf3,0xe0,0x76,0x4c,0xe3,0x76,0xa3,0xd7,0xf4,0x4a,0xc2,0x9d,0xcb,0xbd, /* ....vL.v...J.... */ \
	0xd2,0x24,0x0a,0x35,0x3d,0x46,0x89,0xe7,0x7c,0xc2,0xd4,0xf3,0xa8,0x22,0xf1,0x16, /* .$.5=F..|....".. */ \
	0xa4,0x9c,0x85,0x2a,0x81,0x3c,0x0a,0x84,0x7c,0xc8,0x97,0x61,0x5a,0x8d,0x68,0xdd, /* .....<..|..aZ.h. */ \
	0x94,0x53,0x59,0xa2,0xc9,0x62,0x80,0x1a,0x91,0x48,0x43,0x6f,0x29,0xf1,0x35,0xbb, /* .SY..b...HCo).5. */ \
	0x4c,0x9e,0xdb,0x48,0x0c,0x60,0x17,0xf5,0xa0,0x44,0x7c,0x49,0x5f,0xd5,0x13,0xcd, /* L..H.`...D|I_... */ \
	0x0a,0x62,0xa0,0x58,0x3c,0x09,0xcd,0x88,0x2f,0xd9,0x65,0x16,0xca,0x86,0x62,0xa0, /* .b.X<.../.e...b. */ \
	0x58,0x20,0x2a,0x89,0xf8,0x1a,0x0f,0xd7,0x4a,0x3e,0xcb,0xc4,0x00,0x3c,0xe4,0x89, /* X ......J>...<.. */ \
	0x28,0x23,0xbe,0x34,0x1e,0x56,0x1a,0xe7,0x64,0xe2,0x97,0xb1,0x9f,0x62,0xdd,0x70, /* (#.4.V..d....b.p */ \
	0xd2,0x33,0xd6,0x1b,0x6b,0x44,0x3b,0x60,0x3f,0x5b,0xc3,0xaa,0xac,0xd7,0xb9,0xb1, /* .3..kD;`?[...... */ \
	0xe1,0x82,0x4b,0x2b,0x50,0xb0,0x78,0xc9,0xf3,0xc9,0x88,0xb0,0x7e,0xad,0x71,0xa3, /* ..K+P.x.....~.q. */ \
	0x3a,0xfb,0x91,0x34,0x6e,0x70,0xd6,0xa3,0xe2,0x0b,0x63,0xad,0xbc,0x98,0xae,0x0e, /* :..4np....c..... */ \
	0x0a,0x6c,0xd8,0x6b,0xab,0x56,0x57,0x97,0x0a,0x2b,0xa6,0x1f,0xa6,0xde,0xb1,0x90, /* .l.k.VW..+...... */ \
	0x44,0x61,0x82,0x55,0x6d,0x4e,0x29,0x94,0x4a,0x96,0x60,0xe5,0xf3,0x0c,0x48,0xa2, /* Da.UmN).J.`...H. */ \
	0x38,0x99,0x6b,0x4b,0x32,0x5a,0x5f,0x2a,0x19,0x56,0xfa,0xb8,0x10,0x92,0x30,0x4d, /* 8.kK2Z_..V....0M */ \
	0x6c,0x3d,0x95,0x07,0x9d,0x6c,0xfe,0x58,0x4b,0x2a,0x6c,0x62,0x7b,0x1e,0xdd,0x8e, /* l=...l.XK.lb{... */ \
	0x25,0x49,0x68,0x03,0xca,0xfa,0x8b,0x30,0xb5,0x3c,0x98,0x53,0x0a,0x06,0x14,0xb1, /* %Ih....0.<.S.... */ \
	0x28,0x43,0x54,0x12,0x7a,0xc1,0x74,0x07,0x75,0x3e,0x3e,0x50,0x6a,0xb5,0x3e,0xac, /* (CT.z.t.u>>Pj.>. */ \
	0x4d,0xd8,0x70,0x3a,0x5c,0x75,0x6a,0x83,0xe7,0xec,0xbc,0xe7,0xed,0x22,0xaa,0x14  /* M.p:\uj......".. */
#define DATACHUNK000008 \
	0x08,0x04,0x26,0xec,0xe3,0xfe,0xf5,0x10,0xf5,0x29,0x3d,0x40,0x10,0x12,0xd6,0xcb, /* ..&......)=@.... */ \
	0x79,0xd4,0x1a,0x3a,0xa0,0x58,0x59,0x6e,0x25,0x78,0x2f,0xb8,0xb1,0xab,0xdc,0x8a, /* y..:.XYn%x/..... */ \
	0xf3,0x50,0xcb,0xaf,0x6a,0x1a,0xd6,0x0b,0x2b,0x26,0x7e,0x9d,0xa8,0xa7,0x2e,0x2a, /* .P..j...+&~..... */ \
	0xcc,0x8b,0xa5,0x6c,0x9a,0x71,0xa3,0xe4,0x85,0xc5,0x92,0x26,0x01,0x2d,0x86,0x2c, /* ...l.q.....&.-., */ \
	0xb7,0x2a,0x32,0x33,0x2b,0x2c,0xb2,0x59,0x86,0xc4,0x6c,0x0c,0x31,0x7b,0xd6,0xed, /* ..23+,.Y..l.1{.. */ \
	0xda,0x15,0xf1,0xc1,0x2e,0x8d,0xf4,0xdf,0x47,0x81,0xdb,0xce,0xbb,0xda,0xe6,0xb3, /* ........G....... */ \
	0x26,0xfc,0xd6,0xe3,0x59,0xa9,0x74,0xf5,0x82,0x7b,0x93,0x1d,0xd7,0xcd,0x0b,0xdc, /* &...Y.t..{...... */ \
	0xc3,0xc6,0x15,0x1a,0xfe,0x6d,0x89,0x03,0x77,0x86,0x7e,0xd2,0x13,0x47,0x6d,0x74, /* .....m..w.~..Gmt */ \
	0xdb,0x78,0xa1,0x01,0x09,0x16,0x19,0x05,0xe5,0x85,0x85,0x5e,0x08,0xde,0x78,0x12, /* .x.........^..x. */ \
	0x31,0x8c,0xbd,0xca,0x84,0xa2,0x8c,0xbd,0x9b,0x17,0xf6,0xf2,0x55,0xb7,0xbc,0x12, /* 1...........U... */ \
	0x07,0x2c,0xa9,0xd0,0x97,0x84,0x72,0x31,0xa2,0x6a,0x39,0x0f,0x82,0x06,0x31,0xec, /* .,....r1.j9...1. */ \
	0x70,0x09,0xac,0xc6,0x10,0x16,0x9c,0x59,0x99,0x6f,0x78,0x35,0x86,0x98,0xe9,0xe3, /* p......Y.ox5.... */ \
	0xfc,0x5e,0xde,0x64,0xe5,0x52,0x41,0x47,0xb5,0xdf,0x16,0x58,0xee,0x8c,0x97,0x08, /* .^.d.RAG...X.... */ \
	0x3a,0xb4,0x44,0xa0,0x27,0xdf,0xd5,0xcb,0x79,0xe5,0xa5,0x02,0xe0,0x46,0xa2,0x96, /* :.D.'...y....F.. */ \
	0x08,0xa4,0x04,0x2b,0x2b,0x23,0xec,0xa6,0x54,0x40,0xb1,0xde,0x37,0xd5,0x12,0xc1, /* ...++#..T@..7... */ \
	0x77,0x31,0x7f,0x41,0x2a,0xdd,0xde,0x76,0xfe,0x1a,0xf4,0x7f,0x9b,0xbf,0x0c,0x58, /* w1.A...v.......X */ \
	0x3d,0xfe,0xad,0xea,0xfc,0x15,0xbb,0x1b,0xcc,0x5f,0x22,0x86,0xeb,0xcc,0x5f,0x83, /* =........_"..._. */ \
	0xfe,0x6e,0xe7,0x2f,0x63,0xce,0xa6,0x54,0xd2,0xbf,0x87,0x9c,0x4d,0xb3,0x8b,0xcb, /* .n./c..T....M... */ \
	0x18,0xee,0xb6,0x13,0x37,0x02,0x69,0x97,0x6a,0xa5,0x8a,0x3e,0xce,0x38,0xff,0xd9, /* ....7.i.j..>.8.. */ \
	0x49,0x52,0x74,0x1e,0xd3,0x8b,0x98,0x43,0x1c,0x6a,0x76,0x6d,0x53,0x19,0x53,0x14, /* IRt....C.jvmS.S. */ \
	0x01,0x76,0xc9,0x93,0x17,0x61,0xfe,0x7f,0x69,0x81,0x60,0xa5,0x10,0xac,0x14,0x08, /* .v...a..i.`..... */ \
	0xd4,0x42,0xf0,0xda,0xd7,0x7c,0x75,0x59,0xe8,0x58,0xa9,0x5c,0x20,0xf8,0xbc,0x82, /* .B...|uY.X.\ ... */ \
	0x55,0x18,0xfd,0x35,0xea,0x61,0x7c,0x3c,0x4c,0x81,0x15,0xbc,0x26,0xe6,0xe8,0xdc, /* U..5.a|<L...&... */ \
	0x78,0x69,0xad,0x53,0x55,0x1b,0xc0,0x8d,0x6c,0x2d,0xb4,0x8b,0xa2,0x58,0xbb,0xe4, /* xi.SU...l-...X.. */ \
	0xee,0x44,0xb5,0x28,0x76,0x01,0x77,0x26,0x6a,0xe3,0x46,0xbb,0x27,0x69,0x44,0x9c, /* .D.(v.w&j.F.'iD. */ \
	0x99,0xfb,0xcb,0x74,0xcb,0x59,0xf1,0x9c,0x92,0xdf,0xaa,0xec,0x47,0xe1,0x6f,0x73, /* ...t.Y......G.os */ \
	0x0a,0xc7,0xda,0xcb,0xed,0x62,0x7e,0xe5,0xb7,0xa6,0xad,0xaa,0x44,0x9a,0x53,0x66, /* .....b~.....D.Sf */ \
	0x5e,0x7c,0x07,0xec,0x97,0x38,0x5f,0x41,0x41,0xa5,0xb7,0xaa,0x2a,0xb1,0xa6,0x58, /* ^|...8_AA......X */ \
	0x99,0xb2,0x18,0x31,0x3e,0xca,0xe3,0xe1,0xba,0x0a,0x2a,0x57,0x09,0x5c,0x40,0xd2, /* ...1>......W.\@. */ \
	0x16,0x45,0xda,0x78,0xb8,0xb3,0x85,0x11,0x8c,0x87,0xda,0xa2,0xa8,0x9c,0x87,0xe5, /* .E.x............ */ \
	0x4e,0x33,0xa9,0xc4,0x92,0x6a,0x29,0x92,0xb2,0x88,0x07,0xeb,0x52,0x3e,0xdf,0x31, /* N3...j).....R>.1 */ \
	0x51,0x70,0xab,0x35,0xd1,0x88,0xd0,0xf0,0xd7,0x5f,0x13,0x6d,0x59,0x58,0x33,0x60, /* Qp.5....._.mYX3` */ \
	0x29,0x45,0x36,0x15,0x4b,0x15,0xcf,0x96,0x53,0x0c,0xc5,0x22,0xc2,0x52,0xa6,0x15, /* )E6.K...S..".R.. */ \
	0xe9,0x82,0x7a,0x75,0xf1,0x98,0x83,0xab,0x54,0xa3,0x29,0x16,0x17,0x16,0x0d,0xdc, /* ..zu....T.)..... */ \
	0x33,0xda,0x41,0x9d,0xcd,0xbc,0x3a,0xd2,0xea,0x6c,0xb0,0x2a,0xd2,0x2e,0xd0,0x8a, /* 3.A...:..l...... */ \
	0x8b,0xac,0x85,0x89,0x26,0xfb,0x93,0x27,0x42,0x52,0x81,0xa0,0xc9,0xbb,0xc3,0xe6, /* ....&..'BR...... */ \
	0xe5,0x64,0xf1,0x1e,0x92,0x50,0xec,0x1d,0xa0,0xe1,0xc2,0x71,0xf5,0xbc,0x77,0x5b, /* .d...P.....q..w[ */ \
	0x41,0xe7,0xc6,0x41,0xde,0xab,0x88,0xf9,0x4d,0xa8,0x69,0x59,0x33,0xae,0xfc,0xfa, /* A..A....M.iY3... */ \
	0x72,0xd9,0x5e,0xd0,0x32,0x31,0x8c,0x5d,0x73,0x66,0x5b,0x69,0x9c,0xdf,0xb8,0x5d, /* r.^.21.]sf[i...] */ \
	0xd3,0x5e,0x8a,0x25,0xe3,0xd0,0xad,0x76,0x03,0xc4,0x96,0xd6,0xa8,0x3e,0x54,0xad, /* .^.%...v.....>T. */ \
	0xda,0xce,0x87,0x10,0xbe,0x92,0xb5,0xb9,0xc0,0xa9,0x9b,0xd6,0xe6,0xdb,0x98,0x04, /* ................ */ \
	0xa4,0xe9,0x48,0xf3,0x97,0x62,0x56,0xfd,0x6b,0x58,0x65,0x8c,0x32,0x90,0xbc,0x70, /* ..H..bV.kXe.2..p */ \
	0x79,0xc1,0x96,0x68,0x5d,0x31,0x46,0x51,0xc2,0xc3,0x12,0x62,0x70,0xae,0xe7,0x51, /* y..h]1FQ...bp..Q */ \
	0xa5,0x83,0xc7,0x1a,0x8a,0x80,0x1c,0x80,0x0d,0x1c,0x9c,0xf9,0xe5,0xeb,0xaf,0xca, /* ................ */ \
	0x49,0xa2,0xb8,0xa3,0xab,0xfb,0x8e,0xaf,0xf5,0xa4,0xeb,0x47,0x17,0x4e,0x30,0x95, /* I..........G.N0. */ \
	0xd6,0x7a,0x2c,0xbd,0x16,0x25,0x41,0x97,0xfb,0xab,0x9d,0xef,0x10,0x57,0xd0,0x45, /* .z,..%A......W.E */ \
	0x8d,0xac,0x24,0x3f,0x3c,0x5f,0x06,0x01,0x3a,0x5d,0x2e,0x02,0xfc,0xf8,0xbf,0x92, /* ..$?<_..:]...... */ \
	0x1f,0xa2,0x82,0xfc,0xb0,0xe8,0xc2,0x98,0xb5,0x66,0xe2,0xc8,0xee,0xc5,0xeb,0xe6, /* .........f...... */ \
	0xbf,0xbd,0x5c,0x8c,0x98,0x8d,0xa7,0x6b,0x16,0x23,0x0c,0xdc,0x30,0x85,0x5e,0xbe, /* ..\....k.#..0.^. */ \
	0x80,0x94,0xe5,0x8d,0x84,0x2f,0x34,0xa4,0xf2,0x05,0xa4,0xdd,0x14,0x23,0xe4,0xc1, /* ...../4......#.. */ \
	0x4b,0x9f,0xd9,0xca,0x07,0xaf,0xca,0xb3,0x9b,0x71,0x50,0x9e,0x48,0x33,0x5b,0xd1, /* K........qP.H3[. */ \
	0xa0,0x6c,0xf2,0x57,0x55,0x7d,0xcb,0x57,0x89,0x17,0xef,0xa9,0xff,0x72,0x8d,0x2b, /* .l.WU}.W.....r.+ */ \
	0x4f,0xdd,0x55,0x4d,0x79,0x2b,0xdf,0xcd,0x9a,0xa7,0xc2,0x15,0xef,0x66,0xb5,0x79, /* O.UMy+.......f.y */ \
	0xf4,0x2d,0xce,0x4d,0x7e,0x35,0xf1,0xa5,0x3b,0xc5,0xa8,0x12,0x92,0xe5,0x64,0xee, /* .-.M~5..;.....d. */ \
	0xa7,0x55,0xee,0x14,0x63,0x7e,0x55,0x97,0x0d,0x15,0xd2,0xba,0x8e,0xcd,0xef,0x14, /* .U..c~U......... */ \
	0x5b,0xb4,0x78,0x3a,0x37,0xd4,0x8b,0xce,0xbc,0xb6,0x2b,0x6e,0x87,0x14,0x8c,0x64, /* [.x:7.....+n...d */ \
	0xee,0x13,0x45,0x54,0xf1,0x9c,0x1e,0x7f,0xda,0xcb,0xca,0x8a,0xe3,0x50,0x74,0x7e, /* ..ET.........Pt~ */ \
	0xc0,0xe8,0x83,0x93,0xf8,0x2e,0xba,0x0c,0xa7,0x51,0x5d,0x5f,0x04,0x6e,0x58,0x11, /* .........Q]_.nX. */ \
	0xb0,0xb8,0xbe,0xf3,0x07,0x92,0x80,0xf3,0x52,0x75,0xa0,0x31,0xf5,0xf5,0xa2,0x58, /* ........Ru.1...X */ \
	0xfe,0xb0,0x52,0x3e,0xec,0xb6,0x5f,0x6e,0x5c,0x7d,0x76,0x4d,0x7e,0x12,0x2e,0xf0, /* ..R>.._n\}vM~... */ \
	0x12,0xf6,0x10,0x52,0x83,0x3e,0xa3,0xb6,0xf2,0x24,0x5c,0x55,0x6b,0x8a,0x1f,0x9f, /* ...R.>...$\Uk... */ \
	0xcc,0xf0,0x81,0x87,0xb9,0x55,0xf0,0xa8,0xe4,0x54,0x7e,0x8a,0x4b,0x3c,0x24,0x23, /* .....U...T~.K<$# */ \
	0x96,0x5e,0x86,0x26,0xd9,0xe3,0x93,0xcd,0x17,0x36,0x70,0xb7,0x42,0x8a,0xe3,0x3a, /* .^.&.....6p.B..: */ \
	0x7b,0x54,0x52,0x7b,0xd2,0x94,0x3d,0x8a,0x3b,0x31,0x9c,0xd9,0x5a,0xfd,0x0d,0x06  /* {TR{..=.;1..Z... */
#define DATACHUNK000009 \
	0x0f,0x7d,0x87,0xa5,0x61,0xf1,0xc7,0x59,0xef,0xcd,0x58,0xfb,0x86,0x36,0x6c,0x03, /* .}..a..Y..X..6l. */ \
	0xd6,0x54,0x6f,0x9c,0x6c,0xda,0x45,0x58,0x91,0x11,0x8b,0xb5,0xab,0x35,0xde,0x59, /* .To.l.EX.....5.Y */ \
	0xc5,0x82,0xf9,0x4b,0x3f,0xae,0x5b,0x84,0xf5,0x68,0xb6,0x0b,0x1b,0xda,0xe8,0x19, /* ...K?.[..h...... */ \
	0xec,0x6a,0xe9,0x86,0x34,0xd5,0xe7,0x86,0x15,0x2c,0xc7,0x88,0xe5,0xd9,0x86,0x36, /* .j..4....,.....6 */ \
	0xf6,0x8b,0xb0,0x34,0x83,0x9d,0x35,0xb1,0xf6,0x0c,0x6d,0x18,0xf8,0x02,0xf9,0xa1, /* ...4..5...m..... */ \
	0xe2,0x34,0xb2,0x71,0x8b,0xb0,0x06,0x46,0x2c,0x77,0x62,0x68,0xc3,0x5b,0xc5,0xf2, /* .4.q...F,wbh.[.. */ \
	0x5a,0x06,0xe7,0xe2,0x22,0x2c,0x33,0xe7,0x61,0x24,0xd5,0x1e,0xd8,0x6e,0x4e,0x35, /* Z...",3.a$...nN5 */ \
	0x2c,0x54,0xe5,0x43,0xb1,0x96,0x39,0x48,0xf6,0x61,0x6f,0x11,0xd8,0xe4,0x91,0xfc, /* ,T.C..9H.ao..... */ \
	0x3e,0x0a,0xfc,0xf0,0xde,0x99,0x04,0x18,0x25,0x4f,0xf3,0x49,0x14,0x24,0xeb,0x3c, /* >.......%O.I.$.< */ \
	0x9a,0xdf,0x68,0xa0,0xf3,0x28,0x46,0xfd,0xd6,0xde,0x3b,0xfa,0x0a,0x86,0x04,0x23, /* ..h..(F...;....# */ \
	0x27,0x26,0x0d,0x2d,0x02,0x3f,0x45,0x7e,0x98,0x46,0x28,0xc1,0x0b,0x78,0x81,0x02, /* '&.-.?E~.F(..x.. */ \
	0xf9,0x3d,0x76,0x9e,0x12,0x92,0x1a,0xba,0xce,0x92,0x1c,0x46,0xf6,0x27,0x0b,0x8c, /* .=v........F.'.. */ \
	0xbd,0x04,0x2d,0x17,0xc8,0x8d,0xe6,0x0b,0x3f,0x80,0xda,0x25,0x72,0x50,0x10,0xa5, /* ..-.....?..%rP.. */ \
	0xc4,0x2e,0xde,0x76,0x44,0xda,0x8d,0xb3,0x43,0x70,0x9c,0x00,0x0e,0xc2,0x61,0xea, /* ...vD...Cp....a. */ \
	0x13,0x20,0xcf,0x49,0x1d,0xd6,0x32,0x9a,0x2f,0xc9,0xd2,0x60,0x82,0xf3,0x57,0x16, /* . .I..2./..`..W. */ \
	0x20,0x32,0xf9,0x39,0x28,0xf1,0xc3,0x3b,0x62,0xd8,0x83,0x13,0xfb,0x60,0x21,0xe9, /*  2.9(..;b....`!. */ \
	0x10,0xb4,0x8b,0xc3,0x64,0x49,0x4e,0x4f,0x67,0x4e,0x0a,0xcd,0x51,0x17,0x10,0x10, /* ....dINOgN..Q... */ \
	0x2f,0xc2,0x09,0x5c,0x70,0x8c,0x71,0x14,0xd3,0xaa,0x12,0xdd,0x07,0x18,0xee,0x6c, /* /..\p.q........l */ \
	0x19,0xde,0x27,0xf4,0x35,0x16,0xe7,0x64,0x5a,0x9d,0xa1,0xbf,0xcf,0x70,0xc8,0xfb, /* ..'.5..dZ....p.. */ \
	0xc4,0xda,0x8c,0x16,0xa9,0x3f,0xf7,0xbf,0x81,0x15,0x09,0xb8,0x21,0x5d,0xc6,0xb4, /* .....?......!].. */ \
	0x27,0x51,0x58,0x57,0xdf,0xa6,0x30,0x1e,0xb7,0xf6,0xfa,0xb7,0xb7,0x6f,0x09,0x39, /* 'QXW..0......o.9 */ \
	0x06,0xd7,0x5f,0xd0,0x87,0x5f,0x46,0xec,0xe5,0x13,0xe3,0x61,0xea,0xc4,0xe9,0x9f, /* .._.._F....a.... */ \
	0xfe,0x82,0x8e,0xd0,0x3f,0xb4,0x77,0x1d,0xfc,0xf3,0xfd,0xca,0xc1,0xec,0x5e,0x2f, /* ....?.w.......^/ */ \
	0xd3,0xd1,0xad,0xa2,0xa3,0x2d,0xd3,0xd1,0x16,0x3d,0xfa,0x07,0x1c,0x24,0x78,0x8d, /* .....-...=...$x. */ \
	0xfe,0xbc,0xd3,0xef,0x39,0xd3,0x7f,0xc8,0x5a,0x0d,0x3d,0x7f,0xba,0x16,0x33,0x4b, /* ....9...Z.=...3K */ \
	0x19,0x7b,0x16,0x12,0x6f,0x4e,0xa1,0x6f,0x5b,0xbf,0x77,0xa3,0x91,0x77,0x0f,0x91, /* .{..oN.o[.w..w.. */ \
	0xd8,0x95,0xbf,0xeb,0x42,0x3d,0x6e,0x8b,0x97,0x6e,0xfc,0x07,0xce,0x71,0x46,0x71, /* ....B=n..n...qFq */ \
	0x7e,0x45,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ~E..~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e, /* Node Adapter Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* figuration</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d, /* ...<form method= */ \
	0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f, /* "post" action="/ */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66, /* nodeadapter/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f, /* ig.htm" name="no */ \
	0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73, /* decfg">..<fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* et>..<div><label */ \
	0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c, /* >TX Delay Time:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="dely" value="~ */ \
	0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a, /* delay_time~" siz */ \
	0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="4" class="ad1 */ \
	0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c, /* " />&nbsp;mSec.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c, /* el>TX Time out:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="tout" value="~ */ \
	0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* time_out~" size= */ \
	0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "4" class="ad1"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76, /* >&nbsp;Sec.</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52, /* >..<div><label>R */ \
	0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c, /* X Keep Alive:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65, /* keep" value="~ke */ \
	0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* ep_alive~" size= */ \
	0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "4" class="ad1"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69, /* >&nbsp;mSec.</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69, /* Jitter Buffer si */ \
	0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e  /* ze:</label>..<in */
#define DATACHUNK00000a \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="jitt" valu */ \
	0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65, /* e="~jittter_size */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="3" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30, /* s="ad1"/>&nbsp;0 */ \
	0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69, /* : not effect</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79, /* RX Auto Polarity */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61, /* " name="rxpl" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50, /* lue="" ~RX_AutoP */ \
	0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* olarity~ class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* ad1"/></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c, /* iv><label>RX Pol */ \
	0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* arity:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70, /* ckbox" name="rxp */ \
	0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f, /* o" value="" ~RX_ */ \
	0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73, /* Polarity~  class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ="ad1"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50, /* <div><label>TX P */ \
	0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* olarity:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="txpo" value=" */ \
	0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20, /* " ~TX_Polarity~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* class="ad1" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61, /* l>COS Check:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="cos" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e, /* e="" ~COS_Check~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c, /*  class="ad1" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56, /* el>S/N Squelch V */ \
	0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* alue:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20, /* text" name="sn"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c, /* value="~SN_Squel */ \
	0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c, /* ch~" size="5" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /* ass="ad1"/>&nbsp */ \
	0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f, /* ;0: not effect</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61, /* l>CRC Check:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="crc" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e, /* e="" ~CRC_Check~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f, /*  class="ad1"/></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e, /* l>Last Frame Sen */ \
	0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* d:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73, /* ckbox" name="las */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73, /* t" value="" ~Las */ \
	0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* tFrame~ class="a */ \
	0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* d1" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72, /* iv><label>Header */ \
	0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61, /*  Generation:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c  /*  name="hdrg" val */
#define DATACHUNK00000b \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e, /* ue="" ~HeaderGen */ \
	0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e, /* ~ class="ad1" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20, /* bel>Header Gen.  */ \
	0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Type:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* hdrt" value="" ~ */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20, /* HeaderGenType~   */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* class="ad1"/>&nb */ \
	0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63, /* sp;Checked: Spac */ \
	0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e, /* e</div>..<div>&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70, /* bsp;&nbsp;.&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e, /* ;&nbsp;&nbsp;.Un */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46, /* checked: Last RF */ \
	0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /*  Header</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f, /* div><label>Half/ */ \
	0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61, /* Full Duplex:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="h_f" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20, /* e="" ~HalfFull~  */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73, /* bsp;Checked:&nbs */ \
	0x70,0x3b,0x48,0x61,0x6c,0x66,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64, /* p;Half Duplex</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* iv>..<div>&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* &nbsp;.&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63, /* sp;&nbsp;.Unchec */ \
	0x6b,0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78, /* ked: Full Duplex */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* </div>......<div */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75, /* ><input type="su */ \
	0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31, /* bmit" class="ap1 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61, /* " value="Save Ba */ \
	0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* sic Info." /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* iv>..</fieldset> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51, /* nc~....3.......Q */ \
	0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53, /* ...k...R.......S */ \
	0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55, /* ...o...T.......U */ \
	0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56, /* ...x...^.......V */ \
	0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58, /* ...a...W.......X */ \
	0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a, /* ...a...Y.......Z */ \
	0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c, /* ...R...[.......\ */ \
	0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0xef,0x08,0x00,0x00,0x02, /* .......]........ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e, /* ntent">....<h1>N */ \
	0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61, /* etwork Configura */ \
	0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f, /* tion</h1>....<fo */ \
	0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22, /* rm method="post" */ \
	0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63, /*  action="/protec */ \
	0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* t/config.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66, /* me="config">..<f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ieldset>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73, /* label>MAC Addres */ \
	0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* s:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e  /* ut type="text" n */
#define DATACHUNK00000c \
	0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="mac" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f, /* "~config_mac~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65, /* abel>Server Name */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="host" value= */ \
	0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x22,0x20, /* "~server_name~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20, /* label>Out Bound  */ \
	0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Port:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20,0x76,0x61, /* " name="oprt" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22, /* lue="~out_port~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20, /* <label>In Bound  */ \
	0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Port:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20,0x76,0x61, /* " name="iprt" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20, /* lue="~in_port~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* label>Room Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="RmNm" value=" */ \
	0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ~RoomName~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a, /* l>Node Callsign: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="NdNm" value=" */ \
	0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ~NodeName~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d, /* l>NTP Server Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="ntp" value= */ \
	0x22,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* "~NtpName~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c, /* l>Access Control */ \
	0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  File Name:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63, /* ="text" name="ac */ \
	0x74,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x41,0x63,0x63,0x43, /* tl" value="~AccC */ \
	0x74,0x72,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* trl~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* <div>&nbsp;&nbsp */ \
	0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ;</div>..<div>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ckbox" class="sm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61, /* " name="dhcp" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d, /* lue="1" onclick= */ \
	0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29, /* "configIPBoxes() */ \
	0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68, /* " ~config_dhcpch */ \
	0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65, /* ecked~ /> Enable */ \
	0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /*  DHCP</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72, /* v><label>IP Addr */ \
	0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ess:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76, /* ext" name="ip" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70, /* alue="~config_ip */ \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79, /* v><label>Gateway */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c, /* :</label>..<td>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74  /* input type="text */
#define DATACHUNK00000d \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75, /* " name="gw" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20, /* e="~config_gw~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73, /* label>Subnet Mas */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61, /* t" name="sub" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62, /* lue="~config_sub */ \
	0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* net~" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d, /* <div><label>Prim */ \
	0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* ary DNS:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* e="text" name="d */ \
	0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e, /* ns1" value="~con */ \
	0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* fig_dns1~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c, /* >Secondary DNS:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="dns2" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e, /* config_dns2~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e, /* </div>..<div><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74, /* put type="submit */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c, /* " class="sm" val */ \
	0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22, /* ue="Save Config" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /*  /></div>..</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76, /* pt language="jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67, /* .function config */ \
	0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20, /* IPBoxes() {...e  */ \
	0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73, /* = document.forms */ \
	0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20, /* .config;...st =  */ \
	0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d, /* e.dhcp.checked;. */ \
	0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* ..e.ip.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73, /* = st;...e.gw.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* abled = st;...e. */ \
	0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* sub.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61, /* t;...e.dns1.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64, /* bled = st;...e.d */ \
	0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* ns2.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* t;..}..document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63, /* forms.config.mac */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65, /* .disabled = true */ \
	0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78, /* ;....configIPBox */ \
	0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* es();..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2,0x01,0x00, /* .%...>...J...... */ \
	0x00,0x4b,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x5d,0x02,0x00, /* .K.......L...].. */ \
	0x00,0x4d,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x1e,0x03,0x00, /* .M.......N...... */ \
	0x00,0x60,0x00,0x00,0x00,0x88,0x03,0x00,0x00,0x5f,0x00,0x00,0x00,0x0f,0x04,0x00, /* .`......._...... */ \
	0x00,0x27,0x00,0x00,0x00,0x83,0x04,0x00,0x00,0x28,0x00,0x00,0x00,0xe0,0x04,0x00, /* .'.......(...... */ \
	0x00,0x29,0x00,0x00,0x00,0x42,0x05,0x00,0x00,0x2a,0x00,0x00,0x00,0xa9,0x05,0x00, /* .)...B.......... */ \
	0x00,0x2b,0x00,0x00,0x00,0x0c,0x06,0x00,0x00,0x2c,0x00,0x00,0x00,0xe2,0x07,0x00, /* .+.......,...... */ \
	0x00,0x01,0x00,0x00,0x00,0x02,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .............~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53  /* >....<h1>Login S */
#define DATACHUNK00000e \
	0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* uccessful</h1>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75, /* ..<p>You have su */ \
	0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65, /* ccessfully logge */ \
	0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20, /* d in to the web  */ \
	0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75, /* server.  This au */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69, /* thentication ..i */ \
	0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f, /* s valid until yo */ \
	0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f, /* u close your bro */ \
	0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* wser.</p>....<p> */ \
	0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20, /* Credentials are  */ \
	0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72, /* verified in your */ \
	0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c, /*  own custom call */ \
	0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61, /* back function ca */ \
	0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* lled ..<code>HTT */ \
	0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63, /* PAuthenticate</c */ \
	0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20, /* ode>.  In here,  */ \
	0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e, /* you can determin */ \
	0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65, /* e if the supplie */ \
	0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64, /* d..user name and */ \
	0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61, /*  password are va */ \
	0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74, /* lid for access t */ \
	0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20, /* o the requested  */ \
	0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d, /* page.  You can . */ \
	0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73, /* .add multiple us */ \
	0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74, /* ers and restrict */ \
	0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73, /*  different users */ \
	0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61, /*  to different pa */ \
	0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63, /* ges.</p>....<p c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e, /* lass="exercise"> */ \
	0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e, /* <b>Exercise:</b> */ \
	0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72, /*  Change the user */ \
	0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f, /*  name and passwo */ \
	0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* rd in..<code>HTT */ \
	0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63, /* PAuthenticate</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79, /* ode> to one of y */ \
	0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28, /* our choosing.  ( */ \
	0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20, /* The callback is  */ \
	0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f, /* ..located in <co */ \
	0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70, /* de>CustomHTTPApp */ \
	0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d, /* .c</code>.)</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65, /* ...<div class="e */ \
	0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65, /* xamplebox">..Whe */ \
	0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65, /* n you finish, re */ \
	0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20, /* fresh this page  */ \
	0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77, /* to test your new */ \
	0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70, /*  user name and p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e, /* assword ..combin */ \
	0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ation...</div>.. */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* ..</div>....<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* -..document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c, /* lementById('hell */ \
	0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20, /* o').innerHTML =  */ \
	0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f, /* "~hellomsg~";../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* ...~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01, /* nc~....3........ */ \
	0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f, /* ...........~rebo */ \
	0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ot~....-...~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e, /* ...<h1>Reboot In */ \
	0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31  /*  Progress...</h1 */
#define DATACHUNK00000f \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74, /* >....<p>Your set */ \
	0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65, /* tings were succe */ \
	0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61, /* ssfully saved, a */ \
	0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20, /* nd the board is  */ \
	0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a, /* now rebooting .. */ \
	0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73, /* to configure its */ \
	0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77, /* elf with the new */ \
	0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /*  settings.</p>.. */ \
	0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ..<h6></h6>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73, /*  language="javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66, /* cript">..<!--..f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75, /* unction rebootDu */ \
	0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d, /* mmy(x){}..setTim */ \
	0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d, /* eout("newAJAXCom */ \
	0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* mand('/protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f, /* eboot.cgi',reboo */ \
	0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c, /* tDummy,false);", */ \
	0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* 500);..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0x7e,0x01,0x00,0x00,0x02,0x00,0x00,0x00                                     /* .~.......        */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
