<?php
////////////////////////////////////////////////////////////////////////////////
error_reporting(E_ALL|E_STRICT);
define('RSYNC', 'rsync');
define('LIST_FROM', '/file list/');
define('LIST_UNTIL', '/^$/');

////////////////////////////////////////////////////////////////////////////////
$targets = get_targets();
// $delete = ( ! isset($_POST['delete']) OR $_POST['delete']);
$delete = (isset($_POST['delete']) && $_POST['delete']);
// $existing = ( ! isset($_POST['existing']) OR $_POST['existing']);
$existing = (isset($_POST['existing']) && $_POST['existing']);
$exclude_from = ( ! isset($_POST['exclude_from']) OR $_POST['exclude_from']);

if (isset($_POST['forward']) && isset($_POST['label']))
{
        $target = get_target($targets, $_POST['label']);
        $output = rsync($target, $delete, $existing, $exclude_from);
}
elseif (isset($_POST['reverse']) && isset($_POST['label']))
{
        $target = get_target($targets, $_POST['label']);
        $output = rsync($target, $delete, $existing, $exclude_from, TRUE);
}
elseif (isset($_POST['label']))
{
        $target = get_target($targets, $_POST['label']);
        $output = dry_run($target, $delete, $existing, $exclude_from);
}
else
{
        $target = $targets[0];
        $output = dry_run($target, $delete, $existing, $exclude_from);
}
$output->src = $target->src;
$output->dest = $target->dest;

require_once 'view.php';

////////////////////////////////////////////////////////////////////////////////
function get_target($targets, $label)
{
        foreach ($targets as $target)
        {
                if ($target->label == $label)
                {
                        return $target;
                }
        }
        die('No such target.');
}

////////////////////////////////////////////////////////////////////////////////
function rsync($target, $delete, $existing, $exclude_from, $reverse = FALSE)
{
	$output = (object) array();
        if ( ! $reverse)
        {
                $cmd = RSYNC." {$target->options}".($exclude_from ? ' --exclude-from=\'exclude_from/'.$target->label.'\'' : '').($delete ? ' --delete' : '').($existing? ' --existing' : '')." {$target->src} {$target->dest}";
                $output->forward_cmd = $cmd;
                $output->forward = shell_exec('PATH=$PATH:~/bin; '.$cmd.' 2>&1');
        }
        else
        {
                $cmd = RSYNC." {$target->options}".($exclude_from ? ' --exclude-from=\'exclude_from/'.$target->label.'\'' : '').($delete ? ' --delete' : '').($existing? ' --existing' : '')." {$target->dest} {$target->src}";
                $output->reverse_cmd = $cmd;
                $output->reverse = shell_exec('PATH=$PATH:~/bin; '.$cmd.' 2>&1');
        }
        return $output;
}

////////////////////////////////////////////////////////////////////////////////
function dry_run($target, $delete, $existing, $exclude_from)
{
	$output = (object) array();
        $cmd = RSYNC." {$target->options}".($exclude_from ? ' --exclude-from=\'exclude_from/'.$target->label.'\'' : '').($delete ? ' --delete' : '').($existing? ' --existing' : '')." --dry-run {$target->src} {$target->dest}";
        $output->forward_cmd = $cmd;
        $output->forward = shell_exec('PATH=$PATH:~/bin; '.$cmd.' 2>&1');
        $cmd = RSYNC." {$target->options}".($exclude_from ? ' --exclude-from=\'exclude_from/'.$target->label.'\'' : '').($delete ? ' --delete' : '').($existing? ' --existing' : '')." --dry-run {$target->dest} {$target->src}";
        $output->reverse_cmd = $cmd;
        $output->reverse = shell_exec('PATH=$PATH:~/bin; '.$cmd.' 2>&1');
        return $output;
}

////////////////////////////////////////////////////////////////////////////////
function get_targets()
{
        $lines = explode("\n", file_get_contents('targets.txt'));
        foreach ($lines as $key => $value)
        {
                if (preg_match('/^#/', $value) OR preg_match('/^\s*$/', $value))
                {
                        continue;
                }
                $target = (object) array();
                list($target->label, $target->options, $target->src, $target->dest) = explode(',', $value);
		$target->label = trim($target->label);
		$target->options = trim($target->options);
		$target->src = trim($target->src);
		$target->dest = trim($target->dest);
                if ( ! file_exists('exclude_from/'.$target->label))
                {
                        touch('exclude_from/'.$target->label);
                }
                $targets[] = $target;
        }
        return $targets;
}
?>
