<?php
$src = htmlspecialchars($_GET['src']);
$dest = htmlspecialchars($_GET['dest']);
$direction = htmlspecialchars($_GET['direction']);
$file = htmlspecialchars($_GET['file']);
if ($direction == 'forward')
{
	$tmp = $src;
	$src = $dest;
	$dest = $tmp;
}
$cmd = 'diff -ru '.$src.$file.' '.$dest.$file;
$cmd_undo = 'scp -p '.$src.$file.' '.$dest.$file;
$cmd_one = 'scp -p '.$dest.$file.' '.$src.$file;
// 元がリモートなら
if (preg_match('/:/', $src))
{
	list($src_host, $src_path) = explode(':', $src, 2);
	$cmd = 'ssh '.$src_host.' cat \''.$src_path.$file.'\' | diff -ru - '.$dest.$file;
}
// 先がリモートなら
if (preg_match('/:/', $dest))
{
	list($dest_host, $dest_path) = explode(':', $dest, 2);
	$cmd = 'ssh '.$dest_host.' cat \''.$dest_path.$file.'\' | diff -ru '.$src.$file.' -';
}
$output = '';
if (isset($_GET['undo']))
{
	$output .= htmlspecialchars(shell_exec($cmd_undo.' 2>&1'));
}
if (isset($_GET['one']))
{
	$output .= htmlspecialchars(shell_exec($cmd_one.' 2>&1'));
}
$output .= htmlspecialchars(shell_exec($cmd.' 2>&1'));
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8" />
<title>phpRsync: a web interface of rsync</title>
</head>
<body>
<?php echo $cmd; ?>
<hr />
<form>
<input type="hidden" name="src" value="<?php echo $_GET['src']; ?>" />
<input type="hidden" name="dest" value="<?php echo $_GET['dest']; ?>" />
<input type="hidden" name="direction" value="<?php echo $_GET['direction']; ?>" />
<input type="hidden" name="file" value="<?php echo $_GET['file']; ?>" />
<input type="submit" name="undo" value="元に戻す" />
<input type="submit" name="one" value="このファイルだけコピー" />
</form>
<hr />
<pre>
<?php echo $output; ?>
</pre>
<script>
document.body.onkeydown = function(e){
	if (e.keyCode != 27) return;
	self.close();
};
</script>
</body>
</html>
