<?php
	/**************************************************************************\
	* phpGroupWare API - Subcategories                                         *
	* This file written by Joseph Engo <jengo@phpgroupware.org>                *
	*                  and Bettina Gille [ceb@phpgroupware.org]                *
	* Subcategory manager                                                      *
	* Copyright (C) 2000, 2001 Joseph Engo, Bettina Gille                      *
	* Copyright (C) 2002, 2003 Bettina Gille                                   *
	* Copyright (C) 2003 probusiness AG (Lars Piepho)						   *
	* ------------------------------------------------------------------------ *
	* This library is part of the phpGroupWare API                             *
	* http://www.phpgroupware.org                                              * 
	* ------------------------------------------------------------------------ *
	* This library is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU Lesser General Public License as published by *
	* the Free Software Foundation; either version 2.1 of the License,         *
	* or any later version.                                                    *
	* This library is distributed in the hope that it will be useful, but      *
	* WITHOUT ANY WARRANTY; without even the implied warranty of               *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
	* See the GNU Lesser General Public License for more details.              *
	* You should have received a copy of the GNU Lesser General Public License *
	* along with this library; if not, write to the Free Software Foundation,  *
	* Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
	\**************************************************************************/
	// $Id: class.subcategories.inc.php,v 1.1.1.1 2004/04/06 23:35:07 kazuyan Exp $
	// $Source: /cvsroot/phpgwjp/tts/inc/class.subcategories.inc.php,v $

	require_once constant('PHPGW_INCLUDE_ROOT') . "/phpgwapi/inc/class.categories.inc.php";

	/*!
	@class subcategories
	@abstract class adds ability for applications to make use of subcategories
	@discussion examples can be found in notes app
	*/
	
	class subcategories extends categories
	{
		var $platform_id = 0;
		var $type_id = 0;
		/*!
		@function subcategories
		@abstract constructor for subcategories class
		@param $accountid account id
		@param $app_name app name defaults to current app
		*/
		function subcategories($accountid = '',$app_name = '')
		{
			parent::categories($accountid,$app_name);
			$this->platform_id = $this->getSubCatId('platform');
			$this->type_id = $this->getSubCatId('type');			
		}

		/*!
		@function filter
		@abstract ?
		@param $type string
		@result string either subs or mains
		*/
		function filter($type)
		{
			$s = parent::filter($type);
			switch ($type)
			{
				case 'appandplatform': $s = " OR (cat_appname='phpgw' AND cat_parent=" . $this->platform_id . ')'; break;
				case 'appandtype': $s = " OR (cat_appname='phpgw' AND cat_parent=" . $this->type_id . ')'; break;
				default:			return False;
			}			
			return $s;
		}
		
		function getSubCatId($subcat_name)
		{
			$sql = "SELECT cat_id FROM phpgw_categories WHERE cat_name='tts' AND cat_appname='phpgw'";			
			$this->db->query($sql,__LINE__,__FILE__);
			if(!$this->db->num_rows())
			{
				return 0;
			}
			$this->db->next_record();
			$tts_id = $this->db->f('cat_id');
			
			
			$sql = "SELECT cat_id FROM phpgw_categories WHERE cat_name='" . $this->db->db_addslashes($subcat_name) . "' "
							."AND cat_appname='phpgw' AND cat_parent=" . $tts_id;					
			$this->db->query($sql,__LINE__,__FILE__);
			if(!$this->db->num_rows())
			{
				return 0;
			}
			$this->db->next_record();			
			return $this->db->f('cat_id');
		}

		
		function getSubCatElementId($subcat_name,$subcatelement_name)
		{         
         $cat_id = $this->getSubCatId($subcat_name);
 	  	 $sql = "SELECT cat_id FROM phpgw_categories WHERE cat_parent=" . $cat_id . " AND cat_name='" . $subcatelement_name . "'";					
	 	 $this->db->query($sql,__LINE__,__FILE__);
		 if(!$this->db->num_rows())
		 {
		  return 0;
		 }
		 $this->db->next_record();		 
		 return $this->db->f('cat_id'); 
		}
		
	}
?>
