<?php
  /**************************************************************************\
  * phpGroupWare - Calendar's Sidebox-Menu for idots-template                *
  * http://www.phpgroupware.org                                              *
  * Written by Pim Snel <pim@lingewoud.nl>                                   *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: hook_sidebox_menu.inc.php,v 1.1.1.1.26.1 2007/09/14 02:37:43 kazuyan Exp $ */
{

 /*
	This hookfile is for generating an app-specific side menu used in the idots 
	template set.

	$menu_title speaks for itself
	$file is the array with link to app functions

	display_sidebox can be called as much as you like
 */

	$menu_title = $GLOBALS['phpgw_info']['apps'][$appname]['title'] . ' '. lang('Menu');
	$bo_jssh = createObject('javassh.bo_jssh');
	$servers = $bo_jssh->get_servers();
	if(!is_array($servers))
	{
		if(isset($GLOBALS['phpgw_info']['user']['apps']['admin']))
		{
			$file = array(
					array(
						'text'	=> 'no servers available - please add one',
						'url'	=> $GLOBALS['phpgw']->link('/index.php', 
							array('menuaction', 'javassh.ui_jssh.list_servers'))
					)
				);
		}
		else
		{
			$file = array('text' => 'javassh is not configured');
		}
		$servers = array();
	}
	foreach($servers as $server)
	{
		$file[] = array('text'  => $server['title'],
				'url' => "javascript:window.open('".$GLOBALS['phpgw']->link('/index.php', array('menuaction' => 'javassh.ui_jssh.connect',
											'server'	=> $server['server_id'],
											)
								)."','console','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,width=620,height=450');location.reload(false)"
			);
	}
	display_sidebox($appname,$menu_title,$file, False);

	if ($GLOBALS['phpgw_info']['user']['apps']['admin'])
	{
		$menu_title = lang('Administration');
		$file = Array(
				array('text'	=> 'Site Configuration',
					'url'	=> $GLOBALS['phpgw']->link('/index.php','menuaction=admin.uiconfig.index&appname=javassh')),
				array('text'	=> 'Manage Servers',
					'url'	=> $GLOBALS['phpgw']->link('/index.php','menuaction=javassh.ui_jssh.admin_list')),
				);
									
		display_sidebox($appname,$menu_title,$file);
	}
}
?>
