<?php
  /**************************************************************************\
  * phpGroupWare - Image Editor                                              *
  * http://www.phpgroupware.org                                              *
  * This application written by Miles Lott <milosch@phpgroupware.org>        *
  * --------------------------------------------                             *
  * some methods borrowed from OIC v1.0.6 - the Online Image Converter       *
  *   Copyright (C) 2001 Ray Lopez (http://www.TheDreaming.com)              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.uiimg.inc.php,v 1.1.1.1.36.1 2007/09/14 02:31:49 kazuyan Exp $ */

	/* img admin display class */
	class uiimg
	{
		var $bo;
		var $cat;
		var $template;
		var $nextmatchs;

		/* This setting cascades to all img classes */
		var $debug = False;

		var $start;
		var $limit;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;

		var $public_functions = array(
			'index' => True,
			'view'     => True,
			'add'      => True,
			'edit'     => True,
			'delete'   => True,
			'preferences' => True,
			'manipulate' => True,
			'thumbnails' => True
		);

		function uiimg()
		{
			$this->docroot = preg_replace("/\\".$GLOBALS['phpgw_info']['server']['webserver_url'].'$/', '', PHPGW_SERVER_ROOT, 1);
			$this->bo         = CreateObject('img.boimg',$this->debug);
			$this->cat        = CreateObject('phpgwapi.categories');
			$this->template   = $GLOBALS['phpgw']->template;
			$this->nextmatchs = CreateObject('phpgwapi.nextmatchs');

			$this->start    = $this->bo->start;
			$this->limit    = $this->bo->limit;
			$this->query    = $this->bo->query;
			$this->sort     = $this->bo->sort;
			$this->order    = $this->bo->order;
			$this->filter   = $this->bo->filter;
			$this->cat_id   = $this->bo->cat_id;
		}

		function save_sessiondata()
		{
			$data = array(
				'start'  => $this->start,
				'limit'  => $this->limit,
				'query'  => $this->query,
				'sort'   => $this->sort,
				'order'  => $this->order,
				'filter' => $this->filter,
				'cat_id' => $this->cat_id
			);
			$this->bo->save_sessiondata($data);
		}

		/* Main index img listing */
		function index()
		{
			$this->template->set_file(array( 'list' => 'list.tpl'));
			$this->template->set_block('list','header','header');
			$this->template->set_block('list','list_item','list_item');
			$this->template->set_block('list','footer','footer');

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->template->set_var('title',lang('img'));
			$this->template->set_var('name',lang('List'));
			$this->template->set_var('lang_title',$this->nextmatchs->show_sort_order(
				$this->sort,'img_title',$this->order,'/index.php',lang('img_title'),'&menuaction=img.uiimg.index'));

			$this->template->set_var('lang_name',$this->nextmatchs->show_sort_order(
				$this->sort,'img_name',$this->order,'/index.php',lang('img_name'),'&menuaction=img.uiimg.index'));

			$this->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
			$this->template->set_var('query',$this->query);
			$this->template->set_var('lang_select',lang('Select'));
			$this->template->set_var('lang_search',lang('Search'));
			$this->template->set_var('lang_submit',lang('Submit'));
			$this->template->set_var('lang_view',lang('View'));
			$this->template->set_var('lang_edit',lang('Edit'));
			$this->template->set_var('lang_delete',lang('Delete'));
			$this->template->set_var('cat_action',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));
			$this->template->set_var('lang_category',lang('Category'));
			$this->template->set_var('category_list',$this->cat->formated_list('select','all',$this->cat_id,True));
			$this->template->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));

			$list = $this->bo->index($data);
			$link_data = array
			(
				'menuaction' => 'img.uiimg.index'
			);
			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bo->total,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bo->total,$link_data);
			$this->template->set_var('left', $left);
			$this->template->set_var('right', $right);
			$this->template->set_var('lang_all', lang('all'));
			$this->template->pfp('out','header');
			while (list($key,$val) = @each($list))
			{
				$this->template->set_var('tr_color',$this->nextmatchs->alternate_row_color($tr_color));
				$this->template->set_var('img_name',$val['img_name']);
				$this->template->set_var('img_title',$val['img_title']);
				$this->template->set_var('view',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.view&img_id=' . $val['img_id']));
				$this->template->set_var('edit',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.edit&img_id=' . $val['img_id']));
				$this->template->set_var('delete',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.delete&img_id=' . $val['img_id']));
				$this->template->fp('rows','list_item',True);
			}

			$this->template->set_var('addurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.add'));
			$this->template->set_var('lang_add',lang('Add'));
			$this->template->set_var('thumbnail_link',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.thumbnails&cat_id='.$this->cat_id));
			$this->template->set_var('lang_thumbnail',lang('View Thumbnails'));
			$this->template->pfp('out','footer');

			$this->save_sessiondata();
		}

		function thumbnails()
		{
			$this->template->set_file(array( 'list' => 'thumbnails.tpl'));
			$this->template->set_block('list','header','header');
			$this->template->set_block('list','col','col');
			$this->template->set_block('list','row','row');
			$this->template->set_block('list','footer','footer');

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->template->set_var('title',lang('img'));
			$this->template->set_var('name',lang('List'));
			$this->template->set_var('lang_search',lang('Search'));
			$this->template->set_var('cat_action',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.thumbnails'));
			$this->template->set_var('lang_category',lang('Category'));
			$this->template->set_var('category_list',$this->cat->formated_list('select','all',$this->cat_id,True));

			$list = $this->bo->index($data);
			$link_data = array
			(
				'menuaction' => 'img.uiimg.thumbnails'
			);
			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bo->total,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bo->total,$link_data);
			$this->template->set_var('left', $left);
			$this->template->set_var('right', $right);
			$this->template->set_var('lang_all', lang('all'));
			$this->template->pfp('out','header');
			$i=0;
			$j=0;
			while (list($key,$val) = @each($list))
			{
				$i++;
				$j++;
				$this->template->set_var('tr_color',$this->nextmatchs->alternate_row_color($tr_color));
				$this->template->set_var('img_name',$j . ': ' . $val['img_name'] . '(' . $val['img_title'] . ')');
				$this->template->set_var('img_thumb',$val['img_thumb']);
				$this->template->set_var('view',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.view&thumb=True&img_id=' . $val['img_id']));
				$this->template->fp('cols','col',True);
				if($i>=5)
				{
					$i=0;
					$this->template->fp('rows','row',True);
					$this->template->set_var('cols','');
				}
			}
			$this->template->fp('rows','row',True);

			$this->template->set_var('addurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.add'));
			$this->template->set_var('lang_add',lang('Add'));
			$this->template->set_var('list_link',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index&cat_id='.$this->cat_id));
			$this->template->set_var('lang_list',lang('View List'));
			$this->template->pfp('out','footer');
		}

		/* Single img view */
		function view($id='')
		{
			if(!$id)
			{
				$id = $GLOBALS['HTTP_GET_VARS']['img_id'] ? $GLOBALS['HTTP_GET_VARS']['img_id'] : $GLOBALS['HTTP_POST_VARS']['img_id'];
			}

			if($GLOBALS['HTTP_GET_VARS']['thumb'])
			{
				$cancel_url = $GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.thumbnails');
			}
			else
			{
				$cancel_url = $GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index');
			}

			if($GLOBALS['HTTP_POST_VARS']['cancel'])
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('img.uiimg.index'));
			}
			elseif($GLOBALS['HTTP_POST_VARS']['edit'])
			{
				ExecMethod('img.uiimg.edit',$id);
			}
			else
			{
				$this->template->set_file(array( 'view' => 'view.tpl'));
				$this->template->set_block('view','header','header');
				$this->template->set_block('view','form','form');
				$this->template->set_block('view','footer','footer');

				$this->template->set_var('title',lang('img'));
				$this->template->set_var('name',lang('view'));
				$this->template->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.view'));
				$this->template->set_var('cancel_url',$cancel_url);
				$this->template->set_var('lang_edit',lang('Edit'));
				$this->template->set_var('lang_cancel',lang('Cancel'));
				$this->template->set_var('row_on', $GLOBALS['phpgw_info']['theme']['row_on']);
				$this->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();

				$img = $this->bo->read($id);

				while(list($key,$val) = @each($img[$id]))
				{
					//echo '<br />' . $key . ': ' . $val;
					$this->template->set_var($key,$val);
					$this->template->set_var('lang_' . $key, lang($key));
				}

				if($this->debug)
				{
					echo $this->docroot . SEP . $img[$id]['img_file'];
				}
				$imgSizeArray   = GetImageSize($this->docroot . SEP . $img[$id]['img_file']);
				$imgWidth       = $imgSizeArray[0];
				$imgHeight      = $imgSizeArray[1];
				if($this->debug)
				{
					echo '<br />uiiimg->view(): called getimagesize(' . $this->docroot . SEP . $img[$id]['img_file'] . ')';
					_debug_array($imgSizeArray);
				}

				$this->template->set_var('lang_img_cat',lang('Category'));
				$this->template->set_var('img_cat',$this->cat->id2name($img[$id]['img_cat']));
				$this->template->set_var('img_id',$id);
				$this->template->set_var('imglink',$img[$id]['img_file']);
				$this->template->set_var('imgwidth',$imgWidth);
				$this->template->set_var('imgheight',$imgHeight);
				$this->template->set_var('lang_img_owner',lang('Entered by'));
				$this->template->set_var('img_owner',@$GLOBALS['phpgw']->accounts->id2name($img[$id]['img_owner']));
				$this->template->pfp('out','header');
				$this->template->pfp('out','form');
				$this->template->pfp('out','footer');
			}
		}

		/* Add an img */
		function add()
		{
			$posted = $GLOBALS['HTTP_POST_VARS']['entry'];
			$img_file = $GLOBALS['HTTP_POST_FILES']['img_file'];

			if($GLOBALS['HTTP_POST_VARS']['cancel'])
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('img.uiimg.index'));
			}
			$this->template->set_file(array( 'add' => 'edit.tpl'));
			$this->template->set_block('add','header','header');
			$this->template->set_block('add','form','form');
			$this->template->set_block('add','add_footer','add_footer');

			$this->template->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.add'));
			$this->template->set_var('title',lang('img'));
			$this->template->set_var('name',lang('add'));
			$this->template->set_var('lang_img_name',lang('Name') . ':');
			$this->template->set_var('lang_img_title',lang('Title') . ':');
			$this->template->set_var('lang_img_des',lang('Description') . ':');
			$this->template->set_var('lang_img_file',lang('img_file') . ':');
			$this->template->set_var('lang_img_thumb','');
			$this->template->set_var('imglink','');
			$this->template->set_var('lang_add',lang('Add'));
			$this->template->set_var('cancel_url',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));
			$this->template->set_var('lang_reset',lang('Reset'));
			$this->template->set_var('category_list',$this->cat->formated_list('select','all',$this->cat_id,True));

			if(!$GLOBALS['HTTP_POST_VARS']['submit'])
			{
				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();
				$this->template->pfp('out','header');
				$this->template->pfp('out','form');
				$this->template->pfp('out','add_footer');
			}
			else
			{
				if($img_file['tmp_name'] && $img_file['name'])
				{
					if($img_file['tmp_name'] == 'none' || empty($img_file['tmp_name']))
					{
						break;
					}
					if($img_file['name'] == 'none' || empty($img_file['name']))
					{
						break;
					}
					$imgSizeArray   = GetImageSize($img_file['tmp_name']);
					$imgWidth       = $imgSizeArray[0];
					$imgHeight      = $imgSizeArray[1];
					$imgType        = $imgSizeArray[2];
					if($this->debug)
					{
						echo '<br />uiiimg->add(): called getimagesize(' . $img_file['tmp_name'] . ')';
						_debug_array($imgSizeArray);
					}
					switch ($imgType)
					{
						case '1':
							// GIF
							if (imagetypes() & IMG_GIF)
							{
								$im = imagecreatefromgif($img_file['tmp_name']);
								$image  = $this->bo->img->image2gif($im,$img_file['name']);
							}
							else
							{
								copy($img_file['tmp_name'],$img_file['tmp_name'] . '.gif');
								@unlink($img_file['tmp_name']);
								$newtmp = $this->bo->img->_convert($img_file['tmp_name'] . '.gif',$img_file['tmp_name'] . '.png','png');
								if($this->debug)
								{
									echo '<br />uiiimg->add(): called img->_convert('
										. $img_file['tmp_name'] . '.gif,'
										. $img_file['tmp_name'] . '.png,png) to create: '
										. $newtmp;
								}
								unset($newtmp);
								$img_file['name'] = ereg_replace("\.gif",'.png',$img_file['name']);
								@unlink($img_file['tmp_name'] . '.gif');
								$im = imagecreatefrompng($img_file['tmp_name'] . '.png');
								@unlink($img_file['tmp_name'] . '.png');
								$image = $this->bo->img->image2png($im,$img_file['name']);
							}
							break;
						case '2':
							//JPG
							$im = imagecreatefromjpeg($img_file['tmp_name']);
							$image = $this->bo->img->image2jpg($im,$img_file['name']);
							break;
						case '3':
							//PNG
							$im = imagecreatefrompng($img_file['tmp_name']);
							$image = $this->bo->img->image2png($im,$img_file['name']);
							break;
						case '4':
						default:
						echo $img_file['tmp_name'];
							$im = @ImageCreateFromWBMP($img_file['tmp_name']);
							$image = $this->bo->img->image2bmp($im,$img_file['name']);
					}
					@unlink($img_file['tmp_name']);
					//$image = $this->bo->img->image2png($im,$img_file['name']);
					$thumb = $this->bo->img->thumbnail($im,$imgWidth,$imgHeight,100);
				}

				$entry = array(
					'img_name'   => $posted['img_name'],
					'img_title'  => $posted['img_title'],
					'img_cat'    => $GLOBALS['HTTP_POST_VARS']['fcat_id'],
					'img_des'    => $posted['img_des'],
					'img_images' => $posted['img_images'],
					'img_copy'   => $posted['img_copy'],
					'img_owner'  => $GLOBALS['phpgw_info']['user']['account_id']
				);
				if($image)
				{
					$entry['img_file'] = $image;
				}
				if($thumb)
				{
					$entry['img_thumb'] = $thumb;
				}
				$id = $this->bo->add($entry);
				ExecMethod('img.uiimg.view',$id);
			}
		}

		/* Edit an existing img */
		function edit($id='')
		{
			if(!$id)
			{
				$id = $GLOBALS['HTTP_GET_VARS']['img_id'] ? $GLOBALS['HTTP_GET_VARS']['img_id'] : $GLOBALS['HTTP_POST_VARS']['entry']['img_id'];
			}

			if($GLOBALS['HTTP_POST_VARS']['cancel'])
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('index.php','menuaction=img.uiimg.index'));
			}

			if($GLOBALS['HTTP_POST_VARS']['submit'])
			{
				$posted = $GLOBALS['HTTP_POST_VARS']['entry'];
				$posted['img_cat'] = $GLOBALS['HTTP_POST_VARS']['fcat_id'];
				$img_file = $GLOBALS['HTTP_POST_FILES']['img_file'];

				if($img_file['tmp_name'] && $img_file['name'])
				{
					if($img_file['tmp_name'] == 'none' || empty($img_file['tmp_name']))
					{
						break;
					}
					if($img_file['name'] == 'none' || empty($img_file['name']))
					{
						break;
					}
					$imgSizeArray   = GetImageSize($img_file['tmp_name']);
					$imgWidth       = $imgSizeArray[0];
					$imgHeight      = $imgSizeArray[1];
					$imgType        = $imgSizeArray[2];
					if($this->debug)
					{
						echo '<br />uiiimg->edit(): called getimagesize(' . $img_file['tmp_name'] . ')';
						_debug_array($imgSizeArray);
					}
					switch ($imgType)
					{
						case '1':
							// GIF
							if (imagetypes() & IMG_GIF)
							{
								$im = imagecreatefromgif($img_file['tmp_name']);
								$posted['img_file']  = $this->bo->img->image2gif($im,$img_file['name']);
							}
							else
							{
								copy($img_file['tmp_name'],$img_file['tmp_name'] . '.gif');
								@unlink($img_file['tmp_name']);
								$newtmp = $this->bo->img->_convert($img_file['tmp_name'] . '.gif',$img_file['tmp_name'] . '.png','png');
								if($this->debug)
								{
									echo '<br />uiiimg->edit(): called img->_convert('
										. $img_file['tmp_name'] . '.gif,'
										. $img_file['tmp_name'] . '.png,png) to create: '
										. $newtmp;
								}
								unset($newtmp);
								$img_file['name'] = ereg_replace("\.gif",'.png',$img_file['name']);
								@unlink($img_file['tmp_name'] . '.gif');
								$im = imagecreatefrompng($img_file['tmp_name'] . '.png');
								@unlink($img_file['tmp_name'] . '.png');
							}
							break;
						case '2':
							//JPG
							$im = imagecreatefromjpeg($img_file['tmp_name']);
							$posted['img_file']  = $this->bo->img->image2jpg($im,$img_file['name']);
							break;
						case '3':
							//PNG
							$im = imagecreatefrompng($img_file['tmp_name']);
							$posted['img_file']  = $this->bo->img->image2png($im,$img_file['name']);
							break;
						case '4':
						default:
							$im = @ImageCreateFromWBMP($img_file['tmp_name']);
					}
					@unlink($img_file['tmp_name']);
					$posted['img_thumb'] = $this->bo->img->thumbnail($im,$imgWidth,$imgHeight,100);
				}

				$this->bo->edit($posted);
			}

			$this->template->set_file(array( 'edit' => 'edit.tpl'));
			$this->template->set_block('edit','header','header');
			$this->template->set_block('edit','form','form');
			$this->template->set_block('edit','edit_footer','edit_footer');

			$this->template->set_var('title',lang('img'));
			$this->template->set_var('name',lang('edit'));
			$this->template->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.edit'));
			$this->template->set_var('cancel_url',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));
			$this->template->set_var('lang_load_new',lang('Load New'));
			$this->template->set_var('lang_edit',lang('Edit'));
			$this->template->set_var('lang_cancel',lang('Cancel'));
			$this->template->set_var('row_on', $GLOBALS['phpgw_info']['theme']['row_on']);
			$this->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$img = $this->bo->read($id);
			$this->template->set_var('category_list',$this->cat->formated_list('select','all',$img[$id]['img_cat'],True));
			$this->template->pfp('out','header');

			while(list($key,$val) = @each($img[$id]))
			{
				$this->template->set_var($key,$val);
				$this->template->set_var('lang_' . $key, lang($key) . ':');
			}

			if($this->debug)
			{
				echo $this->docroot . SEP . $img[$id]['img_file'];
			}
			$imgSizeArray = GetImageSize($this->docroot . SEP . $img[$id]['img_file']);
			$imgWidth     = $imgSizeArray[0];
			$imgHeight    = $imgSizeArray[1];
			$imgType      = $imgSizeArray[2];
			if($this->debug)
			{
				echo '<br />uiiimg->edit(): called getimagesize(' . $this->docroot . SEP . $img[$id]['img_file'] . ')';
				_debug_array($imgSizeArray);
			}

			if($imgHeight)
			{
				$detailstr = '(' . $imgWidth . ' X ' . $imgHeight . ' ' . $this->bo->img->convertArray[$imgType] . ')';
			}
			$this->template->set_var('img_link','<a href="javascript:openwindow(\''
				. $img[$id]['img_file'] . "','" . $imgWidth . "','" . $imgHeight . '\')"><img src="' . $img[$id]['img_thumb']
				. '" border="1" align="middle" alt="' . $img[$id]['img_file'] . $detailstr . '">&nbsp;</a>'
			);
			$this->template->set_var('detailstr',$detailstr);
			$this->template->set_var('image_id',$id);
			$this->template->set_var('editurl', $GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.manipulate'));
			$this->template->set_var('lang_edit_image', lang('Edit Image'));
			$this->template->set_var('picture',$img[$id]['img_file']);
			$this->template->pfp('out','form');

			$this->template->pfp('out','edit_footer');
		}

		/* Delete an existing img */
		function delete()
		{
			$img_id = $GLOBALS['HTTP_GET_VARS']['img_id'] ? $GLOBALS['HTTP_GET_VARS']['img_id'] : $GLOBALS['HTTP_POST_VARS']['img_id'];
			$confirm = $GLOBALS['HTTP_GET_VARS']['confirm'];

			if (!$img_id)
			{
				Header('Location: ' . $GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));
			}

			if ($confirm != 'true')
			{
				$this->template->set_file(array( 'delete' => 'delete.tpl'));
				$this->template->set_block('delete','header','header');
				$this->template->set_block('delete','form','form');
				$this->template->set_block('delete','footer','footer');

				$GLOBALS['phpgw']->common->phpgw_header();
				echo parse_navbar();

				$this->template->set_var('lang_sure',lang('Are you sure you want to delete this entry ?'));
				$this->template->set_var('nolink',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.index'));
				$this->template->set_var('lang_no',lang('NO'));
				$this->template->set_var('yeslink',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.delete&img_id=' . $img_id . '&confirm=true'));
				$this->template->set_var('lang_yes',lang('YES'));
				$this->template->pparse('out','delete');
			}
			else
			{
				$this->bo->delete($img_id);
				@Header('Location: ' . $GLOBALS['phpgw']->link('/img/index.php','menuaction=img.uiimg.index'));
			}
		}

		function manipulate()
		{
			$img_id  = $GLOBALS['HTTP_POST_VARS']['img_id'];
			$save    = $GLOBALS['HTTP_POST_VARS']['save'];
//			$action  = $GLOBALS['HTTP_POST_VARS']['action']
			$convert = $GLOBALS['HTTP_POST_VARS']['convert'];
			$rotate  = $GLOBALS['HTTP_POST_VARS']['rotate'];
			$resize  = $GLOBALS['HTTP_POST_VARS']['resize'];
			$dstW    = $GLOBALS['HTTP_POST_VARS']['dstW'];
			$dstH    = $GLOBALS['HTTP_POST_VARS']['dstH'];
			$angle   = $GLOBALS['HTTP_POST_VARS']['angle'];
			$thumbnail = $GLOBALS['HTTP_POST_VARS']['thumbnail'];

			$imgWidth = $imgHeight = $imgType = '';

			$oldfile = $GLOBALS['HTTP_POST_VARS']['oldfile'] ? $GLOBALS['HTTP_POST_VARS']['oldfile'] : $GLOBALS['HTTP_POST_VARS']['picture'];
			if(!ereg("^$this->docroot",$oldfile))
			{
				$oldfile = $this->docroot . $oldfile;
			}

			$picturefile = $GLOBALS['HTTP_POST_VARS']['picture'] ? $GLOBALS['HTTP_POST_VARS']['picture'] : $GLOBALS['HTTP_POST_FILES']['picturefile'];
			if(!ereg("^$this->docroot",$picturefile))
			{
				$picturefile = $this->docroot . $picturefile;
			}

			if($this->debug)
			{
				echo '<br />uiiimg->manipulate(): $picturefile=' . $picturefile;
			}

			if(stat($picturefile))
			{
				$picfile = $picturefile;
			}
			else
			{
				$picfile = $picturefile['tmp_name'];
			}
			if($this->debug)
			{
				echo '<br />uiiimg->manipulate(): $picfile=' . $picfile;
			}

			$conTo  = $GLOBALS['HTTP_POST_VARS']['conTo'];

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			if($save)
			{
				$message = lang('Saved') . ' ' . $picfile . ' ' . lang('as') . ' ' . $oldfile;
				$picfile = $this->bo->img->smartcopy($picfile,$oldfile);
				$oldfile = $picfile;
				$entry = array(
					'img_id'    => $img_id,
					'img_file'  => $picfile,
					'img_thumb' => $thumbnail
				);
				$this->bo->edit($entry);
			}

			if(($convert || $rotate || $resize) || $picfile)
			{
				$imgSizeArray   = GetImageSize($picfile);
				$imgWidth       = $imgSizeArray[0];
				$imgHeight      = $imgSizeArray[1];
				$imgType        = $imgSizeArray[2];
				if($this->debug)
				{
					echo '<br />uiiimg->manipulate(): called getimagesize(' . $picfile . ')';
					_debug_array($imgSizeArray);
				}
				switch ($imgType)
				{
					case '1':
						// GIF
						if (imagetypes() & IMG_GIF)
						{
							$im = imagecreatefromgif($picfile);
						}
						else
						{
							$newtmp = $this->bo->img->convert($picfile,'png');
							if($this->debug)
							{
								echo '<br />uiiimg->manipulate($convert): called img->convert('
									. $picfile  . ',png) to create: '
									. $newtmp;
							}
							$im = imagecreatefrompng($newtmp);
							$picfile = $newtmp;
							$imgType = 3;
						}
						break;
					case '2':
						//JPG
						$im = imagecreatefromjpeg($picfile);
						break;
					case '3':
						//PNG
						$im = imagecreatefrompng($picfile);
						break;
					case '4':
					default:
						$im = @ImageCreateFromWBMP($picfile);
						if(!$im)
						{
							$imgError = $errorCode[0];
						}
				}

				if($imgError)
				{
					echo '<font color="red">' . $imgError . '</font><br />';
				}
				elseif($convert)
				{
					if($conTo == 1)
					{
						//GIF
						$NewImage = $this->docroot . $this->bo->img->image2gif($im);
					}
					elseif($conTo == 2)
					{
						//JPG
						$NewImage = $this->docroot . $this->bo->img->image2jpg($im);
					}
					elseif($conTo == 3)
					{
						//PNG
						$NewImage = $this->docroot . $this->bo->img->image2png($im);
					}
					elseif($conTo == 4)
					{
						//BMP
						$NewImage = $this->docroot . $this->bo->img->image2bmp($im);
					}
					if($this->debug)
					{
						echo '<br />uiiimg->manipulate($convert): created: ' . $NewImage;
					}
					$message = lang('Converted') . ' ' . $picfile . ' ' . lang('to') . ' ' . $NewImage;

					$picfile = $NewImage;
				}
				elseif($resize && $dstW && $dstH)
				{
					$_ext = strtolower($this->bo->img->convertArray[$imgType]);
					$picfile = $this->docroot . $this->bo->img->resize($im,$imgWidth,$imgHeight,$dstW,$dstH,$_ext);
					if($this->debug)
					{
						echo '<br />uiiimg->manipulate($resize) called img->_resize($im,"'
							. $imgWidth . '","' . $imgHeight . '","'
							. $dstW . '","' . $dstH . '","' . $_ext . '" to create: '
							. $picfile;
					}
					$newfile = $picfile . '.' . $_ext;
					copy($picfile,$newfile);
					unlink($picfile);
					$message = lang('Resized') . ' ' . $picfile . ' ' . lang('to') . ' ' . $newfile;
					$picfile = $newfile;
					if($this->debug)
					{
						echo '<br />uiiimg->manipulate($resize) renamed: '
							. $picfile . ' to ' . $newfile;
					}
				}
				elseif($rotate && $angle)
				{
					$message = lang('Rotated') . ' ' . $picfile . ' ' . lang('to') . ' ';
					$picfile = $this->docroot . $this->bo->img->rotate($im,$this->bo->img->angles[$angle]);
					if($this->debug)
					{
						echo '<br />uiiimg->manipulate($rotate): called img->rotate($im,"'
							. $this->bo->img->angles[$angle] . '") to create: '
							. $picfile;
					}
					$message .= $picfile;
				}
				else
				{
				}

				$imgSizeArray   = GetImageSize($picfile);
				$imgWidth       = $imgSizeArray[0];
				$imgHeight      = $imgSizeArray[1];
				$imgType        = $imgSizeArray[2];
				switch ($imgType)
				{
					case '1':
						// GIF
						if (imagetypes() & IMG_GIF)
						{
							$im = imagecreatefromgif($picfile);
						}
						else
						{
							$newtmp = $this->bo->img->convert($picfile,'png');
							if($this->debug)
							{
								echo '<br />uiiimg->manipulate(): called img->convert('
									. $picfile  . ',png) to create: '
									. $newtmp;
							}
							$im = imagecreatefrompng($newtmp);
//							$picfile = $newtmp;
							$imgType = 3;
						}
						break;
					case '2':
						//JPG
						$im = imagecreatefromjpeg($picfile);
						break;
					case '3':
						//PNG
						$im = imagecreatefrompng($picfile);
						break;
					case '4':
					default:
						$im = @ImageCreateFromWBMP($picfile);
						if(!$im)
						{
							$imgError = $errorCode[0];
						}
				}
				if($this->debug)
				{
					_debug_array($imgSizeArray);
				}
				$ext = strtolower($this->bo->img->convertArray[$imgType]);
				if($this->debug)
				{
					echo '<br />uiiimg->manipulate(): calling img->thumbnail($im,'
						. $imgWidth . '","' . $imgHeight . '","100","' . $ext . '")';
				}
				$thumb = $this->bo->img->thumbnail($im,$imgWidth,$imgHeight,100,$ext);
				//echo '<a href="' . $GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.manipulate') . '">' . lang('Go Back') . '</a><br /><br />';
			}
			else
			{
				$thumb = PHPGW_IMAGES . '/thumb.jpg';
			}

			if($imgHeight)
			{
				$detailstr = '(' . $imgWidth . ' X ' . $imgHeight . ' ' . $this->bo->img->convertArray[$imgType] . ')';
			}

			/* TODO */
			unset($angle);
			unset($conTo);
			unset($dstW);
			unset($dstH);

			$this->template->set_file(array('manip' => 'manip.tpl'));

			$this->template->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.manipulate'));
			$this->template->set_var('cancelurl',$GLOBALS['phpgw']->link('/index.php','menuaction=img.uiimg.edit&img_id=' . $img_id));
			$this->template->set_var('message',$message);
			$this->template->set_var('lang_original',lang('Original'));
			$this->template->set_var('lang_current',lang('Current'));
			$this->template->set_var('lang_load_new',lang('Load New'));
			$this->template->set_var('lang_convert',lang('Convert'));
			$this->template->set_var('lang_convert_to',lang('Convert to'));
			$this->template->set_var('lang_rotate',lang('Rotate'));
			$this->template->set_var('lang_resize',lang('Resize'));
			$this->template->set_var('lang_target_width',lang('Target Width'));
			$this->template->set_var('lang_target_height',lang('Target Height'));
			$this->template->set_var('lang_save',lang('Save'));
			$this->template->set_var('lang_cancel',lang('Cancel'));
			$this->template->set_var('lang_thumb',lang('Thumbnail'));

			$this->template->set_var('imgwidth',$imgWidth);
			$this->template->set_var('imgheight',$imgHeight);
			$this->template->set_var('dstW',$dstW);
			$this->template->set_var('dstH',$dstH);
			$this->template->set_var('img_id',$img_id);
			$this->template->set_var('img_file',$picfile);
			$this->template->set_var('oldfile',$oldfile);
			$this->template->set_var('picfile',$picfile);
			$this->template->set_var('picurl',ereg_replace($this->docroot,'',$picfile));
			$this->template->set_var('detailstr',$detailstr);
			$this->template->set_var('thumb',$thumb);

			while(list($key,$arrType) = each($this->bo->img->convertArray))
			{
				$convert_rows .= '<option value="' . $key . '"';
				if($conTo == $key)
				{
					$convert_rows .= ' selected';
				}
				$convert_rows .= '>'. lang($arrType) . '</option>' . "\n";
			}
			$this->template->set_var('convert_rows',$convert_rows);

			while(list($key,$val) = each($this->bo->img->angles))
			{
				$rotate_rows .= '<option value="' . $key . '"';
				if($angle == $key)
				{
					$rotate_rows .= ' selected';
				}
				$rotate_rows .= '>'. $val . '</option>' . "\n";
			}
			$this->template->set_var('rotate_rows',$rotate_rows);

			$this->template->pfp('out','manip');
		}

		function jsWindoPopUp($image, $width, $height)
		{
			echo '<script language="javascript">';
			echo '    window.open("' . $image . '" ,"phpGW_Img","width=' . $width
				. ',height=' . $height
				. ',menubar=0,resizable=0,scrollbars=0,status=0,titlebar=0,toolbar=0,hotkeys=0,locationbar=0");';
			echo '</script>';
		}
	}
?>
