<?php
  /**************************************************************************\
  * phpGroupWare - Filemanager's Sidebox-Menu for idots-template             *
  * http://www.phpgroupware.org                                              *
  * Written by Kazuya Nouchi <info@phpgroupware.jp>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: hook_sidebox_menu.inc.php,v 1.1.20.1 2007/09/14 02:22:13 kazuyan Exp $ */
{

 /*
	This hookfile is for generating an app-specific side menu used in the idots
	template set.

	$menu_title speaks for itself
	$file is the array with link to app functions

	display_sidebox can be called as much as you like
 */

	$menu_title = $GLOBALS['phpgw_info']['apps'][$appname]['title'] . ' '. lang('Menu');
	$file = Array(
		array('text'	=> 'Preferences',
			'url'		=> $GLOBALS['phpgw']->link('/filemanager/preferences.php')),
	);
	if ($GLOBALS['phpgw_info']['user']['apps']['admin'])
	{
		$file += array(
			array('text'	=> '_NewLine_'),
			array('text'	=> 'edit quota',
				'url'		=> $GLOBALS['phpgw']->link('/filemanager/admin.php'))
		);	
	}
	display_sidebox($appname,$menu_title,$file);

	if ($GLOBALS['phpgw_info']['user']['apps']['admin'])
	{
		$file = array();
		$menu_title = lang('Shared Folders') . ' '. lang('Menu');
		$groups = $GLOBALS['phpgw']->accounts->get_list('groups');
		if (is_array($groups))
		{
			foreach($groups as $key => $val)
			{
				$acl = CreateObject('phpgwapi.acl', $val['account_id']);
				if ($acl->check('run', 1, $appname))
				{
					$file[] = array(
							'text'	=> $val['account_firstname'],
							'url'		=> $GLOBALS['phpgw']->link('/index.php','menuaction=preferences.uiaclprefs.index&acl_app='.$appname.'&owner='.$val['account_id'])
					);
				}
			}
			display_sidebox($appname,$menu_title,$file,False);
		}
	}	
}
?>
