<?php
  /**************************************************************************\
  * phpGroupWare - addressbook                                               *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@mail.com>                                  *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: functions.inc.php,v 1.1.1.3.18.1 2007/09/14 01:55:21 kazuyan Exp $ */

	function formatted_list($name,$list,$id='',$default=False,$java=False)
	{
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}

		$select  = "\n" .'<select name="' . $name . '"' . $jselect . ">\n";
		if($default)
		{
			$select .= '<option value="">' . lang('Please Select') . '</option>'."\n";
		}
		while (list($key,$val) = each($list))
		{
			$select .= '<option value="' . $key . '"';
			if ($key == $id && $id != '')
			{
				$select .= ' selected';
			}
			$select .= '>' . $val . '</option>'."\n";
		}

		$select .= '</select>'."\n";
		$select .= '<noscript><input type="submit" name="' . $name . '_select" value="True"></noscript>' . "\n";

		return $select;
	}

	/* Return a select form element with the categories option dialog in it */
	function cat_option($cat_id='',$notall=False,$java=True,$multiple=False)
	{
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}
		/* Setup all and none first */
		$cats_link  = "\n" .'<select name="cat_id'.($multiple?'[]':'').'"' .$jselect . ($multiple ? 'multiple size="3"' : '') . ">\n";
		if (!$notall)
		{
			$cats_link .= '<option value=""';
			if ($cat_id=="all")
			{
				$cats_link .= ' selected';
			}
			$cats_link .= '>'.lang("all").'</option>'."\n";
		}

		/* Get global and app-specific category listings */
		$cats_link .= $GLOBALS['phpgw']->categories->formated_list('select','all',$cat_id,True);
		$cats_link .= '</select>'."\n";
		return $cats_link;
	}

	/* this cleans up the fieldnames for preferences */
	function display_name($column)
	{
		$abc = array(
			'full_name'           => 'full name',
			'sound'               => 'Sound',
			'organizations'       => 'company name',
			'department'          => 'department',
			'title'               => 'title',
			'prefix'              => 'prefix',
			'first_name'          => 'first name',
			'middle_name'         => 'middle name',
			'last_name'           => 'last name',
			'sufix'            	  => 'suffix',
			'label'               => 'label',
			'work_add1'      	  => 'work address 1',
			'work_add2'			  => 'work address 2',
			'work_add3'			  => 'work address 3',
			'work_city'    		  => 'business city',
			'work_state'      	  => 'business state',
			'work_postal_code'    => 'business zip code',
			'work_country' 		  => 'business country',
			//'work_preferred'	  => 'work preferred',
			'home_add1'      	  => 'home address 1',
			'home_add2'			  => 'home address 2',
			'home_add3'			  => 'home address 3',
			'home_city'    		  => 'home city',
			'home_state'      	  => 'home state',
			'home_postal_code'	  => 'home zip code',
			'home_country' 		  => 'home country',
			'home_preferred'	  => 'home preferred',
			'work phone'          => 'work phone',
			'home phone'          => 'home phone',
			'voice phone'         => 'voice phone',
			'msg phone'           => 'message phone',
			'home fax'            => 'home fax',
			'work fax'            => 'work fax',
			'pager'           	  => 'pager',
			'mobile (cell) phone' => 'mobile phone',
			'bbs'             	  => 'bbs',
			'modem'           	  => 'modem',
			'isdn'            	  => 'isdn',
			'car phone'           => 'car phone',
			'video'           	  => 'video',
			'work email'          => 'work email',
			'birthday'            => 'birthday',
			'website'             => 'website',
			'pubkey'              => 'public key',
			'contact_id'		  => 'contact id',
			'initials'			  => 'initials',
			'active'			  => 'active',
			'categories'		  => 'categories',
			'msn'				  => 'msn',
			'aim'				  => 'aim',
			'yahoo'				  => 'yahoo',
			'icq'				  => 'icq',
			'jabber'			  => 'jabber'	
		);
	
		if ($abc[$column])
		{
			return lang($abc[$column]);
		}
		else
		{
			return $abc[$column];
		}
	}

	function read_custom_fields()
	{
		$i = 0; $j = 0;
		$fields = array();
		@reset($GLOBALS['phpgw_info']['user']['preferences']['addressbook']);
		while (list($col,$descr) = @each($GLOBALS['phpgw_info']['user']['preferences']['addressbook']))
		{
			if ( substr($col,0,6) == 'extra_' )
			{
				$fields[$j]['name'] = ereg_replace('extra_','',$col);
				$fields[$j]['name'] = ereg_replace(' ','_',$fields[$j]['name']);
				$fields[$j]['id'] = $i;

				if ($query && ($fields[$j]['name'] != $query))
				{
					unset($fields[$j]['name']);
					unset($fields[$j]['id']);
				}
				else
				{
					/* echo "<br />".$j.": '".$fields[$j]['name']."'"; */
					$j++;
				}
			}
			$i++;
		}
		@reset($fields);
		return $fields;
	}

	function save_custom_field($old='',$new='')
	{
		$GLOBALS['phpgw']->preferences->read_repository($GLOBALS['phpgw_info']['user']['account_id']);
		if ($old)
		{
			$GLOBALS['phpgw']->preferences->delete("addressbook","extra_".$old);
		}
		if($new)
		{
			$GLOBALS['phpgw']->preferences->add("addressbook","extra_".$new);
		}
		$GLOBALS['phpgw']->preferences->save_repository(1);
	}
?>
