<?php 

class module_sendmail extends Module
{
	function module_sendmail()
	{
		$this->arguments = array();
		$this->properties = array();
		$this->title = lang('Send email');
		$this->description = lang('This module offers the function to transmit mail.');
		$this->arguments = array(
			'envelope_sender_address'	=> array(
				'type'	=> 'textfield',
				'params'	=> array(
					'size'	=> '40'
				), 
				'label' => lang('Please specify the Envelope Sender address.')),
			'to_address' => array(
				'type' => 'textfield',
				'params'	=> array(
					'size'	=> '40'
				), 
				'label' => lang('Please specify the To email address.')
			),
		);
		$this->post = array(
			'from_name'	=> array(
				'type'		=> 'textfield',
				'params'	=> array(
					'size'	=> '40',
					'onmouseover'	=> "this.style.background='#f7f7f7'",
					'onmouseout'	=> "this.style.background='#ffffff'",
					'style'			=> "font-size:x-small;border: 1px solid #006699;"
				)
			),
			'from_address'	=> array(
				'type'		=> 'textfield',
				'params'	=> array(
					'size'	=> '40',
					'onmouseover'	=> "this.style.background='#f7f7f7'",
					'onmouseout'	=> "this.style.background='#ffffff'",
					'style'			=> "font-size:x-small;ime-mode:disabled;border: 1px solid #006699;"
				)
			),
			'subject'	=> array(
				'type'		=> 'textfield',
				'params'	=> array(
					'size'	=> '40',
					'style'			=> 'font-size:x-small;border: 1px solid #006699;',
					'onmouseover'	=> "this.style.background='#f7f7f7'",
					'onmouseout'	=> "this.style.background='#ffffff'"
				)
			),
			'body'	=> array(
				'type'		=> 'textarea',
				'params'	=> array(
					'cols'	=> '40',
					'rows'	=> '8',
					'wrap'	=> 'soft',
					'style'			=> 'font-size:x-small;border: 1px solid #006699;',
					'onmouseover'	=> "this.style.background='#f7f7f7'",
					'onmouseout'	=> "this.style.background='#ffffff'"
				)
			),
			'send'		=> array(
				'type' => 'submit',
				'params'	=> array(
					'style'		=> 'font-size:x-small',
					'onclick'	=> 'javascript:return (onclick_submit());'
				),
				'value' => lang('Send')
			),
		);
		if (is_object($GLOBALS['phpgw']->validator))
			$this->validator = &$GLOBALS['phpgw']->validator;
		else 
			$this->validator = CreateObject('phpgwapi.validator');
	}

	function get_content(&$arguments,$properties)
	{
		$lang_your_name = lang('Your name');
		$lang_your_mail = lang('Your email');
		$lang_subject = lang('Subject');
		$lang_body = lang('Body');
		$lang_clear = lang('Clear');
		$lang_sending_mail = lang('Sending this mail now...');
		foreach ($this->post as $key => $val)
		{
			$$key = $this->build_post_element($key);
		}
		$message = $arguments['message'];
$content = <<< EOF
<SCRIPT LANGUAGE="JavaScript" TYPE="text/javascript">
	var send_flg=false;
	function onclick_submit()
	{
		if (!send_flg)
		{
			document.getElementById("SentMail").innerHTML = "<blink>$lang_sending_mail</blink>";
			send_flg = true;
			return true;
		}
		return false;
	}
</SCRIPT>
	<form name="sendmail" method="post">
	<TABLE cellspacing="0" cellpadding="2" width="60%" align="center">
	  <TBODY>
	  	<TR>
	  	  <TD colspan="3" align="center"><FONT size="3"><b><span ID="SentMail">$message</span></b></FONT></TD>
	  	</TR>
	    <TR>
    	  <TD nowrap valign="middle" align="right"><FONT face="Times New Roman" size="2">$lang_your_name</FONT></TD>
		  <TD valign="middle" align="left"><FONT face="Times New Roman" size="2">:</FONT></TD>
		  <TD>$from_name</TD>
		</TR>
    	<TR>
      	  <TD valign="middle" align="right" nowrap><FONT face="Times New Roman" size="2">$lang_your_mail</FONT></TD>
      	  <TD valign="middle" align="left" nowrap><FONT face="Times New Roman" size="2">:</FONT></TD>
      	  <TD align="left" nowrap>$from_address</TD>
    	</TR>
    	<TR>
      	  <TD valign="middle" align="right" nowrap><FONT face="Times New Roman" size="2">$lang_subject</FONT></TD>
      	  <TD valign="middle" align="left"><FONT face="Times New Roman" size="2">:</FONT></TD>
      	  <TD align="left">$subject</TD>
    	</TR>
    	<TR>
      	  <TD valign="top" align="right" nowrap><FONT face="Times New Roman" size="2">$lang_body</FONT></TD>
      	  <TD valign="top" align="left"><FONT face="Times New Roman" size="2">:</FONT></TD>
      	  <TD align="left">$body</TD>
    	</TR>
    	<TR height="40">
      	  <TD align="center" colspan="3">$send&nbsp;<INPUT type="reset" value="$lang_clear" style="font-size:x-small"></TD>
    	</TR>
      </TBODY>
    </TABLE>
    </form>
EOF;
		return $content;
	}

	function set_block(&$block,$produce=False)
	{
		parent::set_block($block,$produce);
		if (!$produce)
			return;
		if ($this->block->arguments['send'])
		{
			if (empty($this->block->arguments['from_address']))
			{
				$this->block->arguments['message'] = lang('Please enter your mail address.');
				return;
			}
			elseif (!$this->validator->is_email($this->block->arguments['from_address']))
			{
				$this->block->arguments['message'] = lang('Invalid email address.');
				return;	
			}	
			$send = CreateObject('phpgwapi.send');
			if ($this->block->arguments['from_name'] && $this->block->arguments['from_address'])
				$sender = '"'.$this->block->arguments['from_name'].'" <'.$this->block->arguments['from_address'].'>';
			elseif ($this->block->arguments['from_address'])
				$sender = $this->block->arguments['from_address'];
			elseif ($this->block->arguments['from_name'])
				$sender = '"'.$this->block->arguments['from_name'].'" <noreply@'.$GLOBALS['phpgw_info']['server']['mail_suffix'].'>';
			else
				$sender = 'noreply@'.$GLOBALS['phpgw_info']['server']['mail_suffix'];
			$tmp_email_address = $GLOBALS['phpgw_info']['user']['preferences']['email']['address'];
			if (!empty($this->block->arguments['envelope_sender_address']))
				$GLOBALS['phpgw_info']['user']['preferences']['email']['address'] = $this->block->arguments['envelope_sender_address'];
			$tmp_use_sent_folder = $GLOBALS['phpgw_info']['user']['preferences']['email']['use_sent_folder'];
			unset($GLOBALS['phpgw_info']['user']['preferences']['email']['use_sent_folder']);
			if ($send->msg('email', $this->block->arguments['to_address'], $this->block->arguments['subject'], $this->block->arguments['body'],
				'', '', '', $sender, $sender))
			{
				$this->block->arguments['message'] = lang('The E-mail has been sent.');
				unset($this->block->arguments['from_name']);
				unset($this->block->arguments['from_address']);
				unset($this->block->arguments['subject']);
				unset($this->block->arguments['body']);
			}
			else 
				$this->block->arguments['message'] = lang('Sending an E-mail went wrong.');
			$GLOBALS['phpgw_info']['user']['preferences']['email']['address'] = $tmp_email_address;
			$GLOBALS['phpgw_info']['user']['preferences']['email']['use_sent_folder'] = $tmp_use_sent_folder;	
		}
	}
	
	function validate(&$data)
	{
		$to_address = explode(',', $data['to_address']);
		for ($i = 0;$i < count($to_address); $i++)
		{
			if (!$this->validator->is_email($to_address[$i]))
			{
				$this->validation_error = lang('Invalid to email address.');
				return false;
			}	
		}
		if (!$this->validator->is_email($data['envelope_sender_address']))
		{
			$this->validation_error = lang('Invalid envelope from address.');
			return false;
		}
		if (!ereg('.*@'.$GLOBALS['phpgw_info']['server']['mail_suffix'], $data['envelope_sender_address']))
		{
			$this->validation_error = lang('Invalid envelope from address.');
			return false;
		}
		return true;
	}
}
