<?php
/**
* phpGroupWare desktop template
* @author Dave Hall dave.hall at mbox.com.au
* @copyright Copyright (C) 2004 Free Software Foundation http://www.fsf.org/
* @license http://www.gnu.org/licenses/gpl.html GNU General Public License
* @package phpgwapi
* @subpackage gui
* @version $Id: class.desktop.inc.php,v 1.1.1.1 2004/04/06 23:11:34 kazuyan Exp $
*/


class desktop
{
	var $iframe;
	var $info;
	var $js;
	var $sessions;
	var $t;
	var $target;
	var $vars;
	function desktop()
	{
		if(!is_object($GLOBALS['phpgw']->sessions))
		{
			$GLOBALS['phpgw']->sessions = createObject('phpgwapi.sessions');
		}

		$this->sessions =& $GLOBALS['phpgw']->sessions;
		if($GLOBALS['phpgw']->sessions->is_repost() && !isset($_GET['desktop_target']))
		{
			$status = $this->sessions->appsession('desktop', 'phpgwapi', False);	
		}
		$status = $this->sessions->appsession('desktop', 'phpgwapi');

		if( (isset($_GET['desktop_target']) && substr($_GET['desktop_target'],0,6) == 'iframe' )
			|| (is_array($status) && @$status['head'] && @$status['navbar'] ))//&& @$status['footer']) )
		{
			$this->iframe = True;
			$this->target = intval(substr($_GET['desktop_target'],6));
		}
		else
		{
			$this->iframe = False;
		}

		if(!is_object($GLOBALS['phpgw']->js))
		{
			$GLOBALS['phpgw']->js = createObject('phpgwapi.javascript');
		}
		$this->js =& $GLOBALS['phpgw']->js;
		
		if(!is_object($GLOBALS['phpgw']->template))
		{
			$GLOBALS['phpgw']->template = createObject('phpgwapi.Template', PHPGW_TEMPLATE_DIR);
		}
		$this->t =& $GLOBALS['phpgw']->template;
		$this->t->set_root(PHPGW_TEMPLATE_DIR);
		$this->t->set_unknowns('remove');

		$this->info =& $GLOBALS['phpgw_info'];

		$this->vars['img_root'] = $this->info['server']['webserver_url'] . '/phpgwapi/templates/desktop/images';
	}

	function footer()
	{
		$this->sessions->appsession('desktop', 'phpgwapi', 
			array('head'		=> True,
				'navbar'	=> True,
				'footer'	=> True
			)
		);
	}

	function footer_iframe()
	{
		$this->t->set_file('footer', 'footer_iframe.tpl');
		$this->t->pfp('out', 'footer');
	}

	function footer_render()
	{
		if($this->iframe)
		{
			$this->footer_iframe();
		}
		else
		{
			$this->footer();
		}
	}

	function head()
	{
		$this->t->set_file(array('head' => 'head.tpl'));
		$GLOBALS['phpgw_info']['flags']['java_script'] .= '<script type="text/javascript"'
		. ' src="' . $GLOBALS['phpgw_info']['server']['webserver_url'] 
		. '/phpgwapi/templates/desktop/js/desktop.js"></script>';
		
		$GLOBALS['phpgw']->js->set_onload('startMain();');

		$this->vars = array_merge($this->vars,
			array (
				'img_icon'      => PHPGW_IMAGES_DIR . '/favicon.ico',
				'img_shortcut'  => PHPGW_IMAGES_DIR . '/favicon.ico',
				'website_title'	=> $GLOBALS['phpgw_info']['server']['site_title'],
			)
		);
		$this->sessions->appsession('desktop', 'phpgwapi', array('head' => True));

	}

	function head_iframe()
	{
		$this->t->set_file(array('head' => 'head_iframe.tpl'));
		//$GLOBALS['phpgw']->js->set_onload('window.top.startFrame();');

		$this->vars = array_merge($this->vars,
			array (
				'charset'	=> lang('charset'),
				'target'	=> $this->target,
				'website_title'	=> 
					$this->info['apps'][$this->info['flags']['currentapp']]['title']
			)
		);
	}

	function head_render()
	{
		if(file_exists(PHPGW_SERVER_ROOT . '/phpgwapi/templates/desktop/css/' 
			. $this->info['user']['preferences']['common']['theme'] . '.css'))
		{
			$this->vars['theme_css'] = $this->info['server']['webserver_url'] 
				. '/phpgwapi/templates/desktop/css/' 
				. $this->info['user']['preferences']['common']['theme'].'.css';
		}
		else
		{
			$this->vars['theme_css'] = $this->info['server']['webserver_url'] 
				. '/phpgwapi/templates/desktop/css/desktop.css';
		}
		
		if($this->iframe)
		{
			$this->head_iframe();
		}
		else
		{
			$this->head();
		}

		$this->vars = array_merge($this->vars, 
			array(
				'charset'	=> lang('charset'),
				'body_tags'	=> $GLOBALS['phpgw']->common->get_body_attribs(),
				'css'		=> $GLOBALS['phpgw']->common->get_css(),
				'java_script'	=> $GLOBALS['phpgw']->common->get_java_script(),
			)
		);
		
		$this->t->set_var($this->vars);
		$this->t->pfp('out', 'head');
	}
	
	function navbar()
	{
		$this->t->set_file(array('navbar' => 'navbar.tpl'));
		$this->t->set_block('navbar','appmenu','menuitem');

		$use_icons = !!strpos($this->info['user']['preferences']['common']['navbar_format'],'con');
		$blank_img = $this->vars['img_root'] . '/blank.png';

		$this->vars['url_home'] = $GLOBALS['phpgw_info']['navbar']['home']['url'];
		$this->vars['img_home'] = ($use_icons ? $this->vars['img_root'] . '/home.png' : $blank_img);
		$this->vars['lang_home'] = lang('home');

		/* TODO - make this work properly
		$this->vars['url_about'] = $GLOBALS['phpgw_info']['navbar']['about']['url'];
		$this->vars['img_about'] = ($use_icons ? $this->vars['img_root'] . '/about.png' : $blank_img);
		$this->vars['lang_about'] = lang('about %1', '');
		*/

		$this->vars['url_logout'] = $GLOBALS['phpgw_info']['navbar']['logout']['url'];
		$this->vars['img_logout'] = ($use_icons ? $this->vars['img_root'] . '/logout.png' : $blank_img);
		$this->vars['lang_logout'] = lang('logout');

		$items = 2;//3;
		@ksort($GLOBALS['phpgw_info']['navbar']);
		foreach($GLOBALS['phpgw_info']['navbar'] as $app => $app_data)
		{
			if ($app != 'home' && $app != 'about' && $app != 'logout')
			{
				$GLOBALS['phpgw']->template->set_var(
					array('lang_app' => $app_data['title'],
						'url_app'=> $app_data['url'],
						'id_app' => strtolower($app),
						'img_app'=> ($use_icons 
							? $app_data['icon'] 
							: $blank_img
						)
					)
				);
				$GLOBALS['phpgw']->template->parse('menuitem', 'appmenu', True);
				$items++;
			}
		}
		$this->vars['items'] = $items;
		$this->vars['no_rows'] = ($items + 1);
		$this->vars['lang_go'] = strtoupper(lang('go'));
		$this->vars['lang_go_title'] = lang('whered\' GNU wanna go today?');
		
		/* TODO make this work
		$this->vars['loadURL'] = $GLOBALS['phpgw']->link('/' 
			. $this->info['user']['preferences']['common']['default_app'] 
			. '/index.php', array('desktop_target' => 'iframe1'));
		*/
		
		$this->vars['username'] = $GLOBALS['phpgw']->common->display_fullname();

		$this->vars['url_null'] = $this->info['server']['webserver_url'] . '/phpgwapi/templates/desktop/null.php';
		
		$this->sessions->appsession('desktop', 'phpgwapi', array('head' => True, 'navbar' => True));

	}

	function navbar_iframe()
	{
			$this->t->set_file(array('navbar' => 'navbar_iframe.tpl'));
			/* TODO remove when this works :)
			$this->vars['img_currentapp'] = $this->info['apps'][$this->info['flags']['currentapp']]['icon'];
			$this->vars['title_currentapp'] = $this->info['apps'][$this->info['flags']['currentapp']]['title'];
			$this->vars['target'] = $this->target;
			*/

	}

	function navbar_render()
	{
		if($this->iframe)
		{
			$this->navbar_iframe();
		}
		else
		{
			$this->navbar();
		}
		$this->t->set_var($this->vars);
		$this->t->pfp('out', 'navbar');
		if(!$this->iframe)
		{
			$GLOBALS['phpgw']->common->phpgw_exit();
		}
	}
}
?>
