<?php
	/**************************************************************************\
	* phpGroupWare - Headlines Administration                                  *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: viewheadline.php,v 1.1.1.2.8.1 2004/09/27 03:51:46 kazuyan Exp $ */

	$phpgw_info['flags'] = array(
		'currentapp'              => 'admin',
		'enable_nextmatchs_class' => True,
		'nonavbar'                => True,
		'noheader'                => True
	);
	include('../header.inc.php');

	$con = intval(get_var('con', array('POST', 'GET'), 0));
	if (! $con)
	{
		$GLOBALS['phpgw']->redirect_link('/headlines/admin.php');
	}
        
	$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_headlines_sites WHERE con=$con", __LINE__, __FILE__);
	if(! $GLOBALS['phpgw']->db->next_record())
	{
		$GLOBALS['phpgw']->redirect_link('/headlines/admin.php');
	}
	$headline_db = $GLOBALS['phpgw']->db;		
	$GLOBALS['phpgw']->translation->add_app('headlines');
	$GLOBALS['phpgw']->common->phpgw_header();
	echo parse_navbar();

	// This is done for a reason (jengo)
	$GLOBALS['phpgw']->template->set_root($GLOBALS['phpgw']->common->get_tpl_dir('headlines'));

	$GLOBALS['phpgw']->template->set_file(array(
		'admin_form' => 'admin_form.tpl'
	));
	$GLOBALS['phpgw']->template->set_block('admin_form','form');
	$GLOBALS['phpgw']->template->set_block('admin_form','listing_row');
	$GLOBALS['phpgw']->template->set_block('admin_form','listing_rows');
	$GLOBALS['phpgw']->template->set_block('admin_form','buttons');

	$GLOBALS['phpgw']->template->set_var('title',lang('Headlines Administration'));
	$GLOBALS['phpgw']->template->set_var('lang_header',lang('View headline'));
	$GLOBALS['phpgw']->template->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('row_on',$phpgw_info['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$phpgw_info['theme']['row_off']);
	$GLOBALS['phpgw']->template->set_var('lang_display',lang('Display'));
	$GLOBALS['phpgw']->template->set_var('lang_base_url',lang('Base URL'));
	$GLOBALS['phpgw']->template->set_var('lang_news_file',lang('News File'));
	$GLOBALS['phpgw']->template->set_var('lang_minutes',lang('Minutes between refresh'));
	$GLOBALS['phpgw']->template->set_var('lang_listings',lang('Listings Displayed'));
	$GLOBALS['phpgw']->template->set_var('lang_type',lang('News Type'));
	$GLOBALS['phpgw']->template->set_var('lang_button',lang('Back'));
	$GLOBALS['phpgw']->template->set_var('action_url', $GLOBALS['phpgw']->link('/headlines/admin.php'));

	$GLOBALS['phpgw']->template->set_var('input_display',$headline_db->f('display'));
	$GLOBALS['phpgw']->template->set_var('input_base_url',$headline_db->f('base_url'));
	$GLOBALS['phpgw']->template->set_var('input_news_file',$headline_db->f('newsfile'));
	$GLOBALS['phpgw']->template->set_var('input_minutes',$GLOBALS['phpgw']->common->show_date($headline_db->f('lastread')));
	$GLOBALS['phpgw']->template->set_var('input_listings',$headline_db->f('cachetime'));
	$GLOBALS['phpgw']->template->set_var('input_type',$headline_db->f('newstype'));


	$GLOBALS['phpgw']->db->query('SELECT title,link FROM phpgw_headlines_cached'
			. " WHERE site = $con",__LINE__,__FILE__);

	$GLOBALS['phpgw']->template->set_var('th_bg2',$phpgw_info['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('lang_current_cache',lang('Current headlines in cache'));

	if ($GLOBALS['phpgw']->db->num_rows() == 0)
	{
		$GLOBALS['phpgw']->nextmatchs->template_alternate_row_color($GLOBALS['phpgw']->template);
		$GLOBALS['phpgw']->template->set_var('value',lang('None'));
		$GLOBALS['phpgw']->template->parse('listing_rows','listing_row',True);
	}

	while ($GLOBALS['phpgw']->db->next_record())
	{
		$GLOBALS['phpgw']->nextmatchs->template_alternate_row_color($GLOBALS['phpgw']->template);
		$GLOBALS['phpgw']->template->set_var('value','<a href="' . $GLOBALS['phpgw']->db->f('link') . '" target="_new">' 
			. $GLOBALS['phpgw']->strip_html($GLOBALS['phpgw']->db->f('title')) . '</a>');
		$GLOBALS['phpgw']->template->parse('listing_rows','listing_row',True);
	}

	$GLOBALS['phpgw']->template->pfp('out','form');
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
