<?php
	/**************************************************************************\
	* phpGroupWare - Headlines Administration                                  *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: admin.php,v 1.1.1.1.18.1 2004/09/27 03:51:46 kazuyan Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'admin_only'              => True,
		'currentapp'              => 'headlines',
		'enable_nextmatchs_class' => True
	);
	include('../header.inc.php');

	// This is done for a reason (jengo)
	$GLOBALS['phpgw']->template->set_root($GLOBALS['phpgw']->common->get_tpl_dir('headlines'));
	$GLOBALS['phpgw']->template->set_file(array(
		'admin' => 'admin.tpl'
	));
	$GLOBALS['phpgw']->template->set_block('admin','list');
	$GLOBALS['phpgw']->template->set_block('admin','row');
	$GLOBALS['phpgw']->template->set_block('admin','row_empty');

	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('title',lang('Headline Sites'));
	$GLOBALS['phpgw']->template->set_var('lang_site',lang('Site'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_delete',lang('Delete'));
	$GLOBALS['phpgw']->template->set_var('lang_view',lang('View'));
	$GLOBALS['phpgw']->template->set_var('lang_add',lang('Add'));
	$GLOBALS['phpgw']->template->set_var('lang_search',lang('Search'));
	
	$search = get_var('search', array('POST'));
	$start = get_var('start', array('GET', 'POST'));
	$searchmethod = empty($search) ? '' : " where display like '%$search%' or base_url like '%$search%' or newsfile like '%$search%'";
	
	$GLOBALS['phpgw']->db->query('select count(*) from phpgw_headlines_sites'.$searchmethod,__LINE__,__FILE__);
	$GLOBALS['phpgw']->db->next_record();

	if (!($total_records = $GLOBALS['phpgw']->db->f(0)))
	{
		$GLOBALS['phpgw']->template->set_var('lang_row_empty',lang('No headlines found'));
		$GLOBALS['phpgw']->nextmatchs->template_alternate_row_color($GLOBALS['phpgw']->template);
		$GLOBALS['phpgw']->template->parse('rows','row_empty');
	}
	// --------------------------------- nextmatch ---------------------------
	$data = $GLOBALS['phpgw']->session->appsession('session_data','headlines');
	$start = isset($start) && $start != '' ? $start : $data['start'];
	if ($start > $total_records)
		$start = 0;
	$nextmatchs = CreateObject('phpgwapi.nextmatchs');
	$link_data = array (
		'search'	=> $search
	);
	$left = $nextmatchs->left('/headlines/admin.php',$start,$total_records,$link_data);
	$right = $nextmatchs->right('/headlines/admin.php',$start,$total_records,$link_data);
	$GLOBALS['phpgw']->template->set_var('left',$left);
	$GLOBALS['phpgw']->template->set_var('right',$right);
	$GLOBALS['phpgw']->template->set_var('search_message',$nextmatchs->show_hits($total_records,$start));
	$GLOBALS['phpgw']->template->set_var('search_url', $GLOBALS['phpgw']->link('/headlines/admin.php'));
	$GLOBALS['phpgw']->template->set_var('search', $GLOBALS['phpgw']->strip_html($search));
	$GLOBALS['phpgw']->session->appsession('session_data','headlines', array('start' => $start));
	// -------------------------- end nextmatch ------------------------------------
	$GLOBALS['phpgw']->db->limit_query("select con,display from phpgw_headlines_sites${searchmethod} order by display",$start,__LINE__,__FILE__);
	while ($GLOBALS['phpgw']->db->next_record())
	{
		$GLOBALS['phpgw']->nextmatchs->template_alternate_row_color($GLOBALS['phpgw']->template);

		$GLOBALS['phpgw']->template->set_var('row_display',$GLOBALS['phpgw']->db->f('display'));
		$GLOBALS['phpgw']->template->set_var('row_edit',$GLOBALS['phpgw']->link('/headlines/editheadline.php','con='.$GLOBALS['phpgw']->db->f('con')));
		$GLOBALS['phpgw']->template->set_var('row_delete',$GLOBALS['phpgw']->link('/headlines/deleteheadline.php','con='.$GLOBALS['phpgw']->db->f('con')));
		$GLOBALS['phpgw']->template->set_var('row_view',$GLOBALS['phpgw']->link('/headlines/viewheadline.php','con='.$GLOBALS['phpgw']->db->f('con')));

		$GLOBALS['phpgw']->template->parse('rows','row',True);
	}

	$GLOBALS['phpgw']->template->set_var('add_url',$GLOBALS['phpgw']->link('/headlines/newheadline.php'));
	$GLOBALS['phpgw']->template->set_var('grab_more_url',$GLOBALS['phpgw']->link('/headlines/grabnewssites.php'));
	$GLOBALS['phpgw']->template->set_var('lang_grab_more',lang('Grab New News Sites'));

	$GLOBALS['phpgw']->template->pfp('out','list');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
