<?php
  /**************************************************************************\
  * phpGroupWare - PHPWebHosting                                             *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/


	$GLOBALS['phpgw_info']['flags'] = array
	(
		"currentapp" => "filemanager",
		"enable_nextmatchs_class" => True,
		"noheader" => True,
		"nonavbar" => True
	);

	include("../header.inc.php");

	$display_error = false;
	$other_inputfields = array ('set_quota' => lang('Enter comma separated Quota value in MB'));
	$values = $_POST['values'];
	$val = $values['set_quota'];
	$config = CreateObject('phpgwapi.config','filemanager');
	$config->read_repository();
	// Check if the Values match the following pattern 0,1,10,unlimited
	if (empty($val) || ereg("^[ 0-9]+(,[ 0-9]+)*$",$val))
	{
		if ($_POST['save'])
		{	
			$config->value('set_quota', '0, ' . $val . ','.'unlimited');
			$config->save_repository();
			$GLOBALS['phpgw']->redirect_link('/admin/index.php');
		}
	}
	else
	{
		$display_error = true;
	}

	if ($_POST['cancel'])
	{
		$GLOBALS['phpgw']->redirect_link('/admin/index.php');
	}

	function display_item($field,$data)
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color ($tr_color);
		$var = array (
			'bg_color'	=>	$tr_color,
			'field'		=>	$field,
			'data'		=>	$data
		);
		$GLOBALS['phpgw']->template->set_var($var);
		$GLOBALS['phpgw']->template->fp('row','normal',True);
	}

	$GLOBALS['phpgw_info']['flags']['app_header'] = lang('filemanager') . ': ' . lang('admin');
	$GLOBALS['phpgw']->common->phpgw_header ();
	echo parse_navbar ();

	$GLOBALS['phpgw']->template->set_file(array('admin' => 'admin.tpl'));
	$GLOBALS['phpgw']->template->set_block('admin','normal');

	$var = array(
		'action_url'	=> $GLOBALS['phpgw']->link ('/' . $GLOBALS['phpgw_info']['flags']['currentapp'] . '/admin.php'),
		'bg_color'		=> $GLOBALS['phpgw_info']['theme']['th_bg'],
		'lang_save'		=> lang ('save'),
		'lang_cancel'	=> lang('cancel')		
	);
	
	$GLOBALS['phpgw']->template->set_var ($var);

	if ($totalerrors)
	{
		echo '<p><center>' . $GLOBALS['phpgw']->common->error_list($errors) . '</center>';
	}

	display_item ('<b>' . lang('edit quota') . '</b>','&nbsp;');
	if ($display_error)
	{
		display_item ('<b>' . lang('erroneous input! check quota value!') . '</b>','&nbsp;');
	}
	
	reset ($other_inputfields);

	if ($config->config_data)
	{
		$items = $config->config_data;
		$quota = $items['set_quota'];
		unset($config);
	}

	$str = '0,';
	while (list($internal, $displayed) = each($other_inputfields))
	{
		if (!$quota)
		{
			$str .= html_form_input ("text", $internal, "1,10", 30, 30, NULL, NULL,'', 1, True);	
		}
		else
		{
			$quota_str = '';
			$tok = strtok ($quota,",");
			
			if ($tok=='0')
				{
					$tok = strtok (",");
				}
				while ($tok) {
					if (strstr($tok,'unlimited'))
					{						
				   		$tok = strtok (",");
					}
					else
					{
						if ($quota_str=='')
						{
							$quota_str .= $tok;
						}
						else
						{
							$quota_str .= ','.$tok;
						}
				   		$tok = strtok (",");
					}
				}
			$str .= html_form_input ("text", $internal, $quota_str, 30, 30, NULL, NULL,'', 1, True);
		}
		$str .= ', '.lang('unlimited');
		display_item($displayed, $str);
	}
	
	$GLOBALS['phpgw']->template->set_var('normal','');
	$GLOBALS['phpgw']->template->pfp('out','admin');
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
