<?php
/**
* dbLister.inc  --  ǡ١νϤɽ
*
* SelectǤθ̤Ϥ뤿Υ饹
* Υڡʬ䤪ӳƥڡؤΥ󥯤
* PEAR/DBƳФͽ
* License: MIT License
*
* @package aglib
* @access public
* @version 0.1
* @author Furukawa Atsushi <agl@violet.plala.or.jp>
* @since 2002/09/07
*/

/**	
 * Ūselectʸ¹Ԥ̤¸ޤ
 * @access public
 * @author Atsushi Furukawa <agl@violet.plala.or.jp>
 * @create 2002/3/29
 * @version $Id:
 */
class dbLister {
	var $errmsg;		/** 顼å */
	var $result;		/** ¹Է̥꥽ */
	var $sql;			/** ¹ԤSQL */

	// ϥå
	var $max;			/** Կ */
	var $row;			/** ȹֹ */

	// ڡ
	var $pgrowmax = 10;		/** 1ڡ˼Ǥ쥳ɿ */
	var $pglinknum = 5;		/** 1ڡɽڡ󥯤ο */


	function dbLister($db, $query="", $pgrow=0)
	{
		if ($pgrow > 0)		$this->pgrowmax = $pgrow;
		if ($db != "" && $query != "")	$this->sql($db, $query);
	}

	//	SQL¹
	function sql($db, $query)
	{
		$this->max = -1;
		$this->row = -1;

		if (!$db || $query=="")		return FALSE;
		$this->result = pg_exec($db, $query);
		if ($this->result) {	// SQL
			$this->max = pg_numrows($this->result);
			$this->row = 0;
		} else {
			$this->errmsg = pg_errormessage($db);
			$this->sql    = $query;
			echo "<PRE>db error: sql = $query\nerror = " . pg_errormessage($db) . "</PRE>\n";
		}
		if (!$this->result)		return false;
		return $this->result;
	}

	//	ȤƹԤФ
	function fetch_row()
	{
		if ($this->row<0 || $this->row>=$this->max)	return false;
		return pg_fetch_array($this->result,$this->row++);
	}

	//	֥ȤȤƹԤФ
	function fetch_row_object()
	{
		if ($this->row<0 || $this->row>=$this->max)	return false;
		return pg_fetch_object($this->result,$this->row++);
	}

	/** 1ɤ߽Ф
	 * @param	string	$field ̾(Default '') ̤ΤȤϺǽι
	 * @return  ɤ߽Фܤ͡ɤ߽ФԻfalse
	*/
	function fetch_column($field="")
	{
		if (!$field)	$field = 0;
		$row = $this->fetch_row();
		return $row[$field];
	}

	//	õ
	function close()
	{
		pg_close($this->DB);
	}

	// ɤ߹߳ϹԻ
	function seek($i)
	{
		if ($i<0 || $i>=$this->max)		return false;
		$this->row = $i;
		return $this->row;
	}

	//	ɽ
	function rowcount($pgno = 1)
	{
		if ($pgno < 1)	$pgno = 1;
		$st = ($pgno-1) * $this->pgrowmax + 1;
		$ed = $st + $this->pgrowmax - 1;
		if ($ed >= $this->max)	$ed = $this->max;

		return array($st, $ed);
	}

	//	ʣڡϰϼ
	function pginterval($pgno)
	{
		$pgmax = intval(($this->max + $this->pgrowmax - 1) / $this->pgrowmax);

		$st = $pgno - intval($this->pglinknum /2 );
		if ($st < 1) $st = 1;

		$ed = $st+ $this->pglinknum - 1;
		if ($ed >= $pgmax){
			$ed = $pgmax;
			$st = intval($pgmax - $this->pglinknum + 1);
		}
		if ($st < 1)  $st = 1;

		return array($st, $ed);
	}

	//	ʣڡѤڡڡΥ󥯤
	function pagelink($pgno = 1, $url = "")
	{
		list($st, $ed) = $this->pginterval($pgno);
		if ($st == $ed)	return "";
		$list = "";
		if ($pgno > 1) 	{
			$i = $pgno - 1;
			$list .= "<A HREF=\"$url?pgno=$i\">ڡ</A>";

		}
		for ($i=$st; $i<=$ed; $i++) {
			if ($i == $pgno)	$s = $pgno;
				else			$s = "<A HREF=\"$url?pgno=$i\">$i</A>";
			if ($list != "")	$list .= "/";
			$list .= $s;
		}

		if ($pgno<$ed && $pgno>=1) {
			$i = $pgno + 1;
			$list .= "/<A HREF=\"$url?pgno=$i\">ڡ</A>";
		}
		return $list;
	}
}
?>
