/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.util;

import java.awt.image.BufferedImage;

import com.otk.application.error.StandardError;

/**
 * This is an enumeration of printer page orientations.
 * 
 * @author olitank
 *
 */
public enum PageOrientation {
	Portrait, Landscape;

	public static BufferedImage revertOrientation(BufferedImage image, PageOrientation pageOrientation) {
		if (pageOrientation == Portrait) {
			return image;
		} else if (pageOrientation == Landscape) {
			return ImageUtils.rotate(ImageUtils.getBufferedImage(image),
					-PageOrientation.LANDSCAPE_ORIENTATION_ROTATION_DEGREES);
		} else {
			throw new StandardError("Illegal printing page orientation: '" + pageOrientation + "'");
		}
	}

	public static BufferedImage updateOrientation(BufferedImage image, PageOrientation pageOrientation) {
		if (pageOrientation == Portrait) {
			return image;
		} else if (pageOrientation == Landscape) {
			return ImageUtils.rotate(ImageUtils.getBufferedImage(image),
					PageOrientation.LANDSCAPE_ORIENTATION_ROTATION_DEGREES);
		} else {
			throw new StandardError("Illegal printing page orientation: '" + pageOrientation + "'");
		}
	}

	public static final int LANDSCAPE_ORIENTATION_ROTATION_DEGREES = -90;
}
