/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

import com.otk.application.util.ImageUtils;
import com.otk.application.util.MathUtils;

public class Rotation extends AbstractFilter {

	public int angleDegrees = 0;

	@Override
	public FilteringContext doExecute(FilteringContext context) {
		if (angleDegrees == 0) {
			return context;
		}
		BufferedImage image = context.getImage();

		Dimension size = new Dimension(image.getWidth(), image.getHeight());
		Dimension newSize = getBoxBounds(0, 0, size.width, size.height, angleDegrees).getSize();

		BufferedImage newImage = new BufferedImage(newSize.width, newSize.height,
				ImageUtils.getAdaptedBufferedImageType());
		Graphics2D g = newImage.createGraphics();
		ImageUtils.setSmoothScalingRenderingHints(g);
		AffineTransform at = getRotationTransform(size.width, size.height, angleDegrees);
		g.setTransform(at);
		g.drawImage(image, 0, 0, null);
		g.dispose();
		return context.withImage(newImage);
	}

	public static AffineTransform getRotationTransform(int w, int h, int angleDegrees) {
		Dimension newSize = getBoxBounds(0, 0, w, h, angleDegrees).getSize();
		double radians = -Math.toRadians(angleDegrees);
		AffineTransform at = new AffineTransform();
		at.translate((newSize.width - w) / 2, (newSize.height - h) / 2);
		int cWidth = MathUtils.round(w / 2.0);
		int cHeight = MathUtils.round(h / 2.0);
		at.rotate(radians, cWidth, cHeight);
		return at;
	}

	public static Rectangle getBoxBounds(int x, int y, int w, int h, int angleDegrees) {
		double radians = -Math.toRadians(angleDegrees);
		double sin, cos;

		sin = Math.abs(Math.sin(radians));
		cos = Math.abs(Math.cos(radians));
		int newWidth = MathUtils.round(Math.floor(w * cos + h * sin));

		sin = Math.abs(Math.sin(radians));
		cos = Math.abs(Math.cos(radians));
		int newHeight = MathUtils.round(Math.floor(h * cos + w * sin));

		x += MathUtils.round((w - newWidth) / 2.0);
		y += MathUtils.round((h - newHeight) / 2.0);
		return new Rectangle(x, y, newWidth, newHeight);
	}
}
