/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.image.BufferedImage;

/**
 * Filter execution context.
 * 
 * It provides the input image.
 * 
 * It also allows to trace the execution of multiple filters and get the
 * intermediate results via {@link #getParent()}.
 * 
 * @author olitank
 *
 */
public class FilteringContext {
	private BufferedImage image;
	private FilteringContext parent;

	public BufferedImage getImage() {
		return image;
	}

	public FilteringContext withImage(BufferedImage newImage) {
		FilteringContext result = createClone(newImage);
		return result;
	}

	private FilteringContext createClone(BufferedImage newImage) {
		FilteringContext result = new FilteringContext();
		result.image = newImage;
		result.parent = this;
		return result;
	}

	public FilteringContext getParent() {
		return parent;
	}

}
