/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.filter;

import java.awt.Color;
import java.util.LinkedHashMap;

public abstract class AbstractOptimizationCache {

	private LinkedHashMap<Object, Color> map = new LinkedHashMap<Object, Color>();
	private int filtersOptimizatiponCacheMaximumSize = 1000;

	public int getFiltersOptimizatiponCacheMaximumSize() {
		return filtersOptimizatiponCacheMaximumSize;
	}

	public void setFiltersOptimizatiponCacheMaximumSize(int filtersOptimizatiponCacheMaximumSize) {
		this.filtersOptimizatiponCacheMaximumSize = filtersOptimizatiponCacheMaximumSize;
	}

	public synchronized Color get(Object key) {
		return map.get(key);
	}

	public synchronized void put(Object key, Color newPixelColor) {
		if (map.containsKey(key)) {
			return;
		}
		map.put(key, newPixelColor);
		if (map.size() > filtersOptimizatiponCacheMaximumSize) {
			Object firstKey = map.keySet().iterator().next();
			map.remove(firstKey);
		}
	}

}
