/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.image.camera;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * Resolution/size of images coming from camera devices.
 * 
 * @author olitank
 *
 */
public class FrameFormat implements Comparable<FrameFormat>, Serializable {

	private static final long serialVersionUID = 1L;

	public static final List<FrameFormat> COMMON = Arrays.asList(new FrameFormat(160, 120), new FrameFormat(320, 240),
			new FrameFormat(640, 480), new FrameFormat(1280, 960));

	public int width;
	public int height;

	public FrameFormat(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public int getWidth() {
		return width;
	}

	public int getHeight() {
		return height;
	}

	public Dimension toDimension() {
		return new Dimension(width, height);
	}

	@Override
	public String toString() {
		if ((width == -1) || (height == -1)) {
			return "unknown";
		}
		return width + "x" + height;
	}

	@Override
	public int compareTo(FrameFormat o) {
		if (getWidth() != o.getWidth()) {
			return new Integer(getWidth()).compareTo(new Integer(o.getWidth()));
		} else {
			return new Integer(getHeight()).compareTo(new Integer(o.getHeight()));
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + height;
		result = prime * result + width;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FrameFormat other = (FrameFormat) obj;
		if (height != other.height)
			return false;
		if (width != other.width)
			return false;
		return true;
	}

}
