/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.error;

/**
 * This class represents a normal error that is expected to occur sometimes.
 * 
 * @author olitank
 *
 */
public class StandardError extends AbstractApplicationError {

	private static final long serialVersionUID = 1L;

	public StandardError(String message, Throwable cause) {
		super(message, cause);
	}

	public StandardError(String message) {
		super(message);
	}

	@Override
	public String toString() {
		return getMessage();
	}

}
