/*******************************************************************************
 * Copyright (C) 2018 OTK Software
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package com.otk.application.error;

/**
 * The base class of the current application specific exceptions.
 * 
 * @author olitank
 *
 */
public abstract class AbstractApplicationError extends RuntimeException {

	private static final long serialVersionUID = 1L;

	public AbstractApplicationError() {
		super();
	}

	public AbstractApplicationError(String message, Throwable cause, boolean enableSuppression,
			boolean writableStackTrace) {
		super(message, cause, enableSuppression, writableStackTrace);
	}

	public AbstractApplicationError(String message, Throwable cause) {
		super(message, cause);
	}

	public AbstractApplicationError(String message) {
		super(message);
	}

	public AbstractApplicationError(Throwable cause) {
		super(cause);
	}

	public static void rethrow(Throwable t) {
		throw getToRethrow(t);
	}

	public static RuntimeException getToRethrow(Throwable t) {
		return getToRethrow(null, t, true);
	}

	public static void rethrow(String errorContextDescription, Throwable t) {
		throw getToRethrow(errorContextDescription, t);
	}

	public static RuntimeException getToRethrow(String errorContextDescription, Throwable t) {
		return getToRethrow(errorContextDescription, t, true);
	}

	public static void rethrow(String errorContextDescription, Throwable t, boolean unknownErrorAsUnexpected) {
		throw getToRethrow(errorContextDescription, t, unknownErrorAsUnexpected);
	}

	private static RuntimeException getToRethrow(String errorContextDescription, Throwable t,
			boolean unknownErrorAsUnexpected) {
		if ((t instanceof UnexpectedError) || (!(t instanceof StandardError) && unknownErrorAsUnexpected)) {
			if (errorContextDescription != null) {
				return new UnexpectedError(errorContextDescription + ": " + t.toString(), t);
			} else {
				return new UnexpectedError(t.toString(), t);
			}
		} else {
			if (errorContextDescription != null) {
				return new StandardError(errorContextDescription + ": " + t.toString(), t);
			} else {
				return new StandardError(t.toString(), t);
			}
		}
	}

}
