package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.CRC32;

import org.phosphoresce.resourcecomp.exception.CompareException;

/**
 * CRC32`FbNTrXgeWNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public class CRC32CompareStrategy extends CompareAbstractStrategy {

	/**
	 * RXgN^<br>
	 */
	public CRC32CompareStrategy() {
		super();
	}

	/**
	 * r惊\[X폜Ԃł邩𔻒肵܂B<br>
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @return r惊\[X폜Ԃłꍇtrueԋp
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.strategy.CompareAbstractStrategy#isUpdate(java.io.File, java.io.File)
	 */
	protected boolean isUpdate(File origin, File destination) throws CompareException {
		long originCrc = getChecksum(origin);
		long destinationCrc = getChecksum(destination);
		if (originCrc == destinationCrc) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * w肳ꂽt@CCRC32`FbNT擾܂B<br>
	 * @param file t@C
	 * @return CRC32`FbNT
	 * @throws CompareException Ƀ`FbNTZosȂꍇɔ
	 */
	private long getChecksum(File file) throws CompareException {
		CRC32 crc = new CRC32();
		try {

			if (file == null || file.isDirectory()) {
				return -1;
			}
			BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
			//		int data;
			//		while ((data = stream.read()) != -1) {
			//			crc.update(data);
			//		}
			byte[] buffer = new byte[2048];
			int size;
			while ((size = stream.read(buffer, 0, buffer.length)) != -1) {
				crc.update(buffer, 0, size);
			}
			stream.close();
			return crc.getValue();
		} catch (Throwable e) {
			throw new CompareException("CRC32`FbNTZoɎs܂", e);
		}
	}
}
