package org.phosphoresce.resourcecomp.plugin.monitor;

import java.io.File;

import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;

/**
 * vOXWo̓j^[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public class ProgressSystemoutMonitor implements CompareMonitor {

	/** vOXLN^ */
	private static String[] progressCharactor = new String[] { //
	//
			" Oo..o ", //
			" Oo..o ", //
			" oOo.. ", //
			" oOo.. ", //
			" .oOo. ", //
			" .oOo. ", //
			" ..oOo ", //
			" ..oOo ", //
			" o..oO ", //
			" o..oO ", //
	};

	/** vOXCfbNX */
	private int progress = 0;

	/**
	 * RXgN^<br>
	 */
	public ProgressSystemoutMonitor() {
		super();
	}

	/**
	 * vOXLN^擾܂B<br>
	 * @return vOXLN^
	 */
	private String getProgress() {
		String result = progressCharactor[progress];
		progress++;
		if (progressCharactor.length - 1 < progress) {
			progress = 0;
		}
		return result;
	}

	/**
	 * JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#start(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void start(CompareSession session) throws CompareException, IllegalConfigurationException {
		System.out.println();
		System.out.println("ȉ̏Ń\[X̔rs܂B");
		System.out.println();
		System.out.println("r\[X : " + session.getConfigure().getOrigin());
		System.out.println("r惊\[X : " + session.getConfigure().getDestination());
		System.out.println("rʏo͐ : " + session.getConfigure().getResultWritePath());
		System.out.println("\[Xo͐ : " + session.getConfigure().getResourceWritePath());
		System.out.println();
		System.out.println("GR[fBO   : " + session.getConfigure().getEncoding());
		System.out.println("JnNX     : " + session.getConfigure().getExecuterClass());
		System.out.println("ReiNX     : " + session.getConfigure().getContainerClass());
		System.out.println("tB^NX     : " + session.getConfigure().getFilterClass());
		System.out.println("j^[NX     : " + session.getConfigure().getMonitorClass());
		System.out.println("XgeW[NX : " + session.getConfigure().getStrategyClass());
		System.out.println("\[Xo̓NX : " + session.getConfigure().getResourceWriterClass());
		System.out.println("rʏo̓NX : " + session.getConfigure().getResultWriterClass());
		System.out.println();
	}

	/**
	 * Ώۃ\[X̃JEgJnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#startCounting(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startCounting(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("rΏۃ\[X𒊏oĂ܂ (Xe[W 1/4)...");

		System.out.println(buffer.toString());
	}

	/**
	 * Ώۃ\[X̃JEgɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̃JEg
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#counting(org.phosphoresce.resourcecomp.core.session.CompareSession, long)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void counting(CompareSession session, long count) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("  ");
		buffer.append(count);
		buffer.append(" ");
		buffer.append("\[Xo܂B");

		System.out.print(buffer.toString());
	}

	/**
	 * Ώۃ\[X̃JEgۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size JEgꂽΏۃ\[X
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#finishCounting(org.phosphoresce.resourcecomp.core.session.CompareSession, long)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishCounting(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("rΏۂ " + size + " \[Xo܂B");
		buffer.append("                                        ");

		System.out.println(buffer.toString());
		System.out.println();
	}

	/**
	 * rJnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size rΏۃ\[X
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#startComparing(org.phosphoresce.resourcecomp.core.session.CompareSession, long)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("Ώۂ̃\[X̔rsĂ܂ (Xe[W 2/4)...");

		System.out.println(buffer.toString());
	}

	/**
	 * rsɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @param originCompare rx[XƂrtruew肳܂
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#comparing(org.phosphoresce.resourcecomp.core.session.CompareSession, java.io.File, java.io.File, boolean, long, long)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void comparing(CompareSession session, File origin, File destination, boolean originCompare, long count, long size) throws CompareException,
			IllegalConfigurationException {
		long percent = (long) (((double) count / (double) size) * 100);

		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("  ");
		buffer.append(percent + "% ܂");
		buffer.append(" (");
		buffer.append(size);
		buffer.append(" ̃\[X̂ ");
		buffer.append(count);
		buffer.append(" ̔rsĂ܂)B ");

		System.out.print(buffer.toString());
	}

	/**
	 * rۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size rΏۃ\[X
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#finishComparing(org.phosphoresce.resourcecomp.core.session.CompareSession, long)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("rΏۂ " + size + " \[X܂B");
		buffer.append("                                        ");

		System.out.println(buffer.toString());
		System.out.println();
	}

	/**
	 * rʏo͏JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#startResultWriting(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 */
	public void startResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("rʏ̏o͂sĂ܂ (Xe[W 3/4)...");

		System.out.println(buffer.toString());
	}

	/**
	 * rʏo͏ɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#resultWriting(org.phosphoresce.resourcecomp.core.session.CompareSession, long, long)
	 */
	public void resultWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException {
		long percent = (long) (((double) count / (double) size) * 100);

		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("  ");
		buffer.append(percent + "% ܂");
		buffer.append(" (");
		buffer.append(size);
		buffer.append(" ̃\[X̂ ");
		buffer.append(count);
		buffer.append(" ̏o͂sĂ܂)B ");

		System.out.print(buffer.toString());
	}

	/**
	 * rʏo͂ۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#finishResultWriting(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 */
	public void finishResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("rʏ̏o͂܂B");
		buffer.append("                                        ");

		System.out.println(buffer.toString());
		System.out.println();
	}

	/**
	 * r\[Xo͏JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#startResourceWriting(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 */
	public void startResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("rʃ\[X̏o͂sĂ܂ (Xe[W 4/4)...");

		System.out.println(buffer.toString());
	}

	/**
	 * r\[Xo͏ɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#resourceWriting(org.phosphoresce.resourcecomp.core.session.CompareSession, long, long)
	 */
	public void resourceWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException {
		long percent = (long) (((double) count / (double) size) * 100);

		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("  ");
		buffer.append(percent + "% ܂");
		buffer.append(" (");
		buffer.append(size);
		buffer.append(" ̃\[X̂ ");
		buffer.append(count);
		buffer.append(" ̃\[Xo͂sĂ܂)B ");

		System.out.print(buffer.toString());
	}

	/**
	 * r\[Xo͂ۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#finishResourceWriting(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 */
	public void finishResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\r");
		buffer.append("rʃ\[X̏o͂܂B");
		buffer.append("                                        ");

		System.out.println(buffer.toString());
		System.out.println();
	}

	/**
	 * IۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @see org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor#finish(org.phosphoresce.resourcecomp.core.session.CompareSession)
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finish(CompareSession session) throws CompareException, IllegalConfigurationException {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\[Xr܂B");

		System.out.println(buffer.toString());
		System.out.println();
	}
}
