package org.phosphoresce.resourcecomp.plugin.container;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

/**
 * \[XrReiC^tF[X<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/14	Kitagawa		VK쐬
 *-->
 */
public interface CompareContainer extends Serializable {

	/**
	 * \[Xǉ܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public void add(Resource resource) throws ResourceOperateException;

	/**
	 * w肳ꂽ\[X폜܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public void remove(Resource resource) throws ResourceOperateException;

	/**
	 * w肳ꂽ\[XXg폜܂B<br>
	 * @param collection 폜Ώۃ\[XXg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public void removeAll(Collection collection) throws ResourceOperateException;

	/**
	 * w肳ꂽrς݃\[XɕێĂ邩肵܂B<br>
	 * @param resource rς݃\[X
	 * @return rς݃\[XɕێĂꍇtrueԋp
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public boolean contains(Resource resource) throws ResourceOperateException;

	/**
	 * \[XXg擾܂B<br>
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public List getResourceList() throws IllegalEnumerationException;

	/**
	 * w肳ꂽXe[^X̃\[XXg擾܂B<br>
	 * @param status Xe[^XXg
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public List getResourceList(Status[] status) throws IllegalEnumerationException;

}
