package org.phosphoresce.resourcecomp.cui;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import org.phosphoresce.resourcecomp.core.CompareExecuter;
import org.phosphoresce.resourcecomp.core.Comparerator;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

/**
 * R}hCsX^[^[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/14	Kitagawa		VK쐬
 *-->
 */
public class CUIExecuter extends CompareExecuter {

	/** rpX */
	private String origin;

	/** rpX */
	private String destination;

	/** rʏo̓pX */
	private String resource;

	/** rCSVo̓pX */
	private String result;

	/** ΏۃXe[^X */
	private Status[] status;

	/**
	 * RXgN^<br>
	 */
	public CUIExecuter() {
		super();
	}

	/**
	 * rs܂B<br>
	 * @param args NR}hC
	 * @param session ZbVIuWFNg
	 * @throws Throwable ɗ\ʗOX[ꂽꍇɔ܂
	 * @see org.phosphoresce.resourcecomp.core.CompareExecuter#execute(java.lang.String[], org.phosphoresce.resourcecomp.core.session.CompareSession)
	 */
	public void execute(String[] args, CompareSession session) throws Throwable {
		// R}hCÓ`FbN
		validateArgument(args);

		// ݒ쐬
		CompareConfigure configure = session.getConfigure();
		configure.setOrigin(origin);
		configure.setDestination(destination);
		configure.setResultWritePath(result);
		configure.setResourceWritePath(resource);
		configure.setTargetStatus(status);

		// rNX
		Comparerator comparerator = new Comparerator(session);

		// rJn
		comparerator.start();
		while (comparerator.isAlive()) {
			//
		}
	}

	/**
	 * ̑Ó`FbNs܂B<br>
	 * @param args R}hC
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 * @throws ResourceOperateException sȃp[^ݒ肪sꂽꍇɔ
	 */
	private void validateArgument(String[] args) throws IllegalEnumerationException, ResourceOperateException {
		if (args == null || args.length < 4 || isHelpCommand(args)) {
			System.out.println(createHelp());
			System.exit(0);
		}
		origin = getOriginPath(args);
		destination = getDestinationPath(args);
		resource = getResourcePath(args);
		result = getResultPath(args);
		status = getStauts(args);

		File originFile = new File(origin);
		if (originFile.exists() && !originFile.isDirectory()) {
			throw new ResourceOperateException("rpXɃfBNgł͂ȂpXw肳܂");
		}
		File destinationFile = new File(destination);
		if (destinationFile.exists() && !destinationFile.isDirectory()) {
			throw new ResourceOperateException("rpXɃfBNgł͂ȂpXw肳܂");
		}
		File resourceFile = new File(resource);
		if (resourceFile.exists() && !resourceFile.isDirectory()) {
			throw new ResourceOperateException("\[Xo͐Ɋ̃fBNgł͂ȂpXw肳܂");
		}
		File resultFile = new File(resource);
		if (resultFile.exists() && !resultFile.isFile()) {
			throw new ResourceOperateException("rʏo͐Ɋ̃t@Cł͂ȂpXw肳܂");
		}
	}

	/**
	 * R}hCwv\w肳Ă邩肵܂B<br>
	 * @param args R}hC
	 * @return wv\w肳Ăꍇtrueԋp
	 */
	private boolean isHelpCommand(String[] args) {
		if (args == null || args.length < 1) {
			return true;
		}
		for (int i = 0; i <= args.length - 1; i++) {
			if ("--help".equals(args[i])) {
				return true;
			}
		}
		return false;
	}

	/**
	 * rfBNgR}hC擾܂B<br>
	 * @param args R}hC
	 * @return rfBNg
	 */
	private String getOriginPath(String[] args) {
		if (args == null || args.length < 1) {
			return "";
		}
		return args[0];
	}

	/**
	 * rfBNgR}hC擾܂B<br>
	 * @param args R}hC
	 * @return rfBNg
	 */
	private String getDestinationPath(String[] args) {
		if (args == null || args.length < 2) {
			return "";
		}
		return args[1];
	}

	/**
	 * r\[Xo̓pXR}hC擾܂B<br>
	 * @param args R}hC
	 * @return r\[Xo̓pX
	 */
	private String getResourcePath(String[] args) {
		if (args == null || args.length < 3) {
			return "";
		}
		return args[2];
	}

	/**
	 * rʏo̓pXR}hC擾܂B<br>
	 * @param args R}hC
	 * @return rʏo̓pX
	 */
	private String getResultPath(String[] args) {
		if (args == null || args.length < 4) {
			return "";
		}
		return args[3];
	}

	/**
	 * ΏۃXe[^XR}hC擾܂B<br>
	 * @param args R}hC
	 * @return ΏۃXe[^X
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	private Status[] getStauts(String[] args) throws IllegalEnumerationException {
		final Status[] DEFAULT_STATUS = new Status[] { Status.ADD, Status.UPDATE, Status.DELETE };
		final String WARNING = "x : Xe[^Xw肳ĂȂ߁Aǉ/XV/폜ΏۂƂ܂B";
		Map map = new HashMap();
		if (args == null || args.length < 5) {
			//return null;
			System.out.println(WARNING);
			return DEFAULT_STATUS;
		}
		List list = new LinkedList();
		for (int i = 4; i <= args.length - 1; i++) {
			if (args[i].startsWith("--status=")) {
				String pattern = args[i].substring("--status=".length());
				for (StringTokenizer tokenizer = new StringTokenizer(pattern, ","); tokenizer.hasMoreTokens();) {
					String token = tokenizer.nextToken().trim();
					list.add(Status.valueOf(token));
				}
			}
		}
		if (list.size() == 0) {
			System.out.println(WARNING);
			return DEFAULT_STATUS;
		} else {
			return (Status[]) list.toArray(new Status[list.size()]);
		}
	}

	/**
	 * R}hCwv𐶐܂B<br>
	 * @return R}hCwv
	 */
	private String createHelp() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("gp@: rcomp [rfBNg] [rfBNg] [r\[Xo̓pX] [rʃt@Co̓pX] [IvV]...").append("\n");
		buffer.append("\n");
		buffer.append("ŎwłIvVȊO̐ݒɂĂ͊eXgeWvOCPropertiest@CɋLq܂").append("\n");
		buffer.append("\n");
		buffer.append("  ").append("--status=STATUS    ").append("o͑Ώۂ̃Xe[^XJ}؂Ŏw肵܂(add/update/delete/same)").append("\n");
		buffer.append("  ").append("                   ").append("ȗꍇadd/update/deleterΏۂƂȂ܂").append("\n");
		buffer.append("  ").append("--help             ").append("̎g\ďI").append("\n");
		buffer.append("\n");
		return buffer.toString();
	}
}
