package org.phosphoresce.resourcecomp.core.session;

import java.io.Serializable;

import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainer;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainerFactory;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilterFactory;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitorFactory;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategyFactory;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriterFactory;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriterFactory;

/**
 * \[XrZbVNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class CompareSession implements Serializable {

	/** ݒIuWFNg */
	private CompareConfigure configure;

	/** r\[XRei */
	private CompareContainer container;

	/**
	 * RXgN^<br>
	 */
	public CompareSession() {
		super();
	}

	/**
	 * ݒIuWFNg擾܂B<br>
	 * @return ݒIuWFNg
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	public CompareConfigure getConfigure() throws IllegalConfigurationException {
		if (configure == null) {
			configure = new CompareConfigure();
		}
		return configure;
	}

	/**
	 * \[XRei擾܂B<br>
	 * @return \[XRei
	 * @throws IllegalConfigurationException ɃReiNXCX^X𐶐łȂꍇɔ
	 */
	public CompareContainer getContainer() throws IllegalConfigurationException {
		if (container == null) {
			CompareContainerFactory factory = new CompareContainerFactory();
			factory.setTargetClass(getConfigure().getContainerClass());
			container = factory.create(this);
		}
		return container;
	}

	/**
	 * rXgeWIuWFNg𐶐܂B<br>
	 * @return rXgeWIuWFNg
	 * @throws IllegalConfigurationException ɃNXCX^XłȂꍇɔ
	 */
	public CompareStrategy createCompareStrategy() throws IllegalConfigurationException {
		CompareStrategyFactory factory = new CompareStrategyFactory();
		factory.setTargetClass(getConfigure().getStrategyClass());
		return factory.create();
	}

	/**
	 * \[XtB^IuWFNg𐶐܂B<br>
	 * @return \[XtB^IuWFNg
	 * @throws IllegalConfigurationException ɃNXCX^XłȂꍇɔ
	 */
	public CompareResourceFilter createCompareResourceFilter() throws IllegalConfigurationException {
		CompareResourceFilterFactory factory = new CompareResourceFilterFactory();
		factory.setTargetClass(getConfigure().getFilterClass());
		return factory.create();
	}

	/**
	 * j^[IuWFNg𐶐܂B<br>
	 * @return j^[IuWFNg
	 * @throws IllegalConfigurationException ɃNXCX^XłȂꍇɔ
	 */
	public CompareMonitor createCompareMonitor() throws IllegalConfigurationException {
		CompareMonitorFactory factory = new CompareMonitorFactory();
		factory.setTargetClass(getConfigure().getMonitorClass());
		return factory.create();
	}

	/**
	 * rʏo̓IuWFNg𐶐܂B<br>
	 * @return rʏo̓IuWFNg
	 * @throws IllegalConfigurationException ɃNXCX^XłȂꍇɔ
	 */
	public ResultWriter createResultWriter() throws IllegalConfigurationException {
		ResultWriterFactory factory = new ResultWriterFactory();
		factory.setTargetClass(getConfigure().getResultWriterClass());
		return factory.create(this, getConfigure().getTargetStatus());
	}

	/**
	 * r\[Xo̓IuWFNg𐶐܂B<br>
	 * @return r\[Xo̓IuWFNg
	 * @throws IllegalConfigurationException ɃNXCX^XłȂꍇɔ
	 */
	public ResourceWriter createResourceWriter() throws IllegalConfigurationException {
		ResourceWriterFactory factory = new ResourceWriterFactory();
		factory.setTargetClass(getConfigure().getResourceWriterClass());
		return factory.create(this, getConfigure().getTargetStatus());
	}
}
