package org.phosphoresce.resourcecomp.core.enumeration;

import java.io.Serializable;

import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;

/**
 * \[XXe[^XNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class Status implements Serializable {

	/** Xe[^XR[h */
	private int code;

	/** Xe[^X */
	private String name;

	/** ԖݒR[h */
	private static final String NAME_UNSETTING = "Unsetting";

	/** ύXԃR[h */
	private static final String NAME_SAME = "Same";

	/** ǉԃR[h */
	private static final String NAME_ADD = "Add";

	/** ύXԃR[h */
	private static final String NAME_UPDATE = "Update";

	/** 폜ԃR[h */
	private static final String NAME_DELETE = "Delete";

	/** ԖݒR[h */
	private static final int CODE_UNSETTING = 0;

	/** ύXԃR[h */
	private static final int CODE_SAME = 1;

	/** ǉԃR[h */
	private static final int CODE_ADD = 2;

	/** ύXԃR[h */
	private static final int CODE_UPDATE = 3;

	/** 폜ԃR[h */
	private static final int CODE_DELETE = 4;

	/** Ԗݒ */
	public static final Status UNSETTING = new Status(CODE_UNSETTING, NAME_UNSETTING);

	/** ύX */
	public static final Status SAME = new Status(CODE_SAME, NAME_SAME);

	/** ǉ */
	public static final Status ADD = new Status(CODE_ADD, NAME_ADD);

	/** ύX */
	public static final Status UPDATE = new Status(CODE_UPDATE, NAME_UPDATE);

	/** 폜 */
	public static final Status DELETE = new Status(CODE_DELETE, NAME_DELETE);

	/**
	 * RXgN^<br>
	 */
	private Status() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param code Xe[^XR[h
	 * @param name Xe[^X
	 */
	private Status(int code, String name) {
		super();
		this.code = code;
		this.name = name;
	}

	/**
	 * w肳ꂽR[hXe[^X擾܂B<br>
	 * @param code R[h
	 * @return Xe[^X
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public static Status valueOf(String code) throws IllegalEnumerationException {
		if (NAME_SAME.equalsIgnoreCase(code)) {
			return SAME;
		} else if (NAME_ADD.equalsIgnoreCase(code)) {
			return ADD;
		} else if (NAME_UPDATE.equalsIgnoreCase(code)) {
			return UPDATE;
		} else if (NAME_DELETE.equalsIgnoreCase(code)) {
			return DELETE;
		} else {
			throw new IllegalEnumerationException("Illegal Code : " + code);
		}
	}

	/**
	 * w肳ꂽR[hXe[^X擾܂B<br>
	 * @param code R[h
	 * @return Xe[^X
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	public static Status valueOf(int code) throws IllegalEnumerationException {
		if (CODE_SAME == code) {
			return SAME;
		} else if (CODE_ADD == code) {
			return ADD;
		} else if (CODE_UPDATE == code) {
			return UPDATE;
		} else if (CODE_DELETE == code) {
			return DELETE;
		} else {
			throw new IllegalEnumerationException("Illegal Code : " + code);
		}
	}

	/**
	 * IuWFNgnbVR[h擾܂B<br>
	 * @return IuWFNgnbVR[h
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + code;
		return result;
	}

	/**
	 * IuWFNg̔rs܂B<br>
	 * @param object rΏۃIuWFNg
	 * @return ̏ꍇtrueԋp
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		final Status other = (Status) object;
		if (code != other.code) {
			return false;
		}
		return true;
	}

	/**
	 * IuWFNg𕶎ƂĒ񋟂܂B<br>
	 * @return IuWFNg񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return name;
	}
}
