package org.phosphoresce.resourcecomp.core;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

/**
 * \[XێReiNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public class Resource implements Serializable {

	/** ZbVIuWFNg */
	private CompareSession session;

	/** \[XXe[^X */
	private Status status;

	/** \[X^Cv */
	private Type type;

	/** r\[X */
	private File origin;

	/** r惊\[X */
	private File destination;

	/**
	 * RXgN^<br>
	 */
	private Resource() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param session ZbVIuWFNg
	 * @param type \[X^Cv
	 * @param status \[XXe[^X
	 * @param origin r\[X
	 * @param destination r惊\[X
	 */
	public Resource(CompareSession session, Type type, Status status, File origin, File destination) {
		super();
		this.session = session;
		this.type = type;
		this.status = status;
		this.origin = origin;
		this.destination = destination;
	}

	/**
	 * RXgN^<br>
	 * @param session ZbVIuWFNg
	 * @param type \[X^Cv
	 * @param origin r\[X
	 * @param destination r惊\[X
	 */
	public Resource(CompareSession session, Type type, File origin, File destination) {
		this(session, type, Status.UNSETTING, origin, destination);
	}

	/**
	 * r惊\[X擾܂B<br>
	 * @return r惊\[X
	 */
	public File getDestination() {
		return destination;
	}

	/**
	 * r\[X擾܂B<br>
	 * @return r\[X
	 */
	public File getOrigin() {
		return origin;
	}

	/**
	 * \[XXe[^X擾܂B<br>
	 * @return \[XXe[^X
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * \[X^Cv擾܂B<br>
	 * @return \[X^Cv
	 */
	public Type getType() {
		return type;
	}

	/**
	 * ^[Qbg\[X擾܂B<br>
	 * @return ^[Qbg\[X
	 */
	public String getName() {
		File target = null;
		if (status == Status.ADD) {
			target = destination;
		} else if (status == Status.ADD) {
			target = origin;
		} else if (status == Status.UPDATE) {
			target = destination;
		} else if (status == Status.SAME) {
			target = origin;
		} else {
			target = origin;
		}
		return target.getName();
	}

	/**
	 * ^[Qbg\[X̑΃pX擾܂B<br>
	 * @return ^[Qbg\[X΃pX
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public String getRelativePath() throws ResourceOperateException {
		try {
			CompareConfigure configure = session.getConfigure();
			File target = null;
			String path = "";
			if (status == Status.ADD) {
				target = destination;
				path = target.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
			} else if (status == Status.ADD) {
				target = origin;
				path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
			} else if (status == Status.UPDATE) {
				target = destination;
				path = target.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
			} else if (status == Status.SAME) {
				target = origin;
				path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
			} else {
				target = origin;
				path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
			}
			return path;
		} catch (Throwable e) {
			throw new ResourceOperateException("΃pX̎擾Ɏs܂", e);
		}
	}

	/**
	 * ^[Qbg\[X̑΃pXzŎ擾܂B<br>
	 * @return ^[Qbg\[X΃pXz
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 */
	public String[] getRelativePathArray() throws ResourceOperateException {
		String path = getRelativePath();
		List list = new LinkedList();
		for (StringTokenizer tokenizer = new StringTokenizer(path, File.separator); tokenizer.hasMoreTokens();) {
			list.add(tokenizer.nextToken());
		}
		if (type == Type.FILE) {
			list.remove(list.size() - 1);
		}
		if (type == Type.DIRECTORY) {
			list.remove(list.size() - 1);
		}
		return (String[]) list.toArray(new String[list.size()]);
	}

	/**
	 * IuWFNgnbVR[h擾܂B<br>
	 * @return IuWFNgnbVR[h
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((destination == null) ? 0 : destination.hashCode());
		result = PRIME * result + ((origin == null) ? 0 : origin.hashCode());
		result = PRIME * result + ((type == null) ? 0 : type.hashCode());
		//		result = PRIME * result + ((status == null) ? 0 : status.hashCode());
		return result;
	}

	/**
	 * IuWFNg̔rs܂B<br>
	 * @param object rΏۃIuWFNg
	 * @return ̏ꍇtrueԋp
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		final Resource other = (Resource) object;
		if (destination == null) {
			if (other.destination != null) {
				return false;
			}
		} else if (!destination.equals(other.destination)) {
			return false;
		}
		if (origin == null) {
			if (other.origin != null) {
				return false;
			}
		} else if (!origin.equals(other.origin)) {
			return false;
		}
		if (type == null) {
			if (other.type != null) {
				return false;
			}
		} else if (!type.equals(other.type)) {
			return false;
		}
		//		if (status == null) {
		//			if (other.status != null) {
		//				return false;
		//			}
		//		} else if (!status.equals(other.status)) {
		//			return false;
		//		}
		return true;
	}

	/**
	 * IuWFNg𕶎ƂĒ񋟂܂B<br>
	 * @return IuWFNg񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("Type=");
		buffer.append(type);
		buffer.append(",");
		buffer.append("Status=");
		buffer.append(status);
		buffer.append(",");
		buffer.append("Origin=");
		buffer.append(origin);
		buffer.append(",");
		buffer.append("Destination=");
		buffer.append(destination);
		buffer.append("}");
		return buffer.toString();
	}
}
