/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;
import org.phosphoresce.resourcecomp.util.StringUtil;

public final class ChainingStrategy
implements CompareStrategy {
    private List list = new LinkedList();

    public ChainingStrategy() throws IllegalConfigurationException {
        this.load();
    }

    private void load() throws IllegalConfigurationException {
        try {
            if (!new File("rcomp-chaining-strategy.properties").exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream("rcomp-chaining-strategy.properties");
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("classes");
            value = value.replaceAll("\\n\\r", "");
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (StringUtil.isEmpty(token)) continue;
                this.add(Class.forName(token));
            }
            stream.close();
        }
        catch (Throwable e) {
            throw new IllegalConfigurationException("\u6b63\u5e38\u306b\u74b0\u5883\u8a2d\u5b9a\u3092\u884c\u3046\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public void add(CompareStrategy strategy) {
        if (!this.list.contains(strategy)) {
            this.list.add(strategy);
        }
    }

    public void add(Class strategy) throws IllegalConfigurationException {
        try {
            Constructor constructor = strategy.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            if (!(object instanceof CompareStrategy)) {
                throw new IllegalConfigurationException("\u6bd4\u8f03\u30b9\u30c8\u30e9\u30c6\u30b8\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u3092\u6301\u305f\u306a\u3044\u30af\u30e9\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
            }
            if (!this.list.contains(object)) {
                this.list.add(object);
            }
        }
        catch (Throwable e) {
            throw new IllegalConfigurationException("\u6bd4\u8f03\u30b9\u30c8\u30e9\u30c6\u30b8\u30af\u30e9\u30b9\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public void remove(CompareStrategy strategy) {
        if (this.list.contains(strategy)) {
            this.list.remove(strategy);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public Status compare(File origin, File destination) throws CompareException {
        if (this.list.size() <= 0) {
            throw new CompareException("\u6bd4\u8f03\u30b9\u30c8\u30e9\u30c6\u30b8\u304c1\u3064\u3082\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Status status = Status.SAME;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            CompareStrategy strategy = (CompareStrategy)iterator.next();
            Status result = strategy.compare(origin, destination);
            if (status != Status.SAME) continue;
            status = result;
        }
        return status;
    }
}

