/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.strategy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.CRC32;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareAbstractStrategy;

public class CRC32CompareStrategy
extends CompareAbstractStrategy {
    protected boolean isUpdate(File origin, File destination) throws CompareException {
        long destinationCrc;
        long originCrc = this.getChecksum(origin);
        return originCrc != (destinationCrc = this.getChecksum(destination));
    }

    private long getChecksum(File file) throws CompareException {
        CRC32 crc = new CRC32();
        try {
            int size;
            if (file == null || file.isDirectory()) {
                return -1L;
            }
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[2048];
            while ((size = stream.read(buffer, 0, buffer.length)) != -1) {
                crc.update(buffer, 0, size);
            }
            stream.close();
            return crc.getValue();
        }
        catch (Throwable e) {
            throw new CompareException("CRC32\u30c1\u30a7\u30c3\u30af\u30b5\u30e0\u7b97\u51fa\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }
}

