/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.cui;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.phosphoresce.resourcecomp.core.CompareExecuter;
import org.phosphoresce.resourcecomp.core.Comparerator;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

public class CUIExecuter
extends CompareExecuter {
    private String origin;
    private String destination;
    private String resource;
    private String result;
    private Status[] status;

    public void execute(String[] args, CompareSession session) throws Throwable {
        this.validateArgument(args);
        CompareConfigure configure = session.getConfigure();
        configure.setOrigin(this.origin);
        configure.setDestination(this.destination);
        configure.setResultWritePath(this.result);
        configure.setResourceWritePath(this.resource);
        configure.setTargetStatus(this.status);
        Comparerator comparerator = new Comparerator(session);
        comparerator.start();
        while (comparerator.isAlive()) {
        }
    }

    private void validateArgument(String[] args) throws IllegalEnumerationException, ResourceOperateException {
        if (args == null || args.length < 4 || this.isHelpCommand(args)) {
            System.out.println(this.createHelp());
            System.exit(0);
        }
        this.origin = this.getOriginPath(args);
        this.destination = this.getDestinationPath(args);
        this.resource = this.getResourcePath(args);
        this.result = this.getResultPath(args);
        this.status = this.getStauts(args);
        File originFile = new File(this.origin);
        if (originFile.exists() && !originFile.isDirectory()) {
            throw new ResourceOperateException("\u6bd4\u8f03\u5143\u30d1\u30b9\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        File destinationFile = new File(this.destination);
        if (destinationFile.exists() && !destinationFile.isDirectory()) {
            throw new ResourceOperateException("\u6bd4\u8f03\u5148\u30d1\u30b9\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        File resourceFile = new File(this.resource);
        if (resourceFile.exists() && !resourceFile.isDirectory()) {
            throw new ResourceOperateException("\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u5148\u306b\u65e2\u5b58\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        File resultFile = new File(this.resource);
        if (resultFile.exists() && !resultFile.isFile()) {
            throw new ResourceOperateException("\u6bd4\u8f03\u7d50\u679c\u51fa\u529b\u5148\u306b\u65e2\u5b58\u306e\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u306a\u3044\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
    }

    private boolean isHelpCommand(String[] args) {
        if (args == null || args.length < 1) {
            return true;
        }
        for (int i = 0; i <= args.length - 1; ++i) {
            if (!"--help".equals(args[i])) continue;
            return true;
        }
        return false;
    }

    private String getOriginPath(String[] args) {
        if (args == null || args.length < 1) {
            return "";
        }
        return args[0];
    }

    private String getDestinationPath(String[] args) {
        if (args == null || args.length < 2) {
            return "";
        }
        return args[1];
    }

    private String getResourcePath(String[] args) {
        if (args == null || args.length < 3) {
            return "";
        }
        return args[2];
    }

    private String getResultPath(String[] args) {
        if (args == null || args.length < 4) {
            return "";
        }
        return args[3];
    }

    private Status[] getStauts(String[] args) throws IllegalEnumerationException {
        Status[] DEFAULT_STATUS = new Status[]{Status.ADD, Status.UPDATE, Status.DELETE};
        String WARNING = "\u8b66\u544a : \u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u8ffd\u52a0/\u66f4\u65b0/\u524a\u9664\u3092\u5bfe\u8c61\u3068\u3057\u307e\u3059\u3002";
        HashMap map = new HashMap();
        if (args == null || args.length < 5) {
            System.out.println("\u8b66\u544a : \u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u8ffd\u52a0/\u66f4\u65b0/\u524a\u9664\u3092\u5bfe\u8c61\u3068\u3057\u307e\u3059\u3002");
            return DEFAULT_STATUS;
        }
        LinkedList<Status> list = new LinkedList<Status>();
        for (int i = 4; i <= args.length - 1; ++i) {
            if (!args[i].startsWith("--status=")) continue;
            String pattern = args[i].substring("--status=".length());
            StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                list.add(Status.valueOf(token));
            }
        }
        if (list.size() == 0) {
            System.out.println("\u8b66\u544a : \u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u8ffd\u52a0/\u66f4\u65b0/\u524a\u9664\u3092\u5bfe\u8c61\u3068\u3057\u307e\u3059\u3002");
            return DEFAULT_STATUS;
        }
        return list.toArray(new Status[list.size()]);
    }

    private String createHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u4f7f\u7528\u65b9\u6cd5: rcomp [\u6bd4\u8f03\u5143\u30c7\u30a3\u30ec\u30af\u30c8\u30ea] [\u6bd4\u8f03\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea] [\u6bd4\u8f03\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u30d1\u30b9] [\u6bd4\u8f03\u7d50\u679c\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u30d1\u30b9] [\u30aa\u30d7\u30b7\u30e7\u30f3]...").append("\n");
        buffer.append("\n");
        buffer.append("\u3053\u3053\u3067\u6307\u5b9a\u3067\u304d\u308b\u30aa\u30d7\u30b7\u30e7\u30f3\u4ee5\u5916\u306e\u8a2d\u5b9a\u306b\u3064\u3044\u3066\u306f\u5404\u30b9\u30c8\u30e9\u30c6\u30b8\u30d7\u30e9\u30b0\u30a4\u30f3\u306eProperties\u30d5\u30a1\u30a4\u30eb\u306b\u8a18\u8ff0\u3057\u307e\u3059").append("\n");
        buffer.append("\n");
        buffer.append("  ").append("--status=STATUS    ").append("\u51fa\u529b\u5bfe\u8c61\u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u3092\u30ab\u30f3\u30de\u533a\u5207\u308a\u3067\u6307\u5b9a\u3057\u307e\u3059(add/update/delete/same)").append("\n");
        buffer.append("  ").append("                   ").append("\u7701\u7565\u3057\u305f\u5834\u5408\u306fadd/update/delete\u304c\u6bd4\u8f03\u5bfe\u8c61\u3068\u306a\u308a\u307e\u3059").append("\n");
        buffer.append("  ").append("--help             ").append("\u3053\u306e\u4f7f\u3044\u65b9\u3092\u8868\u793a\u3057\u3066\u7d42\u4e86").append("\n");
        buffer.append("\n");
        return buffer.toString();
    }
}

