/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core;

import java.io.File;
import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.ExceptionHandler;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainer;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriter;
import org.phosphoresce.resourcecomp.util.FileUtil;

public final class Comparerator
extends Thread {
    private CompareSession session;
    private CompareStrategy strategy;
    private CompareResourceFilter filter;
    private CompareMonitor monitor;
    private ResultWriter resultWriter;
    private ResourceWriter resourceWriter;
    private long size;
    private long counter;

    private Comparerator() {
    }

    public Comparerator(CompareSession session) {
        this.session = session;
    }

    public CompareSession getContainer() {
        return this.session;
    }

    public void setContainer(CompareSession session) {
        this.session = session;
    }

    public void run() {
        try {
            this.execute();
        }
        catch (Throwable e) {
            new ExceptionHandler(e).execute();
        }
    }

    private void countTargetResources(File file) throws CompareException, IllegalConfigurationException {
        if (this.monitor != null) {
            this.monitor.counting(this.session, this.size);
        }
        if (file == null || !file.exists()) {
            this.size += 0L;
        }
        if (file.isFile()) {
            ++this.size;
        } else if (file.isDirectory()) {
            ++this.size;
            File[] files = file.listFiles();
            for (int i = 0; i <= files.length - 1; ++i) {
                this.countTargetResources(files[i]);
            }
        }
        if (this.monitor != null) {
            this.monitor.counting(this.session, this.size);
        }
    }

    private void execute() throws CompareException, IllegalConfigurationException, ResourceOperateException, IllegalEnumerationException {
        this.strategy = this.session.createCompareStrategy();
        this.filter = this.session.createCompareResourceFilter();
        this.monitor = this.session.createCompareMonitor();
        this.resultWriter = this.session.createResultWriter();
        this.resourceWriter = this.session.createResourceWriter();
        if (this.monitor != null) {
            this.monitor.start(this.session);
        }
        if (this.monitor != null) {
            this.monitor.startCounting(this.session);
        }
        this.size = 0L;
        this.counter = 0L;
        this.countTargetResources(this.session.getConfigure().getOrigin());
        this.countTargetResources(this.session.getConfigure().getDestination());
        if (this.monitor != null) {
            this.monitor.finishCounting(this.session, this.size);
        }
        if (this.monitor != null) {
            this.monitor.startComparing(this.session, this.size);
        }
        this.compareFiles(FileUtil.getFiles(this.session.getConfigure().getOrigin()), FileUtil.getFiles(this.session.getConfigure().getDestination()));
        this.compareDirectories(FileUtil.getDirectories(this.session.getConfigure().getOrigin()), FileUtil.getDirectories(this.session.getConfigure().getDestination()));
        if (this.monitor != null) {
            this.monitor.finishComparing(this.session, this.size);
        }
        if (this.monitor != null) {
            this.monitor.startResultWriting(this.session);
        }
        Thread resultWriterThread = new Thread(this.resultWriter);
        resultWriterThread.start();
        while (resultWriterThread.isAlive()) {
            if (this.monitor == null) continue;
            this.monitor.resultWriting(this.session, this.resultWriter.getCount(), this.resultWriter.getSize());
        }
        if (this.monitor != null) {
            this.monitor.finishResultWriting(this.session);
        }
        if (this.monitor != null) {
            this.monitor.startResourceWriting(this.session);
        }
        Thread resourceWriterThread = new Thread(this.resourceWriter);
        resourceWriterThread.start();
        while (resourceWriterThread.isAlive()) {
            if (this.monitor == null) continue;
            this.monitor.resourceWriting(this.session, this.resourceWriter.getCount(), this.resourceWriter.getSize());
        }
        if (this.monitor != null) {
            this.monitor.finishResourceWriting(this.session);
        }
        if (this.monitor != null) {
            this.monitor.finish(this.session);
        }
    }

    private void compareFiles(File[] origins, File[] destinations) throws CompareException, IllegalConfigurationException {
        try {
            CompareContainer container = this.session.getContainer();
            if (origins == null) {
                for (int i = 0; i <= destinations.length - 1; ++i) {
                    if (this.filter != null && !this.filter.accept(destinations[i])) continue;
                    container.add(new Resource(this.session, Type.FILE, Status.ADD, null, destinations[i]));
                }
            } else if (destinations == null) {
                for (int i = 0; i <= origins.length - 1; ++i) {
                    if (this.filter != null && !this.filter.accept(origins[i])) continue;
                    container.add(new Resource(this.session, Type.FILE, Status.DELETE, origins[i], null));
                }
            } else {
                Resource resource;
                Status status;
                boolean searchedSame;
                int i;
                for (i = 0; i <= origins.length - 1; ++i) {
                    Resource resource2;
                    if (this.filter != null && !this.filter.accept(origins[i])) continue;
                    searchedSame = false;
                    File origin = origins[i];
                    String originName = origin.getCanonicalPath();
                    originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
                    originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
                    for (int j = 0; j <= destinations.length - 1; ++j) {
                        File destination = destinations[j];
                        String destinationName = destination.getCanonicalPath();
                        destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
                        if (!originName.equals(destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1))) continue;
                        if (this.monitor != null) {
                            this.monitor.comparing(this.session, origin, destination, true, ++this.counter, this.size);
                        }
                        if (!container.contains(new Resource(this.session, Type.FILE, origin, destination))) {
                            status = this.strategy.compare(origin, destination);
                            resource = new Resource(this.session, Type.FILE, status, origin, destination);
                            container.add(resource);
                        }
                        searchedSame = true;
                    }
                    if (searchedSame || container.contains(resource2 = new Resource(this.session, Type.FILE, Status.DELETE, origin, null))) continue;
                    container.add(resource2);
                }
                for (i = 0; i <= destinations.length - 1; ++i) {
                    Resource resource3;
                    if (this.filter != null && !this.filter.accept(destinations[i])) continue;
                    searchedSame = false;
                    File destination = destinations[i];
                    String destinationName = destination.getCanonicalPath();
                    destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
                    destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
                    for (int j = 0; j <= origins.length - 1; ++j) {
                        File origin = origins[j];
                        String originName = origin.getCanonicalPath().substring(origin.getCanonicalPath().lastIndexOf(File.separator) + 1);
                        originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
                        if (!(originName = originName.substring(originName.lastIndexOf(File.separator) + 1)).equals(destinationName)) continue;
                        if (this.monitor != null) {
                            this.monitor.comparing(this.session, origin, destination, false, ++this.counter, this.size);
                        }
                        if (!container.contains(new Resource(this.session, Type.FILE, origin, destination))) {
                            status = this.strategy.compare(origin, destination);
                            resource = new Resource(this.session, Type.FILE, status, origin, destination);
                            container.add(resource);
                        }
                        searchedSame = true;
                    }
                    if (searchedSame || container.contains(resource3 = new Resource(this.session, Type.FILE, Status.ADD, null, destination))) continue;
                    container.add(resource3);
                }
            }
        }
        catch (Throwable e) {
            throw new CompareException("\u30ea\u30bd\u30fc\u30b9\u6bd4\u8f03\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    private void compareDirectories(File[] origins, File[] destinations) throws CompareException, IllegalConfigurationException {
        try {
            CompareContainer container = this.session.getContainer();
            if (origins == null) {
                for (int i = 0; i <= destinations.length - 1; ++i) {
                    if (this.filter != null && !this.filter.accept(destinations[i])) continue;
                    File destination = destinations[i];
                    container.add(new Resource(this.session, Type.DIRECTORY, Status.ADD, null, destination));
                    if (!destination.isDirectory()) continue;
                    this.compareFiles(null, FileUtil.getFiles(destination));
                    this.compareDirectories(null, FileUtil.getDirectories(destination));
                }
            } else if (destinations == null) {
                for (int i = 0; i <= origins.length - 1; ++i) {
                    if (this.filter != null && !this.filter.accept(origins[i])) continue;
                    File origin = origins[i];
                    container.add(new Resource(this.session, Type.DIRECTORY, Status.DELETE, origin, null));
                    if (!origin.isDirectory()) continue;
                    this.compareFiles(FileUtil.getFiles(origin), null);
                    this.compareDirectories(FileUtil.getDirectories(origin), null);
                }
            } else {
                Resource resource;
                Status status;
                boolean searchedSame;
                int i;
                for (i = 0; i <= origins.length - 1; ++i) {
                    Resource resource2;
                    if (this.filter != null && !this.filter.accept(origins[i])) continue;
                    searchedSame = false;
                    File origin = origins[i];
                    String originName = origin.getCanonicalPath();
                    originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
                    originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
                    for (int j = 0; j <= destinations.length - 1; ++j) {
                        File destination = destinations[j];
                        String destinationName = destination.getCanonicalPath().substring(destination.getCanonicalPath().lastIndexOf(File.separator) + 1);
                        destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
                        if (!originName.equals(destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1))) continue;
                        if (this.monitor != null) {
                            this.monitor.comparing(this.session, origin, destination, true, ++this.counter, this.size);
                        }
                        if (!container.contains(new Resource(this.session, Type.DIRECTORY, origin, destination))) {
                            status = this.strategy.compare(origin, destination);
                            resource = new Resource(this.session, Type.DIRECTORY, status, origin, destination);
                            container.add(resource);
                            this.compareFiles(FileUtil.getFiles(origin), FileUtil.getFiles(destination));
                            this.compareDirectories(FileUtil.getDirectories(origin), FileUtil.getDirectories(destination));
                        }
                        searchedSame = true;
                    }
                    if (searchedSame || container.contains(resource2 = new Resource(this.session, Type.DIRECTORY, Status.DELETE, origin, null))) continue;
                    container.add(resource2);
                    this.compareFiles(FileUtil.getFiles(origin), null);
                    this.compareDirectories(FileUtil.getDirectories(origin), null);
                }
                for (i = 0; i <= destinations.length - 1; ++i) {
                    Resource resource3;
                    if (this.filter != null && !this.filter.accept(destinations[i])) continue;
                    searchedSame = false;
                    File destination = destinations[i];
                    String destinationName = destination.getCanonicalPath();
                    destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
                    destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
                    for (int j = 0; j <= origins.length - 1; ++j) {
                        File origin = origins[j];
                        String originName = origin.getCanonicalPath().substring(origin.getCanonicalPath().lastIndexOf(File.separator) + 1);
                        originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
                        if (!(originName = originName.substring(originName.lastIndexOf(File.separator) + 1)).equals(destinationName)) continue;
                        if (this.monitor != null) {
                            this.monitor.comparing(this.session, origin, destination, false, ++this.counter, this.size);
                        }
                        if (!container.contains(new Resource(this.session, Type.DIRECTORY, origin, destination))) {
                            status = this.strategy.compare(origin, destination);
                            resource = new Resource(this.session, Type.DIRECTORY, status, origin, destination);
                            container.add(resource);
                            this.compareFiles(FileUtil.getFiles(origin), FileUtil.getFiles(destination));
                            this.compareDirectories(FileUtil.getDirectories(origin), FileUtil.getDirectories(destination));
                        }
                        searchedSame = true;
                    }
                    if (searchedSame || container.contains(resource3 = new Resource(this.session, Type.DIRECTORY, Status.ADD, null, destination))) continue;
                    container.add(resource3);
                    this.compareFiles(null, FileUtil.getFiles(destination));
                    this.compareDirectories(null, FileUtil.getDirectories(destination));
                }
            }
        }
        catch (Throwable e) {
            throw new CompareException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u6bd4\u8f03\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

