package org.phosphoresce.resourcecomp.plugin.writer;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.util.FileUtil;

/**
 * \[XrCVSo̓NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/10	Kitagawa		VK쐬
 *-->
 */
public final class ResultCVSWriter extends ResultAbstractWriter {

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 * @param status o͑ΏۃXe[^X
	 */
	public ResultCVSWriter(CompareSession session, Status[] status) {
		super(session, status);
	}

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 */
	public ResultCVSWriter(CompareSession session) {
		super(session);
	}

	/**
	 * w肳ꂽt@CɃ\[Xrʂo͂܂B<br>
	 * @throws CompareException ɏo͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.writer.ResultAbstractWriter#write()
	 */
	public void write() throws CompareException {
		try {
			CompareConfigure configure = session.getConfigure();
			FileUtil.getFilePath(configure.getResultWritePath()).mkdirs();
			OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(configure.getResultWritePath()));

			writer.write("Xe[^X");
			writer.write(",");
			writer.write("\[X");
			writer.write(",");
			writer.write("TCY");
			writer.write(",");
			writer.write("XV");
			writer.write("\n");

			List targets = session.getContainer().getResourceList(status);
			size = targets.size();
			count = 0;

			for (Iterator iterator = targets.iterator(); iterator.hasNext();) {
				Resource resource = (Resource) iterator.next();

				count++;

				String path = "";
				String size = "";
				String date = "";

				if (resource.getStatus() == Status.ADD) {
					path = resource.getDestination().getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
					size = String.valueOf(resource.getDestination().length());
					date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getDestination().lastModified()));
				} else if (resource.getStatus() == Status.DELETE) {
					path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
					size = String.valueOf(resource.getOrigin().length());
					date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
				} else if (resource.getStatus() == Status.UPDATE) {
					path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
					size = String.valueOf(resource.getOrigin().length());
					date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
				} else if (resource.getStatus() == Status.SAME) {
					path = resource.getOrigin().getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
					size = String.valueOf(resource.getOrigin().length());
					date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(resource.getOrigin().lastModified()));
				} else {
					continue;
				}

				Status[] status = configure.getTargetStatus();
				boolean validate = false;
				for (int i = 0; i <= status.length - 1; i++) {
					if (resource.getStatus() == status[i]) {
						validate = true;
						break;
					}
				}

				if (validate) {
					writer.write(resource.getStatus().toString());
					writer.write(",");
					writer.write(path);
					writer.write(",");
					writer.write(size);
					writer.write(",");
					writer.write(date);
					writer.write("\n");
				}

				writer.flush();
			}

			writer.close();
		} catch (Throwable e) {
			throw new CompareException("rʏo͒ɗ\ʗO܂", e);
		}
	}
}
