package org.phosphoresce.resourcecomp.plugin.filter;

import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.phosphoresce.resourcecomp.util.StringUtil;

/**
 * \[XtB^NX<br>
 * <br>
 * NX͎spXrcomp-ignore-filter.properties݂ꍇANXꂽ^C~O
 * Propertiest@Cɒ`ĂŃNX܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public class ResourceIgnoreFilter implements CompareResourceFilter {

	/** }b` */
	private List values;

	/** K\tO */
	private List regexps;

	/**
	 * RXgN^<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	public ResourceIgnoreFilter() throws IllegalConfigurationException {
		super();
		this.values = new LinkedList();
		this.regexps = new LinkedList();
		load();
	}

	/**
	 * vpeBt@Cݒǂݍ݂܂B<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	private void load() throws IllegalConfigurationException {
		try {
			if (!new File("rcomp-ignore-filter.properties").exists()) {
				return;
			}
			FileInputStream stream = new FileInputStream("rcomp-ignore-filter.properties");
			Properties properties = new Properties();
			properties.load(stream);
			String value = properties.getProperty("value");
			value = value.replaceAll("\\n\\r", "");
			for (StringTokenizer tokenizer = new StringTokenizer(value, ","); tokenizer.hasMoreTokens();) {
				String token = tokenizer.nextToken().trim();
				if (!StringUtil.isEmpty(token)) {
					String ignore = token.indexOf("/") >= 0 ? token.substring(0, token.indexOf("/")) : token;
					boolean regexp = token.indexOf("/") >= 0 ? Boolean.getBoolean(token.substring(token.indexOf("/") + 1)) : false;
					add(ignore, regexp);
				}
			}
			stream.close();
		} catch (Throwable e) {
			throw new IllegalConfigurationException("ɊݒsƂo܂ł", e);
		}
	}

	/**
	 * \[Xǉ܂B<br>
	 * @param value 
	 * @param regexp w肷镶񂪐K\̏ꍇtruew
	 */
	public void add(String value, boolean regexp) {
		values.add(value);
		regexps.add(new Boolean(regexp));
	}

	/**
	 * w肳ꂽt@CIuWFNgΏۂł邩肵܂B<br>
	 * @param file Ώۃt@CIuWFNg
	 * @return Ώۂłꍇtrueԋp
	 * @throws ResourceOperateException Ƀ\[XIuWFNgւ̃ANZXsȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter#accept(java.io.File)
	 */
	public boolean accept(File file) throws ResourceOperateException {
		try {
			for (int i = 0; i <= values.size() - 1; i++) {
				String value = (String) values.get(i);
				boolean regexp = ((Boolean) regexps.get(i)).booleanValue();
				boolean match = false;
				if (regexp) {
					match = file.getCanonicalPath().matches(value);
				} else {
					match = file.getCanonicalPath().indexOf(value) >= 0;
				}
				if (match) {
					return false;
				}
			}
			return true;
		} catch (Throwable e) {
			throw new ResourceOperateException("t@CpXANZXɗ\ʗO܂", e);
		}
	}
}
