package org.phosphoresce.resourcecomp.plugin.container;

import java.io.File;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * \[XrhLgIuWFNgfReiNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/10	Kitagawa		VK쐬
 *-->
 */
public final class CompareDOMContainer extends CompareAbstractContainer {

	/** hLgIuWFNg */
	private Document document;

	/** [gGg */
	private Element root;

	/** gXtH[}IuWFNg */
	private Transformer transformer;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 * @throws ResourceOperateException ɃNX̏sȂꍇɔ
	 */
	public CompareDOMContainer(CompareSession session) throws ResourceOperateException {
		super(session);
	}

	// Override Methods

	/**
	 * NX܂B<br>
	 * @throws ResourceOperateException ɃNX̏sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#init()
	 */
	protected void init() throws ResourceOperateException {
		try {
			// DocumentBuilderCX^X
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

			// NXtB[h
			this.document = builder.newDocument();
			this.root = this.document.createElement("resources");
			this.document.appendChild(root);
		} catch (Throwable e) {
			throw new ResourceOperateException("hLgIuWFNgɎs܂", e);
		}
	}

	/**
	 * \[Xǉ܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareContainer#add(org.phosphoresce.resourcecomp.core.Resource)
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#add(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public void add(Resource resource) throws ResourceOperateException {
		Element parent = findDirectoryElement(resource.getRelativePathArray());
		if (resource.getType() == Type.DIRECTORY) {
			parent.appendChild(createDirectoryElement(resource));
		} else if (resource.getType() == Type.FILE) {
			parent.appendChild(createResrouceElement(resource));
		} else {
			throw new ResourceOperateException("sȃ\[X^Cvw肳܂[" + resource.getType() + "]");
		}
	}

	/**
	 * w肳ꂽ\[X폜܂B<br>
	 * @param resource \[XIuWFNg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#remove(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public void remove(Resource resource) throws ResourceOperateException {
		Element parent = findDirectoryElement(resource.getRelativePathArray());
		NodeList list = parent.getChildNodes();
		for (int i = 0; i <= list.getLength() - 1; i++) {
			Element element = (Element) list.item(i);
			if ("resource".equals(element.getTagName()) && resource.getName().equals(element.getAttribute("name"))) {
				parent.removeChild(element);
				break;
			}
		}
	}

	/**
	 * w肳ꂽ\[XXg폜܂B<br>
	 * @param collection 폜Ώۃ\[XXg
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#removeAll(java.util.Collection)
	 */
	public void removeAll(Collection collection) throws ResourceOperateException {
		for (Iterator iterator = collection.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object instanceof Resource) {
				Resource resource = (Resource) object;
				remove(resource);
			}
		}
	}

	/**
	 * w肳ꂽrς݃\[XɕێĂ邩肵܂B<br>
	 * @param resource rς݃\[X
	 * @return rς݃\[XɕێĂꍇtrueԋp
	 * @throws ResourceOperateException ɑ΃pX̉͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#contains(org.phosphoresce.resourcecomp.core.Resource)
	 */
	public boolean contains(Resource resource) throws ResourceOperateException {
		Element parent = findDirectoryElement(resource.getRelativePathArray());
		NodeList list = parent.getChildNodes();
		for (int i = 0; i <= list.getLength() - 1; i++) {
			Element element = (Element) list.item(i);
			if ("resource".equals(element.getTagName()) && resource.getName().equals(element.getAttribute("name"))) {
				return true;
			}
			if ("directory".equals(element.getTagName()) && resource.getName().equals(element.getAttribute("name"))) {
				return true;
			}
		}
		return false;
	}

	/**
	 * \[XXg擾܂B<br>
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#getResourceList()
	 */
	public List getResourceList() throws IllegalEnumerationException {
		return getResourceList(root, null);
	}

	/**
	 * w肳ꂽXe[^X̃\[XXg擾܂B<br>
	 * @param status Xe[^XXg
	 * @return \[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer#getResourceList(org.phosphoresce.resourcecomp.core.enumeration.Status[])
	 */
	public List getResourceList(Status[] status) throws IllegalEnumerationException {
		return getResourceList(root, status);
	}

	// Private Methods

	/**
	 * w肵eGgێ郊\[XXg擾܂B<br>
	 * @param parent eGg
	 * @return eGgێ郊\[XXg
	 * @throws IllegalEnumerationException sȗ񋓌^R[hw肳ꂽꍇɔ
	 */
	private List getResourceList(Element parent, Status[] status) throws IllegalEnumerationException {
		List list = new LinkedList();
		NodeList nodes = parent.getChildNodes();
		for (int i = 0; i <= nodes.getLength() - 1; i++) {
			Element element = (Element) nodes.item(i);
			if ("resource".equals(element.getTagName())) {
				Resource resource = new Resource( //
						session, //
						Type.FILE, //
						Status.valueOf(element.getAttribute("status")), //
						new File(element.getAttribute("origin")), //
						new File(element.getAttribute("destination")) //
				);
				if (status == null) {
					list.add(resource);
				} else {
					for (int j = 0; j <= status.length - 1; j++) {
						if (status[j] == resource.getStatus()) {
							list.add(resource);
							break;
						}
					}
				}
			} else if ("directory".equals(element.getTagName())) {
				list.addAll(getResourceList(element, status));
			}
		}
		return list;
	}

	/**
	 * w肳ꂽpXKwz̍Œ[Element擾܂B<br>
	 * @param paths pXKwz
	 * @return pXKwz̍Œ[Element
	 */
	private Element findDirectoryElement(String[] paths) {
		Element parent = root;
		for (int i = 0; i <= paths.length - 1; i++) {
			String path = paths[i];
			parent = findDirectoryElement(parent, path);
		}
		return parent;
	}

	/**
	 * w肳ꂽeElementێpXElement擾܂B<br>
	 * @param parent eElement
	 * @param path ΏۃpX
	 * @return eElementێpXElement
	 */
	private Element findDirectoryElement(Element parent, String path) {
		NodeList list = parent.getChildNodes();
		for (int i = 0; i <= list.getLength() - 1; i++) {
			if (list.item(i) instanceof Element) {
				Element element = (Element) list.item(i);
				if ("directory".equals(element.getTagName())) {
					if (path.equals(element.getAttribute("name"))) {
						return element;
					}
				}
			}
		}
		return (Element) parent.appendChild(createDirectoryElement(path));
	}

	/**
	 * w肳ꂽpX̃fBNgElement𐶐܂B<br>
	 * @param path fBNgpX
	 * @return fBNgElement
	 */
	private Element createDirectoryElement(String path) {
		Element element = document.createElement("directory");
		element.setAttribute("name", path);
		return element;
	}

	/**
	 * w肳ꂽ\[X̃fBNgElement𐶐܂B<br>
	 * @param resource fBNgpX
	 * @return fBNgElement
	 */
	private Element createDirectoryElement(Resource resource) {
		return createDirectoryElement(resource.getName());
	}

	/**
	 * w肳ꂽ\[X̃\[XElement𐶐܂B<br>
	 * @param resource Ώۃ\[XIuWFNg
	 * @return \[XElement
	 * @throws ResourceOperateException Ƀ\[XIuWFNgւ̃ANZXsȂꍇɔ
	 */
	private Element createResrouceElement(Resource resource) throws ResourceOperateException {
		try {
			Status status = resource.getStatus();
			String name = "";
			if (status == Status.ADD) {
				name = resource.getDestination().getName();
			} else if (status == Status.DELETE) {
				name = resource.getOrigin().getName();
			} else if (status == Status.UPDATE) {
				name = resource.getOrigin().getName();
			} else if (status == Status.SAME) {
				name = resource.getOrigin().getName();
			} else {
				name = resource.getOrigin().getName();
			}
			Element element = document.createElement("resource");
			element.setAttribute("name", name);
			element.setAttribute("status", status.toString());
			element.setAttribute("origin", resource.getOrigin() == null ? "" : resource.getOrigin().getCanonicalPath());
			element.setAttribute("destination", resource.getDestination() == null ? "" : resource.getDestination().getCanonicalPath());
			return element;
		} catch (Throwable e) {
			throw new ResourceOperateException("\[XANZXɗ\ʗO܂", e);
		}
	}

	/**
	 * IuWFNg𕶎ƂĒ񋟂܂B<br>
	 * @return IuWFNg񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		try {
			CompareConfigure configure = session.getConfigure();
			StringWriter writer = new StringWriter();
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/org/phosphoresce/resourcecomp/resource/xmlxslt.xsl")));
			transformer.setOutputProperty("encoding", configure.getEncoding());
			transformer.transform(new DOMSource(document), new StreamResult(writer));
			return writer.toString();
		} catch (Throwable e) {
			StringBuffer buffer = new StringBuffer();
			buffer.append(e.getClass().getName());
			buffer.append(": ");
			buffer.append(e.getLocalizedMessage());
			buffer.append("\n");
			StackTraceElement[] elements = e.getStackTrace();
			for (int i = 0; i <= elements.length - 1; i++) {
				StackTraceElement element = elements[i];
				buffer.append("\t");
				buffer.append("at ");
				buffer.append(element.getClassName());
				buffer.append(".");
				buffer.append(element.getMethodName());
				buffer.append("(");
				buffer.append(element.getFileName());
				buffer.append(":");
				buffer.append(element.getLineNumber());
				buffer.append(")");
				buffer.append("\n");
			}
			return buffer.toString();
		}
	}
}
