package org.phosphoresce.resourcecomp.plugin.writer;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.ExceptionHandler;

/**
 * \[Xrʏo͏ʒۃNX<br>
 * ۉNXJava ReflectioñCX^Xs߂ɁA
 * KpublicȃfBtHgRXgN^݂ĉB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/13	Kitagawa		VK쐬
 *-->
 */
public abstract class ResultAbstractWriter implements ResultWriter {

	/** \[XrZbV */
	protected CompareSession session;

	/** o͑ΏۃXe[^X */
	protected Status[] status;

	/** Ŝ̃\[Xrʏo͐ */
	protected long size = 0;

	/** o͏̃JEg */
	protected long count = 0;

	/**
	 * RXgN^<br>
	 */
	private ResultAbstractWriter() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 * @param status o͑ΏۃXe[^X
	 */
	public ResultAbstractWriter(CompareSession session, Status[] status) {
		super();
		this.session = session;
		this.status = status;
	}

	/**
	 * RXgN^<br>
	 * @param session \[XrZbV
	 */
	public ResultAbstractWriter(CompareSession session) {
		super();
		this.session = session;
		this.status = null;
	}

	/**
	 * s܂B<br>
	 * @see java.lang.Thread#run()
	 */
	public final void run() {
		try {
			write();
		} catch (CompareException e) {
			new ExceptionHandler(e).execute();
		}
	}

	/**
	 * Ŝ̃\[Xrʏo͐擾܂B<br>
	 * @return Ŝ̃\[Xrʏo͐
	 * @see org.phosphoresce.resourcecomp.plugin.writer.ResultWriter#getSize()
	 */
	public long getSize() {
		return size;
	}

	/**
	 * o͏̃JEg擾܂B<br>
	 * @return o͏̃JEg
	 * @see org.phosphoresce.resourcecomp.plugin.writer.ResultWriter#getCount()
	 */
	public long getCount() {
		return count;
	}

	/**
	 * \[Xrʂo͂܂B<br>
	 * @throws CompareException ɏo͂sȂꍇɔ
	 * @see org.phosphoresce.resourcecomp.plugin.writer.ResultWriter#write()
	 */
	public abstract void write() throws CompareException;
}
