package org.phosphoresce.resourcecomp.plugin.monitor;

import java.io.File;

import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;

/**
 * r󋵃j^[C^tF[X<br>
 * ۉNXJava ReflectioñCX^Xs߂ɁA
 * KpublicȃfBtHgRXgN^݂ĉB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public interface CompareMonitor {

	/**
	 * JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void start(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * Ώۃ\[X̃JEgJnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startCounting(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * Ώۃ\[X̃JEgɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̃JEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void counting(CompareSession session, long count) throws CompareException, IllegalConfigurationException;

	/**
	 * Ώۃ\[X̃JEgۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size JEgꂽΏۃ\[X
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishCounting(CompareSession session, long size) throws CompareException, IllegalConfigurationException;

	/**
	 * rJnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size rΏۃ\[X
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException;

	/**
	 * rsɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param origin r\[X
	 * @param destination r惊\[X
	 * @param originCompare rx[XƂrtruew肳܂
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void comparing(CompareSession session, File origin, File destination, boolean originCompare, long count, long size) throws CompareException,
			IllegalConfigurationException;

	/**
	 * rۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param size rΏۃ\[X
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishComparing(CompareSession session, long size) throws CompareException, IllegalConfigurationException;

	/**
	 * rʏo͏JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * rʏo͏ɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void resultWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException;

	/**
	 * rʏo͂ۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishResultWriting(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * r\[Xo͏JnꂽۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void startResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * r\[Xo͏ɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @param count ݂̏JEg
	 * @param size SJEg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void resourceWriting(CompareSession session, long count, long size) throws CompareException, IllegalConfigurationException;

	/**
	 * r\[Xo͂ۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	public void finishResourceWriting(CompareSession session) throws CompareException, IllegalConfigurationException;

	/**
	 * IۂɌĂяo܂B<br>
	 * @param session ZbVIuWFNg
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 */
	public void finish(CompareSession session) throws CompareException, IllegalConfigurationException;
}
