package org.phosphoresce.resourcecomp.core.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;

import org.phosphoresce.resourcecomp.Global;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.util.StringUtil;

/**
 * \[XrݒNX<br>
 * <br>
 * NX͎spXrcomp-config.properties݂ꍇANXꂽ^C~O
 * Propertiest@Cɒ`ĂŃNX܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/10	Kitagawa		VK쐬
 *-->
 */
public final class CompareConfigure implements Serializable {

	/** t@CGR[fBO */
	private String encoding = Global.DEFAULT_ENCODING;

	/** rfBNg */
	private File origin;

	/** rfBNg */
	private File destination;

	/** rʏo̓t@CpX */
	private File resultWritePath;

	/** rʃ\[Xo̓pX */
	private File resourceWritePath;

	/** o͑ΏۃXe[^X */
	private Status[] targetStatus;

	/** rsNX */
	private Class executerClass = Global.DEFAULT_CONTAINER_CLASS;

	/** r\[XNX */
	private Class containerClass = Global.DEFAULT_CONTAINER_CLASS;

	/** rXgeWNX */
	private Class strategyClass = Global.DEFAULT_STRATEGY_CLASS;

	/** r\[XtB^NX */
	private Class filterClass = Global.DEFAULT_FILTER_CLASS;

	/** rj^[NX */
	private Class monitorClass = Global.DEFAULT_MONITOR_CLASS;

	/** rʏo̓NX */
	private Class resultWriterClass = Global.DEFAULT_RESULT_WRITER_CLASS;

	/** rʃ\[Xo̓NX */
	private Class resourceWriterClass = Global.DEFAULT_RESOURCE_WRITER_CLASS;

	/**
	 * RXgN^<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	CompareConfigure() throws IllegalConfigurationException {
		super();
		load();
	}

	/**
	 * vpeBt@Cݒǂݍ݂܂B<br>
	 * @throws IllegalConfigurationException Ɋݒ肪sȂꍇɔ
	 */
	private void load() throws IllegalConfigurationException {
		try {
			if (!new File("rcomp-config.properties").exists()) {
				return;
			}
			FileInputStream stream = new FileInputStream("rcomp-config.properties");
			Properties properties = new Properties();
			properties.load(stream);
			{
				String value = properties.getProperty("executer");
				if (!StringUtil.isEmpty(value)) {
					executerClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("encoding");
				if (!StringUtil.isEmpty(value)) {
					encoding = value;
				}
			}
			{
				String value = properties.getProperty("plugin.container");
				if (!StringUtil.isEmpty(value)) {
					containerClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.strategy");
				if (!StringUtil.isEmpty(value)) {
					strategyClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.filter");
				if (!StringUtil.isEmpty(value)) {
					filterClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.monitor");
				if (!StringUtil.isEmpty(value)) {
					monitorClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.resultWriter");
				if (!StringUtil.isEmpty(value)) {
					resultWriterClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.resultWriter");
				if (!StringUtil.isEmpty(value)) {
					resultWriterClass = Class.forName(value);
				}
			}
			{
				String value = properties.getProperty("plugin.resourceWriter");
				if (!StringUtil.isEmpty(value)) {
					resourceWriterClass = Class.forName(value);
				}
			}
			stream.close();
		} catch (Throwable e) {
			throw new IllegalConfigurationException("ɊݒsƂo܂ł", e);
		}
	}

	/**
	 * t@CGR[fBO擾܂B<br>
	 * @return t@CGR[fBO
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * t@CGR[fBOݒ肵܂B<br>
	 * @param encoding t@CGR[fBO
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	/**
	 * rfBNg擾܂B<br>
	 * @return rfBNg
	 */
	public File getDestination() {
		return destination;
	}

	/**
	 * rfBNgݒ肵܂B<br>
	 * @param destination rfBNg
	 */
	public void setDestination(File destination) {
		this.destination = destination;
	}

	/**
	 * rfBNgݒ肵܂B<br>
	 * @param destination rfBNg
	 */
	public void setDestination(String destination) {
		setDestination(new File(destination));
	}

	/**
	 * rfBNg擾܂B<br>
	 * @return rfBNg
	 */
	public File getOrigin() {
		return origin;
	}

	/**
	 * rfBNgݒ肵܂B<br>
	 * @param origin rfBNg
	 */
	public void setOrigin(File origin) {
		this.origin = origin;
	}

	/**
	 * rfBNgݒ肵܂B<br>
	 * @param origin rfBNg
	 */
	public void setOrigin(String origin) {
		setOrigin(new File(origin));
	}

	/**
	 * rʃ\[Xo̓pX擾܂B<br>
	 * @return rʃ\[Xo̓pX
	 */
	public File getResourceWritePath() {
		return resourceWritePath;
	}

	/**
	 * rʃ\[Xo̓pXݒ肵܂B<br>
	 * @param resourceWritePath rʃ\[Xo̓pX
	 */
	public void setResourceWritePath(File resourceWritePath) {
		this.resourceWritePath = resourceWritePath;
	}

	/**
	 * rʃ\[Xo̓pXݒ肵܂B<br>
	 * @param resourceWritePath rʃ\[Xo̓pX
	 */
	public void setResourceWritePath(String resourceWritePath) {
		this.resourceWritePath = new File(resourceWritePath);
	}

	/**
	 * rʏo̓t@CpX擾܂B<br>
	 * @return rʏo̓t@CpX
	 */
	public File getResultWritePath() {
		return resultWritePath;
	}

	/**
	 * rʏo̓t@CpXݒ肵܂B<br>
	 * @param resultWritePath rʏo̓t@CpX
	 */
	public void setResultWritePath(File resultWritePath) {
		this.resultWritePath = resultWritePath;
	}

	/**
	 * rʏo̓t@CpXݒ肵܂B<br>
	 * @param resultWritePath rʏo̓t@CpX
	 */
	public void setResultWritePath(String resultWritePath) {
		this.resultWritePath = new File(resultWritePath);
	}

	/**
	 * o͑ΏۃXe[^X擾܂B<br>
	 * @return o͑ΏۃXe[^X
	 */
	public Status[] getTargetStatus() {
		return targetStatus;
	}

	/**
	 * o͑ΏۃXe[^Xݒ肵܂B<br>
	 * @param targetStatus o͑ΏۃXe[^X
	 */
	public void setTargetStatus(Status[] targetStatus) {
		this.targetStatus = targetStatus;
	}

	/**
	 * rsNX擾܂B<br>
	 * @return rsNX
	 */
	public Class getExecuterClass() {
		return executerClass;
	}

	/**
	 * rsNXݒ肵܂B<br>
	 * @param executerClass rsNX
	 */
	public void setExecuterClass(Class executerClass) {
		this.executerClass = executerClass;
	}

	/**
	 * r\[XNX擾܂B<br>
	 * @return r\[XNX
	 */
	public Class getContainerClass() {
		return containerClass;
	}

	/**
	 * r\[XNXݒ肵܂B<br>
	 * @param containerClass r\[XNX
	 */
	public void setContainerClass(Class containerClass) {
		this.containerClass = containerClass;
	}

	/**
	 * r\[XtB^NX擾܂B<br>
	 * @return r\[XtB^NX
	 */
	public Class getFilterClass() {
		return filterClass;
	}

	/**
	 * r\[XtB^NXݒ肵܂B<br>
	 * @param filterClass r\[XtB^NX
	 */
	public void setFilterClass(Class filterClass) {
		this.filterClass = filterClass;
	}

	/**
	 * rj^[NX擾܂B<br>
	 * @return rj^[NX
	 */
	public Class getMonitorClass() {
		return monitorClass;
	}

	/**
	 * rj^[NXݒ肵܂B<br>
	 * @param monitorClass rj^[NX
	 */
	public void setMonitorClass(Class monitorClass) {
		this.monitorClass = monitorClass;
	}

	/**
	 * rʃ\[Xo̓NX擾܂B<br>
	 * @return rʃ\[Xo̓NX
	 */
	public Class getResourceWriterClass() {
		return resourceWriterClass;
	}

	/**
	 * rʃ\[Xo̓NXݒ肵܂B<br>
	 * @param resourceWriterClass rʃ\[Xo̓NX
	 */
	public void setResourceWriterClass(Class resourceWriterClass) {
		this.resourceWriterClass = resourceWriterClass;
	}

	/**
	 * rʏo̓NX擾܂B<br>
	 * @return rʏo̓NX
	 */
	public Class getResultWriterClass() {
		return resultWriterClass;
	}

	/**
	 * rʏo̓NXݒ肵܂B<br>
	 * @param resultWriterClass rʏo̓NX
	 */
	public void setResultWriterClass(Class resultWriterClass) {
		this.resultWriterClass = resultWriterClass;
	}

	/**
	 * rXgeWNX擾܂B<br>
	 * @return rXgeWNX
	 */
	public Class getStrategyClass() {
		return strategyClass;
	}

	/**
	 * rXgeWNXݒ肵܂B<br>
	 * @param strategyClass rXgeWNX
	 */
	public void setStrategyClass(Class strategyClass) {
		this.strategyClass = strategyClass;
	}
}
