package org.phosphoresce.resourcecomp.core;

import java.io.File;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.ExceptionHandler;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainer;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriter;
import org.phosphoresce.resourcecomp.util.FileUtil;

/**
 * \[XrsNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2008/03/07	Kitagawa		VK쐬
 *-->
 */
public final class Comparerator extends Thread {

	/** ZbVIuWFNg */
	private CompareSession session;

	/** XgeWIuWFNg */
	private CompareStrategy strategy;

	/** tB^[IuWFNg */
	private CompareResourceFilter filter;

	/** j^[IuWFNg */
	private CompareMonitor monitor;

	/** rʏo̓IuWFNg */
	private ResultWriter resultWriter;

	/** r\[Xo̓IuWFNg */
	private ResourceWriter resourceWriter;

	/** r\[X */
	private long size;

	/** rJE^ */
	private long counter;

	/**
	 * RXgN^<br>
	 */
	private Comparerator() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param session ZbVIuWFNg
	 */
	public Comparerator(CompareSession session) {
		super();
		this.session = session;
	}

	/**
	 * ZbVIuWFNg擾܂B<br>
	 * @return ZbVIuWFNg
	 */
	public CompareSession getContainer() {
		return session;
	}

	/**
	 * ZbVIuWFNgݒ肵܂B<br>
	 * @param session ZbVIuWFNg
	 */
	public void setContainer(CompareSession session) {
		this.session = session;
	}

	/**
	 * XbhJn܂B<br>
	 * @see java.lang.Thread#run()
	 */
	public void run() {
		try {
			execute();
		} catch (Throwable e) {
			//throw new CompareException("rɗ\ʗOX[܂", e);
			new ExceptionHandler(e).execute();
		}
	}

	/**
	 * w肳ꂽ\[X̃JEgċAIɍs܂B<br>
	 * JEgtB[hl𒼐ڃCNgׁAtB[hl͊OŏĂ邱ƂOƂȂ܂B<br>
	 * @param file JEgΏۃ\[X
	 * @throws CompareException iĎɗ\ʗOꍇɃX[܂
	 * @throws IllegalConfigurationException sȊݒꍇɃX[܂
	 */
	private void countTargetResources(File file) throws CompareException, IllegalConfigurationException {
		if (monitor != null) {
			monitor.counting(session, size);
		}
		if (file == null || !file.exists()) {
			size += 0;
		}
		if (file.isFile()) {
			size += 1;
		} else if (file.isDirectory()) {
			size += 1;
			File[] files = file.listFiles();
			for (int i = 0; i <= files.length - 1; i++) {
				countTargetResources(files[i]);
			}
		}
		if (monitor != null) {
			monitor.counting(session, size);
		}
	}

	/**
	 * w肳ꂽrXgeWɃ\[X̔rs܂B<br>
	 * @return rʃ\[Xz
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @throws IllegalConfigurationException ɃReiNX擾łȂꍇɔ
	 * @throws ResourceOperateException Ƀ\[XANZXsȂꍇɔ
	 * @throws IllegalEnumerationException sȗ񋓌^R[hꂽꍇɔ
	 */
	private void execute() throws CompareException, IllegalConfigurationException, ResourceOperateException, IllegalEnumerationException {
		// ݒ
		strategy = session.createCompareStrategy();
		filter = session.createCompareResourceFilter();
		monitor = session.createCompareMonitor();
		resultWriter = session.createResultWriter();
		resourceWriter = session.createResourceWriter();

		// rJn
		if (monitor != null) {
			monitor.start(session);
		}

		// rΏƃ\[XJEg
		if (monitor != null) {
			monitor.startCounting(session);
		}
		size = 0;
		counter = 0;
		countTargetResources(session.getConfigure().getOrigin());
		countTargetResources(session.getConfigure().getDestination());
		if (monitor != null) {
			monitor.finishCounting(session, size);
		}

		// r
		if (monitor != null) {
			monitor.startComparing(session, size);
		}
		compareFiles(FileUtil.getFiles(session.getConfigure().getOrigin()), FileUtil.getFiles(session.getConfigure().getDestination()));
		compareDirectories(FileUtil.getDirectories(session.getConfigure().getOrigin()), FileUtil.getDirectories(session.getConfigure().getDestination()));
		if (monitor != null) {
			monitor.finishComparing(session, size);
		}

		// rʏo
		if (monitor != null) {
			monitor.startResultWriting(session);
		}
		Thread resultWriterThread = new Thread(resultWriter);
		resultWriterThread.start();
		while (resultWriterThread.isAlive()) {
			if (monitor != null) {
				monitor.resultWriting(session, resultWriter.getCount(), resultWriter.getSize());
			}
		}
		if (monitor != null) {
			monitor.finishResultWriting(session);
		}

		// r\[Xo
		if (monitor != null) {
			monitor.startResourceWriting(session);
		}
		Thread resourceWriterThread = new Thread(resourceWriter);
		resourceWriterThread.start();
		while (resourceWriterThread.isAlive()) {
			if (monitor != null) {
				monitor.resourceWriting(session, resourceWriter.getCount(), resourceWriter.getSize());
			}
		}
		if (monitor != null) {
			monitor.finishResourceWriting(session);
		}

		// rI
		if (monitor != null) {
			monitor.finish(session);
		}
	}

	/**
	 * w肳ꂽt@CXgm̔rs܂B<br>
	 * @param origins rt@C\[XXg
	 * @param destinations rt@C\[XXg
	 * @return rς݃\[XXg
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @throws IllegalConfigurationException ɃReiNX擾łȂꍇɔ
	 */
	private void compareFiles(File[] origins, File[] destinations) throws CompareException, IllegalConfigurationException {
		try {
			CompareContainer container = session.getContainer();
			/*
			 * Бr\[X̏ꍇ̏
			 */
			if (origins == null) {
				for (int i = 0; i <= destinations.length - 1; i++) {
					if (filter == null || filter.accept(destinations[i])) {
						container.add(new Resource(session, Type.FILE, Status.ADD, null, destinations[i]));
					}
				}
			} else if (destinations == null) {
				for (int i = 0; i <= origins.length - 1; i++) {
					if (filter == null || filter.accept(origins[i])) {
						container.add(new Resource(session, Type.FILE, Status.DELETE, origins[i], null));
					}
				}
			} else {
				/*
				 * rx[X
				 */
				for (int i = 0; i <= origins.length - 1; i++) {
					if (filter == null || filter.accept(origins[i])) {
						boolean searchedSame = false;
						File origin = origins[i];
						String originName = origin.getCanonicalPath();
						originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
						originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
						for (int j = 0; j <= destinations.length - 1; j++) {
							File destination = destinations[j];
							String destinationName = destination.getCanonicalPath();
							destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
							destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
							// ꃊ\[X̏ꍇ̔r
							if (originName.equals(destinationName)) {
								if (monitor != null) {
									monitor.comparing(session, origin, destination, true, ++counter, size);
								}
								if (!container.contains(new Resource(session, Type.FILE, origin, destination))) {
									Status status = strategy.compare(origin, destination);
									Resource resource = new Resource(session, Type.FILE, status, origin, destination);
									container.add(resource);
								}
								searchedSame = true;
							}
						}
						// ꃊ\[X̍폜\[Xo^
						if (!searchedSame) {
							Resource resource = new Resource(session, Type.FILE, Status.DELETE, origin, null);
							if (!container.contains(resource)) {
								container.add(resource);
							}
						}
					}
				}
				/*
				 * rx[X
				 */
				for (int i = 0; i <= destinations.length - 1; i++) {
					if (filter == null || filter.accept(destinations[i])) {
						boolean searchedSame = false;
						File destination = destinations[i];
						String destinationName = destination.getCanonicalPath();
						destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
						destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
						for (int j = 0; j <= origins.length - 1; j++) {
							File origin = origins[j];
							String originName = origin.getCanonicalPath().substring(origin.getCanonicalPath().lastIndexOf(File.separator) + 1);
							originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
							originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
							// ꃊ\[X̏ꍇ̔r
							if (originName.equals(destinationName)) {
								if (monitor != null) {
									monitor.comparing(session, origin, destination, false, ++counter, size);
								}
								if (!container.contains(new Resource(session, Type.FILE, origin, destination))) {
									Status status = strategy.compare(origin, destination);
									Resource resource = new Resource(session, Type.FILE, status, origin, destination);
									container.add(resource);
								}
								searchedSame = true;
							}
						}
						// ꃊ\[X̒ǉ\[Xo^
						if (!searchedSame) {
							Resource resource = new Resource(session, Type.FILE, Status.ADD, null, destination);
							if (!container.contains(resource)) {
								container.add(resource);
							}
						}
					}
				}
			}
		} catch (Throwable e) {
			throw new CompareException("\[Xrɗ\ʗO܂", e);
		}
	}

	/**
	 * w肳ꂽfBNgXgm̔rs܂B<br>
	 * @param origins rfBNg\[XXg
	 * @param destinations rfBNg\[XXg
	 * @return rς݃\[XXg
	 * @throws CompareException rɗ\ʃG[ꍇɃX[܂
	 * @throws IllegalConfigurationException ɃReiNX擾łȂꍇɔ
	 */
	private void compareDirectories(File[] origins, File[] destinations) throws CompareException, IllegalConfigurationException {
		try {
			CompareContainer container = session.getContainer();
			/*
			 * Бr\[X̏ꍇ̏
			 */
			if (origins == null) {
				for (int i = 0; i <= destinations.length - 1; i++) {
					if (filter == null || filter.accept(destinations[i])) {
						File destination = destinations[i];
						container.add(new Resource(session, Type.DIRECTORY, Status.ADD, null, destination));
						if (destination.isDirectory()) {
							// t@CXgċN
							compareFiles(null, FileUtil.getFiles(destination));
							// fBNgXgċN
							compareDirectories(null, FileUtil.getDirectories(destination));
						}
					}
				}
			} else if (destinations == null) {
				for (int i = 0; i <= origins.length - 1; i++) {
					if (filter == null || filter.accept(origins[i])) {
						File origin = origins[i];
						container.add(new Resource(session, Type.DIRECTORY, Status.DELETE, origin, null));
						if (origin.isDirectory()) {
							// t@CXgċN
							compareFiles(FileUtil.getFiles(origin), null);
							// fBNgXgċN
							compareDirectories(FileUtil.getDirectories(origin), null);
						}
					}
				}
			} else {
				/*
				 * rx[X
				 */
				for (int i = 0; i <= origins.length - 1; i++) {
					if (filter == null || filter.accept(origins[i])) {
						boolean searchedSame = false;
						File origin = origins[i];
						String originName = origin.getCanonicalPath();
						originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
						originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
						for (int j = 0; j <= destinations.length - 1; j++) {
							File destination = destinations[j];
							String destinationName = destination.getCanonicalPath().substring(destination.getCanonicalPath().lastIndexOf(File.separator) + 1);
							destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
							destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
							// ꃊ\[X̏ꍇ̔r
							if (originName.equals(destinationName)) {
								if (monitor != null) {
									monitor.comparing(session, origin, destination, true, ++counter, size);
								}
								if (!container.contains(new Resource(session, Type.DIRECTORY, origin, destination))) {
									Status status = strategy.compare(origin, destination);
									Resource resource = new Resource(session, Type.DIRECTORY, status, origin, destination);
									container.add(resource);
									// t@CXgċN
									compareFiles(FileUtil.getFiles(origin), FileUtil.getFiles(destination));
									// fBNgXgċN
									compareDirectories(FileUtil.getDirectories(origin), FileUtil.getDirectories(destination));
								}
								searchedSame = true;
							}
						}
						// ꃊ\[X̍폜\[Xo^
						if (!searchedSame) {
							Resource resource = new Resource(session, Type.DIRECTORY, Status.DELETE, origin, null);
							if (!container.contains(resource)) {
								container.add(resource);
								// t@CXgċN
								compareFiles(FileUtil.getFiles(origin), null);
								// fBNgXgċN
								compareDirectories(FileUtil.getDirectories(origin), null);
							}
						}
					}
				}
				/*
				 * rx[X
				 */
				for (int i = 0; i <= destinations.length - 1; i++) {
					if (filter == null || filter.accept(destinations[i])) {
						boolean searchedSame = false;
						File destination = destinations[i];
						String destinationName = destination.getCanonicalPath();
						destinationName = destinationName.endsWith(File.separator) ? File.separator.substring(0, destinationName.length() - 1) : destinationName;
						destinationName = destinationName.substring(destinationName.lastIndexOf(File.separator) + 1);
						for (int j = 0; j <= origins.length - 1; j++) {
							File origin = origins[j];
							String originName = origin.getCanonicalPath().substring(origin.getCanonicalPath().lastIndexOf(File.separator) + 1);
							originName = originName.endsWith(File.separator) ? File.separator.substring(0, originName.length() - 1) : originName;
							originName = originName.substring(originName.lastIndexOf(File.separator) + 1);
							// ꃊ\[X̏ꍇ̔r
							if (originName.equals(destinationName)) {
								if (monitor != null) {
									monitor.comparing(session, origin, destination, false, ++counter, size);
								}
								if (!container.contains(new Resource(session, Type.DIRECTORY, origin, destination))) {
									Status status = strategy.compare(origin, destination);
									Resource resource = new Resource(session, Type.DIRECTORY, status, origin, destination);
									container.add(resource);
									// t@CXgċN
									compareFiles(FileUtil.getFiles(origin), FileUtil.getFiles(destination));
									// fBNgXgċN
									compareDirectories(FileUtil.getDirectories(origin), FileUtil.getDirectories(destination));
								}
								searchedSame = true;
							}
						}
						// ꃊ\[X̒ǉ\[Xo^
						if (!searchedSame) {
							Resource resource = new Resource(session, Type.DIRECTORY, Status.ADD, null, destination);
							if (!container.contains(resource)) {
								container.add(resource);
								// t@CXgċN
								compareFiles(null, FileUtil.getFiles(destination));
								// fBNgXgċN
								compareDirectories(null, FileUtil.getDirectories(destination));
							}
						}
					}
				}
			}
		} catch (Throwable e) {
			throw new CompareException("fBNgrɗ\ʗO܂", e);
		}
	}
}
